/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.usb4java.libusb;

import de.ailis.usb4java.libusb.DeviceHandle;
import de.ailis.usb4java.libusb.EndpointDescriptor;
import de.ailis.usb4java.libusb.LibUsb;
import de.ailis.usb4java.utils.DescriptorUtils;
import java.nio.ByteBuffer;
import javax.usb.UsbInterfaceDescriptor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class InterfaceDescriptor
implements UsbInterfaceDescriptor {
    private long pointer;

    InterfaceDescriptor() {
    }

    public long getPointer() {
        return this.pointer;
    }

    @Override
    public native byte bLength();

    @Override
    public native byte bDescriptorType();

    @Override
    public native byte bInterfaceNumber();

    @Override
    public native byte bAlternateSetting();

    @Override
    public native byte bNumEndpoints();

    @Override
    public native byte bInterfaceClass();

    @Override
    public native byte bInterfaceSubClass();

    @Override
    public native byte bInterfaceProtocol();

    @Override
    public native byte iInterface();

    public native EndpointDescriptor[] endpoint();

    public native ByteBuffer extra();

    public native int extraLength();

    public String dump() {
        return this.dump(null);
    }

    public String dump(DeviceHandle handle) {
        StringBuilder builder = new StringBuilder();
        byte iInterface = this.iInterface();
        String sInterface = LibUsb.getStringDescriptor(handle, iInterface);
        if (sInterface == null) {
            sInterface = "";
        }
        builder.append(String.format("%s%n  extralen %17d%n  extra:%n%s", DescriptorUtils.dump(this), this.extraLength(), DescriptorUtils.dump(this.extra()).replaceAll("(?m)^", "    ")));
        if (this.extraLength() != 0) {
            return builder.toString();
        }
        for (EndpointDescriptor edesc : this.endpoint()) {
            builder.append(edesc.dump().replaceAll("(?m)^", "  "));
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        InterfaceDescriptor other = (InterfaceDescriptor)obj;
        return new EqualsBuilder().append(this.bDescriptorType(), other.bDescriptorType()).append(this.bLength(), other.bLength()).append(this.bAlternateSetting(), other.bAlternateSetting()).append(this.bInterfaceClass(), other.bInterfaceClass()).append(this.bInterfaceNumber(), other.bInterfaceNumber()).append(this.bInterfaceProtocol(), other.bInterfaceProtocol()).append(this.bInterfaceSubClass(), other.bInterfaceSubClass()).append(this.bNumEndpoints(), other.bNumEndpoints()).append(this.iInterface(), other.iInterface()).append(this.extraLength(), other.extraLength()).append(this.extra(), other.extra()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bLength()).append(this.bDescriptorType()).append(this.bInterfaceNumber()).append(this.bAlternateSetting()).append(this.bNumEndpoints()).append(this.bInterfaceClass()).append(this.bInterfaceSubClass()).append(this.bInterfaceProtocol()).append(this.iInterface()).append(this.extra()).append(this.extraLength()).toHashCode();
    }

    public String toString() {
        return this.dump();
    }
}

