/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import jpos.BaseControl;
import jpos.JposException;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceLoader;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;

public abstract class BaseJposControl
implements BaseControl {
    protected static final int deviceVersion12 = 1002000;
    protected static final int deviceVersion13 = 1003000;
    protected static final int deviceVersion14 = 1004000;
    protected static final int deviceVersion15 = 1005000;
    protected static final int deviceVersion16 = 1006000;
    protected static final int deviceVersion17 = 1007000;
    protected static final int deviceVersion18 = 1008000;
    protected static final int deviceVersion19 = 1009000;
    protected String deviceControlDescription;
    protected int deviceControlVersion;
    protected JposServiceConnection serviceConnection;
    protected int serviceVersion;
    protected boolean bOpen;
    protected BaseService service;

    public String getCheckHealthText() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getCheckHealthText();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getClaimed() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getClaimed();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getDeviceControlDescription() {
        return this.deviceControlDescription;
    }

    public int getDeviceControlVersion() {
        return this.deviceControlVersion;
    }

    public boolean getDeviceEnabled() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getDeviceEnabled();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.setDeviceEnabled(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getDeviceServiceDescription();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getDeviceServiceVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getDeviceServiceVersion();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public boolean getFreezeEvents() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getFreezeEvents();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void setFreezeEvents(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.setFreezeEvents(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getPhysicalDeviceDescription();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public String getPhysicalDeviceName() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getPhysicalDeviceName();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public int getState() {
        int n = 1;
        if (this.bOpen) {
            try {
                n = this.service.getState();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public void claim(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.claim(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public synchronized void close() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.close();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
        try {
            try {
                this.serviceConnection.disconnect();
            }
            catch (Exception exception) {
                throw new JposException(104, "Unable to free service connection", exception);
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.setDeviceService(null, 0);
            this.serviceConnection = null;
            this.service = null;
            this.serviceVersion = 0;
            this.bOpen = false;
            throw throwable;
        }
        this.setDeviceService(null, 0);
        this.serviceConnection = null;
        this.service = null;
        this.serviceVersion = 0;
        this.bOpen = false;
    }

    public void checkHealth(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.checkHealth(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public void directIO(int n, int[] nArray, Object object) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.directIO(n, nArray, object);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    public synchronized void open(String string) throws JposException {
        if (this.bOpen) {
            throw new JposException(106, "Device Control already open");
        }
        try {
            this.serviceConnection = JposServiceLoader.findService(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(109, "Device profile not found", exception);
        }
        try {
            this.serviceConnection.connect();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(104, "Could not connect to service", exception);
        }
        try {
            this.service = (BaseService)((Object)this.serviceConnection.getService());
        }
        catch (Exception exception) {
            throw new JposException(104, "Could not get service instance", exception);
        }
        JposException jposException = null;
        boolean bl = false;
        try {
            EventCallbacks eventCallbacks = this.createEventCallbacks();
            this.service.open(string, eventCallbacks);
            bl = true;
            this.serviceVersion = this.service.getDeviceServiceVersion();
            this.setDeviceService(this.service, this.serviceVersion);
            this.bOpen = true;
        }
        catch (JposException jposException2) {
            jposException = jposException2;
        }
        catch (Exception exception) {
            jposException = new JposException(111, "Unhandled exception from Device Service", exception);
        }
        if (!this.bOpen) {
            try {
                this.service.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.serviceConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.serviceConnection = null;
            this.serviceVersion = 0;
            throw jposException;
        }
    }

    public void release() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.release();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    protected abstract EventCallbacks createEventCallbacks();

    protected abstract void setDeviceService(BaseService var1, int var2) throws JposException;
}

