/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import jpos.config.JposRegPopulator;
import jpos.config.simple.SimpleRegPopulator;
import jpos.config.simple.editor.JposEntryEditorConfig;
import jpos.config.simple.editor.MainFrame;
import jpos.config.simple.xml.SimpleXmlRegPopulator;

public class JposEntryMergerDialog
extends JDialog {
    private JFileChooser openFileChooser = null;
    private JFileChooser saveFileChooser = null;
    private JButton openFile1Button = new JButton("...");
    private JButton openFile2Button = new JButton("...");
    private JRadioButton serFile1RadioButton = new JRadioButton("Serialized", true);
    private JRadioButton serFile2RadioButton = new JRadioButton("Serialized", true);
    private JRadioButton xmlFile1RadioButton = new JRadioButton("XML");
    private JRadioButton xmlFile2RadioButton = new JRadioButton("XML");
    private JTextField file1TextField = new JTextField(25);
    private JTextField file2TextField = new JTextField(25);
    private JButton mergeSaveXMLButton = new JButton("Merge and save XML...");
    private JButton mergeSaveSerializedButton = new JButton("Merge and save Serialized...");
    private JposRegPopulator xmlRegPopulator = new SimpleXmlRegPopulator();
    private JposRegPopulator serRegPopulator = new SimpleRegPopulator();
    private FileFilter serFileFilter = new SerFileFilter();
    private FileFilter xmlFileFilter = new XmlFileFilter();
    public static final String XML_EXT = ".xml";
    public static final String SER_EXT = ".cfg";
    public static final String SER_STRING = "Serialized";
    public static final String XML_STRING = "XML";
    public static final String MERGE_SAVE_XML_STRING = "Merge and save XML...";
    public static final String MERGE_SAVE_SERIALIZED_STRING = "Merge and save Serialized...";
    public static final String JPOS_ENTRY_MERGER_DIALOG_TITLE_STRING = "JposEntry Merger";
    public static final String SELECT_FILE_CHOOSER_TITLE_STRING = "Select JposEntries serialized or XML file";
    public static final String SELECT_STRING = "Select";
    public static final String SELECT_BUTTON_TOOLTIP_TEXT_STRING = "Click to select file";
    public static final String SAVE_FILE_CHOOSER_TITLE_STRING = "Save JposEntries serialized or XML file";
    public static final String SAVE_STRING = "Save";
    public static final String SAVE_BUTTON_TOOLTIP_TEXT_STRING = "Click to save file";
    public static final String SER_FILE_SUFFIX_STRING = ".cfg";
    public static final String SER_FILEFILTER_DESCRIPTION_STRING = "JposEntry serialized file (*.cfg)";
    public static final String XML_FILE_SUFFIX_STRING = ".xml";
    public static final String XML_FILEFILTER_DESCRIPTION_STRING = "JposEntry XML file (*.xml)";
    public static final String ERROR_DIALOG_TITLE_STRING = "Error loading XML or serialized file";
    public static final String ERROR_READING_FILE_STRING = "Error reading file: ";
    public static final String ERROR_SAVING_XML_FILE_STRING = "Error saving XML file: ";
    public static final String ERROR_SAVING_SERIALIZED_FILE_STRING = "Error saving serialized file: ";
    public static final String ERROR_SAVING_DIALOG_TITLE_STRING = "Error saving XML or Serialized file";
    public static final String SUCCESSFULLY_SAVED_XML_FILE_MSG = "Successfully saved XML file...";
    public static final String SUCCESSFULLY_SAVED_CFG_FILE_MSG = "Successfully saved serialized file...";
    public static final String OVERWRITE_FILE_STRING = "File exists, overwrite?";

    public JposEntryMergerDialog(MainFrame mainFrame) {
        this(mainFrame, true);
    }

    public JposEntryMergerDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.setTitle(JPOS_ENTRY_MERGER_DIALOG_TITLE_STRING);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel(new FlowLayout(1));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.serFile1RadioButton);
        buttonGroup.add(this.xmlFile1RadioButton);
        jPanel.add(this.serFile1RadioButton);
        jPanel.add(this.xmlFile1RadioButton);
        jPanel.add(this.file1TextField);
        jPanel.add(this.openFile1Button);
        this.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.serFile2RadioButton);
        buttonGroup2.add(this.xmlFile2RadioButton);
        jPanel2.add(this.serFile2RadioButton);
        jPanel2.add(this.xmlFile2RadioButton);
        jPanel2.add(this.file2TextField);
        jPanel2.add(this.openFile2Button);
        this.getContentPane().add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(this.mergeSaveXMLButton);
        jPanel3.add(this.mergeSaveSerializedButton);
        this.getContentPane().add(jPanel3);
        this.openFile1Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JposEntryMergerDialog.this.openFile1ButtonClicked();
            }
        });
        this.openFile2Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JposEntryMergerDialog.this.openFile2ButtonClicked();
            }
        });
        this.mergeSaveXMLButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JposEntryMergerDialog.this.mergeAndSaveXMLButtonClicked();
            }
        });
        this.mergeSaveSerializedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JposEntryMergerDialog.this.mergeAndSaveSerializedButtonClicked();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JposEntryMergerDialog.this.close();
            }
        });
        this.pack();
        this.init();
    }

    private void init() {
        JposEntryEditorConfig jposEntryEditorConfig = JposEntryEditorConfig.getInstance();
        this.setLocation(jposEntryEditorConfig.getJposEntryMergerDialogLocation());
        this.setSize(jposEntryEditorConfig.getJposEntryMergerDialogSize());
    }

    private void close() {
        JposEntryEditorConfig jposEntryEditorConfig = JposEntryEditorConfig.getInstance();
        jposEntryEditorConfig.setJposEntryMergerDialogLocation(this.getLocation());
        jposEntryEditorConfig.setJposEntryMergerDialogSize(this.getSize());
    }

    private void openFile1ButtonClicked() {
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        JFileChooser jFileChooser = this.getOpenFileChooser();
        FileFilter fileFilter = this.serFile1RadioButton.isSelected() ? this.serFileFilter : this.xmlFileFilter;
        this.getOpenFileChooser().resetChoosableFileFilters();
        this.getOpenFileChooser().setAcceptAllFileFilterUsed(false);
        this.getOpenFileChooser().addChoosableFileFilter(fileFilter);
        int n = jFileChooser.showDialog(this, SELECT_STRING);
        this.setCursor(cursor);
        if (n == 0) {
            this.file1TextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void openFile2ButtonClicked() {
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        JFileChooser jFileChooser = this.getOpenFileChooser();
        FileFilter fileFilter = this.serFile2RadioButton.isSelected() ? this.serFileFilter : this.xmlFileFilter;
        this.getOpenFileChooser().resetChoosableFileFilters();
        this.getOpenFileChooser().setAcceptAllFileFilterUsed(false);
        this.getOpenFileChooser().addChoosableFileFilter(fileFilter);
        int n = jFileChooser.showDialog(this, SELECT_STRING);
        this.setCursor(cursor);
        if (n == 0) {
            this.file2TextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void mergeAndSaveXMLButtonClicked() {
        Vector vector = null;
        try {
            vector = this.getCombinedEntries();
        }
        catch (Exception exception) {
            return;
        }
        if (vector == null || vector.size() == 0) {
            return;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        this.getSaveFileChooser().resetChoosableFileFilters();
        this.getSaveFileChooser().setAcceptAllFileFilterUsed(false);
        this.getSaveFileChooser().addChoosableFileFilter(this.xmlFileFilter);
        int n = this.getSaveFileChooser().showSaveDialog(this);
        if (n == 0) {
            try {
                String string;
                String string2 = this.getSaveFileChooser().getSelectedFile().getAbsolutePath();
                String string3 = string = !string2.endsWith(".xml") ? string2 + ".xml" : string2;
                if (!this.checkIfFileShouldBeOverwritten(string)) {
                    this.setCursor(cursor);
                    return;
                }
                this.xmlRegPopulator.save(vector.elements(), string);
                JOptionPane.showMessageDialog(this, SUCCESSFULLY_SAVED_XML_FILE_MSG);
            }
            catch (Exception exception) {
                String string = ERROR_SAVING_XML_FILE_STRING + this.getSaveFileChooser().getSelectedFile().getAbsolutePath();
                JOptionPane.showMessageDialog(this, string, ERROR_SAVING_DIALOG_TITLE_STRING, 0);
            }
        }
        this.setCursor(cursor);
    }

    private boolean checkIfFileShouldBeOverwritten(String string) {
        File file = new File(string);
        if (file.exists()) {
            int n = JOptionPane.showConfirmDialog(this, OVERWRITE_FILE_STRING, JPOS_ENTRY_MERGER_DIALOG_TITLE_STRING, 0, 3);
            return n == 0;
        }
        return true;
    }

    private void mergeAndSaveSerializedButtonClicked() {
        Vector vector = null;
        try {
            vector = this.getCombinedEntries();
        }
        catch (Exception exception) {
            return;
        }
        if (vector == null || vector.size() == 0) {
            return;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        this.getSaveFileChooser().resetChoosableFileFilters();
        this.getSaveFileChooser().setAcceptAllFileFilterUsed(false);
        this.getSaveFileChooser().addChoosableFileFilter(this.serFileFilter);
        int n = this.getSaveFileChooser().showSaveDialog(this);
        if (n == 0) {
            try {
                String string;
                String string2 = this.getSaveFileChooser().getSelectedFile().getAbsolutePath();
                String string3 = string = !string2.endsWith(".cfg") ? string2 + ".cfg" : string2;
                if (!this.checkIfFileShouldBeOverwritten(string)) {
                    this.setCursor(cursor);
                    return;
                }
                this.serRegPopulator.save(vector.elements(), string);
                JOptionPane.showMessageDialog(this, SUCCESSFULLY_SAVED_CFG_FILE_MSG);
            }
            catch (Exception exception) {
                String string = ERROR_SAVING_XML_FILE_STRING + this.getSaveFileChooser().getSelectedFile().getAbsolutePath();
                JOptionPane.showMessageDialog(this, string, ERROR_SAVING_DIALOG_TITLE_STRING, 0);
            }
        }
        this.setCursor(cursor);
    }

    private Vector getCombinedEntries() throws Exception {
        Vector vector = new Vector();
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = vector.elements();
        try {
            enumeration = this.file1TextField.getText().endsWith(".xml") ? this.getJposEntriesFromXml(this.file1TextField.getText()) : this.getJposEntriesFromSerialized(this.file1TextField.getText());
        }
        catch (Exception exception) {
            String string = ERROR_READING_FILE_STRING + this.file1TextField.getText();
            JOptionPane.showMessageDialog(this, string, ERROR_DIALOG_TITLE_STRING, 0);
            throw exception;
        }
        try {
            enumeration2 = this.file2TextField.getText().endsWith(".xml") ? this.getJposEntriesFromXml(this.file2TextField.getText()) : this.getJposEntriesFromSerialized(this.file2TextField.getText());
        }
        catch (Exception exception) {
            String string = ERROR_READING_FILE_STRING + this.file2TextField.getText();
            JOptionPane.showMessageDialog(this, string, ERROR_DIALOG_TITLE_STRING, 0);
            throw exception;
        }
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        while (enumeration2.hasMoreElements()) {
            vector.addElement(enumeration2.nextElement());
        }
        return vector;
    }

    private Enumeration getJposEntriesFromXml(String string) throws Exception {
        this.xmlRegPopulator.load(string);
        if (this.xmlRegPopulator.getLastLoadException() != null) {
            throw this.xmlRegPopulator.getLastLoadException();
        }
        return this.xmlRegPopulator.getEntries();
    }

    private Enumeration getJposEntriesFromSerialized(String string) throws Exception {
        this.serRegPopulator.load(string);
        if (this.serRegPopulator.getLastLoadException() != null) {
            throw this.serRegPopulator.getLastLoadException();
        }
        Enumeration enumeration = this.serRegPopulator.getEntries();
        if (!enumeration.hasMoreElements()) {
            throw new Exception("Invalid .cfg file or empty file");
        }
        return this.serRegPopulator.getEntries();
    }

    private JFileChooser getOpenFileChooser() {
        if (this.openFileChooser == null) {
            this.openFileChooser = new JFileChooser();
            this.openFileChooser.setDialogTitle(SELECT_FILE_CHOOSER_TITLE_STRING);
            this.openFileChooser.setDialogType(0);
            this.openFileChooser.setApproveButtonText(SELECT_STRING);
            this.openFileChooser.setApproveButtonToolTipText(SELECT_BUTTON_TOOLTIP_TEXT_STRING);
            this.openFileChooser.setFileSelectionMode(2);
        }
        return this.openFileChooser;
    }

    private JFileChooser getSaveFileChooser() {
        if (this.saveFileChooser == null) {
            this.saveFileChooser = new JFileChooser();
            this.saveFileChooser.setDialogTitle(SAVE_FILE_CHOOSER_TITLE_STRING);
            this.saveFileChooser.setDialogType(1);
            this.saveFileChooser.setApproveButtonText(SAVE_STRING);
            this.saveFileChooser.setApproveButtonToolTipText(SAVE_BUTTON_TOOLTIP_TEXT_STRING);
        }
        return this.saveFileChooser;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Simple test frame");
        new JposEntryMergerDialog(jFrame, false).setVisible(true);
    }

    public static class XmlFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(".xml");
        }

        public String getDescription() {
            return JposEntryMergerDialog.XML_FILEFILTER_DESCRIPTION_STRING;
        }
    }

    public static class SerFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().endsWith(".cfg");
        }

        public String getDescription() {
            return JposEntryMergerDialog.SER_FILEFILTER_DESCRIPTION_STRING;
        }
    }
}

