/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import jpos.loader.JposServiceLoader;
import jpos.util.DefaultProperties;
import jpos.util.JposProperties;

public class PropertiesEditorFrame
extends JFrame {
    private PropsTableModel propsTableModel = null;
    private JTable propsTable = null;
    private JButton refreshButton = new JButton("Refresh");
    private JButton saveButton = new JButton("Save");
    private JButton saveAsButton = new JButton("Save As...");
    private JButton closeButton = new JButton("Close");
    private JButton addButton = new JButton("Add");
    private JButton deleteButton = new JButton("Delete");
    private JFileChooser jFileChooser = null;
    public static final int INITIAL_ROWHEIGHT = 20;
    public static final String PROPERTIES_EDITOR_TITLE_STRING = "JposProperties Editor";
    public static final String REFRESH_BUTTON_STRING = "Refresh";
    public static final String SAVE_BUTTON_STRING = "Save";
    public static final String SAVE_AS_BUTTON_STRING = "Save As...";
    public static final String CLOSE_BUTTON_STRING = "Close";
    public static final String ADD_BUTTON_STRING = "Add";
    public static final String DELETE_BUTTON_STRING = "Delete";
    public static final String PROP_NAME_STRING = "Property Name";
    public static final String PROP_VALUE_STRING = "Property Value";
    public static final String DEFAULT_PROP_NAME_STRING = "default.prop.name";
    public static final String DEFAULT_PROP_VALUE_STRING = "default.prop.value";
    public static final String JPOSPROPERTIES_TABLE_STRING = "JposProperties <name, value> pairs";
    public static final String SAVING_DIALOG_TITLE_STRING = "Save JCL jpos.properties file";
    public static final String JCL_PROPERTIES_FILE_SAVED_MSG = "JCL properties file saved by JposProperties Editor";
    public static final String ERROR_SAVING_PROPERTIES_FILE_MSG = "Error saving properties file";

    public PropertiesEditorFrame() {
        this.setTitle("JposProperties Editor - jpos/res/jpos.properties");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), JPOSPROPERTIES_TABLE_STRING));
        this.setupTable();
        JScrollPane jScrollPane = new JScrollPane(this.propsTable, 22, 30);
        jPanel.add(jScrollPane);
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(new JPanel());
        jPanel2.add(this.addButton);
        jPanel2.add(this.deleteButton);
        jPanel2.add(new JPanel());
        jPanel2.add(this.refreshButton);
        jPanel2.add(this.saveButton);
        jPanel2.add(this.saveAsButton);
        jPanel2.add(this.closeButton);
        jPanel2.add(new JPanel());
        this.getContentPane().add((Component)jPanel2, "East");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesEditorFrame.this.refresh();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesEditorFrame.this.save();
            }
        });
        this.saveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesEditorFrame.this.saveAs();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesEditorFrame.this.close();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesEditorFrame.this.add();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesEditorFrame.this.delete();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PropertiesEditorFrame.this.close();
            }
        });
        this.setSize(660, 210);
        this.centerFrame();
        this.refreshButton.setEnabled(false);
        this.saveButton.setEnabled(false);
    }

    private void setupTable() {
        this.propsTableModel = new PropsTableModel();
        this.propsTable = new JTable(this.propsTableModel);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(true);
        Iterator iterator = DefaultProperties.getDefinedPropertyNames();
        while (iterator.hasNext()) {
            jComboBox.addItem((String)iterator.next());
        }
        TableColumn tableColumn = this.propsTable.getColumn(PROP_NAME_STRING);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        this.propsTable.setRowHeight(20);
        this.propsTableModel.setProperties(JposServiceLoader.getManager().getProperties());
    }

    private void refresh() {
        throw new RuntimeException("Not yet implemented...");
    }

    private void save() {
        throw new RuntimeException("Not yet implemented... Need to find out how to save file in loaded JAR file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAs() {
        Cursor cursor = this.getCursor();
        try {
            this.setCursor(new Cursor(3));
            int n = this.getJFileChooser().showSaveDialog(this);
            if (n == 0) {
                Properties properties = this.propsTableModel.getProperties();
                properties.store(new FileOutputStream(this.getJFileChooser().getSelectedFile()), JCL_PROPERTIES_FILE_SAVED_MSG);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, ERROR_SAVING_PROPERTIES_FILE_MSG);
        }
        finally {
            this.setCursor(cursor);
        }
    }

    private void add() {
        this.propsTableModel.add(DEFAULT_PROP_NAME_STRING, DEFAULT_PROP_VALUE_STRING);
    }

    private void delete() {
        int n = this.propsTable.getSelectedRow();
        this.propsTableModel.delete(n);
    }

    private void close() {
        int n = this.getDefaultCloseOperation();
        if (n == 3) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    private void centerFrame() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
    }

    private JFileChooser getJFileChooser() {
        if (this.jFileChooser == null) {
            this.jFileChooser = new JFileChooser();
            this.jFileChooser.setDialogTitle(SAVING_DIALOG_TITLE_STRING);
            this.jFileChooser.setDialogType(1);
        }
        return this.jFileChooser;
    }

    public void setProperties(JposProperties jposProperties) {
        this.propsTableModel.setProperties(jposProperties);
        this.saveAsButton.setEnabled(true);
        this.addButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
        if (jposProperties.size() > 0) {
            this.deleteButton.setEnabled(true);
        }
    }

    class PropsTableModel
    extends AbstractTableModel {
        private JposProperties jposProps = null;
        private List props = new ArrayList();
        private final String[] COLUMN_NAMES = new String[]{"Property Name", "Property Value"};

        public void setProperties(JposProperties jposProperties) {
            this.jposProps = jposProperties;
            Iterator iterator = this.jposProps.getProps();
            this.props.clear();
            while (iterator.hasNext()) {
                this.props.add(iterator.next());
            }
            Collections.sort(this.props, DefaultProperties.propComparator());
        }

        public Properties getProperties() {
            Properties properties = new Properties();
            Iterator iterator = this.props.iterator();
            while (iterator.hasNext()) {
                JposProperties.Prop prop = (JposProperties.Prop)iterator.next();
                properties.put(prop.getName(), prop.getValue());
            }
            return properties;
        }

        public void add(String string, String string2) {
            DefaultProperties.Prop prop = new DefaultProperties.Prop(string, string2);
            this.props.add(prop);
            this.fireTableDataChanged();
        }

        public void delete(int n) {
            if (n >= 0 && n < this.props.size()) {
                this.props.remove(n);
            }
            this.fireTableDataChanged();
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public int getRowCount() {
            return this.props.size();
        }

        public void setValueAt(Object object, int n, int n2) {
            JposProperties.Prop prop = (JposProperties.Prop)this.props.get(n);
            if (n2 == 1) {
                prop.setValue(object.toString());
            } else {
                prop.setName(object.toString());
            }
        }

        public Object getValueAt(int n, int n2) {
            JposProperties.Prop prop = (JposProperties.Prop)this.props.get(n);
            return n2 == 0 ? prop.getName() : prop.getValue();
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }
}

