/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import jpos.config.JposEntry;
import jpos.config.JposEntryConst;
import jpos.config.simple.editor.AbstractPropsViewPanel;
import jpos.config.simple.editor.JposEntryEditorMsg;
import jpos.config.simple.editor.PropsViewPanel;
import jpos.profile.DevCat;
import jpos.profile.JposDevCats;

class StandardPropsViewPanel
extends AbstractPropsViewPanel {
    private boolean refreshed = false;
    private CreationPropertyTable creationPropertyTable = new CreationPropertyTable();
    private JavaPosPropertyTable javaPosPropertyTable = new JavaPosPropertyTable();
    private VendorPropertyTable vendorPropertyTable = new VendorPropertyTable();
    private ProductPropertyTable productPropertyTable = new ProductPropertyTable();
    public static final String LOGICALNAMETEXT_STRING = JposEntryEditorMsg.LOGICALNAMETEXT_STRING;
    public static final String SIFACTORYCLASSTEXT_STRING = JposEntryEditorMsg.SIFACTORYCLASSTEXT_STRING;
    public static final String CREATION_PROPS_STRING = JposEntryEditorMsg.CREATION_PROPS_STRING;
    public static final String JPOS_PROPS_STRING = JposEntryEditorMsg.JPOS_PROPS_STRING;
    public static final String VENDOR_PROPS_STRING = JposEntryEditorMsg.VENDOR_PROPS_STRING;
    public static final String PRODUCT_PROPS_STRING = JposEntryEditorMsg.PRODUCT_PROPS_STRING;
    public static final String PROPERTY_NAME = JposEntryEditorMsg.PROPERTY_NAME_STRING;
    public static final String PROPERTY_VALUE = JposEntryEditorMsg.PROPERTY_VALUE_STRING;
    public static final String SAVE_CHANGES_TO_JPOSENTRY_QUESTION_MSG = "Save changes to entry?";
    public static final String SELECT_AN_OPTION_MSG = "Select and option";

    public StandardPropsViewPanel() {
        this.setLayout(new GridLayout(4, 1));
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), CREATION_PROPS_STRING));
        jPanel.setPreferredSize(new Dimension(200, 60));
        jPanel.add(this.creationPropertyTable);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1));
        jPanel2.setLayout(new GridLayout(1, 1));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), JPOS_PROPS_STRING));
        jPanel2.setPreferredSize(new Dimension(200, 60));
        jPanel2.add(this.javaPosPropertyTable);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), VENDOR_PROPS_STRING));
        jPanel3.setPreferredSize(new Dimension(200, 60));
        jPanel3.add(this.vendorPropertyTable);
        this.add(jPanel3);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), PRODUCT_PROPS_STRING));
        jPanel4.setPreferredSize(new Dimension(200, 60));
        jPanel4.add(this.productPropertyTable);
        this.add(jPanel4);
        this.init();
    }

    private void init() {
        this.clearAll();
        this.setEnabledAll(false);
    }

    private String getLogicalName() {
        return this.creationPropertyTable.getLogicalName();
    }

    private void setLogicalName(String string) {
        this.creationPropertyTable.setLogicalName(string);
    }

    private String getFactoryClassName() {
        return this.creationPropertyTable.getFactoryClassName();
    }

    private void setFactoryClassName(String string) {
        this.creationPropertyTable.setFactoryClassName(string);
    }

    private String getServiceClassName() {
        return this.creationPropertyTable.getServiceClassName();
    }

    private void setServiceClassName(String string) {
        this.creationPropertyTable.setServiceClassName(string);
    }

    private String getVendorName() {
        return this.vendorPropertyTable.getVendorName();
    }

    private void setVendorName(String string) {
        this.vendorPropertyTable.setVendorName(string);
    }

    private String getVendorURL() {
        return this.vendorPropertyTable.getVendorURL();
    }

    private void setVendorURL(String string) {
        this.vendorPropertyTable.setVendorURL(string);
    }

    private String getDeviceCategory() {
        return this.javaPosPropertyTable.getDeviceCategory();
    }

    private void setDeviceCategory(String string) {
        this.javaPosPropertyTable.setDeviceCategory(string);
    }

    private String getJposVersion() {
        return this.javaPosPropertyTable.getJposVersion();
    }

    private void setJposVersion(String string) {
        this.javaPosPropertyTable.setJposVersion(string);
    }

    private String getProductName() {
        return this.productPropertyTable.getProductName();
    }

    private void setProductName(String string) {
        this.productPropertyTable.setProductName(string);
    }

    private void setProductDescription(String string) {
        this.productPropertyTable.setProductDescription(string);
    }

    private String getProductDescription() {
        return this.productPropertyTable.getProductDescription();
    }

    private void setProductURL(String string) {
        this.productPropertyTable.setProductURL(string);
    }

    private String getProductURL() {
        return this.productPropertyTable.getProductURL();
    }

    private void updateJposEntryFromView(JposEntry jposEntry) {
        this.creationPropertyTable.updateJposEntryFromView(jposEntry);
        this.javaPosPropertyTable.updateJposEntryFromView(jposEntry);
        this.vendorPropertyTable.updateJposEntryFromView(jposEntry);
        this.productPropertyTable.updateJposEntryFromView(jposEntry);
        this.fireJposEntryChanged(new PropsViewPanel.Event(this));
    }

    public void clearAll() {
        this.setLogicalName("");
        this.setFactoryClassName("");
        this.setServiceClassName("");
        this.setVendorName("");
        this.setVendorURL("");
        this.setJposVersion("");
        this.setProductName("");
        this.setProductDescription("");
        this.setProductURL("");
        this.setDeviceCategory("");
        this.refreshed = false;
    }

    public void setEnabledAll(boolean bl) {
        this.creationPropertyTable.setEnabled(bl);
        this.javaPosPropertyTable.setEnabled(bl);
        this.vendorPropertyTable.setEnabled(bl);
        this.productPropertyTable.setEnabled(bl);
    }

    public void setEditableAll(boolean bl) {
        this.creationPropertyTable.setEditable(bl);
        this.javaPosPropertyTable.setEditable(bl);
        this.vendorPropertyTable.setEditable(bl);
        this.productPropertyTable.setEditable(bl);
    }

    public void setJposEntry(JposEntry jposEntry) {
        this.jposEntry = jposEntry;
        this.refreshed = false;
        this.refresh(this.jposEntry);
    }

    public void refresh(JposEntry jposEntry) {
        if (jposEntry != null) {
            this.setLogicalName((String)jposEntry.getPropertyValue("logicalName"));
            this.setFactoryClassName((String)jposEntry.getPropertyValue("serviceInstanceFactoryClass"));
            this.setServiceClassName((String)jposEntry.getPropertyValue("serviceClass"));
            this.setVendorName((String)jposEntry.getPropertyValue("vendorName"));
            this.setVendorURL((String)jposEntry.getPropertyValue("vendorURL"));
            this.setJposVersion((String)jposEntry.getPropertyValue("jposVersion"));
            this.setProductName((String)jposEntry.getPropertyValue("productName"));
            this.setProductDescription((String)jposEntry.getPropertyValue("productDescription"));
            this.setProductURL((String)jposEntry.getPropertyValue("productURL"));
            this.setDeviceCategory((String)jposEntry.getPropertyValue("deviceCategory"));
            this.refreshed = true;
        }
    }

    public void cancelButtonClicked() {
        boolean bl;
        boolean bl2 = bl = this.creationPropertyTable.isJposEntryDifferentFromView(this.getJposEntry()) || this.javaPosPropertyTable.isJposEntryDifferentFromView(this.getJposEntry()) || this.vendorPropertyTable.isJposEntryDifferentFromView(this.getJposEntry()) || this.productPropertyTable.isJposEntryDifferentFromView(this.getJposEntry());
        if (this.refreshed && bl) {
            int n = JOptionPane.showConfirmDialog(this, SAVE_CHANGES_TO_JPOSENTRY_QUESTION_MSG, SELECT_AN_OPTION_MSG, 0);
            if (n == 0) {
                this.updateJposEntryFromView(this.getJposEntry());
            } else {
                this.refresh(this.jposEntry);
            }
        }
        this.setEnabledAll(false);
        this.setEditableAll(false);
    }

    public void editButtonClicked() {
        this.setEnabledAll(true);
        this.setEditableAll(true);
    }

    public void okButtonClicked() {
        this.setEnabledAll(false);
        this.setEditableAll(false);
        this.updateJposEntryFromView(this.getJposEntry());
    }

    public void aboutToLooseFocus() {
        if (this.jposEntry != null) {
            this.cancelButtonClicked();
        }
    }

    class ProductPropertyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        MyTextArea descriptionTextArea;
        JTextField jTextField;
        ProductPropertyTable productPropertyTable;
        protected JTextComponent editorComponent;

        public ProductPropertyCellEditor(ProductPropertyTable productPropertyTable) {
            this.descriptionTextArea = new MyTextArea("productDescription");
            this.jTextField = new JTextField(" ");
            this.productPropertyTable = null;
            this.productPropertyTable = productPropertyTable;
            this.descriptionTextArea.addFocusListener(new FocusListener(this){
                private final /* synthetic */ ProductPropertyCellEditor this$1;
                {
                    this.this$1 = productPropertyCellEditor;
                }

                public void focusLost(FocusEvent focusEvent) {
                    this.this$1.stopCellEditing();
                }

                public void focusGained(FocusEvent focusEvent) {
                }
            });
            this.descriptionTextArea.addPropertyChangeListener(new PropertyChangeListener(this, StandardPropsViewPanel.this){
                private final /* synthetic */ StandardPropsViewPanel val$this$0;
                private final /* synthetic */ ProductPropertyCellEditor this$1;
                {
                    this.this$1 = productPropertyCellEditor;
                    this.val$this$0 = standardPropsViewPanel;
                }

                public void propertyChanged(String string) {
                    this.this$1.productPropertyTable.setProductDescription(string);
                }
            });
            this.jTextField.addActionListener(new ActionListener(this){
                private final /* synthetic */ ProductPropertyCellEditor this$1;
                {
                    this.this$1 = productPropertyCellEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.stopCellEditing();
                }
            });
        }

        public Object getCellEditorValue() {
            return this.editorComponent.getText();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object == null) {
                object = "";
            }
            switch (n) {
                case 0: 
                case 1: {
                    this.jTextField.setText(object.toString());
                    this.editorComponent = this.jTextField;
                    break;
                }
                case 2: {
                    this.descriptionTextArea.setText(object.toString());
                    this.editorComponent = this.descriptionTextArea;
                    break;
                }
                default: {
                    this.editorComponent = null;
                }
            }
            return this.editorComponent;
        }
    }

    class JavaPosPropertyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox versionComboBox = new JComboBox<String>(JposEntryConst.JPOS_VERSION_PROPS);
        private JComboBox devCatComboBox = new JComboBox<DevCat>(JposDevCats.DEVCAT_ARRAY);
        protected JComboBox editorComponent;

        public JavaPosPropertyCellEditor() {
            this.versionComboBox.addActionListener(new ActionListener(this){
                private final /* synthetic */ JavaPosPropertyCellEditor this$1;
                {
                    this.this$1 = javaPosPropertyCellEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.stopCellEditing();
                }
            });
            this.versionComboBox.addItemListener(new ItemListener(this){
                private final /* synthetic */ JavaPosPropertyCellEditor this$1;
                {
                    this.this$1 = javaPosPropertyCellEditor;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    this.this$1.stopCellEditing();
                }
            });
            this.devCatComboBox.addActionListener(new ActionListener(this){
                private final /* synthetic */ JavaPosPropertyCellEditor this$1;
                {
                    this.this$1 = javaPosPropertyCellEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.stopCellEditing();
                }
            });
            this.devCatComboBox.addItemListener(new ItemListener(this){
                private final /* synthetic */ JavaPosPropertyCellEditor this$1;
                {
                    this.this$1 = javaPosPropertyCellEditor;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    this.this$1.stopCellEditing();
                }
            });
        }

        public Object getCellEditorValue() {
            return this.editorComponent.getSelectedItem();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            switch (n) {
                case 0: {
                    this.versionComboBox.setSelectedItem(object);
                    this.editorComponent = this.versionComboBox;
                    break;
                }
                case 1: {
                    this.devCatComboBox.setSelectedItem(object);
                    this.editorComponent = this.devCatComboBox;
                    break;
                }
                default: {
                    this.editorComponent = null;
                }
            }
            return this.editorComponent;
        }
    }

    class ProductPropertyTable
    extends MyTable {
        public ProductPropertyTable() {
            super(new String[]{"productName", "productURL", "productDescription"});
            this.initialize(new ProductPropertyCellEditor(this));
        }

        public String getProductName() {
            return (String)this.dataModel.getValueAt(0, 1);
        }

        public void setProductName(String string) {
            this.dataModel.setValueAt(string, 0, 1);
            this.table.tableChanged(new TableModelEvent(this.dataModel, 0));
        }

        public String getProductURL() {
            return (String)this.dataModel.getValueAt(1, 1);
        }

        public void setProductURL(String string) {
            this.dataModel.setValueAt(string, 1, 1);
            this.table.tableChanged(new TableModelEvent(this.dataModel, 1));
        }

        public String getProductDescription() {
            return (String)this.dataModel.getValueAt(2, 1);
        }

        public void setProductDescription(String string) {
            this.dataModel.setValueAt(string, 2, 1);
            this.table.tableChanged(new TableModelEvent(this.dataModel, 2));
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.table.setEnabled(bl);
        }

        public void updateJposEntryFromView(JposEntry jposEntry) {
            jposEntry.modifyPropertyValue("productName", this.getProductName());
            jposEntry.modifyPropertyValue("productURL", this.getProductURL());
            jposEntry.modifyPropertyValue("productDescription", this.getProductDescription());
        }

        public boolean isJposEntryDifferentFromView(JposEntry jposEntry) {
            Object object = jposEntry.getPropertyValue("productName");
            Object object2 = jposEntry.getPropertyValue("productURL");
            Object object3 = jposEntry.getPropertyValue("productDescription");
            if (!object.equals(this.getProductName())) {
                return true;
            }
            if (!object2.equals(this.getProductURL())) {
                return true;
            }
            return !object3.equals(this.getProductDescription());
        }
    }

    class VendorPropertyTable
    extends MyTable {
        public VendorPropertyTable() {
            super(new String[]{"vendorName", "vendorURL"});
            this.initialize();
        }

        public String getVendorName() {
            return (String)this.dataModel.getValueAt(0, 1);
        }

        public void setVendorName(String string) {
            this.dataModel.setValueAt(string, 0, 1);
            this.table.tableChanged(new TableModelEvent(this.dataModel, 0));
        }

        public String getVendorURL() {
            return (String)this.dataModel.getValueAt(1, 1);
        }

        public void setVendorURL(String string) {
            this.dataModel.setValueAt(string, 1, 1);
            this.table.tableChanged(new TableModelEvent(this.dataModel, 1));
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.table.setEnabled(bl);
        }

        public void updateJposEntryFromView(JposEntry jposEntry) {
            jposEntry.modifyPropertyValue("vendorName", this.getVendorName());
            jposEntry.modifyPropertyValue("vendorURL", this.getVendorURL());
        }

        public boolean isJposEntryDifferentFromView(JposEntry jposEntry) {
            Object object = jposEntry.getPropertyValue("vendorName");
            Object object2 = jposEntry.getPropertyValue("vendorURL");
            if (!object.equals(this.getVendorName())) {
                return true;
            }
            return !object2.equals(this.getVendorURL());
        }
    }

    class JavaPosPropertyTable
    extends MyTable {
        public JavaPosPropertyTable() {
            super(new String[]{"jposVersion", "deviceCategory"});
            this.initialize(new JavaPosPropertyCellEditor());
            this.table.setRowHeight(this.table.getRowHeight() + 5);
        }

        public String getDeviceCategory() {
            return (String)this.dataModel.getValueAt(1, 1);
        }

        public void setDeviceCategory(String string) {
            this.dataModel.setValueAt(string, 1, 1);
            this.table.tableChanged(new TableModelEvent(this.dataModel, 1));
        }

        public String getJposVersion() {
            return (String)this.dataModel.getValueAt(0, 1);
        }

        public void setJposVersion(String string) {
            this.dataModel.setValueAt(string, 0, 1);
            this.table.tableChanged(new TableModelEvent(this.dataModel, 0));
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.table.setEnabled(bl);
        }

        public void updateJposEntryFromView(JposEntry jposEntry) {
            jposEntry.modifyPropertyValue("jposVersion", this.getJposVersion());
            jposEntry.modifyPropertyValue("deviceCategory", this.getDeviceCategory());
        }

        public boolean isJposEntryDifferentFromView(JposEntry jposEntry) {
            Object object = jposEntry.getPropertyValue("jposVersion");
            Object object2 = jposEntry.getPropertyValue("deviceCategory");
            if (!object.equals(this.getJposVersion())) {
                return true;
            }
            return !object2.equals(this.getDeviceCategory());
        }
    }

    class CreationPropertyTable
    extends MyTable {
        public CreationPropertyTable() {
            this.propertyNames = new String[]{"logicalName", "serviceInstanceFactoryClass", "serviceClass"};
            this.dataModel = new MyTable.DefaultDataModel(this, this, StandardPropsViewPanel.this){
                private final /* synthetic */ StandardPropsViewPanel val$this$0;
                private final /* synthetic */ CreationPropertyTable this$1;
                {
                    this.this$1 = creationPropertyTable;
                    this.val$this$0 = standardPropsViewPanel;
                }

                public boolean isCellEditable(int n, int n2) {
                    if (n == 0) {
                        return false;
                    }
                    return n2 != 0;
                }
            };
            this.initialize();
        }

        public String getLogicalName() {
            return (String)this.dataModel.getValueAt(0, 1);
        }

        public void setLogicalName(String string) {
            this.dataModel.setValueAt(string, 0, 1);
            this.table.tableChanged(new TableModelEvent(this.dataModel, 0));
        }

        public String getFactoryClassName() {
            return (String)this.dataModel.getValueAt(1, 1);
        }

        public void setFactoryClassName(String string) {
            this.dataModel.setValueAt(string, 1, 1);
            this.table.tableChanged(new TableModelEvent(this.dataModel, 1));
        }

        public String getServiceClassName() {
            return (String)this.dataModel.getValueAt(2, 1);
        }

        public void setServiceClassName(String string) {
            this.dataModel.setValueAt(string, 2, 1);
            this.table.tableChanged(new TableModelEvent(this.dataModel, 2));
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.table.setEnabled(bl);
        }

        public void updateJposEntryFromView(JposEntry jposEntry) {
            jposEntry.modifyPropertyValue("logicalName", this.getLogicalName());
            jposEntry.modifyPropertyValue("serviceInstanceFactoryClass", this.getFactoryClassName());
            jposEntry.modifyPropertyValue("serviceClass", this.getServiceClassName());
        }

        public boolean isJposEntryDifferentFromView(JposEntry jposEntry) {
            Object object = jposEntry.getPropertyValue("logicalName");
            Object object2 = jposEntry.getPropertyValue("serviceInstanceFactoryClass");
            Object object3 = jposEntry.getPropertyValue("serviceClass");
            if (!object.equals(this.getLogicalName())) {
                return true;
            }
            if (!object2.equals(this.getFactoryClassName())) {
                return true;
            }
            return !object3.equals(this.getServiceClassName());
        }
    }

    abstract class MyTable
    extends JScrollPane {
        protected TableModel dataModel = null;
        protected JTable table = null;
        protected String[] propertyNames = null;
        protected boolean editable = false;

        public MyTable(String[] stringArray) {
            this.propertyNames = stringArray;
            this.dataModel = new DefaultDataModel();
        }

        public MyTable() {
        }

        protected void initialize() {
            this.initialize(null);
        }

        protected void initialize(TableCellEditor tableCellEditor) {
            DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
            TableColumn tableColumn = new TableColumn(0, 150, new DefaultTableCellRenderer(), null);
            tableColumn.setHeaderValue(PROPERTY_NAME);
            defaultTableColumnModel.addColumn(tableColumn);
            tableColumn = new TableColumn(1, 300, new DefaultTableCellRenderer(), tableCellEditor);
            tableColumn.setHeaderValue(PROPERTY_VALUE);
            defaultTableColumnModel.addColumn(tableColumn);
            this.table = new JTable(this.dataModel, defaultTableColumnModel);
            this.setViewportView(this.table);
        }

        protected void setEditable(boolean bl) {
            this.editable = bl;
        }

        public abstract void updateJposEntryFromView(JposEntry var1);

        public abstract boolean isJposEntryDifferentFromView(JposEntry var1);

        protected class DefaultDataModel
        extends AbstractTableModel {
            private String[] data;

            protected DefaultDataModel() {
                this.data = new String[MyTable.this.propertyNames.length];
            }

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                return this.data.length;
            }

            public Object getValueAt(int n, int n2) {
                String string = null;
                string = n2 == 0 ? MyTable.this.propertyNames[n] : this.data[n];
                return string;
            }

            public void setValueAt(Object object, int n, int n2) {
                try {
                    if (object == null) {
                        object = "";
                    }
                    this.data[n] = object.toString();
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 != 0;
            }
        }
    }

    class MyTextArea
    extends JTextArea {
        private Vector propertyChangeListeners = new Vector();
        private MultiLinePropertyEditor mlEditor = new MultiLinePropertyEditor();

        public MyTextArea(String string) {
            super(" ", 4, 20);
            this.addMouseListener(new MouseListener(this){
                private final /* synthetic */ MyTextArea this$1;
                {
                    this.this$1 = myTextArea;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        MyTextArea.access$100(this.this$1).setPropertyValue(this.this$1.getText());
                        MyTextArea.access$100(this.this$1).show();
                        if (!MyTextArea.access$100(this.this$1).isCanceled()) {
                            String string = MyTextArea.access$100(this.this$1).getPropertyValue();
                            this.this$1.setText(string);
                            Vector vector = MyTextArea.access$200(this.this$1);
                            synchronized (vector) {
                                Enumeration<E> enumeration = MyTextArea.access$200(this.this$1).elements();
                                while (enumeration.hasMoreElements()) {
                                    PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
                                    propertyChangeListener.propertyChanged(string);
                                }
                            }
                        }
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
            this.mlEditor.setTitle(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            Vector vector = this.propertyChangeListeners;
            synchronized (vector) {
                this.propertyChangeListeners.addElement(propertyChangeListener);
            }
        }

        static /* synthetic */ MultiLinePropertyEditor access$100(MyTextArea myTextArea) {
            return myTextArea.mlEditor;
        }

        static /* synthetic */ Vector access$200(MyTextArea myTextArea) {
            return myTextArea.propertyChangeListeners;
        }
    }

    static interface PropertyChangeListener {
        public void propertyChanged(String var1);
    }

    class MultiLinePropertyEditor
    extends JDialog {
        private boolean canceled = false;
        private GridLayout gridLayout1 = new GridLayout();
        private JPanel jPanel1 = new JPanel();
        private GridBagLayout gridBagLayout1 = new GridBagLayout();
        private JButton okBtn = new JButton();
        private JButton cancelBtn = new JButton();
        private JScrollPane jScrollPane1 = new JScrollPane();
        private JTextArea jTextArea = new JTextArea();

        public MultiLinePropertyEditor() {
            super((Frame)null, " ", true);
            this.getContentPane().setLayout(this.gridLayout1);
            this.jPanel1.setLayout(this.gridBagLayout1);
            this.okBtn.setText(JposEntryEditorMsg.OKBUTTON_STRING);
            this.cancelBtn.setText(JposEntryEditorMsg.CANCELBUTTON_STRING);
            this.jTextArea.setText("");
            this.getContentPane().add((Component)this.jPanel1, null);
            this.jPanel1.add((Component)this.okBtn, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jPanel1.add((Component)this.cancelBtn, new GridBagConstraints(1, 1, 1, 2, 1.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 2, 1, 1.0, 40.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jScrollPane1.getViewport().add((Component)this.jTextArea, null);
            this.setBounds(100, 100, 300, 300);
            this.okBtn.addActionListener(new ActionListener(this){
                private final /* synthetic */ MultiLinePropertyEditor this$1;
                {
                    this.this$1 = multiLinePropertyEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    MultiLinePropertyEditor.access$002(this.this$1, false);
                    this.this$1.hide();
                }
            });
            this.cancelBtn.addActionListener(new ActionListener(this){
                private final /* synthetic */ MultiLinePropertyEditor this$1;
                {
                    this.this$1 = multiLinePropertyEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.hide();
                }
            });
        }

        public void setPropertyValue(String string) {
            this.jTextArea.setText(string);
        }

        public String getPropertyValue() {
            return this.jTextArea.getText();
        }

        public void show() {
            this.canceled = true;
            super.show();
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        static /* synthetic */ boolean access$002(MultiLinePropertyEditor multiLinePropertyEditor, boolean bl) {
            multiLinePropertyEditor.canceled = bl;
            return multiLinePropertyEditor.canceled;
        }
    }
}

