/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.tools.sdist;

import com.ibm.jpos.tools.sdist.SdistAppModel;
import com.ibm.jpos.tools.sdist.SdistAppView;
import com.ibm.jpos.tools.sdist.panels.SdistAppPanel;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SdistAppController
implements ActionListener {
    private SdistAppView myView = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer("SDIST", "SdistAppController");

    public SdistAppController(SdistAppView view) {
        this.myView = view;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "-->actionPerformed " + e.getActionCommand());
        }
        if (e.getActionCommand().equals("CMDCANCEL")) {
            this.myView.close(1);
        } else if (e.getActionCommand().equals("CMDPREV")) {
            this.handleCmdPrev();
        } else if (e.getActionCommand().equals("CMDNEXT")) {
            this.handleCmdNext();
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<--actionPerformed");
        }
    }

    private void handleCmdNext() {
        SdistAppModel model;
        SdistAppPanel panel;
        String nextPanel;
        if (this.tracer.isOn()) {
            this.tracer.println(3, "-->handleCmdNext");
        }
        if ((nextPanel = (panel = (model = this.myView.getModel()).getCurrentPanel()).getNextPanelID()) == null) {
            if (!model.close(2)) {
                return;
            }
            this.myView.close(2);
        } else {
            this.myView.setCurrentPanel(nextPanel);
        }
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<--handleCmdNext");
        }
    }

    private void handleCmdPrev() {
        if (this.tracer.isOn()) {
            this.tracer.println(3, "-->handleCmdPrev");
        }
        SdistAppModel model = this.myView.getModel();
        SdistAppPanel panel = model.getCurrentPanel();
        this.myView.setCurrentPanel(panel.getPrevPanelID());
        if (this.tracer.isOn()) {
            this.tracer.println(3, "<--handleCmdPrev");
        }
    }
}

