/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.tools.sdist.model;

import com.ibm.jpos.tools.sdist.model.EnvironmentModel;
import com.ibm.jpos.tools.sdist.model.POSTracingModel;
import com.ibm.jpos.tools.sdist.model.SdistConst;
import com.ibm.jpos.tools.sdist.model.SdistProperties;
import com.ibm.jpos.tools.sdist.model.SdistUtils;
import com.ibm.jutil.FileUtil;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JavaPOSTracingModel
implements POSTracingModel {
    private static EnvironmentModel em = EnvironmentModel.getInstance();
    private static Tracer tracer = TracerFactory.getInstance().createTracer("SDIST", "JavaPOSTracingModel");
    private static JavaPOSTracingModel instance = null;
    private static List propList = new ArrayList();
    private static SdistProperties props = null;
    private static String myHeader = "#new jutil properties file";
    private static String myFileName = null;

    protected JavaPOSTracingModel() {
        myFileName = SdistUtils.getPropFileLocation() + File.separator + "jutil.properties";
    }

    public static JavaPOSTracingModel getInstance() {
        if (instance == null) {
            instance = new JavaPOSTracingModel();
            if (tracer.isOn()) {
                tracer.println("-->Creating JavaPOSTracingModel instance<--");
            }
            instance.init();
        }
        return instance;
    }

    public boolean isTraceEnabled() {
        return JavaPOSTracingModel.areAllTracersOn();
    }

    public void enableTrace() {
        JavaPOSTracingModel.standardAllTracersSetting(true);
    }

    public void disableTrace() {
        JavaPOSTracingModel.standardAllTracersSetting(false);
    }

    public HashMap getAllTraceProps() {
        Enumeration propNames = props.getPropertyNames();
        HashMap<String, String> propMap = new HashMap<String, String>();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (propName.startsWith("com.ibm.jutil.tracing.Tracer.")) continue;
            propList.add(propName);
        }
        if (propList != null) {
            Collections.sort(propList);
            for (int i = 0; i < propList.size(); ++i) {
                propMap.put(propList.get(i).toString(), JavaPOSTracingModel.getValue(propList.get(i)));
            }
            return propMap;
        }
        return null;
    }

    public HashMap getAllDefaultProps() {
        HashMap propMap = SdistUtils.getMap("general");
        return propMap;
    }

    public void setAllTraceProps(HashMap data) {
        SdistUtils.createTempDir();
        SdistUtils.createEnvInfoFile();
        if (!data.isEmpty()) {
            Set set = data.keySet();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                String name = iter.next().toString();
                props.addProperty(name, data.get(name).toString());
            }
            if (tracer.isOn()) {
                tracer.println("-->setAllTraceProps:Properties and their values were added to current properties<--");
            }
        } else if (tracer.isOn()) {
            tracer.println("-->setAllTraceProps:Properties and their values were not added to current properties<--");
        }
    }

    public void saveChanges() throws IOException {
        if (tracer.isOn()) {
            tracer.println("-->SaveChanges:" + myFileName + "<--");
        }
        props.storeProperties(myHeader, myFileName);
    }

    public void endSession() throws Exception {
        if (SdistUtils.isWindows()) {
            this.endSession(SdistConst.WIN_FILES_TO_SEND_DEFAULT_LOCATION);
        } else if (SdistUtils.isLinux()) {
            this.endSession(SdistConst.WIN_FILES_TO_SEND_DEFAULT_LOCATION);
        }
    }

    public void endSession(String location) throws Exception {
        em.setSendFolderLocation(location);
        em.init();
        instance.disableTrace();
        instance.saveChanges();
        instance.getTracerFiles();
        em.makeZip();
    }

    private void getTracerFiles() {
        String traceType = props.getPropertyString("com.ibm.jutil.tracing.TracerOutputTo").toString();
        if (tracer.isOn()) {
            tracer.println("-->getTracerFiles");
        }
        switch (SdistUtils.getTraceOutputType(traceType)) {
            case 1: {
                if (!tracer.isOn()) break;
                tracer.println("Tracer output set to Console. No trace files to copy");
                break;
            }
            case 2: {
                File path = new File(JavaPOSTracingModel.getTracerFileLocation());
                if (path.exists()) {
                    File[] FileList;
                    if (tracer.isOn()) {
                        tracer.println("Tracer path: " + path.toString());
                    }
                    if ((FileList = path.listFiles()).length > 0) {
                        for (int i = 0; i < FileList.length; ++i) {
                            if (FileList[i].isDirectory()) continue;
                            String fn = JavaPOSTracingModel.getTracerFileName();
                            String nm = FileList[i].getName();
                            if (JavaPOSTracingModel.getTracerFileName().lastIndexOf(".") >= 0) {
                                fn = JavaPOSTracingModel.getTracerFileName().substring(0, JavaPOSTracingModel.getTracerFileName().lastIndexOf("."));
                            }
                            if (!nm.startsWith(fn)) continue;
                            if (tracer.isOn()) {
                                tracer.println("file found: " + nm.toString());
                            }
                            try {
                                FileUtil.copyFile((File)FileList[i], (File)new File(SdistUtils.getTempFolderLocation() + File.separator + FileList[i].getName()));
                                continue;
                            }
                            catch (FileNotFoundException e) {
                                if (!tracer.isOn()) continue;
                                tracer.println("File traces error: " + e.getMessage());
                                continue;
                            }
                            catch (IOException e) {
                                if (!tracer.isOn()) continue;
                                tracer.println("File traces error: " + e.getMessage());
                            }
                        }
                        break;
                    }
                    if (!tracer.isOn()) break;
                    tracer.println("Tracer File location has no files");
                    break;
                }
                if (!tracer.isOn()) break;
                tracer.println("Tracer File location does not exist");
                break;
            }
            case 3: {
                File path = new File(SdistConst.LOGGING_TRACE_FILES_LOCATION);
                if (path.exists()) {
                    File[] FileList = path.listFiles();
                    if (FileList.length > 0) {
                        for (int i = 0; i < FileList.length; ++i) {
                            if (FileList[i].isDirectory()) {
                                File[] list = FileList[i].listFiles();
                                if (list.length > 0) {
                                    for (int j = 0; j < list.length; ++j) {
                                        try {
                                            FileUtil.copyFile((File)list[j], (File)new File(SdistUtils.getTempFolderLocation() + File.separator + list[j].getName()));
                                            continue;
                                        }
                                        catch (FileNotFoundException e) {
                                            if (!tracer.isOn()) continue;
                                            tracer.println("Logging traces error: " + e.getMessage());
                                            continue;
                                        }
                                        catch (IOException e) {
                                            if (!tracer.isOn()) continue;
                                            tracer.println("Logging traces error: " + e.getMessage());
                                        }
                                    }
                                    continue;
                                }
                                if (!tracer.isOn()) continue;
                                tracer.println("Directory " + FileList[i].getName() + "has no files.");
                                continue;
                            }
                            try {
                                FileUtil.copyFile((File)FileList[i], (File)new File(SdistUtils.getTempFolderLocation() + File.separator + FileList[i].getName()));
                                continue;
                            }
                            catch (FileNotFoundException e) {
                                if (!tracer.isOn()) continue;
                                tracer.println("Logging traces error: " + e.getMessage());
                                continue;
                            }
                            catch (IOException e) {
                                if (!tracer.isOn()) continue;
                                tracer.println("Logging traces error: " + e.getMessage());
                            }
                        }
                    } else if (tracer.isOn()) {
                        tracer.println("Logging folder has no files");
                    }
                } else if (tracer.isOn()) {
                    tracer.println("Logging folder does not exist");
                }
                if (!tracer.isOn()) break;
                tracer.println("Tracer output set to Logging");
                break;
            }
            case -1: {
                if (!tracer.isOn()) break;
                tracer.println("Tracer output setting not valid.");
            }
        }
        if (tracer.isOn()) {
            tracer.println("<--getTracerFiles");
        }
    }

    private void init() {
        block11: {
            File fbk;
            if (tracer.isOn()) {
                tracer.println("-->init");
            }
            if (!(fbk = new File(SdistUtils.getPropFileLocation() + File.separator + "jutil.properties.bk")).exists()) {
                File futil = new File(SdistUtils.getPropFileLocation() + File.separator + "jutil.properties");
                try {
                    FileUtil.copyFile((File)futil, (File)fbk);
                }
                catch (FileNotFoundException e) {
                    if (tracer.isOn()) {
                        tracer.println("Backup File error:" + e.getMessage());
                    }
                }
                catch (IOException e) {
                    if (!tracer.isOn()) break block11;
                    tracer.println("Backup File Error:" + e.getMessage());
                }
            }
        }
        props = new SdistProperties();
        File propFile = new File(SdistUtils.getPropFileLocation() + File.separator + "jutil.properties");
        if (propFile.exists()) {
            props.loadPropertiesByName(SdistUtils.getPropFileLocation() + File.separator + "jutil.properties");
            if (tracer.isOn()) {
                tracer.println("Loading jutil properties current values");
            }
        } else {
            JavaPOSTracingModel.initDefaults();
            if (tracer.isOn()) {
                tracer.println("Current jutil properties file not found. Loading default values.");
            }
        }
        if (tracer.isOn()) {
            tracer.println("<--init");
        }
    }

    private static void initDefaults() {
        String name;
        HashMap map = SdistUtils.getMap("general");
        Set set = map.keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            name = iter.next().toString();
            props.addProperty(name, map.get(name).toString());
        }
        map = SdistUtils.getMap("named");
        set = map.keySet();
        iter = set.iterator();
        while (iter.hasNext()) {
            name = iter.next().toString();
            props.addProperty("com.ibm.jutil.tracing.Tracer." + name, map.get(name).toString());
        }
    }

    private static boolean areAllTracersOn() {
        return props.getStringProperty("com.ibm.jutil.tracing.TurnOnAllNamedTracers").equalsIgnoreCase("ON");
    }

    private static void standardAllTracersSetting(boolean b) {
        if (b) {
            JavaPOSTracingModel.enableAllTracing(b);
        } else {
            JavaPOSTracingModel.enableAllTracing(b);
        }
    }

    private static void enableAllTracing(boolean b) {
        if (tracer.isOn()) {
            tracer.println("-->enableAllTracing");
        }
        if (b) {
            props.addProperty("com.ibm.jutil.tracing.TurnOnAllNamedTracers", "ON");
            props.addProperty("com.ibm.jutil.tracing.TracerLevel", "Maximum");
            props.addProperty("com.ibm.jutil.tracing.TracerOutputTo", "File");
            if (tracer.isOn()) {
                tracer.println("Enabling all tracers...");
            }
        } else {
            props.addProperty("com.ibm.jutil.tracing.TurnOnAllNamedTracers", "OFF");
            if (tracer.isOn()) {
                tracer.println("Disabling all tracers...");
            }
        }
        if (tracer.isOn()) {
            tracer.println("<--enableAllTracing");
        }
    }

    private static String getValue(Object a) {
        if (props.isPropertyDefined(a.toString())) {
            String value = props.getPropertyString(a.toString());
            if (tracer.isOn()) {
                tracer.println("-->getValue:Getting property current value for " + a.toString() + "<--");
            }
            return value;
        }
        if (tracer.isOn()) {
            tracer.println("-->getValue:" + a.toString() + " property is not defined<--");
        }
        return null;
    }

    private static String getTracerFileName() {
        String name = props.getPropertyString("com.ibm.jutil.tracing.TracerOutputFileName");
        return name;
    }

    private static String getTracerFileLocation() {
        String location = props.getPropertyString("com.ibm.jutil.tracing.TracerOutputFileLocation");
        if (location.startsWith("~")) {
            location = System.getProperty("user.home") + location.substring(1);
        }
        if (location.endsWith(File.separator) && location.length() > 1) {
            location = location.substring(0, location.length() - 1);
        }
        if (SdistUtils.isWindows() && location.length() == 2 && location.charAt(1) == ':') {
            location = location + File.separator;
        }
        return location;
    }
}

