/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.tools.sdist.model;

import com.ibm.jpos.tools.sdist.model.EnvironmentModel;
import com.ibm.jpos.tools.sdist.model.SdistConst;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;

public class SdistUtils {
    private static HashMap aMap = new HashMap();
    private static EnvironmentModel em = EnvironmentModel.getInstance();
    private static Tracer tracer = TracerFactory.getInstance().createTracer("SDIST", "SdistUtils");

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Win");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").startsWith("Lin");
    }

    public static String getPropFileLocation() {
        if (SdistUtils.isWindows()) {
            return SdistConst.WIN_JUTIL_PROPERTIES_FILE_LOCATION;
        }
        if (SdistUtils.isLinux()) {
            return SdistConst.LIN_JUTIL_PROPERTIES_FILE_LOCATION;
        }
        return null;
    }

    public static void createEnvInfoFile() {
        block9: {
            try {
                if (SdistUtils.isWindows()) {
                    Runtime.getRuntime().exec("cmd.exe /c set > " + SdistConst.WIN_ENV_INFO_FILENAME);
                } else if (SdistUtils.isLinux()) {
                    String line;
                    SdistUtils.makeWritable(SdistConst.LIN_JUTIL_PROPERTIES_FILE_LOCATION);
                    BufferedWriter out = new BufferedWriter(new FileWriter(SdistConst.LIN_ENV_INFO_FILENAME, true));
                    Runtime r = Runtime.getRuntime();
                    Process p = null;
                    p = r.exec("env");
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    while ((line = br.readLine()) != null) {
                        out.write(line);
                    }
                    out.close();
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (tracer.isOn()) {
                    tracer.println("Creating file with environment variables and values...");
                }
            }
            catch (IOException e) {
                if (!tracer.isOn()) break block9;
                tracer.println("File with environment variables and values could not be created...");
            }
        }
    }

    public static int getTraceOutputType(String t) {
        if (t.equals("Console")) {
            return 1;
        }
        if (t.equals("File")) {
            return 2;
        }
        if (t.equals("Logging")) {
            return 3;
        }
        return -1;
    }

    public static void makeWritable(String location) {
        if (SdistUtils.isLinux()) {
            block7: {
                try {
                    if (!new File(location).canWrite()) {
                        String cmd = "chmod -c 777 " + location;
                        Runtime.getRuntime().exec(cmd);
                    } else if (tracer.isOn()) {
                        tracer.println("File " + location + " was writable.Nothing done. ");
                    }
                }
                catch (IOException e) {
                    if (!tracer.isOn()) break block7;
                    tracer.println("File " + location + " could not be made writable.");
                }
            }
            if (tracer.isOn()) {
                tracer.println("File " + location + " is now writable.");
            }
        }
    }

    public static void copyThisFile(String filename) {
        block5: {
            try {
                FileInputStream file = new FileInputStream(filename);
                BufferedInputStream buff = new BufferedInputStream(file);
                BufferedWriter out = new BufferedWriter(new FileWriter(em.getSendFolderLocation() + File.separator + "environment.txt", true));
                out.newLine();
                boolean eof = false;
                out.newLine();
                out.write("FILE: " + filename);
                out.newLine();
                out.write("#########################################################################");
                out.newLine();
                while (!eof) {
                    int input = buff.read();
                    if (input == -1) {
                        eof = true;
                        out.newLine();
                        out.write("#########################################################################");
                        out.close();
                        break;
                    }
                    out.write(input);
                }
                file.close();
            }
            catch (IOException e) {
                if (tracer.isOn()) {
                    tracer.println("Error copying file: " + filename);
                }
                if (!tracer.isOn()) break block5;
                tracer.println("Appendding " + filename + " content to information file.");
            }
        }
    }

    public static HashMap getMap(String s) {
        if (s.equals("general")) {
            aMap.clear();
            aMap.put("com.ibm.jutil.tracing.TracerOutputFileMaxFiles", "10");
            aMap.put("com.ibm.jutil.tracing.TimeStampFormat", "DATE");
            aMap.put("com.ibm.jutil.tracing.TracerOutputFileFlushFrequency", "5000");
            aMap.put("com.ibm.jutil.tracing.TracerOutputFileThreshold", "200");
            aMap.put("com.ibm.jutil.tracing.TracerLevel", "Maximum");
            aMap.put("com.ibm.jutil.tracing.TurnOnAllNamedTracers", "ON");
            aMap.put("com.ibm.jutil.tracing.TracerOutputTo", "File");
            aMap.put("com.ibm.jutil.tracing.TracerOutputFileName", "traceroutput.txt");
            aMap.put("com.ibm.jutil.tracing.TracerOutputFileLocation", "~" + File.separator + ".ibmjpos");
            aMap.put("com.ibm.jutil.tracing.AddAllTraceSubName", "ON");
            aMap.put("com.ibm.jutil.tracing.TracerOutputFileMaxSize", "10000000");
        } else if (s.equals("named")) {
            aMap.clear();
            aMap.put("com.ibm.jutil.tracing.Tracer.System", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.SystemExt", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.GlobalTracer", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.POSCC", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.POSJ", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.Embedded", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.HID", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.HID0", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.HID1", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.HID2", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.HID3", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.HID4", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.HID5", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.PosKbd", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.RS232", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.RS485", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.CashDrawer", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.CashDrawer1", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.CashDrawer2", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.CashDrawer3", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.CheckScanner", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.CheckScanner0", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.FiscalPrinter", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.FiscalPrinter0", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.HardTotals", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.HardTotals0", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.Keylock", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.Keylock0", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.LineDisplay", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.LineDisplay0", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.LineDisplay1", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.MICR", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.MICR0", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.MSR", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.MSR0", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.MotionSensor", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.MotionSensor0", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.POSKeyboard", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.POSKeyboard0", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.POSPrinter", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.POSPrinter0", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.Scale", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.Scale0", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.Scanner", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.Scanner0", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.ToneIndicator", "OFF");
            aMap.put("com.ibm.jutil.tracing.Tracer.ToneIndicator0", "OFF");
        }
        if (tracer.isOn()) {
            tracer.println("Providing hashmap with " + s + " properties.");
        }
        return aMap;
    }

    public static String getTempFolderLocation() {
        if (SdistUtils.isWindows()) {
            return SdistConst.WIN_TEMP_FOLDER;
        }
        if (SdistUtils.isLinux()) {
            return SdistConst.LIN_TEMP_FOLDER;
        }
        return null;
    }

    public static void createTempDir() {
        File path = new File(SdistUtils.getTempFolderLocation());
        if (tracer.isOn()) {
            tracer.println("-->createTempDir");
        }
        if (SdistUtils.isLinux()) {
            SdistUtils.makeWritable(path.getParent().toString());
        }
        if (path.exists()) {
            File[] FList = path.listFiles();
            for (int i = 0; i < FList.length; ++i) {
                if (tracer.isOn()) {
                    tracer.println(FList[i].getName());
                }
                FList[i].delete();
            }
            if (tracer.isOn()) {
                tracer.println("Information directory exists. Deleting old directory information files.");
            }
        } else if (path.mkdir()) {
            if (tracer.isOn()) {
                tracer.println("Temp directory for information files created.");
            }
        } else if (tracer.isOn()) {
            tracer.println("Temp directory for information files was not created.");
        }
        if (tracer.isOn()) {
            tracer.println("<--createTempDir");
        }
    }

    public static void getFile(File orig, File dest, String title) {
        block7: {
            try {
                FileInputStream fis = new FileInputStream(orig);
                BufferedReader in = new BufferedReader(new InputStreamReader(fis));
                FileOutputStream fos = new FileOutputStream(dest);
                PrintWriter out = new PrintWriter(fos);
                if (tracer.isOn()) {
                    tracer.println("Writing to new " + orig.getName() + " file location .");
                }
                out.println(title);
                out.println();
                try {
                    String line = in.readLine();
                    while (line != null) {
                        out.println(line);
                        line = in.readLine();
                    }
                    out.flush();
                    out.close();
                    in.close();
                }
                catch (IOException e) {
                    if (tracer.isOn()) {
                        tracer.println("Error copying to new " + orig.getName() + "file.");
                    }
                }
            }
            catch (FileNotFoundException e) {
                if (!tracer.isOn()) break block7;
                tracer.println("File " + orig.getName() + " not found.");
            }
        }
    }

    public static void emptyThisFolder(File file) {
        if (file.exists()) {
            File[] FileList = file.listFiles();
            if (FileList.length > 0) {
                for (int i = 0; i < FileList.length; ++i) {
                    String nm = FileList[i].getName();
                    if (FileList[i].delete()) {
                        if (!tracer.isOn()) continue;
                        tracer.println("-->emptyThisFolder Deleting file: " + nm + " <---");
                        continue;
                    }
                    if (!tracer.isOn()) continue;
                    tracer.println("--->emptyThisFolder File: " + nm + " could not be deleted.<---");
                }
            }
        } else if (tracer.isOn()) {
            tracer.println("-->emptyThisFolder: Nothing to delete. Temp folder does not exist<--");
        }
    }
}

