/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.DeviceServiceImp;
import com.ibm.jpos.services.DeviceServiceImpMsg;
import com.ibm.jpos.services.DeviceServiceMsg;
import com.ibm.jpos.util.JposEntryInfo;
import com.ibm.jpos.util.Tracer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.loader.JposServiceInstance;
import jpos.loader.JposServiceInstanceFactory;

public final class IBMJposServiceInstanceFactory
implements JposServiceInstanceFactory {
    public JposServiceInstance createInstance(String logicalName, JposEntry jposEntry) throws JposException {
        JposEntryInfo jposEntryInfo = new JposEntryInfo(logicalName, jposEntry);
        JposServiceInstance jposServiceInstance = null;
        try {
            String impClassName = jposEntryInfo.getImpClassName();
            if (impClassName == null) {
                throw new JposException(104, DeviceServiceMsg.BC_IMPCLASS_ENTRY_NOT_FOUND_MSG);
            }
            Class<?> impClass = null;
            try {
                impClass = Class.forName(impClassName);
            }
            catch (ClassNotFoundException e) {
                throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_FOUND_MSG, (Exception)e);
            }
            Method createImpMethod = null;
            try {
                createImpMethod = this.lookForStaticMethod("createImp", impClass);
            }
            catch (Exception e) {
                throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_FOUND_MSG, e);
            }
            if (createImpMethod == null) {
                throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_COMPLIANT_MSG);
            }
            try {
                if (!this.isValidCreateImpMethod(createImpMethod)) {
                    throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_COMPLIANT_MSG);
                }
            }
            catch (ClassNotFoundException e) {
                throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_COMPLIANT_MSG, (Exception)e);
            }
            String abstractionClassName = jposEntryInfo.getAbstractionClassName();
            if (abstractionClassName == null) {
                throw new JposException(104, DeviceServiceMsg.BC_ABSTRACTIONCLASS_ENTRY_NOT_FOUND_MSG);
            }
            Class<?> abstractionClass = null;
            try {
                abstractionClass = Class.forName(abstractionClassName);
            }
            catch (ClassNotFoundException e) {
                throw new JposException(104, DeviceServiceMsg.ABSTRACTIONCLASS_NOT_FOUND_MSG, (Exception)e);
            }
            DeviceService ds = null;
            try {
                ds = (DeviceService)abstractionClass.newInstance();
            }
            catch (Exception e) {
                throw new JposException(104, DeviceServiceMsg.ABSTRACTIONCLASS_INSTANTIATION_ERROR_MSG, e);
            }
            ds.getDeviceServiceState().setJposEntryInfo(jposEntryInfo);
            DeviceServiceImp imp = null;
            Object[] args = new Object[]{ds};
            try {
                imp = (DeviceServiceImp)createImpMethod.invoke(null, args);
            }
            catch (Exception e) {
                throw new JposException(104, DeviceServiceMsg.IMPCLASS_CREATEIMP_METHOD_ERROR_MSG, e);
            }
            ds.setDeviceServiceImp(imp);
            jposServiceInstance = (JposServiceInstance)ds;
        }
        catch (ClassCastException e) {
            throw new JposException(104, e.getMessage(), (Exception)e);
        }
        this.initTraceInfo(logicalName, jposEntry);
        return jposServiceInstance;
    }

    private void initTraceInfo(String logicalName, JposEntry jposEntry) {
        if (jposEntry != null) {
            String name = "";
            Enumeration e = null;
            e = jposEntry.getPropertyNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                if (name.equalsIgnoreCase("TraceLevel")) {
                    String sLevel = jposEntry.getPropertyValue(name).toString();
                    int level = Integer.decode(sLevel);
                    Tracer.setTracerLevel(level);
                }
                if (name.equalsIgnoreCase("TraceFileName")) {
                    String fn = jposEntry.getPropertyValue(name).toString();
                    Tracer.setTracerFilename(fn);
                }
                if (!name.equalsIgnoreCase("TraceClassName")) continue;
                StringTokenizer tokens = new StringTokenizer(jposEntry.getPropertyValue(name).toString(), " ,\n\r");
                while (tokens.hasMoreTokens()) {
                    Tracer.addTracerClassname(tokens.nextToken());
                }
            }
        }
    }

    private boolean isValidCreateImpMethod(Method aMethod) throws ClassNotFoundException {
        Class<?> serviceInstanceImpClass = Class.forName("com.ibm.jpos.services.ServiceInstanceImp");
        Class<?> deviceAbstractionClass = Class.forName("com.ibm.jpos.services.DeviceServiceAbstraction");
        if (!Modifier.isStatic(aMethod.getModifiers())) {
            return false;
        }
        if (!serviceInstanceImpClass.equals(aMethod.getReturnType())) {
            return false;
        }
        Class<?>[] args = aMethod.getParameterTypes();
        if (args.length != 1) {
            return false;
        }
        return deviceAbstractionClass.equals(args[0]);
    }

    private Method lookForMethod(String methodName, Class aClass) throws SecurityException {
        Method method = null;
        Method[] methods = aClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            method = methods[i];
            break;
        }
        return method;
    }

    private Method lookForStaticMethod(String methodName, Class aClass) throws SecurityException {
        Method method = null;
        Method[] methods = aClass.getMethods();
        Vector<Method> staticMethods = new Vector<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName) || !Modifier.isStatic(methods[i].getModifiers())) continue;
            if (methods[i].getDeclaringClass().equals(aClass)) {
                method = methods[i];
                break;
            }
            staticMethods.addElement(methods[i]);
        }
        if (method == null) {
            Vector superclasses = new Vector();
            for (Class c = aClass.getSuperclass(); c != null; c = c.getSuperclass()) {
                superclasses.addElement(c);
            }
            block2: for (int i = 0; i < superclasses.size() && method == null; ++i) {
                for (int j = 0; j < staticMethods.size(); ++j) {
                    if (!((Method)staticMethods.elementAt(j)).getDeclaringClass().equals((Class)superclasses.elementAt(i))) continue;
                    method = (Method)staticMethods.elementAt(j);
                    continue block2;
                }
            }
        }
        return method;
    }
}

