/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.KeylockServiceImp;
import com.ibm.jpos.services.KeylockServiceState;
import com.ibm.jutil.Util;
import jpos.JposException;
import jpos.services.KeylockService19;

public abstract class KeylockService
extends DeviceService
implements KeylockService19 {
    public static final String KEYLOCK_DEVCAT = "com.ibm.jpos.services.KeylockService";

    public KeylockService(KeylockServiceImp imp) {
        super(imp);
        this.setDeviceServiceState(new KeylockServiceState());
    }

    public synchronized void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - KeylockService.getFsttmStamp(), "-->setDeviceEnabled," + deviceEnabled);
        }
        this.getDeviceServiceState().isOpen();
        this.getDeviceServiceImp().setDeviceEnabled(deviceEnabled);
        this.getDeviceServiceState().setDeviceEnabled(deviceEnabled);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - KeylockService.getFsttmStamp(), "<--setDeviceEnabled," + deviceEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeyPosition() throws JposException {
        KeylockServiceState state;
        KeylockServiceState keylockServiceState = state = this.getKeylockServiceState();
        synchronized (keylockServiceState) {
            state.isOpenEnable();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - KeylockService.getFsttmStamp(), "getKeyPosition," + state.getKeyPosition());
            }
            return state.getKeyPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPositionCount() throws JposException {
        KeylockServiceState state;
        KeylockServiceState keylockServiceState = state = this.getKeylockServiceState();
        synchronized (keylockServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - KeylockService.getFsttmStamp(), "getPositionCount," + state.getPositionCount());
            }
            return state.getPositionCount();
        }
    }

    public synchronized void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->compareFirmwareVersion");
        }
        this.getDeviceServiceState().isOpenEnable();
        if (!this.getDeviceServiceState().getCapCompareFirmwareVersion()) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().compareFirmwareVersion(firmwareFileName, result);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--compareFirmwareVersion");
        }
    }

    public synchronized void updateFirmware(String firmwareFileName) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->updateFirmware");
        }
        this.getDeviceServiceState().isOpenEnable();
        if (!this.getDeviceServiceState().getCapUpdateFirmware()) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().updateFirmware(firmwareFileName);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--updateFirmware");
        }
    }

    public synchronized void release() throws JposException {
        super.releaseSharable();
    }

    public synchronized void claim(int timeout) throws JposException {
        throw new JposException(106);
    }

    public synchronized void checkHealth(int level) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - KeylockService.getFsttmStamp(), "-->checkHealth," + level);
        }
        this.getDeviceServiceState().isOpenEnable();
        this.checkCheckHealthArg(level);
        this.getDeviceServiceImp().checkHealth(level);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - KeylockService.getFsttmStamp(), "<--checkHealth," + level);
        }
    }

    public synchronized void waitForKeylockChange(int keyPosition, int timeout) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - KeylockService.getFsttmStamp(), "waitForKeylockChange," + keyPosition + "," + timeout);
        }
        KeylockServiceState state = this.getKeylockServiceState();
        state.checkKeyPositionValue(keyPosition);
        this.checkTimeoutArg(timeout);
        state.isOpenEnable();
        this.checkOnline();
        this.getKeylockServiceImp().waitForKeylockChange(keyPosition, timeout);
    }

    public synchronized void retrieveStatistics(String[] statisticsBuffer) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->retrieveStatistics," + Util.toString((String[])statisticsBuffer));
        }
        if (!this.getDeviceServiceState().getCapStatisticsReporting()) {
            throw new JposException(106);
        }
        this.getDeviceServiceState().isOpenEnable();
        this.getDeviceServiceImp().retrieveStatistics(statisticsBuffer);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--retrieveStatistics," + Util.toString((String[])statisticsBuffer));
        }
    }

    protected KeylockServiceImp getKeylockServiceImp() {
        return (KeylockServiceImp)this.getDeviceServiceImp();
    }

    protected KeylockServiceState getKeylockServiceState() {
        return (KeylockServiceState)this.getDeviceServiceState();
    }

    public final String getDeviceCategory() {
        return KEYLOCK_DEVCAT;
    }
}

