/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import com.ibm.jpos.util.DefaultLogEntry;
import com.ibm.jpos.util.LogStore;
import java.util.Vector;

public abstract class AbstractLogger
implements Runnable {
    private LogStore logStore = null;
    private Vector entries = new Vector();
    private Thread logStoreThread = new Thread(this);
    private Object wakeup = new Object();
    private boolean saveLog = false;
    private boolean logSaved = false;
    private boolean errorSaving = false;
    private Exception errorException = null;
    private static String terminalID = "Terminal X";

    protected AbstractLogger(LogStore logStore) {
        this.logStore = logStore;
        this.logStoreThread.start();
    }

    public static void setTerminalID(String s) {
        terminalID = s;
    }

    public static String getTerminalID() {
        return terminalID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(DefaultLogEntry entry) {
        this.entries.addElement(entry);
        if (this.entries.size() == 1) {
            Object object = this.wakeup;
            synchronized (object) {
                this.wakeup.notifyAll();
            }
        }
        this.logSaved = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() {
        this.saveLog = true;
        Object object = this.wakeup;
        synchronized (object) {
            this.wakeup.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (this.entries.isEmpty() || !this.saveLog) {
                Object object = this.wakeup;
                synchronized (object) {
                    try {
                        this.wakeup.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!this.entries.isEmpty()) {
                for (int i = 0; i < this.entries.size(); ++i) {
                    this.logStore.add((DefaultLogEntry)this.entries.elementAt(i));
                }
                this.entries.removeAllElements();
            }
            if (!this.saveLog) continue;
            try {
                this.logStore.flush();
                this.errorSaving = false;
                this.errorException = null;
            }
            catch (Exception e) {
                this.errorSaving = true;
                this.errorException = e;
            }
            this.saveLog = false;
            this.logSaved = !this.errorSaving;
        }
    }

    public boolean isLogSaved() {
        return this.logSaved;
    }

    public boolean isErrorSaving() {
        return this.errorSaving;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    protected LogStore getLogStore() {
        return this.logStore;
    }
}

