/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

public class HexDumper {
    public HexDumper(String title, StringBuffer buffer, int len) {
        this.dumpStringBuffer(title, buffer, len, null);
    }

    public HexDumper(String title, StringBuffer buffer, int len, StringBuffer output) {
        this.dumpStringBuffer(title, buffer, len, output);
    }

    public boolean isPrintable(byte value) {
        return value != 0 && value != 7 && value != 8 && value != 9 && value != 10 && value != 13;
    }

    public StringBuffer hexString(int value, int length) {
        String tempS = new String();
        tempS = Integer.toHexString(value);
        while (tempS.length() < length) {
            tempS = "0" + tempS;
        }
        StringBuffer output = new StringBuffer(tempS);
        return output;
    }

    public StringBuffer hexString(byte value) {
        byte highNibble = (byte)((value & 0xF0) >> 4);
        byte lowNibble = (byte)(value & 0xF);
        StringBuffer output = new StringBuffer();
        output.append(this.hexNibble(highNibble));
        output.append(this.hexNibble(lowNibble));
        return output;
    }

    private char hexNibble(byte value) {
        if (value < 10) {
            return (char)(value + 48);
        }
        return (char)(value - 10 + 65);
    }

    void dumpStringBuffer(String title, StringBuffer stringData, int len, StringBuffer output) {
        int i;
        StringBuffer ascii = new StringBuffer("                ");
        int BytesToDump = 0;
        int dataSize = stringData.length();
        byte[] dataBuffer = new byte[dataSize];
        StringBuffer out = new StringBuffer();
        if (len > 0 && len < dataSize) {
            dataSize = len;
        }
        for (i = 0; i < dataSize; ++i) {
            dataBuffer[i] = (byte)stringData.toString().charAt(i);
        }
        if (dataBuffer.length != 0 && dataSize != 0) {
            out.append("\n\n" + title + " (" + dataSize + " bytes)\n\n");
            if (dataSize < 65520) {
                BytesToDump = dataSize + 15 & 0xFFF0;
            }
            int pData = 0;
            for (i = 0; i < BytesToDump; ++i) {
                if (i % 16 == 0) {
                    out.append("   " + this.hexString(i, 4) + ": ");
                }
                if ((i + 8) % 16 == 0) {
                    out.append(" - ");
                }
                if (i < dataSize) {
                    byte ch = dataBuffer[pData++];
                    out.append(this.hexString(ch).toString());
                    if (this.isPrintable(ch)) {
                        ascii.setCharAt(i % 16, (char)ch);
                    } else {
                        ascii.setCharAt(i % 16, '.');
                    }
                } else {
                    out.append("--");
                    ascii.setCharAt(i % 16, ' ');
                }
                if (i % 16 != 15) continue;
                out.append(" | " + ascii + "\n");
            }
            out.append("\n");
        }
        if (output == null) {
            System.out.println(out);
        } else {
            output.append(out);
        }
    }
}

