/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mask.inumeric;

import com.ibm.mask.inumeric.InternalDocument;
import com.ibm.mask.inumeric.InvalidInputEvent;
import com.ibm.mask.inumeric.InvalidInputListener;
import com.ibm.mask.inumeric.NumericRangeEvent;
import com.ibm.mask.inumeric.NumericRangeListener;
import com.ibm.mask.inumeric.TextEventFirer;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class INumeric
extends JTextField
implements FocusListener,
KeyListener,
MouseListener,
Serializable {
    private int digitsBeforeDP;
    private int digitsAfterDP;
    private String positivePrefix;
    private String positiveSuffix;
    private String negativePrefix;
    private String negativeSuffix;
    private char decimalInput;
    private String decimalDisplay;
    private char groupingSymbol;
    private int groupingSize;
    private double value;
    private double minValue;
    private double maxValue;
    private boolean beepOnError;
    private boolean selectOnFocus;
    private double oldValue;
    private static final int INVALID_CHAR = 0;
    private static final int INVALID_OPERATION = 1;
    private static final int END_OF_INPUT = 2;
    private DecimalFormat formatter;
    private transient FieldPosition intField;
    private transient FieldPosition fractField;
    private int intBegin;
    private int intEnd;
    private int fractBegin;
    private int fractEnd;
    private StringBuffer txtBuffer;
    private int cursorPosition;
    private boolean inIntegerField;
    private transient Toolkit toolkit;
    private Vector inputListeners;
    private Vector valueListeners;
    private static final long serialVersionUID = -8463076283495164873L;
    boolean insertStringValid = false;
    private Document defaultModel;
    private Vector textListeners = new Vector(5);
    private transient TextEventFirer firer;

    public INumeric() {
        this.initialise();
    }

    public INumeric(int n) {
        super(n);
        this.initialise();
    }

    protected void initialise() {
        super.setBackground(Color.white);
        this.firer = new TextEventFirer(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.inputListeners = new Vector(5);
        this.valueListeners = new Vector(5);
        this.minValue = -100.0;
        this.maxValue = 1000000.0;
        this.toolkit = Toolkit.getDefaultToolkit();
        this.beepOnError = true;
        this.selectOnFocus = true;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            this.formatter = (DecimalFormat)numberFormat;
        } else {
            numberFormat = NumberFormat.getInstance(Locale.US);
            if (numberFormat instanceof DecimalFormat) {
                this.formatter = (DecimalFormat)numberFormat;
            } else {
                throw new Error("Could not get a DecimalFormat for the current locale!!");
            }
        }
        this.positivePrefix = this.formatter.getPositivePrefix();
        this.positiveSuffix = this.formatter.getPositiveSuffix();
        this.negativePrefix = this.formatter.getNegativePrefix();
        this.negativeSuffix = this.formatter.getNegativeSuffix();
        this.groupingSize = this.formatter.getGroupingSize();
        this.digitsBeforeDP = 13;
        this.digitsAfterDP = ((NumberFormat)this.formatter).getMaximumFractionDigits();
        ((NumberFormat)this.formatter).setMinimumFractionDigits(this.digitsAfterDP);
        if (this.digitsAfterDP > 0) {
            this.formatter.setParseIntegerOnly(false);
            this.formatter.setDecimalSeparatorAlwaysShown(true);
        } else {
            this.formatter.setParseIntegerOnly(true);
            this.formatter.setDecimalSeparatorAlwaysShown(false);
        }
        DecimalFormatSymbols decimalFormatSymbols = this.formatter.getDecimalFormatSymbols();
        this.decimalInput = decimalFormatSymbols.getDecimalSeparator();
        this.decimalDisplay = new Character(decimalFormatSymbols.getDecimalSeparator()).toString();
        this.groupingSymbol = decimalFormatSymbols.getGroupingSeparator();
        this.intField = new FieldPosition(0);
        this.fractField = new FieldPosition(1);
        this.txtBuffer = new StringBuffer();
        this.oldValue = this.value = 0.0;
        this.updateField();
        this.cursorPosition = this.intBegin;
        this.inIntegerField = true;
    }

    protected void parseField() throws ParseException {
        if (this.digitsAfterDP > 0) {
            int n = this.fractBegin;
            int n2 = this.intEnd;
            int n3 = this.txtBuffer.length();
            while (n < n3) {
                this.txtBuffer.setCharAt(n2, this.txtBuffer.charAt(n));
                ++n;
                ++n2;
            }
            this.txtBuffer.insert(this.intEnd, this.decimalInput);
            int n4 = this.decimalDisplay.length() - 1;
            this.fractBegin -= n4;
            this.fractEnd -= n4;
            this.txtBuffer.setLength(n3 - n4);
        }
        this.value = this.formatter.parse(this.txtBuffer.toString()).doubleValue();
    }

    private int digitsAfterDecimalPoint(double d) {
        int n;
        Double d2 = new Double(d);
        String string = d2.toString();
        String string2 = string.substring((n = string.indexOf(this.decimalInput)) + 1);
        if (string2.equals("0")) {
            return 0;
        }
        return string.length() - n - 1;
    }

    private int digitsBeforeDecimalPoint(double d) {
        Double d2 = new Double(d);
        String string = d2.toString();
        int n = string.indexOf(this.decimalInput);
        return n;
    }

    protected void updateField() throws IllegalArgumentException {
        CharSequence charSequence;
        boolean bl = false;
        double d = Math.abs(this.value);
        char c = String.valueOf(this.value).charAt(0);
        StringBuffer stringBuffer = new StringBuffer("-");
        if (d == 0.0 && c == '-' && this.getNegativePrefix().equals("-")) {
            charSequence = String.valueOf(this.value);
            stringBuffer.append("1");
            stringBuffer.append(((String)charSequence).substring(2, ((String)charSequence).length()));
            this.value = Double.valueOf(stringBuffer.toString());
            bl = true;
        }
        this.txtBuffer.setLength(0);
        this.formatter.format(this.value, this.txtBuffer, this.intField);
        this.txtBuffer.setLength(0);
        this.formatter.format(this.value, this.txtBuffer, this.fractField);
        if (bl) {
            this.txtBuffer.setCharAt(1, '0');
            charSequence = new StringBuffer(stringBuffer.toString());
            ((StringBuffer)charSequence).setCharAt(1, '0');
            this.value = Double.valueOf(((StringBuffer)charSequence).toString());
            bl = false;
        }
        this.intBegin = this.intField.getBeginIndex();
        this.intEnd = this.intField.getEndIndex();
        this.fractBegin = this.fractField.getBeginIndex();
        this.fractEnd = this.fractField.getEndIndex();
        if (this.digitsAfterDP > 0) {
            int n = this.txtBuffer.length();
            int n2 = this.intEnd;
            while (n2 < n - 1) {
                this.txtBuffer.setCharAt(n2, this.txtBuffer.charAt(n2 + 1));
                ++n2;
            }
            this.txtBuffer.setLength(n - 1);
            int n3 = this.decimalDisplay.length();
            this.txtBuffer.insert(this.intEnd, this.decimalDisplay);
            this.fractBegin += n3 - 1;
            this.fractEnd += n3 - 1;
        }
        this.insertStringValid = true;
        super.setText(this.txtBuffer.toString());
        this.insertStringValid = false;
        if (this.oldValue != this.value) {
            this.firePropertyChange("value", this.oldValue, this.value);
            this.oldValue = this.value;
        }
    }

    protected void resetField() {
        if (this.digitsBeforeDP > 0) {
            this.cursorPosition = this.intEnd;
            this.inIntegerField = true;
            return;
        }
        this.cursorPosition = this.fractBegin;
        this.inIntegerField = false;
    }

    public void setText(String string) {
    }

    public void setCaretPosition(int n) {
        int n2 = this.intBegin;
        if (n < this.intBegin) {
            n2 = this.intBegin;
        } else if (this.digitsAfterDP > 0 && n > this.fractEnd) {
            n2 = this.fractEnd;
        } else if (this.digitsAfterDP == 0 && n > this.intEnd) {
            n2 = this.intEnd;
        } else if (n > this.intEnd && n < this.fractBegin) {
            n2 = this.intEnd;
        }
        this.cursorPosition = n2;
        if (this.cursorPosition <= this.intEnd) {
            this.inIntegerField = true;
        } else if (this.digitsAfterDP > 0 && this.cursorPosition >= this.fractBegin) {
            this.inIntegerField = false;
        }
        super.setCaretPosition(n2);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) throws IllegalArgumentException {
        double d2 = this.value;
        if (this.digitsAfterDP == 0) {
            d = (long)d;
        }
        if (d < this.minValue) {
            throw new IllegalArgumentException("Cannot set value below the minimum specified value");
        }
        if (d > this.maxValue) {
            throw new IllegalArgumentException("Cannot set value above the maximum specified value");
        }
        this.value = d;
        double d3 = Math.abs(d);
        if (this.digitsAfterDecimalPoint(d3) > this.getDigitsAfterDP()) {
            throw new IllegalArgumentException("Digits after DP exceeds the value set");
        }
        if (this.digitsBeforeDecimalPoint(d3) > this.getDigitsBeforeDP()) {
            throw new IllegalArgumentException("Digits before DP exceeds the value set");
        }
        this.updateField();
        this.resetField();
        this.firePropertyChange("value", d2, this.value);
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double d) throws IllegalArgumentException {
        if (d > this.maxValue) {
            throw new IllegalArgumentException("Minimum value cannot be greater than the maximum specified");
        }
        double d2 = this.minValue;
        this.minValue = d;
        if (this.value < d) {
            this.value = this.minValue;
        }
        this.updateField();
        this.resetField();
        this.firePropertyChange("minValue", d2, this.minValue);
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double d) throws IllegalArgumentException {
        if (d < this.minValue) {
            throw new IllegalArgumentException("Maximum value cannot be less than the minimum specified");
        }
        double d2 = this.maxValue;
        this.maxValue = d;
        if (this.value > d) {
            this.value = this.maxValue;
        }
        this.updateField();
        this.resetField();
        this.firePropertyChange("maxValue", d2, this.maxValue);
    }

    public boolean getSelectOnFocus() {
        return this.selectOnFocus;
    }

    public void setSelectOnFocus(boolean bl) {
        boolean bl2 = this.selectOnFocus;
        this.selectOnFocus = bl;
        this.firePropertyChange("selectOnFocus", bl2, this.selectOnFocus);
    }

    public boolean getBeepOnError() {
        return this.beepOnError;
    }

    public void setBeepOnError(boolean bl) {
        boolean bl2 = this.beepOnError;
        this.beepOnError = bl;
        this.firePropertyChange("beepOnError", bl2, this.beepOnError);
    }

    public int getDigitsBeforeDP() {
        return this.digitsBeforeDP;
    }

    public void setDigitsBeforeDP(int n) throws IllegalArgumentException {
        int n2 = this.digitsBeforeDP;
        double d = Math.abs(this.getValue());
        if (this.digitsBeforeDecimalPoint(d) > n) {
            throw new IllegalArgumentException("Digits before DP exceeds the value set");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Expecting a positive value for digits before decimal point");
        }
        if (n > 127) {
            throw new IllegalArgumentException("Too large a value for digits before decimal point");
        }
        this.digitsBeforeDP = n;
        ((NumberFormat)this.formatter).setMaximumIntegerDigits(n);
        this.updateField();
        this.resetField();
        this.firePropertyChange("digitsBeforeDP", n2, this.digitsBeforeDP);
    }

    public int getDigitsAfterDP() {
        return this.digitsAfterDP;
    }

    public void setDigitsAfterDP(int n) throws IllegalArgumentException {
        int n2 = this.digitsAfterDP;
        double d = Math.abs(this.getValue());
        if (this.digitsAfterDecimalPoint(d) > n) {
            throw new IllegalArgumentException("Digits after DP exceeds the value set");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Expecting a positive value for digits after decimal point");
        }
        if (n > 127) {
            throw new IllegalArgumentException("Too large a value for digits after decimal point");
        }
        this.digitsAfterDP = n;
        ((NumberFormat)this.formatter).setMinimumFractionDigits(n);
        ((NumberFormat)this.formatter).setMaximumFractionDigits(n);
        if (n == 0) {
            this.formatter.setParseIntegerOnly(true);
            this.formatter.setDecimalSeparatorAlwaysShown(false);
        } else if (n > 0) {
            this.formatter.setParseIntegerOnly(false);
            this.formatter.setDecimalSeparatorAlwaysShown(true);
        }
        this.updateField();
        this.resetField();
        this.firePropertyChange("setDigitsAfterDP", n2, this.digitsAfterDP);
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null Positive Prefix!");
        }
        String string2 = this.positivePrefix;
        this.positivePrefix = string;
        this.formatter.setPositivePrefix(string);
        this.updateField();
        this.firePropertyChange("positivePrefix", string2, this.positivePrefix);
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public void setPositiveSuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null Positive Suffix!");
        }
        String string2 = this.positiveSuffix;
        this.positiveSuffix = string;
        this.formatter.setPositiveSuffix(string);
        this.updateField();
        this.firePropertyChange("positiveSuffix", string2, this.positiveSuffix);
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public void setNegativePrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null Negative Prefix!");
        }
        String string2 = this.negativePrefix;
        this.negativePrefix = string;
        this.formatter.setNegativePrefix(string);
        this.updateField();
        this.firePropertyChange("negativePrefix", string2, this.negativePrefix);
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public void setNegativeSuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null Negative Suffix!");
        }
        String string2 = this.negativeSuffix;
        this.negativeSuffix = string;
        this.formatter.setNegativeSuffix(string);
        this.updateField();
        this.firePropertyChange("negativeSuffix", string2, this.negativeSuffix);
    }

    public String getDecimalDisplay() {
        return this.decimalDisplay;
    }

    public void setDecimalDisplay(String string) throws IllegalArgumentException {
        String string2 = this.decimalDisplay;
        if (string == null) {
            throw new IllegalArgumentException("Null value for decimal display string specified");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("Non-empty decimal display string required");
        }
        if (string.charAt(0) == this.getGroupingSymbol()) {
            throw new IllegalArgumentException("Cannot be same as GroupingSymbol.");
        }
        this.decimalDisplay = string;
        this.updateField();
        this.firePropertyChange("decimalDisplay", string2, this.decimalDisplay);
    }

    public char getDecimalInput() {
        return this.decimalInput;
    }

    public void setDecimalInput(char c) throws IllegalArgumentException {
        char c2 = this.decimalInput;
        if (Character.isDigit(c) || c == '+' || c == '-' || c == ' ') {
            throw new IllegalArgumentException("Illegal character for decimal input");
        }
        if (c == this.getGroupingSymbol()) {
            throw new IllegalArgumentException("Cannot be the same as GroupingSymbol");
        }
        this.decimalInput = c;
        DecimalFormatSymbols decimalFormatSymbols = this.formatter.getDecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator(c);
        this.formatter.setDecimalFormatSymbols(decimalFormatSymbols);
        this.updateField();
        this.firePropertyChange("decimalInput", c2, this.decimalInput);
    }

    public char getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public void setGroupingSymbol(char c) throws IllegalArgumentException {
        char c2 = this.groupingSymbol;
        Character c3 = new Character(c);
        int n = c3.toString().length();
        if (Character.isDigit(c) || c == '+' || c == '-' || n == 0 || n > 1) {
            throw new IllegalArgumentException("Illegal character for grouping symbol");
        }
        if (c == this.getDecimalInput()) {
            throw new IllegalArgumentException("Cannot be the same as DecimalInput");
        }
        if (c == this.getDecimalDisplay().charAt(0)) {
            throw new IllegalArgumentException("Cannot be the same as DecimalDisplay");
        }
        this.groupingSymbol = c;
        if (c == '\u0000') {
            ((NumberFormat)this.formatter).setGroupingUsed(false);
        } else {
            ((NumberFormat)this.formatter).setGroupingUsed(true);
            DecimalFormatSymbols decimalFormatSymbols = this.formatter.getDecimalFormatSymbols();
            decimalFormatSymbols.setGroupingSeparator(c);
            this.formatter.setDecimalFormatSymbols(decimalFormatSymbols);
        }
        this.updateField();
        this.firePropertyChange("groupingSymbol", c2, this.groupingSymbol);
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int n) throws IllegalArgumentException {
        int n2 = this.groupingSize;
        if (n < 0) {
            throw new IllegalArgumentException("Expecting a positive value for grouping size");
        }
        if (n == 0) {
            ((NumberFormat)this.formatter).setGroupingUsed(false);
            this.groupingSize = n;
        } else {
            ((NumberFormat)this.formatter).setGroupingUsed(true);
            this.groupingSize = n;
            this.formatter.setGroupingSize(n);
        }
        this.updateField();
        this.firePropertyChange("groupingSize", n2, this.groupingSize);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            int n = this.getCaretPosition();
            if (n < this.intBegin) {
                super.setCaretPosition(this.intBegin);
            } else if (this.digitsAfterDP > 0 && n > this.fractEnd) {
                super.setCaretPosition(this.fractEnd);
            } else if (n > this.intEnd && n < this.fractBegin) {
                super.setCaretPosition(this.intEnd);
            }
            this.cursorPosition = this.getCaretPosition();
            if (this.cursorPosition <= this.intEnd) {
                this.cursorPosition = this.intBegin;
                this.inIntegerField = true;
            } else if (this.digitsAfterDP > 0 && this.cursorPosition >= this.fractBegin) {
                this.cursorPosition = this.intBegin;
                this.inIntegerField = true;
            }
            if (this.selectOnFocus) {
                super.setCaretPosition(this.getText().length());
                super.moveCaretPosition(0);
                this.inIntegerField = true;
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.value < this.minValue) {
            this.notifyRangeError(0);
        } else if (this.value > this.maxValue) {
            this.notifyRangeError(1);
        }
        if (this.selectOnFocus) {
            super.setCaretPosition(0);
            super.moveCaretPosition(0);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.insertStringValid = true;
        if (!this.isEditable()) {
            this.insertStringValid = false;
            return;
        }
        if (keyEvent.getModifiers() == 8 || keyEvent.getModifiers() == 2 || keyEvent.getModifiers() == 4) {
            this.insertStringValid = false;
            return;
        }
        if (!this.isEditable()) {
            keyEvent.consume();
            this.insertStringValid = false;
            return;
        }
        int n = keyEvent.getKeyCode();
        boolean bl = false;
        switch (n) {
            case 37: {
                bl = this.handleLeft(keyEvent);
                break;
            }
            case 39: {
                bl = this.handleRight(keyEvent);
                break;
            }
            case 38: 
            case 40: {
                bl = true;
                break;
            }
            case 36: {
                bl = this.handleHome(keyEvent);
                break;
            }
            case 35: {
                bl = this.handleEnd(keyEvent);
                break;
            }
            case 8: {
                bl = this.handleBackSpace(keyEvent);
                break;
            }
            case 127: {
                bl = this.handleDelete(keyEvent);
                break;
            }
            default: {
                this.handleKeyPress(keyEvent);
                bl = false;
            }
        }
        if (bl) {
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void handleKeyPress(KeyEvent keyEvent) {
        this.insertStringValid = true;
        if (!this.isEditable()) {
            this.insertStringValid = false;
            return;
        }
        if (keyEvent.isAltDown() || keyEvent.isControlDown()) {
            keyEvent.consume();
            this.insertStringValid = false;
            return;
        }
        if (!this.isEditable()) {
            keyEvent.consume();
            this.insertStringValid = false;
            return;
        }
        char c = keyEvent.getKeyChar();
        boolean bl = false;
        switch (c) {
            case '+': {
                bl = this.handlePlus(keyEvent);
                break;
            }
            case '-': {
                bl = this.handleMinus(keyEvent);
                break;
            }
            case '\b': {
                bl = true;
                break;
            }
            case '\t': 
            case '\n': {
                bl = false;
                break;
            }
            default: {
                if (c == this.decimalInput) {
                    bl = this.handleDecimalPoint(keyEvent);
                    break;
                }
                if (Character.isDigit(c)) {
                    bl = this.handleDigits(keyEvent);
                    break;
                }
                bl = true;
                this.notifyInputError(0, c);
            }
        }
        if (bl) {
            keyEvent.consume();
        }
        this.insertStringValid = false;
    }

    protected boolean handlePlus(KeyEvent keyEvent) {
        if (this.maxValue < 0.0) {
            this.notifyRangeError(1);
            return true;
        }
        if (this.value < 0.0) {
            this.value *= -1.0;
            int n = this.cursorPosition - this.intBegin;
            this.updateField();
            this.cursorPosition = this.intBegin + n;
            super.setCaretPosition(this.cursorPosition);
        }
        if (Math.abs(this.value) == 0.0 && String.valueOf(this.value).charAt(0) == '-') {
            String string = String.valueOf(this.value);
            String string2 = string.substring(1, string.length());
            this.value = Double.valueOf(string2);
            this.updateField();
            super.setCaretPosition(0);
        }
        return true;
    }

    protected boolean handleMinus(KeyEvent keyEvent) {
        if (this.minValue >= 0.0) {
            this.notifyRangeError(0);
            return true;
        }
        if (this.value > 0.0) {
            this.value *= -1.0;
            int n = this.cursorPosition - this.intBegin;
            this.updateField();
            this.cursorPosition = this.intBegin + n;
            if (String.valueOf(this.value).charAt(0) == '-' && Math.abs(this.value) == 0.0) {
                this.cursorPosition = this.getNegativePrefix().equals("-") ? 1 : 0;
            }
            if (String.valueOf(this.value).charAt(0) != '-' && Math.abs(this.value) == 0.0) {
                this.cursorPosition = 0;
            }
            super.setCaretPosition(this.cursorPosition);
        }
        return true;
    }

    protected boolean handleDecimalPoint(KeyEvent keyEvent) {
        if (this.digitsAfterDP > 0 && this.cursorPosition < this.txtBuffer.length() && this.cursorPosition == this.intEnd) {
            this.cursorPosition = this.fractBegin;
            this.inIntegerField = false;
            super.setCaretPosition(this.cursorPosition);
        } else {
            this.notifyInputError(1, keyEvent.getKeyChar());
        }
        return true;
    }

    protected boolean handleDigits(KeyEvent keyEvent) {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        if (n2 - n > 0) {
            this.deleteSelectedText(n, n2);
        }
        int n3 = this.txtBuffer.length();
        char c = keyEvent.getKeyChar();
        if (this.inIntegerField) {
            int n4;
            int n5 = this.intEnd - this.intBegin;
            if (this.groupingSize == 0 && n5 == this.digitsBeforeDP) {
                DecimalFormatSymbols decimalFormatSymbols = this.formatter.getDecimalFormatSymbols();
                char c2 = decimalFormatSymbols.getZeroDigit();
                if (this.cursorPosition == this.intBegin || this.txtBuffer.charAt(this.intBegin) != c2) {
                    this.notifyInputError(2, keyEvent.getKeyChar());
                    return true;
                }
            }
            if (n5 - (n4 = (int)Math.floor(n5 / (this.groupingSize + 1))) == this.digitsBeforeDP) {
                DecimalFormatSymbols decimalFormatSymbols = this.formatter.getDecimalFormatSymbols();
                char c3 = decimalFormatSymbols.getZeroDigit();
                if (this.cursorPosition == this.intBegin || this.txtBuffer.charAt(this.intBegin) != c3) {
                    this.notifyInputError(2, keyEvent.getKeyChar());
                    return true;
                }
            }
            this.txtBuffer.insert(this.cursorPosition, c);
            ++this.intEnd;
            ++this.fractBegin;
        } else {
            if (this.cursorPosition == this.fractEnd) {
                this.notifyInputError(2, keyEvent.getKeyChar());
                return true;
            }
            this.txtBuffer.setCharAt(this.cursorPosition, c);
        }
        try {
            this.parseField();
        }
        catch (ParseException parseException) {}
        this.updateField();
        if (this.inIntegerField) {
            this.cursorPosition += this.txtBuffer.length() - n3;
        } else if (this.cursorPosition != this.fractEnd) {
            ++this.cursorPosition;
        }
        super.setCaretPosition(this.cursorPosition);
        return true;
    }

    protected void deleteSelectedText(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (this.digitsBeforeDP > 0 && n < this.intEnd && n2 > this.intBegin) {
            n8 = n < this.intBegin ? this.intBegin : n;
            n7 = n2 > this.intEnd ? this.intEnd : n2;
        }
        if (this.digitsAfterDP > 0 && n < this.fractEnd && n2 > this.fractBegin) {
            n10 = n < this.fractBegin ? this.fractBegin : n;
            n9 = n2 > this.fractEnd ? this.fractEnd : n2;
        }
        if (n7 - n8 > 0) {
            n6 = n8;
            n5 = n7;
            n4 = this.txtBuffer.length();
            n3 = n7 - n8;
            while (n5 < n4) {
                this.txtBuffer.setCharAt(n6, this.txtBuffer.charAt(n5));
                ++n5;
                ++n6;
            }
            this.txtBuffer.setLength(n4 - n3);
            this.intEnd -= n3;
            this.fractBegin -= n3;
            this.fractEnd -= n3;
            n10 -= n3;
            n9 -= n3;
        }
        if (n9 - n10 > 0) {
            n6 = n10;
            n5 = n9;
            n4 = this.txtBuffer.length();
            n3 = n9 - n10;
            while (n5 < n4) {
                this.txtBuffer.setCharAt(n6, this.txtBuffer.charAt(n5));
                ++n5;
                ++n6;
            }
            this.txtBuffer.setLength(n4 - n3);
            this.fractEnd -= n3;
        }
        try {
            this.parseField();
        }
        catch (ParseException parseException) {
            this.value = 0.0;
        }
        this.updateField();
        if (this.value == 0.0) {
            this.cursorPosition = this.inIntegerField && this.digitsBeforeDP > 0 ? this.intEnd : this.fractBegin;
        } else if (n7 - n8 > 0) {
            this.cursorPosition = n8 <= this.intEnd ? n8 : this.intEnd;
            this.inIntegerField = true;
        } else if (n9 - n10 > 0) {
            this.cursorPosition = n10;
            this.inIntegerField = false;
        }
        super.setCaretPosition(this.cursorPosition);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean handleBackSpace(KeyEvent var1_1) {
        block32: {
            block31: {
                var2_2 = this.getSelectionStart();
                var3_3 = this.getSelectionEnd();
                var4_4 = '*';
                var5_5 = 0;
                if (this.cursorPosition != 0) {
                    var5_5 = this.cursorPosition - 1;
                }
                var6_6 = this.txtBuffer.charAt(var5_5);
                var7_7 = this.cursorPosition;
                if (var3_3 - var2_2 > 0) {
                    this.deleteSelectedText(var2_2, var3_3);
                    return true;
                }
                if (this.cursorPosition <= this.intBegin) break block31;
                var8_8 = this.txtBuffer.length();
                if (var8_8 > 1) {
                    var4_4 = this.txtBuffer.charAt(1);
                    if (this.txtBuffer.charAt(1) == this.getGroupingSymbol()) {
                        --var8_8;
                    }
                }
                if (this.inIntegerField || this.cursorPosition != this.fractBegin) ** GOTO lbl25
                if (this.digitsBeforeDP > 0) {
                    this.inIntegerField = true;
                    this.cursorPosition = this.intEnd;
                } else {
                    this.notifyInputError(1, var1_1.getKeyCode());
                    return true;
lbl25:
                    // 1 sources

                    if (this.inIntegerField) {
                        var9_9 = this.cursorPosition - 1;
                        while (var9_9 < var8_8 - 1) {
                            this.txtBuffer.setCharAt(var9_9, this.txtBuffer.charAt(var9_9 + 1));
                            ++var9_9;
                        }
                        if (this.digitsAfterDP > 0) {
                            this.txtBuffer.setLength(var8_8 - 1);
                        } else if (this.value < this.getValueBeforeGS()) {
                            this.txtBuffer.setLength(var8_8 - 1);
                        } else if (var4_4 == this.getGroupingSymbol()) {
                            this.txtBuffer.setLength(var8_8);
                        } else {
                            this.txtBuffer.setLength(var8_8 - 1);
                        }
                        --this.intEnd;
                        --this.fractBegin;
                    } else {
                        var9_10 = this.formatter.getDecimalFormatSymbols();
                        var10_11 = var9_10.getZeroDigit();
                        this.txtBuffer.setCharAt(this.cursorPosition - 1, var10_11);
                    }
                }
                try {
                    if (this.digitsAfterDP == 0 && this.getPositiveSuffix().length() > 0) {
                        this.txtBuffer.setLength(this.intEnd);
                        this.txtBuffer.append(this.getPositiveSuffix());
                    }
                    this.parseField();
                }
                catch (ParseException v0) {
                    this.value = 0.0;
                }
                this.updateField();
                if (this.value == 0.0) {
                    this.cursorPosition = this.inIntegerField && this.digitsBeforeDP > 0 ? this.intEnd : this.fractBegin;
                } else if (this.inIntegerField) {
                    this.cursorPosition -= var8_8 - this.txtBuffer.length();
                    if (this.cursorPosition == -1) {
                        this.cursorPosition = 0;
                    }
                } else {
                    --this.cursorPosition;
                }
                if (var6_6 == this.getGroupingSymbol()) {
                    this.cursorPosition = var7_7 - 1;
                }
                if (var4_4 == this.getGroupingSymbol() && this.inIntegerField && this.cursorPosition > 0) {
                    --this.cursorPosition;
                }
                if (this.digitsAfterDP > 0) {
                    try {
                        super.setCaretPosition(this.cursorPosition);
                    }
                    catch (IllegalArgumentException v1) {
                        super.setCaretPosition(this.cursorPosition - 1);
                        --this.cursorPosition;
                    }
                } else {
                    try {
                        super.setCaretPosition(this.cursorPosition);
                    }
                    catch (IllegalArgumentException v2) {
                        super.setCaretPosition(this.cursorPosition - 1);
                        --this.cursorPosition;
                    }
                }
                break block32;
            }
            this.notifyInputError(1, var1_1.getKeyCode());
        }
        return true;
    }

    private double getValueBeforeGS() {
        int n = this.getGroupingSize();
        double d = 1.0;
        int n2 = 0;
        while (n2 < n) {
            d *= 10.0;
            ++n2;
        }
        return d;
    }

    protected boolean handleDelete(KeyEvent keyEvent) {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        if (this.cursorPosition == this.intEnd || this.digitsAfterDP > 0 && this.cursorPosition >= this.fractEnd) {
            this.notifyInputError(1, keyEvent.getKeyCode());
            return true;
        }
        char c = this.txtBuffer.charAt(this.cursorPosition);
        if (n2 - n > 0) {
            this.deleteSelectedText(n, n2);
            return true;
        }
        if (this.cursorPosition == this.intEnd || this.digitsAfterDP > 0 && this.cursorPosition == this.fractEnd) {
            this.notifyInputError(1, keyEvent.getKeyCode());
        } else {
            int n3 = this.txtBuffer.length();
            int n4 = this.cursorPosition;
            while (n4 < n3 - 1) {
                this.txtBuffer.setCharAt(n4, this.txtBuffer.charAt(n4 + 1));
                ++n4;
            }
            this.txtBuffer.setLength(n3 - 1);
            if (this.inIntegerField) {
                --this.intEnd;
                --this.fractBegin;
            }
            try {
                this.parseField();
            }
            catch (ParseException parseException) {
                this.value = 0.0;
            }
            this.updateField();
            if (this.inIntegerField && this.cursorPosition > this.intEnd) {
                this.cursorPosition = this.intEnd;
            }
            int n5 = 0;
            if (String.valueOf(this.value).charAt(0) == '-') {
                n5 = 1;
            }
            if (String.valueOf(this.value).charAt(n5) == '0' && String.valueOf(this.value).charAt(n5 + 1) == '.' && this.cursorPosition == n5) {
                this.cursorPosition = this.fractBegin;
                this.inIntegerField = false;
            }
            if (String.valueOf(this.value).charAt(n5) == '0' && String.valueOf(this.value).charAt(n5 + 1) == '.' && this.cursorPosition == this.getNegativePrefix().length()) {
                this.cursorPosition = this.fractBegin;
                this.inIntegerField = false;
            }
            if (c == this.getGroupingSymbol()) {
                ++this.cursorPosition;
            }
            super.setCaretPosition(this.cursorPosition);
        }
        return true;
    }

    protected boolean handleHome(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown()) {
            this.cursorPosition = this.intBegin;
            return false;
        }
        if (this.digitsBeforeDP > 0) {
            this.cursorPosition = this.intBegin;
            this.inIntegerField = true;
        } else {
            this.cursorPosition = this.fractBegin;
            this.inIntegerField = false;
        }
        super.setCaretPosition(this.cursorPosition);
        return true;
    }

    protected boolean handleEnd(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown()) {
            this.cursorPosition = this.fractEnd;
            return false;
        }
        if (this.digitsAfterDP > 0) {
            this.cursorPosition = this.fractEnd;
            this.inIntegerField = false;
        } else {
            this.cursorPosition = this.intEnd;
            this.inIntegerField = true;
        }
        super.setCaretPosition(this.cursorPosition);
        return true;
    }

    protected boolean handleLeft(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown()) {
            if (this.cursorPosition > this.intBegin) {
                --this.cursorPosition;
            }
            return false;
        }
        if (this.cursorPosition > this.intBegin) {
            if (this.digitsAfterDP > 0 && this.cursorPosition == this.fractBegin && this.digitsBeforeDP > 0) {
                this.inIntegerField = true;
                this.cursorPosition = this.intEnd;
            } else {
                if (this.digitsBeforeDP == 0 && this.cursorPosition == this.fractBegin) {
                    this.notifyInputError(1, keyEvent.getKeyCode());
                    return true;
                }
                --this.cursorPosition;
            }
            super.setCaretPosition(this.cursorPosition);
        } else {
            this.notifyInputError(1, keyEvent.getKeyCode());
        }
        return true;
    }

    protected boolean handleRight(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown()) {
            if (this.cursorPosition < this.fractEnd) {
                ++this.cursorPosition;
            }
            return false;
        }
        if (this.fractEnd > 0 && this.cursorPosition < this.fractEnd || this.cursorPosition < this.intEnd) {
            if (this.digitsAfterDP > 0 && this.cursorPosition == this.intEnd) {
                this.cursorPosition = this.fractBegin;
                this.inIntegerField = false;
            } else {
                ++this.cursorPosition;
            }
            super.setCaretPosition(this.cursorPosition);
        } else {
            this.notifyInputError(1, keyEvent.getKeyCode());
        }
        return true;
    }

    protected void notifyInputError(int n, int n2) {
        if (this.beepOnError) {
            this.toolkit.beep();
        }
        if (n == 0) {
            Vector vector;
            if (n2 == 10 || n2 == 13) {
                return;
            }
            InvalidInputEvent invalidInputEvent = new InvalidInputEvent(this, (char)n2);
            INumeric iNumeric = this;
            synchronized (iNumeric) {
                vector = (Vector)this.inputListeners.clone();
            }
            int n3 = 0;
            while (n3 < vector.size()) {
                InvalidInputListener invalidInputListener = (InvalidInputListener)vector.elementAt(n3);
                invalidInputListener.invalidCharacterEntered(invalidInputEvent);
                ++n3;
            }
        }
    }

    protected void notifyRangeError(int n) {
        Vector vector;
        NumericRangeEvent numericRangeEvent = new NumericRangeEvent(this, n, this.minValue, this.maxValue);
        INumeric iNumeric = this;
        synchronized (iNumeric) {
            vector = (Vector)this.valueListeners.clone();
        }
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < vector.size()) {
                    NumericRangeListener numericRangeListener = (NumericRangeListener)vector.elementAt(n2);
                    numericRangeListener.valueTooSmall(numericRangeEvent);
                    ++n2;
                }
                return;
            }
            case 1: {
                int n3 = 0;
                while (n3 < vector.size()) {
                    NumericRangeListener numericRangeListener = (NumericRangeListener)vector.elementAt(n3);
                    numericRangeListener.valueTooLarge(numericRangeEvent);
                    ++n3;
                }
                return;
            }
        }
    }

    public synchronized void addInvalidInputListener(InvalidInputListener invalidInputListener) {
        if (invalidInputListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.inputListeners == null) {
            this.inputListeners = new Vector();
        }
        if (!this.inputListeners.contains(invalidInputListener)) {
            this.inputListeners.addElement(invalidInputListener);
        }
    }

    public synchronized void removeInvalidInputListener(InvalidInputListener invalidInputListener) {
        if (invalidInputListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.inputListeners == null) {
            return;
        }
        if (this.inputListeners.contains(invalidInputListener)) {
            this.inputListeners.removeElement(invalidInputListener);
        }
    }

    public synchronized void addNumericRangeListener(NumericRangeListener numericRangeListener) {
        if (numericRangeListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.valueListeners == null) {
            this.valueListeners = new Vector();
        }
        if (!this.valueListeners.contains(numericRangeListener)) {
            this.valueListeners.addElement(numericRangeListener);
        }
    }

    public synchronized void removeNumericRangeListener(NumericRangeListener numericRangeListener) {
        if (numericRangeListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.valueListeners == null) {
            return;
        }
        if (this.valueListeners.contains(numericRangeListener)) {
            this.valueListeners.removeElement(numericRangeListener);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            mouseEvent.consume();
            return;
        }
        if (this.getSelectionEnd() - this.getSelectionStart() > 0) {
            return;
        }
        int n = this.getCaretPosition();
        if (n < this.intBegin) {
            super.setCaretPosition(this.intBegin);
        } else if (this.digitsAfterDP > 0 && n > this.fractEnd) {
            super.setCaretPosition(this.fractEnd);
        } else if (this.digitsAfterDP == 0 && n > this.intEnd) {
            super.setCaretPosition(this.intEnd);
        } else if (n > this.intEnd && n < this.fractBegin) {
            super.setCaretPosition(this.intEnd);
        }
        this.cursorPosition = this.getCaretPosition();
        if (this.cursorPosition <= this.intEnd) {
            this.inIntegerField = true;
            return;
        }
        if (this.digitsAfterDP > 0 && this.cursorPosition >= this.fractBegin) {
            this.inIntegerField = false;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.intField = new FieldPosition(0);
        this.fractField = new FieldPosition(1);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setSelectionStart(int n) {
        super.setSelectionStart(n);
    }

    public void setSelectionEnd(int n) {
        super.setSelectionEnd(n);
    }

    protected Document createDefaultModel() {
        return new InternalDocument(this);
    }

    public Document getDocument() {
        Document document = super.getDocument();
        if (document != null) {
            return document;
        }
        if (this.defaultModel == null) {
            this.defaultModel = this.createDefaultModel();
        }
        return this.defaultModel;
    }

    public void setDocument(Document document) {
        if (document != null && document instanceof InternalDocument) {
            super.setDocument(document);
            return;
        }
        throw new IllegalArgumentException("Only InternalDocument can be set!");
    }

    public synchronized void addTextListener(TextListener textListener) {
        if (this.textListeners == null) {
            this.textListeners = new Vector(5);
        }
        if (this.textListeners.contains(textListener)) {
            return;
        }
        this.textListeners.addElement(textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        if (this.textListeners == null) {
            return;
        }
        if (!this.textListeners.contains(textListener)) {
            return;
        }
        this.textListeners.removeElement(textListener);
    }

    Vector getTextListeners() {
        return (Vector)this.textListeners.clone();
    }
}

