/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import com.ibm.uvm.abt.edit.DialogHelper;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

public class CustomPropertyEditorDialog
extends Dialog
implements ActionListener,
WindowListener {
    private static ResourceBundle resabtedit = ResourceBundle.getBundle("com/ibm/uvm/abt/edit/abtedit");
    private Component propertyEditorComponent;
    private Object vajCustomPropertyEditorDialogProxy;
    private Button okButton;
    private Button cancelButton;
    private Panel buttonRow;
    private Rectangle frameBounds;
    private boolean firstLayout = true;
    private boolean okPressed = false;

    static {
        System.loadLibrary("abtedit");
    }

    public CustomPropertyEditorDialog(Frame frame, String title, Rectangle frameRect, Component customEditor, Object listener) {
        super(frame, true);
        String text = title;
        if (text == null) {
            text = customEditor.getClass().getName();
        }
        this.setTitle(text);
        this.frameBounds = frameRect;
        this.propertyEditorComponent = customEditor;
        this.vajCustomPropertyEditorDialogProxy = listener;
        this.setLayout(new BorderLayout());
        this.add("Center", this.propertyEditorComponent);
        this.buttonRow = new Panel();
        this.buttonRow.setLayout(new FlowLayout(2));
        Panel buttonGrid = new Panel();
        this.buttonRow.add(buttonGrid);
        buttonGrid.setLayout(new GridLayout(1, 0, 5, 0));
        this.okButton = new Button(resabtedit.getString("OK"));
        buttonGrid.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new Button(resabtedit.getString("Cancel"));
        buttonGrid.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.add("South", this.buttonRow);
        this.addWindowListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.okPressed = true;
            this.dispose();
        }
        if (e.getSource() == this.cancelButton) {
            this.okPressed = false;
            this.dispose();
        }
    }

    public synchronized void dispose() {
        this.remove(this.propertyEditorComponent);
        super.dispose();
    }

    public void doInitialLayout() {
        Insets insets = this.getInsets();
        Dimension dc = this.propertyEditorComponent.getSize();
        if (dc.width == 0 || dc.height == 0) {
            dc = this.propertyEditorComponent.getPreferredSize();
            this.propertyEditorComponent.setSize(dc);
        }
        this.propertyEditorComponent.setLocation(0, 0);
        Dimension dp = this.buttonRow.getPreferredSize();
        int newWidth = Math.max(dc.width, dp.width) + insets.left + insets.right;
        int newHeight = dc.height + dp.height + insets.top + insets.bottom;
        ((Component)this).setSize(newWidth, newHeight);
        DialogHelper.centerWindowOnRectangle(this, this.frameBounds);
    }

    public void doLayout() {
        if (this.firstLayout) {
            this.doInitialLayout();
            this.firstLayout = false;
        }
        super.doLayout();
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public void windowActivated(WindowEvent e) {
    }

    public native void windowClosed(WindowEvent var1);

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.okPressed = false;
            this.dispose();
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

