/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ResourceBundle;

public class FontPropertyEditor
extends Panel
implements PropertyChangeListener {
    private static ResourceBundle resabtedit = ResourceBundle.getBundle("com/ibm/uvm/abt/edit/abtedit");
    private Font fontValue;
    private String[] fonts;
    private BorderLayout ivjBorderLayout = null;
    private Panel ivjHeaderPanel = null;
    private GridLayout ivjHeaderGridLayout = null;
    private Label ivjFamilyLabel = null;
    private Label ivjStyleLabel = null;
    private Label ivjSizeLabel = null;
    private Choice ivjFamilyChooser = null;
    private Choice ivjSizeChooser = null;
    private Choice ivjStyleChooser = null;
    private TextArea ivjTextArea = null;
    private static final int[] pointSizes = new int[]{3, 5, 8, 10, 12, 14, 18, 24, 36, 48};
    private Label sample;
    private String sampleText = resabtedit.getString("Abcde...");
    private static final String[] styleNames = new String[]{resabtedit.getString("plain"), resabtedit.getString("bold"), resabtedit.getString("italic"), resabtedit.getString("bold_italic")};
    private static final int[] styles = new int[]{0, 1, 2, 3};
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Toolkit toolkit;

    public FontPropertyEditor() {
        this.initialize();
    }

    public FontPropertyEditor(Font aFont) {
        this.initialize();
        this.setFontValue(aFont);
    }

    public boolean action(Event e, Object arg) {
        String family = this.getFamilyChooser().getSelectedItem();
        int style = styles[this.getStyleChooser().getSelectedIndex()];
        int size = pointSizes[this.getSizeChooser().getSelectedIndex()];
        try {
            Font f = new Font(family, style, size);
            this.changeFont(f);
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(resabtedit.getString("Couldn't_create_font")) + family + "-" + styleNames[style] + "-" + size);
        }
        return false;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    private void changeFont(Font f) {
        this.fontValue = f;
        Container p = this.getParent();
        if (p != null) {
            ((Component)p).invalidate();
            ((Component)p).doLayout();
        }
        this.invalidate();
        this.doLayout();
        this.repaint();
        this.support.firePropertyChange("", null, null);
    }

    private BorderLayout getBorderLayout() {
        try {
            this.ivjBorderLayout = new BorderLayout(5, 5);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return this.ivjBorderLayout;
    }

    private Choice getFamilyChooser() {
        if (this.ivjFamilyChooser == null) {
            try {
                this.ivjFamilyChooser = new Choice();
                this.ivjFamilyChooser.setName("FamilyChooser");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFamilyChooser;
    }

    private Label getFamilyLabel() {
        if (this.ivjFamilyLabel == null) {
            try {
                this.ivjFamilyLabel = new Label();
                this.ivjFamilyLabel.setName("FamilyLabel");
                this.ivjFamilyLabel.setText(resabtedit.getString("Name"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFamilyLabel;
    }

    public Font getFontValue() {
        return this.fontValue;
    }

    private GridLayout getHeaderGridLayout() {
        try {
            this.ivjHeaderGridLayout = new GridLayout(2, 3, 5, 0);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return this.ivjHeaderGridLayout;
    }

    private Panel getHeaderPanel() {
        if (this.ivjHeaderPanel == null) {
            try {
                this.ivjHeaderPanel = new Panel();
                this.ivjHeaderPanel.setName("HeaderPanel");
                this.ivjHeaderPanel.setLayout(this.getHeaderGridLayout());
                this.ivjHeaderPanel.add((Component)this.getFamilyLabel(), this.getFamilyLabel().getName());
                this.ivjHeaderPanel.add((Component)this.getStyleLabel(), this.getStyleLabel().getName());
                this.ivjHeaderPanel.add((Component)this.getSizeLabel(), this.getSizeLabel().getName());
                this.ivjHeaderPanel.add((Component)this.getFamilyChooser(), this.getFamilyChooser().getName());
                this.ivjHeaderPanel.add((Component)this.getStyleChooser(), this.getStyleChooser().getName());
                this.ivjHeaderPanel.add((Component)this.getSizeChooser(), this.getSizeChooser().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjHeaderPanel;
    }

    private Choice getSizeChooser() {
        if (this.ivjSizeChooser == null) {
            try {
                this.ivjSizeChooser = new Choice();
                this.ivjSizeChooser.setName("SizeChooser");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSizeChooser;
    }

    private Label getSizeLabel() {
        if (this.ivjSizeLabel == null) {
            try {
                this.ivjSizeLabel = new Label();
                this.ivjSizeLabel.setName("SizeLabel");
                this.ivjSizeLabel.setText(resabtedit.getString("Size"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSizeLabel;
    }

    private Choice getStyleChooser() {
        if (this.ivjStyleChooser == null) {
            try {
                this.ivjStyleChooser = new Choice();
                this.ivjStyleChooser.setName("StyleChooser");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStyleChooser;
    }

    private Label getStyleLabel() {
        if (this.ivjStyleLabel == null) {
            try {
                this.ivjStyleLabel = new Label();
                this.ivjStyleLabel.setName("StyleLabel");
                this.ivjStyleLabel.setText(resabtedit.getString("Style"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStyleLabel;
    }

    private TextArea getTextArea() {
        if (this.ivjTextArea == null) {
            try {
                this.ivjTextArea = new TextArea();
                this.ivjTextArea.setName("TextArea");
                this.ivjTextArea.setText(resabtedit.getString("The_quick_brown_fox"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTextArea;
    }

    private void handleException(Throwable exception) {
    }

    private void initChoiceContents() {
        this.toolkit = Toolkit.getDefaultToolkit();
        this.fonts = this.toolkit.getFontList();
        int i = 0;
        while (i < this.fonts.length) {
            this.getFamilyChooser().addItem(this.fonts[i]);
            ++i;
        }
        i = 0;
        while (i < styleNames.length) {
            this.getStyleChooser().addItem(styleNames[i]);
            ++i;
        }
        i = 0;
        while (i < pointSizes.length) {
            this.getSizeChooser().addItem("" + pointSizes[i]);
            ++i;
        }
    }

    private void initialize() {
        this.addPropertyChangeListener(this);
        this.setName("Font Selection");
        this.setName("Font Selection");
        this.setLayout(this.getBorderLayout());
        this.setSize(405, 200);
        this.add("North", this.getHeaderPanel());
        this.add("Center", this.getTextArea());
        this.initChoiceContents();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this) {
            this.getTextArea().setFont(this.getFontValue());
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void setFontValue(Font newFont) {
        this.changeFont(newFont);
        int i = 0;
        while (i < this.fonts.length) {
            if (this.fonts[i].equalsIgnoreCase(this.fontValue.getFamily())) {
                this.getFamilyChooser().select(i);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < styleNames.length) {
            if (this.fontValue.getStyle() == styles[i]) {
                this.getStyleChooser().select(i);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < pointSizes.length) {
            if (this.fontValue.getSize() <= pointSizes[i]) {
                this.getSizeChooser().select(i);
                break;
            }
            ++i;
        }
    }
}

