/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.util.ResourceBundle;

public class RectanglePropertyEditor
extends PropertyEditorSupport {
    private static ResourceBundle resabtedit = ResourceBundle.getBundle("com/ibm/uvm/abt/edit/abtedit");

    public String getAsText() {
        if (this.getValue() instanceof String) {
            return (String)this.getValue();
        }
        if (this.getValue() == null) {
            return "";
        }
        Rectangle rect = (Rectangle)this.getValue();
        return "" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height;
    }

    public String getJavaInitializationString() {
        Rectangle rect = (Rectangle)this.getValue();
        if (rect == null) {
            return "new java.awt.Rectangle(0,0,0,0)";
        }
        return "new java.awt.Rectangle(" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height + ")";
    }

    private Rectangle parseForRectangle(String text) throws Exception, NumberFormatException {
        String remains = text;
        int x = remains.indexOf(",");
        if (x < 0) {
            throw new Exception(resabtedit.getString("Rect_num_must_be_sep"));
        }
        String xText = remains.substring(0, x);
        int y = (remains = remains.substring(x + ",".length())).indexOf(",");
        if (y < 0) {
            throw new Exception(resabtedit.getString("Rect_num_must_be_sep"));
        }
        String yText = remains.substring(0, y);
        int w = (remains = remains.substring(y + ",".length())).indexOf(",");
        if (w < 0) {
            throw new Exception(resabtedit.getString("Rect_num_must_be_sep"));
        }
        String wText = remains.substring(0, w);
        String hText = remains.substring(w + ",".length());
        return new Rectangle(Integer.valueOf(xText.trim()), Integer.valueOf(yText.trim()), Integer.valueOf(wText.trim()), Integer.valueOf(hText.trim()));
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text instanceof String) {
            try {
                this.setValue(this.parseForRectangle(text));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
            return;
        }
        throw new IllegalArgumentException(text);
    }
}

