/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.windows;

import com.ibm.jusb.UsbInterfaceImp;
import com.ibm.jusb.os.UsbInterfaceOsImp;
import com.ibm.jusb.os.windows.JavaxUsb;
import com.ibm.jusb.os.windows.WindowsDeviceOsImp;
import com.ibm.jusb.os.windows.WindowsInterfaceRequest;
import com.ibm.jusb.os.windows.WindowsRequest;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfacePolicy;

class WindowsInterfaceOsImp
implements UsbInterfaceOsImp {
    protected UsbInterfaceImp usbInterfaceImp = null;
    protected WindowsDeviceOsImp windowsDeviceOsImp = null;
    private byte interfaceNumber = 0;
    private boolean interfaceNumberSet = false;

    public WindowsInterfaceOsImp(UsbInterfaceImp iface, WindowsDeviceOsImp device) {
        this.setUsbInterfaceImp(iface);
        this.setWindowsDeviceOsImp(device);
    }

    public void claim() throws UsbException {
        WindowsInterfaceRequest.WindowsClaimInterfaceRequest request = new WindowsInterfaceRequest.WindowsClaimInterfaceRequest(this.getInterfaceNumber());
        this.submit(request);
        request.waitUntilCompleted();
        if (0 != request.getError()) {
            throw new UsbException("Could not claim interface : " + JavaxUsb.nativeGetErrorMessage(request.getError()));
        }
    }

    public void claim(UsbInterfacePolicy policy) throws UsbException {
        boolean forceClaim = policy.forceClaim((UsbInterface)this.getUsbInterfaceImp());
        WindowsInterfaceRequest.WindowsClaimInterfaceRequest request = new WindowsInterfaceRequest.WindowsClaimInterfaceRequest(this.getInterfaceNumber(), forceClaim);
        this.submit(request);
        request.waitUntilCompleted();
        if (0 != request.getError()) {
            throw new UsbException("Could not claim interface : " + JavaxUsb.nativeGetErrorMessage(request.getError()));
        }
    }

    public byte getInterfaceNumber() {
        if (!this.interfaceNumberSet) {
            this.interfaceNumber = this.usbInterfaceImp.getUsbInterfaceDescriptor().bInterfaceNumber();
            this.interfaceNumberSet = true;
        }
        return this.interfaceNumber;
    }

    public UsbInterfaceImp getUsbInterfaceImp() {
        return this.usbInterfaceImp;
    }

    public WindowsDeviceOsImp getWindowsDeviceOsImp() {
        return this.windowsDeviceOsImp;
    }

    public boolean isClaimed() {
        WindowsInterfaceRequest.WindowsIsClaimedInterfaceRequest request = new WindowsInterfaceRequest.WindowsIsClaimedInterfaceRequest(this.getInterfaceNumber());
        try {
            this.submit(request);
        }
        catch (UsbException uE) {
            return false;
        }
        request.waitUntilCompleted();
        if (0 != request.getError()) {
            return false;
        }
        return request.isClaimed();
    }

    public void release() {
        WindowsInterfaceRequest.WindowsReleaseInterfaceRequest request = new WindowsInterfaceRequest.WindowsReleaseInterfaceRequest(this.getInterfaceNumber());
        try {
            this.submit(request);
        }
        catch (UsbException uE) {
            return;
        }
        request.waitUntilCompleted();
    }

    public void release(Object key) {
        this.release();
    }

    public void setUsbInterfaceImp(UsbInterfaceImp iface) {
        this.usbInterfaceImp = iface;
    }

    public void setWindowsDeviceOsImp(WindowsDeviceOsImp device) {
        this.windowsDeviceOsImp = device;
    }

    void cancel(WindowsRequest request) {
        this.getWindowsDeviceOsImp().cancel(request);
    }

    void submit(WindowsRequest request) throws UsbException {
        this.getWindowsDeviceOsImp().submit(request);
    }
}

