/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.windows;

public abstract class WindowsRequest {
    public static final int WINDOWS_CLAIM_INTERFACE_REQUEST = 4;
    public static final int WINDOWS_IS_CLAIMED_INTERFACE_REQUEST = 5;
    public static final int WINDOWS_ISOCHRONOUS_REQUEST = 7;
    public static final int WINDOWS_PIPE_REQUEST = 1;
    public static final int WINDOWS_RELEASE_INTERFACE_REQUEST = 6;
    public static final int WINDOWS_SET_CONFIGURATION_REQUEST = 3;
    public static final int WINDOWS_SET_INTERFACE_REQUEST = 2;
    private boolean completed = false;
    private Completion completion = null;
    private int errorNumber = 0;
    private static int requestNumber = 0;
    private int instanceNumber = 0;
    private int waitCount = 0;
    private Object waitLock = new Object();

    public WindowsRequest() {
        this.instanceNumber = this.instanceNumber == Integer.MAX_VALUE ? 1 : ++requestNumber;
    }

    public Completion getCompletion() {
        return this.completion;
    }

    public int getError() {
        return this.errorNumber;
    }

    public abstract int getType();

    public boolean isCompleted() {
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCompleted() {
        Object object = this.waitLock;
        synchronized (object) {
            if (0 < this.waitCount) {
                this.waitLock.notifyAll();
            }
        }
    }

    public void setCompleted(boolean c) {
        this.completed = c;
        if (this.completed) {
            this.notifyCompleted();
            this.executeCompletion();
        }
    }

    public void setCompletion(Completion c) {
        this.completion = c;
    }

    public void setError(int error) {
        this.errorNumber = error;
    }

    public void waitUntilCompleted() {
        this.waitUntilCompleted(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilCompleted(long timeout) {
        long start = System.currentTimeMillis();
        boolean use_timeout = 0L < timeout;
        Object object = this.waitLock;
        synchronized (object) {
            ++this.waitCount;
            while (!this.isCompleted()) {
                long elapsed = System.currentTimeMillis() - start;
                if (use_timeout && elapsed > timeout) break;
                try {
                    this.waitLock.wait(1000L);
                }
                catch (InterruptedException iE) {}
            }
            --this.waitCount;
        }
    }

    protected void executeCompletion() {
        try {
            this.getCompletion().windowsRequestComplete(this);
        }
        catch (NullPointerException npE) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getRequestNumber() {
        return this.instanceNumber;
    }

    public static interface Completion {
        public void windowsRequestComplete(WindowsRequest var1);
    }
}

