/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.logging;

import com.ibm.jutil.logging.LogEntry;
import com.ibm.jutil.logging.LogEntryFactory;
import com.ibm.jutil.logging.LoggerProperties;
import java.util.Vector;

public abstract class AbstractLogEntryFactory
implements LogEntryFactory {
    protected Vector queue = new Vector();
    private Class logEntryClass = null;
    private int logIndex = 1;
    public static final int DEFAULT_STACK_SIZE = 10;

    public AbstractLogEntryFactory() {
        this.decideLogEntryClass();
        this.initializeFactoryStack();
    }

    private void initializeFactoryStack() {
        int nEntries = 0;
        try {
            nEntries = Integer.parseInt(LoggerProperties.getProperty("com.ibm.jutil.logging.LogEntryFactory.initialStackSize", "com.ibm.jutil.logging.default.LogEntryFactory.initialStackSize"));
        }
        catch (Exception e) {
            nEntries = 10;
        }
        while (nEntries-- > 0) {
            this.queue.addElement(this.newLogEntry());
        }
    }

    private void decideLogEntryClass() {
        try {
            this.logEntryClass = Class.forName(LoggerProperties.getProperty("com.ibm.jutil.logging.LogEntryName"));
        }
        catch (ClassNotFoundException e) {
            try {
                this.logEntryClass = Class.forName(LoggerProperties.getProperty("com.ibm.jutil.logging.default.LogEntryName"));
            }
            catch (ClassNotFoundException f) {
                // empty catch block
            }
        }
        try {
            LogEntry x = (LogEntry)this.logEntryClass.newInstance();
        }
        catch (ClassCastException e) {
            try {
                this.logEntryClass = Class.forName(LoggerProperties.getProperty("com.ibm.jutil.logging.default.LogEntryName"));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private LogEntry newLogEntry() {
        try {
            return (LogEntry)this.logEntryClass.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public int getLogIndex() {
        return this.logIndex;
    }

    public void setLogIndex(int id) {
        this.logIndex = id > 0 ? id : 1;
    }

    public int getLogCode() {
        return this.logIndex;
    }

    public void setLogCode(int id) {
        this.logIndex = id > 0 ? id : 1;
    }

    public LogEntry createLogEntry() {
        LogEntry entry = this.queue.size() == 0 ? this.newLogEntry() : (LogEntry)this.queue.remove(0);
        entry.setIndex(this.logIndex++);
        entry.setDateToNow();
        entry.setCategory("test");
        entry.setPriority(2);
        return entry;
    }

    public void reclaim(LogEntry entry) {
        entry.clear();
        this.queue.addElement(entry);
    }

    protected int getStackSize() {
        return this.queue.size();
    }
}

