/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.tracing;

import com.ibm.jutil.logging.LogHelper;
import com.ibm.jutil.tasks.AbstractActiveObject;
import com.ibm.jutil.tasks.ActiveObject;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.jutil.tracing.TracerOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class Tracer {
    private boolean tracerOn = false;
    private String tracerName = "";
    private String tracerSubName = "";
    private boolean appendName = true;
    private boolean appendSubName = true;
    private int tracerLevel = 2;
    private FileTracerOutputDecorator tracerOutputDecorator = null;
    private TracerOutput onTracerOutput = new DefaultTracerOutput();
    private String timeStampFormat = null;
    private TracerOutput offTracerOutput = new TracerOutput(){

        public void close() {
        }

        public StringBuffer getPrefix() {
            return new StringBuffer();
        }

        public void print(Exception e) {
        }

        public void println(String s) {
        }

        public void print(String s) {
        }

        public void flush() {
        }
    };
    private static TracerOutput commonTracerOutput = null;
    private static Tracer instance = null;
    private static final int FLUSH_FREQUENCY = 5000;
    public static final int DEFAULT_FILE_TRACER_OUTPUT_THRESHOLD = 100;
    public static final int MINIMUM = 1;
    public static final int NORMAL = 2;
    public static final int MAXIMUM = 3;

    protected Tracer() {
        this("", "");
    }

    Tracer(String name) {
        this(name, "");
    }

    Tracer(String name, String subName) {
        if (name == null || name.equals("")) {
            this.appendName = false;
            this.tracerName = "";
        } else {
            this.appendName = true;
            this.tracerName = name;
        }
        if (subName == null || subName.equals("")) {
            this.appendSubName = false;
            this.tracerSubName = "";
        } else {
            this.appendSubName = true;
            this.tracerSubName = subName;
        }
        this.onTracerOutput = new DefaultTracerOutput();
    }

    public static Tracer getInstance() {
        if (instance == null) {
            instance = TracerFactory.getInstance().createGlobalTracer();
        }
        return instance;
    }

    public static void setCommonTracerOutput(TracerOutput tracerOutput) {
        commonTracerOutput = tracerOutput;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String tracerOutputString = "null";
        tracerOutputString = commonTracerOutput != null ? (commonTracerOutput instanceof FileTracerOutput ? "common.FileTracerOutput" : (commonTracerOutput instanceof LogTracerOutput ? "common.LogTracerOutput" : "common.DefaultTracerOutput")) : (this.getTracerOutput() instanceof FileTracerOutput ? "FileTracerOutput" : (commonTracerOutput instanceof LogTracerOutput ? "LogTracerOutput" : "DefaultTracerOutput"));
        sb.append("<Tracer name=\"" + this.getName() + "\" isOn=\"" + this.isOn() + "\" appendName=\"" + this.isAppendName() + "\" appendSubName=\"" + this.isAppendSubName() + "\" tracerOutput =\"" + tracerOutputString + "\"/>");
        return sb.toString();
    }

    public void println(String s) {
        this.getTracerOutput().println(s);
    }

    public void println(int traceLevel, String s) {
        if (traceLevel <= this.getTraceLevel()) {
            this.println(s);
        }
    }

    public void println(Object obj) {
        if (null == obj) {
            if (2 <= this.getTraceLevel()) {
                this.print(new NullPointerException("Caught an error this is for info purposes"));
                return;
            }
            this.println("NULL:");
            return;
        }
        this.println(obj.toString());
    }

    public void println(int traceLevel, Object obj) {
        this.println(traceLevel, obj.toString());
    }

    public void print(String s) {
        this.getTracerOutput().print(s);
    }

    public void print(int traceLevel, String s) {
        if (traceLevel <= this.getTraceLevel()) {
            this.print(s);
        }
    }

    public void print(Object obj) {
        this.print(obj.toString());
    }

    public void print(int traceLevel, Object obj) {
        this.print(traceLevel, obj.toString());
    }

    public void print(Exception e) {
        if (3 <= this.getTraceLevel()) {
            this.getTracerOutput().print(e);
        }
    }

    public void flush() {
        this.getTracerOutput().flush();
    }

    public void setOn(boolean b) {
        this.tracerOn = b;
    }

    public boolean isOn() {
        return this.tracerOn;
    }

    public String getName() {
        return this.tracerName;
    }

    public void setAppendName(boolean b) {
        this.appendName = b;
    }

    public boolean isAppendName() {
        return this.appendName;
    }

    public String getSubName() {
        return this.tracerSubName;
    }

    public void setAppendSubName(boolean b) {
        this.appendSubName = b;
    }

    public boolean isAppendSubName() {
        return this.appendSubName;
    }

    public void setTraceLevel(int level) {
        this.tracerLevel = level <= 1 ? 1 : (level == 2 ? 2 : 3);
    }

    public int getTraceLevel() {
        return this.tracerLevel;
    }

    public void setTimeStampFormat(String timeDateFormat) {
        this.timeStampFormat = timeDateFormat;
    }

    public String getTimeStampFormat() {
        return this.timeStampFormat;
    }

    TracerOutput getTracerOutputDecorator() {
        if (this.tracerOutputDecorator == null) {
            this.tracerOutputDecorator = new FileTracerOutputDecorator(commonTracerOutput);
        }
        return this.tracerOutputDecorator;
    }

    public TracerOutput getTracerOutput() {
        if (this.isOn() && commonTracerOutput != null) {
            if (commonTracerOutput instanceof FileTracerOutput) {
                return this.getTracerOutputDecorator();
            }
            if (commonTracerOutput instanceof LogTracerOutput) {
                return this.getTracerOutputDecorator();
            }
            return commonTracerOutput;
        }
        return this.isOn() ? this.onTracerOutput : this.offTracerOutput;
    }

    void setTracerOutput(TracerOutput tracerOutput) {
        this.tracerOn = true;
        commonTracerOutput = tracerOutput;
    }

    TracerOutput createFileTracerOutput(File file, int threshold) throws IOException {
        return this.createFileTracerOutput(file, threshold, false, 5000);
    }

    TracerOutput createFileTracerOutput(File file, int threshold, boolean appendMode, int flushPollTimeout) throws IOException {
        return new FileTracerOutput(file, threshold, appendMode, flushPollTimeout);
    }

    TracerOutput createFileTracerOutput(File file, int threshold, boolean appendMode, int flushPollTimeout, long maxFileSize, int maxFiles) throws IOException {
        return new FileTracerOutput(file, threshold, appendMode, flushPollTimeout, maxFileSize, maxFiles);
    }

    TracerOutput createLogTracerOutput(LogHelper logHelper) {
        return new LogTracerOutput(logHelper);
    }

    class LogTracerOutput
    extends DefaultTracerOutput {
        private LogHelper logHelper = null;

        public LogTracerOutput(LogHelper logHelper) {
            this.logHelper = logHelper;
        }

        public void close() {
            this.logHelper.close();
        }

        public void flush() {
        }

        public void print(Exception e) {
            this.log(e.toString());
        }

        public void print(String s) {
            this.log(s);
        }

        public void println(String s) {
            this.log(s);
        }

        protected void log(String msg) {
            this.logHelper.addLogEntry(1015, msg, "AllDevices", 1);
            this.logHelper.close();
        }
    }

    class FileTracerOutput
    extends DefaultTracerOutput {
        FileOutputStream fileOutputStream = null;
        FileOutputStream fosSplitFiles = null;
        private StringBuffer sb = new StringBuffer();
        private File file = null;
        private int threshold = 100;
        private Object flushLock = new Object();
        private ActiveObject activeObject = null;
        private int flushFrequency = 5000;
        private long fileMaxSize = 0L;
        private int maxFiles = 0;
        private int cycles = 1;
        private long offsetCopyData = 0L;
        private String postFileName = "";
        private File myFile = null;
        private File tempFile = null;
        private String preFileName = "";
        private boolean keepSplitting = false;
        private int remainingDataStored = 0;
        private Object writeToHardDisk = new Object();

        public FileTracerOutput(File file, int threshold) throws IOException {
            this(file, threshold, false, 5000);
        }

        public FileTracerOutput(File file, int threshold, boolean appendMode, int timeout) throws IOException {
            this(file, threshold, false, 5000, 0L, 0);
        }

        public FileTracerOutput(File file, int threshold, boolean appendMode, int timeout, long fileMaxSize, int maxFiles) throws IOException {
            this.file = file;
            this.threshold = threshold;
            this.flushFrequency = timeout;
            this.fileMaxSize = fileMaxSize;
            this.maxFiles = maxFiles;
            this.init();
        }

        void endActiveObject() {
            this.getActiveObject().end();
        }

        private void init() throws IOException {
            if (this.file.getName().lastIndexOf(46) >= 0) {
                this.preFileName = this.file.getName().substring(0, this.file.getName().lastIndexOf(46));
                this.postFileName = this.file.getName().substring(this.file.getName().lastIndexOf(46));
            } else {
                this.preFileName = this.file.getName();
            }
            if (this.myFile == null) {
                this.myFile = new File(this.file.getParent() + File.separator + this.preFileName + String.valueOf(1) + this.postFileName);
                boolean isNew = false;
                if (!this.myFile.exists()) {
                    this.myFile.createNewFile();
                    isNew = true;
                }
                this.fosSplitFiles = new FileOutputStream(this.myFile.getAbsolutePath(), true);
                if (!isNew) {
                    this.remainingDataStored = (int)this.myFile.length();
                    boolean found = false;
                    int keeplooking = this.maxFiles;
                    do {
                        File searchFile = new File(this.file.getParent() + File.separator + this.preFileName + String.valueOf(keeplooking) + this.postFileName);
                        if (!searchFile.exists()) continue;
                        this.cycles = keeplooking;
                        found = true;
                    } while (!found && --keeplooking > 1);
                }
            }
            this.getActiveObject().start();
        }

        private ActiveObject getActiveObject() {
            if (this.activeObject == null) {
                this.activeObject = new AbstractActiveObject(this){
                    private final /* synthetic */ FileTracerOutput this$1;
                    {
                        this.this$1 = this$1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void runActiveObject() {
                        while (this.isStarted()) {
                            while (FileTracerOutput.access$000(this.this$1).length() < this.this$1.getThreshold()) {
                                Object object = FileTracerOutput.access$100(this.this$1);
                                synchronized (object) {
                                    try {
                                        FileTracerOutput.access$100(this.this$1).wait(FileTracerOutput.access$200(this.this$1));
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (FileTracerOutput.access$000(this.this$1).length() > this.this$1.getThreshold()) {
                                        break;
                                    }
                                }
                            }
                            this.this$1.flush();
                        }
                    }
                };
            }
            return this.activeObject;
        }

        public void close() {
            this.endActiveObject();
            super.close();
            try {
                this.fileOutputStream.close();
            }
            catch (IOException ioe) {
                System.err.println("[Tracer]Unexpected exception with message = " + ioe.getMessage());
            }
        }

        public int getThreshold() {
            return this.threshold;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            Object object = this.writeToHardDisk;
            synchronized (object) {
                try {
                    if (this.sb.length() > 0 && this.fosSplitFiles != null) {
                        if ((long)(this.sb.length() + this.remainingDataStored) < this.fileMaxSize) {
                            this.fosSplitFiles.write(this.sb.toString().getBytes(), (int)this.offsetCopyData, this.sb.length() - (int)this.offsetCopyData);
                            this.remainingDataStored += this.sb.length() - (int)this.offsetCopyData;
                            this.offsetCopyData = this.sb.length();
                            this.sb.delete(0, (int)this.offsetCopyData);
                            this.offsetCopyData = 0L;
                        } else {
                            long fileSize = this.fileMaxSize - (long)this.remainingDataStored;
                            if (fileSize <= 0L) {
                                this.splitIntoFiles();
                                return;
                            }
                            this.fosSplitFiles.write(this.sb.toString().getBytes(), (int)this.offsetCopyData, (int)this.fileMaxSize - this.remainingDataStored);
                            this.offsetCopyData = this.fileMaxSize - (long)this.remainingDataStored;
                            this.sb.delete(0, (int)this.offsetCopyData);
                            this.offsetCopyData = 0L;
                            if (fileSize > 0L) {
                                this.splitIntoFiles();
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            object = this.writeToHardDisk;
            synchronized (object) {
                this.writeToHardDisk.notify();
            }
        }

        public void splitIntoFiles() {
            try {
                do {
                    this.fosSplitFiles.close();
                    if (this.cycles >= this.maxFiles) {
                        this.cycles = this.maxFiles - 1;
                    }
                    this.tempFile = new File(this.file.getParent() + File.separator + this.preFileName + String.valueOf(this.cycles + 1) + this.postFileName);
                    if (this.tempFile.exists()) {
                        this.tempFile.delete();
                    }
                    while (this.tempFile.exists()) {
                        this.tempFile.delete();
                        try {
                            Thread.currentThread();
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {}
                    }
                    for (int i = this.cycles; i > 0; --i) {
                        this.tempFile = null;
                        this.tempFile = new File(this.file.getParent() + File.separator + this.preFileName + String.valueOf(i) + this.postFileName);
                        if (!this.tempFile.exists()) continue;
                        if (this.tempFile.renameTo(new File(this.file.getParentFile() + File.separator + this.preFileName + String.valueOf(i + 1) + this.postFileName))) continue;
                        System.err.println("[FileTracerOutput]Fatal Error!!! could not rename File");
                    }
                    this.myFile = null;
                    this.fosSplitFiles = null;
                    this.tempFile = null;
                    ++this.cycles;
                    if (this.myFile == null) {
                        this.myFile = new File(this.file.getParent() + File.separator + this.preFileName + String.valueOf(1) + this.postFileName);
                        if (this.myFile.exists()) {
                            this.myFile.delete();
                        }
                        this.myFile.createNewFile();
                        this.fosSplitFiles = new FileOutputStream(this.myFile.getAbsolutePath(), true);
                    }
                    if (this.sb.length() - (int)this.offsetCopyData <= (int)this.fileMaxSize) {
                        this.keepSplitting = false;
                        this.fosSplitFiles.write(this.sb.toString().getBytes(), (int)this.offsetCopyData, this.sb.length() - (int)this.offsetCopyData);
                        this.remainingDataStored = this.sb.length() - (int)this.offsetCopyData;
                        this.offsetCopyData = this.sb.length();
                        this.sb.delete(0, (int)this.offsetCopyData);
                        this.offsetCopyData = 0L;
                        continue;
                    }
                    this.keepSplitting = true;
                    this.fosSplitFiles.write(this.sb.toString().getBytes(), (int)this.offsetCopyData, (int)this.fileMaxSize);
                    this.offsetCopyData += this.fileMaxSize;
                    this.sb.delete(0, (int)this.offsetCopyData);
                    this.offsetCopyData = 0L;
                } while (this.keepSplitting);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        public void println(String s) {
            this.print(s + "\n");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void print(String s) {
            Object object = this.writeToHardDisk;
            synchronized (object) {
                this.sb.append(s);
            }
            object = this.flushLock;
            synchronized (object) {
                this.flushLock.notify();
            }
        }

        public void print(Exception e) {
            if (Tracer.this.isAppendName()) {
                this.println("<" + this.getPrefix() + ">");
            }
            StringWriter sW = new StringWriter();
            PrintWriter pW = new PrintWriter((Writer)sW, true);
            e.printStackTrace(pW);
            this.print(sW.toString());
            this.flush();
            if (Tracer.this.isAppendName()) {
                this.println("<" + this.getPrefix() + "/>");
            }
        }

        static /* synthetic */ StringBuffer access$000(FileTracerOutput x0) {
            return x0.sb;
        }

        static /* synthetic */ Object access$100(FileTracerOutput x0) {
            return x0.flushLock;
        }

        static /* synthetic */ int access$200(FileTracerOutput x0) {
            return x0.flushFrequency;
        }
    }

    class DefaultTracerOutput
    implements TracerOutput {
        protected PrintStream printStream = System.err;
        protected boolean appendPrefix = false;
        String dateHourOut = "";
        SimpleDateFormat formatterHour = new SimpleDateFormat("yyyy.MM.dd H:mm:ss:SSS");
        StringBuffer prefix = new StringBuffer();

        public DefaultTracerOutput() {
        }

        public DefaultTracerOutput(String s, PrintStream pStream) {
            this.printStream = pStream;
        }

        public StringBuffer getPrefix() {
            this.prefix.delete(0, this.prefix.length());
            if (Tracer.this.isAppendName()) {
                if (Tracer.this.getTimeStampFormat().equals("DATE")) {
                    this.prefix.append("[" + this.formatterHour.format(Calendar.getInstance().getTime()) + "]" + "[" + Tracer.this.getName() + "]");
                } else if (Tracer.this.getTimeStampFormat().equals("MSECS")) {
                    this.prefix.append("[" + System.currentTimeMillis() + "]" + "[" + Tracer.this.getName() + "]");
                } else if (Tracer.this.getTimeStampFormat() != null && !Tracer.this.getTimeStampFormat().equals("DATE") && !Tracer.this.getTimeStampFormat().equals("MSECS")) {
                    this.prefix.append("[" + Tracer.this.getName() + "]");
                }
            }
            if (Tracer.this.isAppendSubName()) {
                this.prefix.append("[" + Tracer.this.getSubName() + "]");
            }
            return this.prefix;
        }

        public void close() {
            this.getPrintStream().close();
        }

        public void println(String s) {
            this.print(s + "\n");
        }

        public void print(String s) {
            this.getPrintStream().print(Tracer.this.isAppendName() ? this.getPrefix() + s : s);
        }

        public void print(Exception e) {
            if (Tracer.this.isAppendName()) {
                this.println("<" + Tracer.this.getName() + ">");
            }
            e.printStackTrace(this.getPrintStream());
            if (Tracer.this.isAppendName()) {
                this.println("<" + Tracer.this.getName() + "/>");
            }
        }

        public void flush() {
            this.getPrintStream().flush();
        }

        protected PrintStream getPrintStream() {
            return this.printStream;
        }

        protected void setPrintStream(PrintStream pStream) {
            this.printStream = pStream;
        }
    }

    class FileTracerOutputDecorator
    implements TracerOutput {
        private TracerOutput tracerOutput = null;
        String dateHourOut = "";
        SimpleDateFormat formatterHour = new SimpleDateFormat("yyyy.MM.dd H:mm:ss:SSS");
        StringBuffer prefix = new StringBuffer();

        public FileTracerOutputDecorator(TracerOutput tracerOutput) {
            this.tracerOutput = tracerOutput;
        }

        public StringBuffer getPrefix() {
            this.prefix.delete(0, this.prefix.length());
            if (Tracer.this.isAppendName()) {
                if (Tracer.this.getTimeStampFormat().equals("DATE")) {
                    this.prefix.append("[" + this.formatterHour.format(Calendar.getInstance().getTime()) + "]" + "[" + Tracer.this.getName() + "]");
                } else if (Tracer.this.getTimeStampFormat().equals("MSECS")) {
                    this.prefix.append("[" + System.currentTimeMillis() + "]" + "[" + Tracer.this.getName() + "]");
                } else if (Tracer.this.getTimeStampFormat() != null && !Tracer.this.getTimeStampFormat().equals("DATE") && !Tracer.this.getTimeStampFormat().equals("MSECS")) {
                    this.prefix.append("[" + Tracer.this.getName() + "]");
                }
            }
            if (Tracer.this.isAppendSubName()) {
                this.prefix.append("[" + Tracer.this.getSubName() + "]");
            }
            return this.prefix;
        }

        public void close() {
            this.tracerOutput.close();
        }

        public void println(String s) {
            this.tracerOutput.print(this.getPrefix() + s + "\n");
        }

        public void print(String s) {
            this.tracerOutput.print(this.getPrefix() + s);
        }

        public void print(Exception e) {
            this.tracerOutput.print(e);
        }

        public void flush() {
            this.tracerOutput.flush();
        }
    }
}

