/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.embedded;

import com.ibm.embedded.CashDrawerPciDriverImp;
import com.ibm.embedded.EmbeddedDriver;
import com.ibm.embedded.EmbeddedException;
import com.ibm.embedded.GetSlotInfo;
import com.ibm.embedded.HardTotalsPciDriverImp;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.util.DevBuses;
import java.util.ArrayList;
import java.util.Iterator;

public class PciInitializer {
    private static GetSlotInfo gsi;
    private static ArrayList listeners;
    private static byte status;
    private Tracer tracer = TracerFactory.getInstance().createTracer(DevBuses.EMBEDDED_DEVBUS.getName(), "PciInitializer");

    public Iterator init() throws EmbeddedException {
        ArrayList<EmbeddedDriver> al = new ArrayList<EmbeddedDriver>();
        try {
            gsi = PciInitializer.nativeInit();
        }
        catch (Exception pe) {
            this.tracer.println("Exception when initializing PCI native code :" + pe.toString());
            this.tracer.println("Let's return an empty iterator");
            return al.iterator();
        }
        catch (Error e) {
            this.tracer.println("Error when initializing PCI native code :" + e.toString());
            this.tracer.println("Let's return an empty iterator");
            return al.iterator();
        }
        if (null != gsi) {
            long numberOfDrawers = gsi.getSlotDrawers();
            long sizeOfNVRAM = gsi.getSlotNVRAM();
            long adapterID = gsi.getAdapterID();
            if (numberOfDrawers > 0L) {
                al.add(new CashDrawerPciDriverImp(numberOfDrawers, adapterID));
            }
            if (sizeOfNVRAM > 0L) {
                al.add(new HardTotalsPciDriverImp(sizeOfNVRAM));
            }
            if (al.isEmpty()) {
                return al.iterator();
            }
        }
        return al.iterator();
    }

    private static native GetSlotInfo nativeInit() throws EmbeddedException;

    static {
        try {
            System.loadLibrary("aipposembedded");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        gsi = null;
        listeners = null;
        status = 0;
    }
}

