/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.embedded;

import com.ibm.embedded.CashDrawerEmbeddedDriver;
import com.ibm.embedded.EmbeddedException;
import com.ibm.embedded.event.EmbeddedEvent;
import com.ibm.embedded.event.EmbeddedListener;
import com.ibm.jutil.Timer;
import com.ibm.jutil.Timerable;
import com.ibm.jutil.Util;
import com.ibm.posj.HandleCmd;
import com.ibm.posj.HandleException;
import com.ibm.posj.HandleKey;
import com.ibm.posj.SystemCmd;
import com.ibm.posj.bus.CashDrawerHandleImp;
import com.ibm.posj.bus.CashDrawerStatusByteParser;
import com.ibm.posj.bus.HandleImpVisitor;
import com.ibm.posj.bus.embedded.AbstractEmbeddedHandleImp;
import com.ibm.posj.event.OfflineEvent;
import com.ibm.posj.event.OnlineEvent;
import com.ibm.posj.event.StatusEvent;
import com.ibm.posj.util.DevCat;
import com.ibm.posj.util.DevCats;
import com.ibm.posj.util.PosjUtil;

public class EmbeddedCashDrawerHandleImp
extends AbstractEmbeddedHandleImp
implements CashDrawerHandleImp {
    private EmbeddedListener listener = null;
    private int cdNum = 1;
    private CashDrawerEmbeddedDriver embeddedDriver = null;
    private CashDrawerStatusByteParser statusParser = null;
    private Object openCmdPending = new Object();
    private OfflineTimerable timerable = new OfflineTimerable();
    private Timer offlineTimer = new Timer((Timerable)this.timerable, 500);
    private boolean isOpenCmdPending = false;
    public static final int CD1 = 1;
    public static final int CD2 = 2;
    public static final long OPEN_CD_COMMAND_TIMEOUT = 500L;
    public static final int CD_1_OPEN_BIT_POSITION = 7;
    public static final int CD_1_PRESENT_BIT_POSITION = 6;
    public static final int CD_2_OPEN_BIT_POSITION = 5;
    public static final int CD_2_PRESENT_BIT_POSITION = 4;
    public static final int CD_INTERRUPTS_BIT_POSITION = 3;
    public static final int CD_INTERFACE_BIT_POSITION = 2;
    public static final int CD_PULSE_BIT_POSITION = 1;
    public static final int CD_OPEN_ARM_BIT_POSITION = 0;
    public static final String STATUS_REQ_TIMEOUT_MSG = "EmbeddedCashDrawer: timeout while waiting for statusRequest command to complete";
    public static final String ERROR_GETTING_STATUS_MSG = "An error occurred while trying to get status from the device";
    public static final String DEVICE_REMOVED_STRING = "Embedded Cash Drawer removed";
    public static final String DEVICE_ADDED_STRING = "Embedded Cash Drawer added";
    private static final int MAX_TIMEOUT_RETRY = 6;

    public EmbeddedCashDrawerHandleImp(HandleKey key, CashDrawerEmbeddedDriver driver, int cdNum) {
        super(key);
        this.embeddedDriver = driver;
        this.cdNum = cdNum;
    }

    public void accept(HandleImpVisitor visitor) {
        visitor.visitCashDrawer(this);
    }

    public DevCat getDevCat() {
        return DevCats.CASHDRAWER_DEVCAT;
    }

    public void init() throws HandleException {
        this.listener = new CDEmbeddedListener();
        try {
            this.getEmbeddedDriver().addEmbeddedEventListener(this.listener);
        }
        catch (EmbeddedException exc) {
            this.getLogHelper().addLogEntry(1003, "Could not add listener", "CashDrawer", 3);
        }
        this.statusParser = new EmbeddedCDStatusParser();
        this.submitStatusReqCmd();
    }

    public short getECLevel() {
        return -1;
    }

    public boolean isFlashable() {
        return false;
    }

    public CashDrawerEmbeddedDriver getEmbeddedDriver() {
        return this.embeddedDriver;
    }

    public void submit(HandleCmd cmd) throws HandleException {
        block9: {
            if (cmd == null) {
                throw new HandleException("Attempted to submit a null command to handle");
            }
            try {
                if (cmd.getCode() == 100) {
                    this.submitOpenDrawerCmd(cmd);
                    break block9;
                }
                if (cmd.getCode() == 101) {
                    this.submitStatusReqCmd();
                    break block9;
                }
                if (cmd.getCode() == 103) {
                    this.submitDevInfoCmd((SystemCmd.DeviceInfoRequestCmd)cmd);
                    break block9;
                }
                throw new HandleException("Invalid CashDrawerCmd object submitted!");
            }
            catch (HandleException he) {
                this.setHandleCmdResultInError(cmd, true);
                throw he;
            }
            finally {
                cmd.setCompleted(true);
            }
        }
    }

    public int getCdNum() {
        return this.cdNum;
    }

    protected void submitDevInfoCmd(SystemCmd.DeviceInfoRequestCmd devInfoCmd) {
        int id = 2300;
        if (this.isTracerOn()) {
            this.traceNormal("-->submitDevInfoCmd() : getAdapterID() = " + Util.toHexString((long)this.embeddedDriver.getAdapterID()));
        }
        if (this.embeddedDriver.getAdapterID() == 661L) {
            id = this.cdNum == 1 ? 2303 : 2304;
        } else if (this.embeddedDriver.getAdapterID() == 665L) {
            id = 2302;
        } else if (this.embeddedDriver.getAdapterID() == 4614L) {
            id = 2301;
        } else if (this.embeddedDriver.getAdapterID() == 5L) {
            id = 2305;
        }
        devInfoCmd.setDeviceId(id);
        if (this.isTracerOn()) {
            this.traceNormal("submitDevInfoCmd() : devInfoCmd.getDeviceId() = " + devInfoCmd.getDeviceId() + "<--");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitOpenDrawerCmd(HandleCmd cashDrawerCmd) throws HandleException {
        if (this.isTracerOn()) {
            this.traceNormal("->submitOpenDrawerCmd()");
        }
        this.isOpenCmdPending = true;
        try {
            this.waitForOpenCmdToComplete();
        }
        catch (EmbeddedException pciE) {
            new HandleException("Error in Embedded bus :", pciE);
        }
        finally {
            this.isOpenCmdPending = false;
        }
        if (this.isTracerOn()) {
            this.traceNormal("<-submitOpenDrawerCmd()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForOpenCmdToComplete() throws EmbeddedException {
        int retry = 0;
        while (this.isOpenCmdPending && retry < 6) {
            Object object = this.openCmdPending;
            synchronized (object) {
                this.getEmbeddedDriver().openCD(this.getCdNum());
                try {
                    this.openCmdPending.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected void submitStatusReqCmd() throws HandleException {
        if (this.isTracerOn()) {
            this.traceNormal("submitStatusReqCmd()");
        }
        byte statusByte = this.getStatus();
        this.statusParser.init(statusByte);
        int cdStatusCode = this.statusParser.getCashDrawerStatusCode();
        this.getHandle().getEventHelper().fireStatusEvent(new StatusEvent(this, cdStatusCode));
    }

    protected byte getStatus() throws HandleException {
        byte status = 0;
        try {
            status = this.getEmbeddedDriver().getCDStatus();
            if (this.isTracerOn()) {
                this.traceNormal("getStatus()... status  = " + Util.toHexString((byte)status));
            }
        }
        catch (EmbeddedException pciE) {
            throw new HandleException(ERROR_GETTING_STATUS_MSG, pciE);
        }
        return status;
    }

    protected class OfflineTimerable
    implements Timerable {
        protected OfflineTimerable() {
        }

        public void timerExpired() {
            EmbeddedCashDrawerHandleImp.this.traceNormal("firing offline");
            EmbeddedCashDrawerHandleImp.this.getLogHelper().addLogEntry(2006, EmbeddedCashDrawerHandleImp.DEVICE_REMOVED_STRING, "CashDrawer");
            EmbeddedCashDrawerHandleImp.this.getHandle().getState().setOnline(false);
            EmbeddedCashDrawerHandleImp.this.getHandle().getEventHelper().fireOfflineEvent(new OfflineEvent(this, System.currentTimeMillis()));
        }
    }

    private class EmbeddedCDStatusParser
    extends CashDrawerStatusByteParser {
        private EmbeddedCDStatusParser() {
        }

        public void init(byte status) {
            super.init(status);
            if (!this.isCDConnected()) {
                EmbeddedCashDrawerHandleImp.this.traceNormal("EmbeddedCDStatusParser: CD" + EmbeddedCashDrawerHandleImp.this.getCdNum() + " not connected, will set handle offline");
                if (EmbeddedCashDrawerHandleImp.this.getHandle().getState().isOnline()) {
                    if (!EmbeddedCashDrawerHandleImp.this.offlineTimer.getStarted()) {
                        EmbeddedCashDrawerHandleImp.this.offlineTimer.reset();
                    }
                    EmbeddedCashDrawerHandleImp.this.offlineTimer.start();
                }
            } else {
                EmbeddedCashDrawerHandleImp.this.traceNormal("started=" + EmbeddedCashDrawerHandleImp.this.offlineTimer.getStarted());
                if (EmbeddedCashDrawerHandleImp.this.offlineTimer.getStarted()) {
                    EmbeddedCashDrawerHandleImp.this.offlineTimer.stop();
                }
                if (!EmbeddedCashDrawerHandleImp.this.getHandle().getState().isOnline()) {
                    EmbeddedCashDrawerHandleImp.this.traceNormal("EmbeddedCDStatusParser: CD" + EmbeddedCashDrawerHandleImp.this.getCdNum() + " is connected, will set handle online");
                    EmbeddedCashDrawerHandleImp.this.getHandle().getState().setOnline(true);
                    EmbeddedCashDrawerHandleImp.this.getLogHelper().addLogEntry(2005, EmbeddedCashDrawerHandleImp.DEVICE_ADDED_STRING, "CashDrawer");
                    EmbeddedCashDrawerHandleImp.this.getHandle().getEventHelper().fireOnlineEvent(new OnlineEvent(this, System.currentTimeMillis()));
                }
            }
        }

        public boolean isCDOpened() {
            if (EmbeddedCashDrawerHandleImp.this.getCdNum() == 1) {
                return this.isCD1Opened();
            }
            return this.isCD2Opened();
        }

        public boolean isCD1Opened() {
            return !PosjUtil.isBitSelected(this.getStatusByte(), 7);
        }

        public boolean isCD2Opened() {
            return !PosjUtil.isBitSelected(this.getStatusByte(), 5);
        }

        public boolean isCDConnected() {
            if (EmbeddedCashDrawerHandleImp.this.getCdNum() == 1) {
                return this.isCD1Connected();
            }
            return this.isCD2Connected();
        }

        public boolean isCD1Connected() {
            return !PosjUtil.isBitSelected(this.getStatusByte(), 6);
        }

        public boolean isCD2Connected() {
            return !PosjUtil.isBitSelected(this.getStatusByte(), 4);
        }

        public boolean getUnsolicitedStatus() {
            return true;
        }
    }

    private class CDEmbeddedListener
    implements EmbeddedListener {
        private CDEmbeddedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void statusEventOccurred(EmbeddedEvent event) {
            byte statusByte = event.getStatus();
            if (EmbeddedCashDrawerHandleImp.this.isTracerOn()) {
                EmbeddedCashDrawerHandleImp.this.traceNormal("statusEventOccurred() = " + Util.toHexString((byte)statusByte));
            }
            EmbeddedCashDrawerHandleImp.this.statusParser.init(statusByte);
            if (EmbeddedCashDrawerHandleImp.this.statusParser.isCDConnected()) {
                int cdStatusCode = EmbeddedCashDrawerHandleImp.this.statusParser.getCashDrawerStatusCode();
                if (EmbeddedCashDrawerHandleImp.this.isTracerOn()) {
                    EmbeddedCashDrawerHandleImp.this.traceNormal("EmbeddedCDHandleImp... CDStatusCode = " + cdStatusCode);
                }
                EmbeddedCashDrawerHandleImp.this.getHandle().getEventHelper().fireStatusEvent(new StatusEvent(this, cdStatusCode));
            }
            Object object = EmbeddedCashDrawerHandleImp.this.openCmdPending;
            synchronized (object) {
                EmbeddedCashDrawerHandleImp.this.isOpenCmdPending = false;
                EmbeddedCashDrawerHandleImp.this.openCmdPending.notifyAll();
            }
        }
    }
}

