/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.hid.javaxusb;

import com.ibm.jutil.Util;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.Handle;
import com.ibm.posj.HandleFactory;
import com.ibm.posj.HandleRegistry;
import com.ibm.posj.PosException;
import com.ibm.posj.PosSystem;
import com.ibm.posj.PosSystemManager;
import com.ibm.posj.bus.AbstractHandlePopulator;
import com.ibm.posj.bus.hid.HidHandleFactoryV;
import com.ibm.posj.bus.hid.HidHandleImp;
import com.ibm.posj.bus.hid.javaxusb.UsbHandleImpFactory;
import com.ibm.posj.bus.hid.javaxusb.UsbIDUtil;
import com.ibm.posj.util.DevBus;
import com.ibm.posj.util.DevBuses;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.usb.UsbDevice;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbServices;
import javax.usb.event.UsbServicesEvent;
import javax.usb.event.UsbServicesListener;

public class UsbHandlePopulator
extends AbstractHandlePopulator {
    private UsbServices usbServices = null;
    private UsbServicesListener usbServicesListener = new UsbServicesL();
    private UsbHandleImpFactory usbHandleImpFactory = new UsbHandleImpFactory(this);
    private int newDeviceConnecting = 0;
    private List reenumeratingDevices = new Vector();
    private long reenumerateWaitUntilTime = 0L;
    private boolean initialized = false;
    private long initDelay = 5000L;
    private long connectDelay = 1000L;
    private long maxReenumerationDelay = 30000L;
    protected Tracer tracer = TracerFactory.getInstance().createTracer("HID", "UsbHandlePopulator");
    public static final String USB_HANDLE_POPULATOR_NAME_STRING = "USB/HID Handle Populator";
    public static final String INIT_DELAY_PROPERTY = "com.ibm.posj.bus.hid.javaxusb.UsbHandlePopulator.INIT_DELAY";
    public static final String CONNECT_DELAY_PROPERTY = "com.ibm.posj.bus.hid.javaxusb.UsbHandlePopulator.CONNECT_DELAY";
    public static final String MAX_REENUMERATION_DELAY_PROPERTY = "com.ibm.posj.bus.hid.javaxusb.UsbHandlePopulator.MAX_REENUMERATION_DELAY";
    public static final long INIT_DELAY = 5000L;
    public static final long CONNECT_DELAY = 1000L;
    public static final long MAX_REENUMERATION_DELAY = 30000L;
    public static final long NEW_DEVICE_CONNECT_POLL_PERIOD = 1000L;

    public UsbHandlePopulator(HandleRegistry handleRegistry, HandleFactory handleFactory, PosSystem.EventHelper eventHelper) {
        super(handleRegistry, handleFactory, eventHelper);
        PosSystem.Properties p = PosSystemManager.getInstance().getProperties();
        if (p.isPropertyDefined(INIT_DELAY_PROPERTY)) {
            try {
                this.initDelay = Long.decode(p.getPropertyString(INIT_DELAY_PROPERTY));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (p.isPropertyDefined(CONNECT_DELAY_PROPERTY)) {
            try {
                this.connectDelay = Long.decode(p.getPropertyString(CONNECT_DELAY_PROPERTY));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (p.isPropertyDefined(MAX_REENUMERATION_DELAY_PROPERTY)) {
            try {
                this.maxReenumerationDelay = Long.decode(p.getPropertyString(MAX_REENUMERATION_DELAY_PROPERTY));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    void syncAddUsbDevice(UsbDevice device) throws PosException {
        HidHandleFactoryV hidHandleFactoryV = new HidHandleFactoryV(this.getHandleFactory());
        PosException posException = null;
        Iterator iterator = null;
        iterator = this.usbHandleImpFactory.createHandleImps(device).iterator();
        while (iterator.hasNext()) {
            HidHandleImp hhI = (HidHandleImp)iterator.next();
            if (null != hhI.getHandle()) continue;
            hidHandleFactoryV.clear();
            hhI.accept(hidHandleFactoryV);
            if (null == hidHandleFactoryV.getException()) {
                if (null == hidHandleFactoryV.getHandle()) continue;
                this.getHandleRegistry().addHandle(hidHandleFactoryV.getHandle());
                continue;
            }
            posException = new PosException("Error while creating Handle", hidHandleFactoryV.getException());
        }
        if (null != posException) {
            this.lastException = posException;
            throw posException;
        }
    }

    void asyncAddUsbDevice(UsbDevice device) {
        AddUsbDevice auD = new AddUsbDevice(device);
        this.getRunnableManager().add((Runnable)auD);
    }

    void delayedAsyncAddUsbDevice(UsbDevice device, boolean compoundWait) {
        DelayedAddUsbDevice auD = new DelayedAddUsbDevice(device, compoundWait);
        this.getRunnableManager().add((Runnable)auD);
    }

    void setLastException(Exception exception) {
        this.lastException = exception;
    }

    protected long getInitDelay() {
        return this.initDelay;
    }

    protected long getConnectDelay() {
        return this.connectDelay;
    }

    protected long getMaxReenumerationDelay() {
        return this.maxReenumerationDelay;
    }

    private void init() throws PosException {
        if (this.tracer.isOn()) {
            this.tracer.println("USB bus starting initialization.");
        }
        try {
            this.usbServices = UsbHostManager.getUsbServices();
        }
        catch (UsbException uE) {
            throw new PosException("Could not access UsbServices", (Exception)((Object)uE));
        }
        UsbHub rootHub = null;
        try {
            rootHub = this.usbServices.getRootUsbHub();
        }
        catch (UsbException ue) {
            throw new PosException("Error while accessing root UsbHub", (Exception)((Object)ue));
        }
        this.usbServices.addUsbServicesListener(this.usbServicesListener);
        this.syncAddUsbDevice((UsbDevice)rootHub);
        try {
            Thread.sleep(this.getInitDelay());
        }
        catch (InterruptedException iE) {
            // empty catch block
        }
        while (!this.reenumeratingDevices.isEmpty() && System.currentTimeMillis() < this.reenumerateWaitUntilTime) {
            long timeLeft = this.reenumerateWaitUntilTime - System.currentTimeMillis();
            if (this.tracer.isOn()) {
                this.tracer.println("Waiting for " + this.reenumeratingDevices.size() + " reenumerating devices (" + timeLeft + " ms remaining)");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException iE) {}
        }
        while (0 < this.newDeviceConnecting) {
            if (this.tracer.isOn()) {
                this.tracer.println("Waiting for " + this.newDeviceConnecting + " devices being actively populated.");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.initialized = true;
        if (this.tracer.isOn()) {
            this.tracer.println("USB bus is initialized.");
        }
    }

    private void removeHandleRegistry() {
        HandleRegistry registry = this.getHandleRegistry();
        Iterator iterator = registry.getHandles();
        Vector temp = new Vector();
        while (iterator.hasNext()) {
            temp.add(iterator.next());
        }
        for (int i = 0; i < temp.size(); ++i) {
            registry.removeHandle((Handle)temp.elementAt(i));
        }
    }

    public String getName() {
        return USB_HANDLE_POPULATOR_NAME_STRING;
    }

    public DevBus getDevBus() {
        return DevBuses.HID_DEVBUS;
    }

    public void start() throws PosException {
        if (this.isStarted()) {
            return;
        }
        super.start();
        try {
            this.init();
        }
        catch (PosException pE) {
            this.stop();
            throw pE;
        }
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.usbServices.removeUsbServicesListener(this.usbServicesListener);
        }
        catch (NullPointerException npE) {
            // empty catch block
        }
        this.removeHandleRegistry();
        try {
            super.stop();
        }
        catch (PosException posException) {
            // empty catch block
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void waitForDeviceToReenumerate(short vendorId, short productId, String serialNumber, int hashCode) {
        String devId = "<0x" + Util.toHexString((short)vendorId) + ",0x" + Util.toHexString((short)productId) + ">";
        if (this.tracer.isOn()) {
            this.tracer.println("Waiting for re-enumerating device " + devId + " SN '" + serialNumber + "'" + "with diff hashcode than '" + hashCode + "'");
        }
        this.reenumeratingDevices.add(new ReenumeratingDevice(vendorId, productId, serialNumber, hashCode));
        this.reenumerateWaitUntilTime = System.currentTimeMillis() + this.getMaxReenumerationDelay();
    }

    class DelayedAddUsbDevice
    extends AddUsbDevice
    implements Runnable {
        private boolean compoundWait = false;

        public DelayedAddUsbDevice(UsbDevice device, boolean wait) {
            super(device);
            this.compoundWait = wait;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            UsbHandlePopulator.this.newDeviceConnecting++;
            int totalWait = 0;
            int thisWait = 1;
            if (this.compoundWait) {
                thisWait = UsbHandlePopulator.this.newDeviceConnecting;
            }
            do {
                try {
                    Thread.sleep(UsbHandlePopulator.this.getConnectDelay() * (long)thisWait);
                }
                catch (InterruptedException iE) {
                    thisWait = 0;
                }
                thisWait = UsbHandlePopulator.this.newDeviceConnecting - (totalWait += thisWait);
            } while (this.compoundWait && 0 < thisWait);
            try {
                super.run();
            }
            catch (Exception exception) {
            }
            finally {
                UsbHandlePopulator.this.newDeviceConnecting--;
            }
        }
    }

    class AddUsbDevice
    implements Runnable {
        public UsbDevice usbDevice = null;

        public AddUsbDevice(UsbDevice device) {
            this.usbDevice = device;
        }

        public void run() {
            try {
                UsbHandlePopulator.this.syncAddUsbDevice(this.usbDevice);
            }
            catch (PosException pE) {
                UsbHandlePopulator.this.setLastException(pE);
            }
        }
    }

    class UsbServicesL
    implements UsbServicesListener {
        UsbServicesL() {
        }

        public void usbDeviceAttached(UsbServicesEvent event) {
            int hashCode;
            String sN;
            short pId;
            short vId;
            block7: {
                if (UsbHandlePopulator.this.tracer.isOn()) {
                    UsbHandlePopulator.this.tracer.println("->usbDeviceAttached()");
                }
                UsbDevice device = event.getUsbDevice();
                vId = device.getUsbDeviceDescriptor().idVendor();
                pId = device.getUsbDeviceDescriptor().idProduct();
                String idVendorString = "0x" + Util.toHexString((short)vId);
                String idProductString = "0x" + Util.toHexString((short)pId);
                String idString = "<" + idVendorString + "," + idProductString + ">";
                if (!this.isKnownPosDevice(device)) {
                    if (UsbHandlePopulator.this.tracer.isOn()) {
                        UsbHandlePopulator.this.tracer.println("UsbDevice " + idString + " is not known POS device, skipping.");
                        UsbHandlePopulator.this.tracer.println("<-usbDeviceAttached");
                    }
                    return;
                }
                UsbHandlePopulator.this.delayedAsyncAddUsbDevice(device, true);
                sN = "";
                hashCode = device.hashCode();
                try {
                    sN = device.getSerialNumberString();
                }
                catch (Exception e) {
                    if (!UsbHandlePopulator.this.tracer.isOn()) break block7;
                    UsbHandlePopulator.this.tracer.println("Could not get SerialNumber for newly connected device : " + e.getMessage());
                    UsbHandlePopulator.this.tracer.print(e);
                }
            }
            if (UsbHandlePopulator.this.reenumeratingDevices.remove(new ReenumeratingDevice(vId, pId, sN, hashCode)) && UsbHandlePopulator.this.tracer.isOn()) {
                UsbHandlePopulator.this.tracer.println("Reenumerated device found with ID <0x" + Util.toHexString((short)vId) + ",0x" + Util.toHexString((short)pId) + "> SN '" + sN + "'" + ", HashCode '" + hashCode + "'");
            }
            if (UsbHandlePopulator.this.tracer.isOn()) {
                UsbHandlePopulator.this.tracer.println("<-usbDeviceAttached()");
            }
        }

        public void usbDeviceDetached(UsbServicesEvent event) {
            UsbDevice device = event.getUsbDevice();
        }

        private boolean isKnownPosDevice(UsbDevice device) {
            return UsbIDUtil.getInstance().isKnownPosDevice(device.getUsbDeviceDescriptor().idVendor(), device.getUsbDeviceDescriptor().idProduct());
        }
    }

    class ReenumeratingDevice {
        protected short vendorId = 0;
        protected short productId = 0;
        protected String serialNumber = "";
        protected int hashCode = 0;

        public ReenumeratingDevice(short vId, short pId, String sN, int hash) {
            if (null == sN) {
                sN = "";
            }
            this.vendorId = vId;
            this.productId = pId;
            this.serialNumber = sN;
            this.hashCode = hash;
        }

        public boolean equals(Object o) {
            ReenumeratingDevice rD = null;
            try {
                rD = (ReenumeratingDevice)o;
            }
            catch (ClassCastException ccE) {
                return false;
            }
            if (this.getVendorId() != rD.getVendorId()) {
                return false;
            }
            if (this.getProductId() != rD.getProductId()) {
                return false;
            }
            if (this.getHashCode() == rD.getHashCode()) {
                return false;
            }
            return this.getSerialNumber().equals(rD.getSerialNumber());
        }

        public short getVendorId() {
            return this.vendorId;
        }

        public short getProductId() {
            return this.productId;
        }

        public int getHashCode() {
            return this.hashCode;
        }

        public String getSerialNumber() {
            return this.serialNumber;
        }
    }
}

