/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.bus.rs232.javaxcomm;

import com.ibm.jutil.ByteBuffer;
import com.ibm.jutil.Util;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import com.ibm.posj.HandleFactory;
import com.ibm.posj.HandleFactoryException;
import com.ibm.posj.PosSystem;
import com.ibm.posj.PosSystemManager;
import com.ibm.posj.bus.HandleImp;
import com.ibm.posj.bus.IBM4610PrinterHandleImp;
import com.ibm.posj.bus.IBMPrinterComposite;
import com.ibm.posj.bus.rs232.Rs2324610PrinterHandleImp;
import com.ibm.posj.bus.rs232.Rs232APALineDisplayHandleImp;
import com.ibm.posj.bus.rs232.Rs232CashDrawerHandleImp;
import com.ibm.posj.bus.rs232.Rs232FiscalPrinterHandleImp;
import com.ibm.posj.bus.rs232.Rs232FiscalPrinterProtocol;
import com.ibm.posj.bus.rs232.Rs232FiscalPrinterProtocolListener;
import com.ibm.posj.bus.rs232.Rs232HandleKey;
import com.ibm.posj.bus.rs232.Rs232IntegratedLineScannerHandleImp;
import com.ibm.posj.bus.rs232.Rs232IntegratedOmniScannerHandleImp;
import com.ibm.posj.bus.rs232.Rs232IntegratedScannerHandleImp;
import com.ibm.posj.bus.rs232.Rs232MSRHandleImp;
import com.ibm.posj.bus.rs232.Rs232POSPrinterCashDrawerHandleImp;
import com.ibm.posj.bus.rs232.Rs232POSPrinterCheckScannerHandleImp;
import com.ibm.posj.bus.rs232.Rs232POSPrinterMICRHandleImp;
import com.ibm.posj.bus.rs232.Rs232POSPrinterToneIndicatorHandleImp;
import com.ibm.posj.bus.rs232.Rs232PrinterReader;
import com.ibm.posj.bus.rs232.Rs232SureonePrinterHandleImp;
import com.ibm.posj.bus.rs232.Rs232ToneIndicatorHandleImp;
import com.ibm.posj.bus.rs232.Rs232VFDLineDisplayHandleImp;
import com.ibm.posj.bus.rs232.javaxcomm.Rs232PortCommAdapter;
import com.ibm.posj.bus.rs232.javaxcomm.Rs232PortManager;
import com.ibm.posj.bus.rs232.javaxcomm.Rs232Util;
import com.ibm.posj.printer.IBM4610SSTToneIndicatorImp;
import com.ibm.posj.printer.ibm4610.IBM4610CashDrawerImp;
import com.ibm.posj.printer.ibm4610.IBM4610CheckScannerImp;
import com.ibm.posj.printer.ibm4610.IBM4610MICRImp;
import com.ibm.posj.util.DefaultDevCatV;
import com.ibm.posj.util.DevBuses;
import com.ibm.posj.util.DevCat;
import com.ibm.posj.util.DevCatVisitor;
import com.ibm.posj.util.DevCats;
import com.ibm.posj.util.JclHelper;
import com.ibm.posj.util.PosjUtil;
import com.ibm.rs232.DefaultRs232PortListener;
import com.ibm.rs232.Rs232Config;
import com.ibm.rs232.Rs232Exception;
import com.ibm.rs232.Rs232Port;
import com.ibm.rs232.event.Rs232DataEvent;
import com.ibm.rs232.event.Rs232ErrorEvent;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import jpos.config.JposEntry;

public class Rs232HandleImpFactory {
    private DevCatVisitor devCatVisitor = null;
    private List list = new LinkedList();
    private HandleFactory handleFactory = null;
    private HandleFactoryException hfE = null;
    private JposEntry jposEntry = null;
    private Hashtable numberTable = new Hashtable();
    private Hashtable handleNumberTable = new Hashtable();
    private Rs232PortManager portManager = null;
    private Rs232Config config = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer(((Object)DevBuses.RS232_DEVBUS).toString(), "Rs232HandleImpFactory");
    private boolean isCheckScannerPresent = false;
    private boolean isMicrPresent = false;
    private boolean isTIPresent = false;
    private int printerID_microcodeLevel = -1;
    private int cdMaxHandles = 2;
    public static final int DEFAULT_MAX_HANDLES_PER_DEVICE = 1;
    public static final int DEFAULT_CD_MAX_HANDLES_PER_DEVICE = 2;
    public static final byte[] RESET_4610_PRINTER_CMD = new byte[]{16, 5, 64};
    public static final byte[] SUREONE_FIRMWARE_THERMAL_CMD = new byte[]{27, 35, 42, 10, 0};
    public static final byte[] REQUEST_PRINTER_ID_CMD = new byte[]{29, 73, 1};
    public static final byte[] PRINTER_IDENTIFIER_CMD = new byte[]{5};
    public static final byte MICR_PRESENT_BIT_POSITION = 0;
    public static final byte TI4_EMULATION_BIT_POSITION = 1;
    public static final int CD1 = 1;
    public static final int CD2 = 2;
    public static final int CD_1_PRESENT_BIT_POSITION = 4;
    public static final int CD_2_PRESENT_BIT_POSITION = 3;
    public static final int MSR_ISO = 1;
    public static final int MSR_JUCC = 2;
    public static final String OPEN_PORT_ID = "RS232";
    public static final String POLL_TIME_OUT_MSR = "com.ibm.posj.bus.rs232.onLineWatcherPollTime.MSR";
    public static final String POLL_TIME_OUT_SCANNER = "com.ibm.posj.bus.rs232.onLineWatcherPollTime.Scanner";

    public Rs232HandleImpFactory(HandleFactory factory) {
        this.handleFactory = factory;
    }

    public synchronized List createHandleImps(JposEntry jposEntry) {
        block9: {
            this.jposEntry = jposEntry;
            if (this.tracer.isOn()) {
                this.tracer.println("--->Creating HandleImps for " + jposEntry.getLogicalName());
            }
            this.clear();
            this.config = Rs232Util.createRs232Config(jposEntry);
            try {
                String portName = this.config.getPortName();
                boolean existPort = this.getPortManager().hasRs232Port(portName);
                Rs232Port rs232Port = null;
                if (existPort) {
                    rs232Port = this.getPortManager().getRs232Port(portName);
                    if (!this.config.equals(rs232Port.getRs232config()) && this.tracer.isOn()) {
                        this.tracer.println("Rs232Port < " + portName + "> exists in portManager used previous one " + " this entry config :" + this.config);
                    }
                } else {
                    rs232Port = this.getPortManager().createRs232Port(this.config);
                    rs232Port.open(OPEN_PORT_ID);
                    if (!this.getPortManager().addRs232Port(rs232Port) && this.tracer.isOn()) {
                        this.tracer.println("Rs232Port < " + portName + "> exists in portManager used previous one " + " this entry config :" + this.config);
                    }
                }
                JclHelper.getDevCat(jposEntry).accept(this.getDevCatVisitor());
            }
            catch (Rs232Exception exc) {
                if (!this.tracer.isOn()) break block9;
                this.tracer.println("Error at Rs232Port < " + this.config.getPortName() + "> creation " + exc.toString());
            }
        }
        if (null != this.getException() && this.tracer.isOn()) {
            this.tracer.println(" An error occurred when creating Handle -> " + this.getException().toString());
        }
        if (this.tracer.isOn()) {
            this.tracer.println("<---HandleImp creation successful, " + this.list.size() + " HandleImps created for " + jposEntry.getLogicalName());
        }
        return this.list;
    }

    protected void visitCashDrawer(DevCat devCat) {
        try {
            String portName = this.config.getPortName();
            if (!portName.equalsIgnoreCase("COM4")) {
                throw new HandleFactoryException("Cash Drawers in a different port than \"COM4\" are not allowed for creation");
            }
            Rs232HandleKey key = null;
            Rs232CashDrawerHandleImp handleImp = null;
            String hKey = ((Object)devCat).toString() + portName;
            this.checkHandleNumber(hKey, this.cdMaxHandles);
            if (this.isCDPresent(this.getRs232Port(portName), 1)) {
                key = new Rs232HandleKey(devCat, 0, this.config);
                handleImp = new Rs232CashDrawerHandleImp(key, this.getRs232Port(portName), 1);
                handleImp.setHandle(this.handleFactory.createCashDrawerHandle(handleImp));
                this.list.add(handleImp);
                this.addHandle(hKey);
            } else {
                this.cdMaxHandles = 1;
            }
            if (this.isCDPresent(this.getRs232Port(portName), 2)) {
                key = new Rs232HandleKey(devCat, 1, this.config);
                handleImp = new Rs232CashDrawerHandleImp(key, this.getRs232Port(portName), 2);
                handleImp.setHandle(this.handleFactory.createCashDrawerHandle(handleImp));
                this.list.add(handleImp);
                this.addHandle(hKey);
            } else {
                this.cdMaxHandles = 1;
            }
        }
        catch (HandleFactoryException exc) {
            this.hfE = exc;
        }
    }

    protected void visitFiscalPrinter(DevCat devCat) {
        try {
            String portName = this.config.getPortName();
            String hKey = ((Object)devCat).toString() + portName;
            this.checkHandleNumber(hKey, 1);
            this.createFiscalPrinterHandle(devCat, portName);
            this.addHandle(hKey);
        }
        catch (HandleFactoryException exc) {
            this.hfE = exc;
        }
    }

    protected void visitLineDisplay(DevCat devCat) {
        try {
            String hKey = ((Object)devCat).toString() + this.config.getPortName();
            this.checkHandleNumber(hKey, 1);
            Rs232HandleKey key = new Rs232HandleKey(devCat, this.getDeviceNumber(devCat), this.config);
            Object obj = this.jposEntry.getPropertyValue("com.ibm.posj.bus.rs232.lineDisplayId");
            String lineDisplayDeviceValue = null;
            if (obj == null) {
                throw new HandleFactoryException("can not decide what LineDisplay handleImp factory create");
            }
            lineDisplayDeviceValue = obj.toString();
            if (lineDisplayDeviceValue.equals("APA")) {
                Rs232APALineDisplayHandleImp handleImp = new Rs232APALineDisplayHandleImp(key, this.getRs232Port(key.getPortName()), this.lineDisplayRs232CursorState());
                handleImp.setHandle(this.handleFactory.createLineDisplayHandle(handleImp));
                this.list.add(handleImp);
            } else if (lineDisplayDeviceValue.equals("VFD")) {
                Rs232VFDLineDisplayHandleImp handleImp = new Rs232VFDLineDisplayHandleImp(key, this.getRs232Port(key.getPortName()), this.lineDisplayRs232CursorState());
                handleImp.setHandle(this.handleFactory.createLineDisplayHandle(handleImp));
                this.list.add(handleImp);
            } else {
                throw new HandleFactoryException("Not supported LineDisplay handleImp factory type");
            }
            this.addHandle(hKey);
        }
        catch (HandleFactoryException exc) {
            this.hfE = exc;
        }
    }

    protected void visitMSR(DevCat devCat) {
        try {
            PosSystem.Properties p;
            String hKey = ((Object)devCat).toString() + this.config.getPortName();
            this.checkHandleNumber(hKey, 1);
            Rs232HandleKey key = new Rs232HandleKey(devCat, this.getDeviceNumber(devCat), this.config);
            Object obj = this.jposEntry.getPropertyValue("com.ibm.posj.bus.rs232.msrId");
            int msrDeviceId = 1;
            if (obj != null) {
                String id = obj.toString();
                if ((id = id.toUpperCase()).equals("ISO") || id.equals("1")) {
                    msrDeviceId = 1;
                } else if (id.equals("JUCC") || id.equals("2")) {
                    msrDeviceId = 2;
                }
            }
            msrDeviceId = msrDeviceId == 1 ? 3300 : (msrDeviceId == 2 ? 3301 : 3303);
            int timeout = 10000;
            boolean watcherEnabled = false;
            obj = this.jposEntry.getPropertyValue("com.ibm.posj.bus.rs232.enableOnlineWatcher");
            if (obj != null) {
                watcherEnabled = (Boolean)obj;
            }
            if (watcherEnabled && (p = PosSystemManager.getInstance().getProperties()).isPropertyDefined(POLL_TIME_OUT_MSR)) {
                try {
                    timeout = Integer.decode(p.getPropertyString(POLL_TIME_OUT_MSR));
                }
                catch (Exception e) {
                    this.tracer.print(e);
                }
            }
            Rs232MSRHandleImp handleImp = new Rs232MSRHandleImp(key, this.getRs232Port(key.getPortName()), msrDeviceId, watcherEnabled, timeout);
            handleImp.setHandle(this.handleFactory.createMSRHandle(handleImp));
            this.list.add(handleImp);
            this.addHandle(hKey);
        }
        catch (HandleFactoryException exc) {
            this.hfE = exc;
        }
    }

    protected void visitPOSPrinter(DevCat devCat) {
        try {
            String portName = this.config.getPortName();
            String hKey = ((Object)devCat).toString() + portName;
            this.checkHandleNumber(hKey, 1);
            if (!portName.equalsIgnoreCase("COM3") || this.is4610Printer(this.getRs232Port(portName))) {
                this.create4610PrinterHandles(devCat, portName);
                if (this.tracer.isOn()) {
                    this.tracer.println("creating 4610");
                }
            } else {
                if (this.tracer.isOn()) {
                    this.tracer.println("Creating sureone");
                }
                Rs232HandleKey key = new Rs232HandleKey(devCat, this.getDeviceNumber(devCat), this.config);
                Rs232SureonePrinterHandleImp sImp = new Rs232SureonePrinterHandleImp(key, this.getRs232Port(portName));
                sImp.setHandle(this.handleFactory.createPOSPrinterHandle(sImp));
                this.list.add(sImp);
            }
            this.addHandle(hKey);
        }
        catch (HandleFactoryException exc) {
            this.hfE = exc;
        }
    }

    protected void visitScanner(DevCat devCat) {
        try {
            Rs232IntegratedScannerHandleImp handleImp;
            String id;
            PosSystem.Properties p;
            String hKey = ((Object)devCat).toString() + this.config.getPortName();
            this.checkHandleNumber(hKey, 1);
            Rs232HandleKey key = new Rs232HandleKey(devCat, this.getDeviceNumber(devCat), this.config);
            int timeout = 10000;
            boolean watcherEnabled = false;
            int pollInterval = 0;
            Object pollIntervalPropertyObj = this.jposEntry.getPropertyValue("com.ibm.posj.bus.rs232.scannerPollInterval");
            Object watcherEnabledPropertyObj = this.jposEntry.getPropertyValue("com.ibm.posj.bus.rs232.enableOnlineWatcher");
            if (pollIntervalPropertyObj != null) {
                pollInterval = ((Byte)pollIntervalPropertyObj).intValue();
            }
            if (watcherEnabledPropertyObj != null && (watcherEnabled = ((Boolean)watcherEnabledPropertyObj).booleanValue()) && pollInterval > 0) {
                watcherEnabled = false;
                if (this.tracer.isOn()) {
                    this.tracer.println(1, "***OnlineWatcher disabled by DevicePoller***");
                }
            }
            if (watcherEnabled && (p = PosSystemManager.getInstance().getProperties()).isPropertyDefined(POLL_TIME_OUT_SCANNER)) {
                try {
                    timeout = Integer.decode(p.getPropertyString(POLL_TIME_OUT_SCANNER));
                }
                catch (Exception e) {
                    this.tracer.print(e);
                }
            }
            if (this.tracer.isOn()) {
                this.tracer.println("com.ibm.posj.bus.rs232.scannerPollInterval = " + pollInterval);
                this.tracer.println("com.ibm.posj.bus.rs232.enableOnlineWatcher = " + watcherEnabled + "\n" + POLL_TIME_OUT_SCANNER + " = " + timeout);
            }
            Object scannerIdPropertyObj = this.jposEntry.getPropertyValue("com.ibm.posj.bus.rs232.scannerId");
            boolean isOmniScannerId = false;
            if (scannerIdPropertyObj != null && (id = scannerIdPropertyObj.toString()).toUpperCase().indexOf("OMNI") >= 0) {
                isOmniScannerId = true;
            }
            if (isOmniScannerId) {
                handleImp = new Rs232IntegratedOmniScannerHandleImp(key, this.getRs232Port(key.getPortName()), watcherEnabled, timeout, pollInterval);
                handleImp.setHandle(this.handleFactory.createScannerHandle(handleImp));
                this.list.add(handleImp);
                this.addHandle(hKey);
            } else {
                handleImp = new Rs232IntegratedLineScannerHandleImp(key, this.getRs232Port(key.getPortName()), watcherEnabled, timeout, pollInterval);
                handleImp.setHandle(this.handleFactory.createScannerHandle(handleImp));
                this.list.add(handleImp);
                this.addHandle(hKey);
            }
        }
        catch (HandleFactoryException exc) {
            this.hfE = exc;
        }
    }

    protected DevCatVisitor getDevCatVisitor() {
        if (this.devCatVisitor == null) {
            this.devCatVisitor = new DevCatV();
        }
        return this.devCatVisitor;
    }

    protected HandleFactoryException getException() {
        return this.hfE;
    }

    protected void clear() {
        this.hfE = null;
        this.list.clear();
    }

    protected Rs232Port getRs232Port(String port) {
        return this.getPortManager().getRs232Port(port);
    }

    protected Rs232PortManager getPortManager() {
        if (this.portManager == null) {
            this.portManager = Rs232PortManager.getInstance();
        }
        return this.portManager;
    }

    protected int getDeviceNumber(DevCat devCat) {
        String key = ((Object)devCat).toString();
        int number = 0;
        if (this.numberTable.containsKey(key)) {
            number = (Integer)this.numberTable.get(key);
            ++number;
        }
        this.numberTable.put(key, new Integer(number));
        return number;
    }

    protected int getHandleNumber(String handleKey) {
        int number = 0;
        if (this.handleNumberTable.containsKey(handleKey)) {
            number = (Integer)this.handleNumberTable.get(handleKey);
        }
        return number;
    }

    protected void addHandle(String handleKey) {
        int number = 1;
        if (this.handleNumberTable.containsKey(handleKey)) {
            number = (Integer)this.handleNumberTable.get(handleKey);
            ++number;
        }
        this.handleNumberTable.put(handleKey, new Integer(number));
    }

    protected void checkHandleNumber(String hKey, int maxNumber) throws HandleFactoryException {
        if (this.getHandleNumber(hKey) >= maxNumber) {
            throw new HandleFactoryException("The number of Handle Imps exceds the limit permited :" + maxNumber);
        }
    }

    private byte lineDisplayRs232CursorState() {
        String stringCursorState = null;
        byte cursorState = 1;
        Object obj = this.jposEntry.getPropertyValue("com.ibm.jpos.services.sdi.config.LineDisplay.CursorState");
        if (obj != null && (stringCursorState = obj.toString()).equals("OFF")) {
            cursorState = 0;
        }
        return cursorState;
    }

    private void createFiscalPrinterHandle(DevCat devCat, String portName) throws HandleFactoryException {
        if (this.tracer.isOn()) {
            this.tracer.println("-->createFiscalPrinterHandle");
        }
        this.checkFiscalPrinterOnline(this.getRs232Port(portName));
        Rs232HandleKey key = new Rs232HandleKey(devCat, this.getDeviceNumber(devCat), this.config);
        Rs232FiscalPrinterHandleImp handleImp = new Rs232FiscalPrinterHandleImp(key, this.getRs232Port(portName));
        handleImp.setHandle(this.handleFactory.createFiscalPrinterHandle(handleImp));
        this.list.add(handleImp);
        if (this.tracer.isOn()) {
            this.tracer.println("<--createFiscalPrinterHandle");
        }
    }

    private byte checkFiscalPrinterOnline(Rs232Port port) throws HandleFactoryException {
        if (this.tracer.isOn()) {
            this.tracer.println("-->checkFiscalPrinterOnline");
            this.tracer.println("Check 4610 Fiscal Printer existance");
        }
        Rs232FiscalPrinterProtocol protocol = new Rs232FiscalPrinterProtocol();
        class StateListener
        implements Rs232FiscalPrinterProtocolListener {
            private boolean dataReceived = false;
            private Rs232PortCommAdapter port = null;

            StateListener() {
            }

            public void writeToPort(byte[] data, int length) {
                try {
                    this.port.submit(data);
                }
                catch (Rs232Exception rs232Exception) {
                    // empty catch block
                }
            }

            public void fireErrorEvent(int type) {
            }

            public void fireDataEvent(byte[] data) {
                this.dataReceived = true;
                Rs232HandleImpFactory.this.tracer.println("data received");
            }

            public void fireStatusEvent(int sts) {
            }

            public void fireDirectIOEvent(byte[] data) {
            }

            public boolean isDirectIOMode() {
                return false;
            }

            public boolean getDataReceived() {
                return this.dataReceived;
            }

            public void setPort(Rs232PortCommAdapter commAdapter) {
                this.port = commAdapter;
            }
        }
        StateListener listener = new StateListener();
        byte type = 0;
        try {
            port.open("HandleImpFactory");
            listener.setPort((Rs232PortCommAdapter)port);
            ((Rs232PortCommAdapter)port).setReaderStrategy(protocol);
            int maxRetry = 0;
            long startTime = 0L;
            do {
                ++maxRetry;
                if (this.tracer.isOn()) {
                    this.tracer.println("retry: " + maxRetry);
                }
                protocol.stopTimer();
                startTime = System.currentTimeMillis();
                protocol.detectFiscalPrinter(listener);
                while (!listener.getDataReceived()) {
                    if (System.currentTimeMillis() - startTime < (long)(250 * 10)) continue;
                }
            } while (!listener.getDataReceived() && maxRetry < 6);
            protocol.stopTimer();
            if (maxRetry >= 6) {
                if (this.tracer.isOn()) {
                    this.tracer.println("no more retries");
                }
                throw new HandleFactoryException("NO 4610 Fiscal Printer Hardware present");
            }
        }
        catch (Rs232Exception e) {
            if (this.tracer.isOn()) {
                this.tracer.println("create exception");
            }
            throw new HandleFactoryException("Error checking Fiscal Printer existance" + e);
        }
        finally {
            protocol.setHandleImp(null);
            protocol = null;
        }
        if (this.tracer.isOn()) {
            this.tracer.println("<--checkFiscalPrinterOnline");
        }
        return type;
    }

    private void create4610PrinterHandles(DevCat devCat, String portName) throws HandleFactoryException {
        IBM4610PrinterHandleImp.PrinterInfo type = this.areSubDevicesPresent(this.getRs232Port(portName));
        Rs232HandleKey key = new Rs232HandleKey(devCat, this.getDeviceNumber(devCat), this.config);
        Rs2324610PrinterHandleImp ptrHandleImp = new Rs2324610PrinterHandleImp(key, this.getRs232Port(portName), type);
        ptrHandleImp.setPrinterID_microcodeLevel(this.getPrinterID_microcodeLevel());
        ptrHandleImp.setHandle(this.handleFactory.createPOSPrinterHandle(ptrHandleImp));
        this.list.add(ptrHandleImp);
        if (this.isMicrPresent) {
            this.list.add(this.create4610MicrHandleImp(DevCats.MICR_DEVCAT, this.config, ptrHandleImp));
        }
        HandleImp handleI = this.create4610CDHandleImp(DevCats.CASHDRAWER_DEVCAT, this.config, 1, 0, ptrHandleImp);
        this.list.add(handleI);
        handleI = this.create4610CDHandleImp(DevCats.CASHDRAWER_DEVCAT, this.config, 2, 1, ptrHandleImp);
        this.list.add(handleI);
        if (this.isTIPresent) {
            handleI = this.create4610TIHandleImp(DevCats.TONEINDICATOR_DEVCAT, this.config, ptrHandleImp);
            this.list.add(handleI);
        }
        if (this.isCheckScannerPresent) {
            handleI = this.create4610CSHandleImp(DevCats.CHECKSCANNER_DEVCAT, this.config, ptrHandleImp);
            this.list.add(handleI);
        }
    }

    private int getPrinterID_microcodeLevel() {
        return this.printerID_microcodeLevel;
    }

    private boolean is4610Printer(Rs232Port port) throws HandleFactoryException {
        final ByteBuffer buffer = new ByteBuffer();
        DefaultRs232PortListener printerSubDevicesListener = new DefaultRs232PortListener(){

            public void dataEventOccurred(Rs232DataEvent rs232DataEvent) {
                buffer.append(rs232DataEvent.getData());
            }

            public void errorEventOccurred(Rs232ErrorEvent rs232ErrorEvent) {
                Rs232HandleImpFactory.this.tracer.println(rs232ErrorEvent.getRs232Exception().toString());
            }
        };
        port.addRs232PortListener(printerSubDevicesListener);
        try {
            port.submit(PRINTER_IDENTIFIER_CMD);
            Thread.currentThread();
            Thread.sleep(1200L);
        }
        catch (Exception e) {
            throw new HandleFactoryException("Error checking printer existance" + e);
        }
        return buffer.getByteCount() <= 0;
    }

    private IBM4610PrinterHandleImp.PrinterInfo areSubDevicesPresent(Rs232Port port) throws HandleFactoryException {
        IBM4610PrinterHandleImp.PrinterInfo level = new IBM4610PrinterHandleImp.PrinterInfo();
        this.isMicrPresent = false;
        this.isTIPresent = false;
        int printer_ID = 1;
        int printermicrocodeLevel = -1;
        DefaultRs232PortListener printerSubDevicesListener = null;
        this.tracer.println("Check 4610 TI3/4/5 TM/F 6/7 Printer existance");
        Rs232PrinterReader treader = new Rs232PrinterReader(port);
        try {
            try {
                final ByteBuffer buffer = new ByteBuffer();
                ((Rs232PortCommAdapter)port).setReaderStrategy(treader);
                printerSubDevicesListener = new DefaultRs232PortListener(){

                    public void dataEventOccurred(Rs232DataEvent rs232DataEvent) {
                        buffer.append((byte)0);
                        buffer.append((byte)0);
                        buffer.append(rs232DataEvent.getData());
                    }

                    public void errorEventOccurred(Rs232ErrorEvent rs232ErrorEvent) {
                        Rs232HandleImpFactory.this.tracer.println(rs232ErrorEvent.getRs232Exception().toString());
                    }
                };
                port.submit(RESET_4610_PRINTER_CMD);
                try {
                    Thread.currentThread();
                    Thread.sleep(3500L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                port.addRs232PortListener(printerSubDevicesListener);
                port.submit(REQUEST_PRINTER_ID_CMD);
                int maxRetry = 0;
                do {
                    try {
                        Thread.currentThread();
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                } while (buffer.getByteCount() < 15 && maxRetry++ < 5);
                if (maxRetry >= 5) {
                    throw new HandleFactoryException("NO 4610 TI3/4/5 TM/F 6/7 Printer Hardware present");
                }
                if (PosjUtil.isBitSelected(buffer.byteAt(12), 0) || buffer.byteAt(10) == 49) {
                    this.isMicrPresent = true;
                }
                this.tracer.println(Util.toFormatedHexString((byte[])buffer.getBytes()));
                if (buffer.byteAt(11) == 3 || buffer.byteAt(11) == 5 || buffer.byteAt(11) == 7) {
                    this.isTIPresent = true;
                }
                level.setType((byte)48);
                level.setId(buffer.byteAt(11));
                if (buffer.byteAt(10) == 49 || buffer.byteAt(10) == 48 && PosjUtil.isBitSelected(buffer.byteAt(13), 1)) {
                    level.setType((byte)49);
                    if (PosjUtil.isBitSelected(buffer.byteAt(13), 2)) {
                        if (PosjUtil.isBitSelected(buffer.byteAt(13), 4)) {
                            printer_ID = 11;
                            this.isCheckScannerPresent = false;
                        } else {
                            printer_ID = 10;
                            this.isCheckScannerPresent = true;
                        }
                    } else {
                        printer_ID = 9;
                        this.isCheckScannerPresent = true;
                    }
                    level.setId((byte)printer_ID);
                } else {
                    printer_ID = buffer.byteAt(11);
                }
                this.printerID_microcodeLevel = -1;
                printermicrocodeLevel = buffer.byteAt(14);
                this.printerID_microcodeLevel = printermicrocodeLevel | (printer_ID <<= 8);
                port.removeRs232PortListener(printerSubDevicesListener);
            }
            catch (Rs232Exception e) {
                throw new HandleFactoryException("Error checking MICR existance" + e);
            }
            Object var11_12 = null;
            port.removeRs232PortListener(printerSubDevicesListener);
            ((Rs232PortCommAdapter)port).setReaderStrategy(null);
            treader.kill();
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            port.removeRs232PortListener(printerSubDevicesListener);
            ((Rs232PortCommAdapter)port).setReaderStrategy(null);
            treader.kill();
            throw throwable;
        }
        return level;
    }

    private boolean isCDPresent(Rs232Port port, int cdNumber) throws HandleFactoryException {
        boolean cdPresent = false;
        int presenceBitPosition = cdNumber == 1 ? 4 : 3;
        try {
            final ByteBuffer status = new ByteBuffer();
            port.open("HandleImpFactory");
            DefaultRs232PortListener cdListener = new DefaultRs232PortListener(){

                public void dataEventOccurred(Rs232DataEvent rs232DataEvent) {
                    status.append(rs232DataEvent.getData()[0]);
                    Rs232HandleImpFactory.this.tracer.println("Verifying if CD present. status = " + status.byteAt(0));
                }

                public void errorEventOccurred(Rs232ErrorEvent rs232ErrorEvent) {
                    Rs232HandleImpFactory.this.tracer.println(rs232ErrorEvent.getRs232Exception().toString());
                }
            };
            port.addRs232PortListener(cdListener);
            port.submit(Rs232CashDrawerHandleImp.STATUS_REQUEST_CMD);
            int retry = 0;
            int maxRetry = 6;
            do {
                try {
                    Thread.currentThread();
                    Thread.sleep(300L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while (status.getByteCount() == 0 && retry++ < maxRetry);
            if (retry >= maxRetry) {
                throw new HandleFactoryException("No Cash Drawer Hardware present");
            }
            if (PosjUtil.isBitSelected(status.byteAt(0), presenceBitPosition)) {
                cdPresent = true;
            }
            port.removeRs232PortListener(cdListener);
        }
        catch (Rs232Exception e) {
            throw new HandleFactoryException("Error while verifying Cash Drawer presence" + e);
        }
        this.tracer.println("Cash drawer " + cdNumber + " present ? " + cdPresent);
        return cdPresent;
    }

    private HandleImp create4610CDHandleImp(DevCat devCat, Rs232Config config, int cdNumber, int deviceNumber, IBMPrinterComposite printerComposite) throws HandleFactoryException {
        Rs232HandleKey k = new Rs232HandleKey(devCat, deviceNumber, config);
        IBM4610CashDrawerImp cdLinker = new IBM4610CashDrawerImp(k, printerComposite, cdNumber);
        Rs232POSPrinterCashDrawerHandleImp hi = new Rs232POSPrinterCashDrawerHandleImp(k, this.getRs232Port(k.getPortName()), cdLinker);
        cdLinker.setHandleImp(hi);
        hi.setHandle(this.handleFactory.createCashDrawerHandle(hi));
        printerComposite.addDevice(k, cdLinker);
        return hi;
    }

    private HandleImp create4610CSHandleImp(DevCat devCat, Rs232Config config, IBMPrinterComposite printerComposite) throws HandleFactoryException {
        Rs232HandleKey k = new Rs232HandleKey(devCat, this.getDeviceNumber(devCat), config);
        IBM4610CheckScannerImp csLinker = new IBM4610CheckScannerImp(k, printerComposite);
        Rs232POSPrinterCheckScannerHandleImp hi = new Rs232POSPrinterCheckScannerHandleImp(k, this.getRs232Port(k.getPortName()), csLinker);
        csLinker.setHandleImp(hi);
        hi.setHandle(this.handleFactory.createCheckScannerHandle(hi));
        printerComposite.addDevice(k, csLinker);
        return hi;
    }

    private HandleImp create4610MicrHandleImp(DevCat devCat, Rs232Config config, IBMPrinterComposite printerComposite) throws HandleFactoryException {
        Rs232HandleKey k = new Rs232HandleKey(devCat, this.getDeviceNumber(devCat), config);
        IBM4610MICRImp micrLinker = new IBM4610MICRImp(k, printerComposite);
        Rs232POSPrinterMICRHandleImp hi = new Rs232POSPrinterMICRHandleImp(k, this.getRs232Port(k.getPortName()), micrLinker);
        micrLinker.setHandleImp(hi);
        hi.setHandle(this.handleFactory.create4610MICRHandle(hi));
        printerComposite.addDevice(k, micrLinker);
        return hi;
    }

    private Rs232ToneIndicatorHandleImp create4610TIHandleImp(DevCat devCat, Rs232Config config, IBMPrinterComposite printerComposite) throws HandleFactoryException {
        Rs232HandleKey k = new Rs232HandleKey(devCat, this.getDeviceNumber(devCat), config);
        IBM4610SSTToneIndicatorImp ti = new IBM4610SSTToneIndicatorImp(printerComposite);
        Rs232POSPrinterToneIndicatorHandleImp hi = new Rs232POSPrinterToneIndicatorHandleImp(k, this.getRs232Port(k.getPortName()), ti);
        hi.setHandle(this.handleFactory.createToneIndicatorHandle(hi));
        printerComposite.addDevice(k, hi);
        return hi;
    }

    class DevCatV
    extends DefaultDevCatV {
        DevCatV() {
        }

        public void visitCashDrawer(DevCat devCat) {
            Rs232HandleImpFactory.this.visitCashDrawer(devCat);
        }

        public void visitFiscalPrinter(DevCat devCat) {
            Rs232HandleImpFactory.this.visitFiscalPrinter(devCat);
        }

        public void visitMSR(DevCat devCat) {
            Rs232HandleImpFactory.this.visitMSR(devCat);
        }

        public void visitLineDisplay(DevCat devCat) {
            Rs232HandleImpFactory.this.visitLineDisplay(devCat);
        }

        public void visitPOSPrinter(DevCat devCat) {
            Rs232HandleImpFactory.this.visitPOSPrinter(devCat);
        }

        public void visitScanner(DevCat devCat) {
            Rs232HandleImpFactory.this.visitScanner(devCat);
        }
    }
}

