/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.kbd;

import com.ibm.posj.kbd.AbstractKbdMapping;
import com.ibm.posj.kbd.POSKeyboardData;
import com.ibm.posj.util.PosjUtil;
import java.util.Vector;

public class DefaultSIOUsbPOSKbdMapping
extends AbstractKbdMapping {
    private byte lastKey = 0;
    private Vector vector = new Vector();
    private POSKeyboardData[] posKeyboardData = new POSKeyboardData[0];

    public synchronized POSKeyboardData[] translateKey(byte[] handleKey) {
        int count;
        this.vector.removeAllElements();
        for (count = 0; count < handleKey.length; ++count) {
            if (!this.isValidKey(handleKey[count])) continue;
            this.processKey(handleKey[count]);
            this.setLastKey(handleKey[count]);
        }
        this.posKeyboardData = new POSKeyboardData[this.vector.size()];
        for (count = 0; count < this.posKeyboardData.length; ++count) {
            this.posKeyboardData[count] = (POSKeyboardData)this.vector.elementAt(count);
        }
        return this.posKeyboardData;
    }

    protected void processKey(byte key) {
        if (key == -16) {
            return;
        }
        if (this.lastKey == -16) {
            this.vector.add(this.toPOSKeyboardData(key, 2));
        } else {
            this.vector.add(this.toPOSKeyboardData(key, 1));
        }
    }

    protected boolean isValidKey(byte key) {
        return key != -1;
    }

    protected POSKeyboardData toPOSKeyboardData(byte key, int type) {
        int data = PosjUtil.toUnsignedInt(key);
        return new POSKeyboardData(data, type);
    }

    protected void setLastKey(byte key) {
        this.lastKey = key;
    }
}

