/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.posj.printer;

import com.ibm.jutil.JUtilException;
import com.ibm.posj.bus.printer.cmds.PrintCmdList;
import com.ibm.posj.printer.PrinterWriter;
import com.ibm.posj.printer.RetryInputQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SubmissionContainer {
    List internalList = Collections.synchronizedList(new ArrayList(5));

    public int size() {
        return this.internalList.size();
    }

    public String toString() {
        try {
            return "\n\tSentQ - " + this.internalList.toString();
        }
        catch (Exception e) {
            return "Exception";
        }
    }

    public void removeList(PrintCmdList cmd) {
        this.internalList.remove(cmd);
    }

    public Iterator iterator() {
        return this.internalList.iterator();
    }

    public void addToContainer(PrintCmdList cmd) {
        if (PrinterWriter.getTracer().isOn()) {
            PrinterWriter.getTracer().println("Adding 2 sq " + cmd);
        }
        this.internalList.add(cmd);
    }

    public PrintCmdList getLastSent() {
        try {
            PrintCmdList last = null;
            do {
                if (null == last) continue;
                this.internalList.remove(last);
            } while (!(last = (PrintCmdList)this.internalList.get(this.internalList.size() - 1)).hasCommands());
            return last;
        }
        catch (Exception a) {
            return null;
        }
    }

    public void format() {
        if (this.internalList.isEmpty()) {
            return;
        }
        try {
            for (int i = 0; i < this.internalList.size(); ++i) {
                PrintCmdList list = (PrintCmdList)this.internalList.get(i);
                if (!list.isFullyComplete()) continue;
                this.internalList.remove(list);
                list.recycle();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PrintCmdList getPendingCmdList() {
        if (this.internalList.isEmpty()) {
            return null;
        }
        try {
            return (PrintCmdList)this.internalList.get(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public PrintCmdList removePendingCmdList() {
        if (this.internalList.isEmpty()) {
            return null;
        }
        PrintCmdList ret = null;
        try {
            ret = (PrintCmdList)this.internalList.remove(0);
        }
        catch (Exception e) {
            return null;
        }
        return ret;
    }

    public PrintCmdList getNextCmdListToComplete() {
        return this.getCmdListToComplete(0);
    }

    public PrintCmdList getCmdListToComplete(int offset) {
        int posi = offset;
        if (this.internalList.isEmpty() || posi >= this.internalList.size()) {
            return null;
        }
        PrintCmdList item = null;
        try {
            item = (PrintCmdList)this.internalList.get(posi);
        }
        catch (Exception jut) {
            return null;
        }
        try {
            do {
                PrintCmdList l;
                if ((l = item).isPartialComplete()) {
                    if (l.isFullyComplete()) {
                        this.internalList.remove(l);
                        --posi;
                    }
                } else {
                    return l;
                }
                if (posi + 1 < this.internalList.size()) continue;
                return null;
            } while (null != (item = (PrintCmdList)this.internalList.get(++posi)));
            return null;
        }
        catch (Exception e) {
            if (PrinterWriter.getTracer().isOn()) {
                PrinterWriter.getTracer().print(e);
            }
            return null;
        }
    }

    public void resendCmds() throws JUtilException {
        while (!this.internalList.isEmpty()) {
            PrintCmdList pcl = (PrintCmdList)this.internalList.remove(this.internalList.size() - 1);
            if (!pcl.hasCommands()) {
                pcl.recycle();
                continue;
            }
            if (pcl.isFullyComplete()) {
                return;
            }
            pcl.reset();
            RetryInputQueue riq = (RetryInputQueue)pcl.getParent();
            riq.retryOutput(pcl);
        }
    }
}

