/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.os.sockets;

import com.ibm.jsio.SioDevice;
import com.ibm.jsio.SioException;
import com.ibm.jsio.SioIrp;
import com.ibm.jsio.SioSlot;
import com.ibm.jsio.event.DefaultSioDeviceEventHelper;
import com.ibm.jsio.event.SioDeviceEventHelper;
import com.ibm.jsio.event.SioDeviceListener;
import com.ibm.jsio.os.SioIrpImp;
import com.ibm.jsio.os.SioIrpRecyclable;
import com.ibm.jsio.os.sockets.SioMessageReader;
import com.ibm.jsio.os.sockets.SioProtocol;
import java.util.Iterator;
import java.util.List;

public class SioDeviceImp
implements SioDevice {
    private boolean deviceAttached = true;
    private byte deviceNumber = 0;
    private int tcpPort = 0;
    private byte portNumber = 0;
    private SioSlot sioSlot = null;
    private byte aWait = (byte)-64;
    private byte bWait = (byte)-112;
    private boolean open = false;
    private SioProtocol protocol = null;
    private SioDeviceEventHelper eventHelper = new DefaultSioDeviceEventHelper();
    private Thread readerThread = null;
    private SioMessageReader reader = null;

    public void open() throws SioException {
        if (!this.open) {
            if (this.protocol == null) {
                this.protocol = new SioProtocol(this);
                this.protocol.init();
                this.reader = new SioMessageReader(this.protocol, this.protocol.getSocket());
                this.readerThread = new Thread(this.reader);
                this.readerThread.start();
                this.protocol.exchangeVersion();
            }
        } else {
            throw new SioException("The device has already been opened.");
        }
        this.protocol.start();
        this.open = true;
    }

    public void close() throws SioException {
        if (!this.open) {
            throw new SioException("The device is already closed.");
        }
        this.protocol.close();
        this.protocol = null;
    }

    public void killReader() {
        if (this.reader != null) {
            this.reader.setEnabled(false);
        }
        this.protocol.closeSocket();
    }

    public boolean isDeviceAttached() {
        return this.deviceAttached;
    }

    public SioSlot getSioSlot() {
        return this.sioSlot;
    }

    public byte getSioSlotNumber() {
        if (this.sioSlot != null) {
            return this.sioSlot.getSioSlotNumber();
        }
        return 0;
    }

    public byte getPortNumber() {
        return this.portNumber;
    }

    public byte getDeviceNumber() {
        return this.deviceNumber;
    }

    public byte getAddressWaitTime() {
        return this.aWait;
    }

    public byte getInterByteWaitTime() {
        return this.bWait;
    }

    public void setAddressWaitTime(byte time) {
        this.aWait = time;
    }

    public void setInterByteWaitTime(byte time) {
        this.bWait = time;
    }

    public void syncSubmit(SioIrp irp) throws SioException, IllegalArgumentException {
        if (!this.open) {
            throw new SioException("Device is closed. You must open it to submit.");
        }
        if (this.aWait == -1 || this.bWait == -1) {
            throw new SioException("You must set aWait and bWait with proper values for the device before calling submit");
        }
        this.protocol.syncSubmit(irp);
    }

    public void asyncSubmit(SioIrp irp) throws SioException, IllegalArgumentException {
        if (!this.open) {
            throw new SioException("Device is closed. You must open it to submit.");
        }
        if (this.aWait == -1 || this.bWait == -1) {
            throw new SioException("You must set aWait and bWait with proper values for the device before calling submit");
        }
        this.protocol.asyncSubmit(irp);
    }

    public void syncSubmit(List list) throws SioException, IllegalArgumentException {
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.syncSubmit((SioIrp)it.next());
            }
        } else {
            throw new SioException("Illegal parameter. The list of irps must not be null");
        }
    }

    public void asyncSubmit(List list) throws SioException, IllegalArgumentException {
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.asyncSubmit((SioIrp)it.next());
            }
        } else {
            throw new SioException("Illegal parameter. The list of irps must not be null");
        }
    }

    public void addSioDeviceListener(SioDeviceListener listener) {
        this.eventHelper.addSioDeviceListener(listener);
    }

    public void removeSioDeviceListener(SioDeviceListener listener) {
        this.eventHelper.removeSioDeviceListener(listener);
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    public void setDeviceNumber(byte b) {
        this.deviceNumber = b;
    }

    public void setPortNumber(byte b) {
        this.portNumber = b;
    }

    public void setTcpPort(int i) {
        this.tcpPort = i;
    }

    public void setSioSlot(SioSlot slot) {
        this.sioSlot = slot;
    }

    public SioDeviceEventHelper getEventHelper() {
        return this.eventHelper;
    }

    public void setDeviceAttached(boolean value) {
        this.deviceAttached = value;
    }

    public SioIrp createSioIrp(byte[] data, boolean recyclable) {
        if (recyclable) {
            return SioIrpRecyclable.createSioIrpRecyclable(data);
        }
        return new SioIrpImp(data);
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean b) {
        this.open = b;
    }

    public SioIrp createSioIrp(byte[] data, int o, int l, boolean recyclable) {
        if (recyclable) {
            return SioIrpRecyclable.createSioIrpRecyclable(data, o, l);
        }
        return new SioIrpImp(data, o, l);
    }
}

