/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsio.os.sockets;

import com.ibm.jsio.SioIrp;
import com.ibm.jsio.os.sockets.SioProtocol;
import com.ibm.jutil.Util;
import java.util.HashMap;

public class SioImpUtil {
    public static final int FLAG_ERROR = 2;
    public static final int FLAG_INDEX = 8;

    private SioImpUtil() {
    }

    public static boolean is485Message(byte[] msg) {
        return SioImpUtil.checkValue(msg, "<rs485>");
    }

    public static boolean isAckMessage(byte[] msg) {
        return SioImpUtil.checkValue(msg, "<ack>");
    }

    public static boolean checkValue(byte[] data, String value) {
        if (data == null || value == null || data.length < value.length()) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            if ((char)data[i] == value.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int parseConnectionId(byte[] msg) {
        int value = 0;
        if (SioImpUtil.checkValue(msg, "<open>OK")) {
            int i;
            for (i = SioProtocol.CONNECTION_ID_INITIAL_INDEX; (char)msg[i] != '<' && i < msg.length; ++i) {
            }
            value = Integer.parseInt(new String(msg, SioProtocol.CONNECTION_ID_INITIAL_INDEX, i - SioProtocol.CONNECTION_ID_INITIAL_INDEX));
        }
        return value;
    }

    public static String formatConnectionId(int id) {
        byte[] temp = new byte[]{(byte)((id & 0xFF000000) >> 24), (byte)((id & 0xFF0000) >> 16), (byte)((id & 0xFF00) >> 8), (byte)(id & 0xFF)};
        return new String(temp);
    }

    public static Integer getMsgId(byte[] msg) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value = (value << 8) + (msg[14 + i] & 0xFF);
        }
        return new Integer(value);
    }

    public static boolean isControlMessage(byte[] msg) {
        return SioImpUtil.checkValue(msg, "<close>") || SioImpUtil.checkValue(msg, "<status>") || SioImpUtil.checkValue(msg, "<trace>") || SioImpUtil.checkValue(msg, "<version>") || SioImpUtil.checkValue(msg, "<open>");
    }

    public static String format(byte[] data) {
        StringBuffer string = new StringBuffer();
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] < 34 || data[i] > 122) {
                    string.append("\\x");
                    string.append(Integer.toHexString(data[i] & 0xFF));
                    continue;
                }
                string.append("\\");
                string.append((char)data[i]);
            }
        }
        return string.toString();
    }

    public static String getClassName(Object o) {
        String temp = o.getClass().getName();
        if (temp.lastIndexOf(46) == -1) {
            return temp;
        }
        String temp2 = temp.substring(temp.lastIndexOf(46) + 1, temp.length());
        return temp2;
    }

    public static void loadDefaultAWait(HashMap defaultAWaitHashMap) {
        defaultAWaitHashMap.put(new Integer(84), new Byte(-64));
        defaultAWaitHashMap.put(new Integer(36), new Byte(96));
        defaultAWaitHashMap.put(new Integer(37), new Byte(96));
        defaultAWaitHashMap.put(new Integer(42), new Byte(48));
        defaultAWaitHashMap.put(new Integer(43), new Byte(48));
        defaultAWaitHashMap.put(new Integer(44), new Byte(48));
        defaultAWaitHashMap.put(new Integer(45), new Byte(48));
        defaultAWaitHashMap.put(new Integer(34), new Byte(35));
        defaultAWaitHashMap.put(new Integer(35), new Byte(35));
        defaultAWaitHashMap.put(new Integer(38), new Byte(48));
        defaultAWaitHashMap.put(new Integer(39), new Byte(48));
        defaultAWaitHashMap.put(new Integer(28), new Byte(32));
        defaultAWaitHashMap.put(new Integer(29), new Byte(32));
        defaultAWaitHashMap.put(new Integer(26), new Byte(48));
        defaultAWaitHashMap.put(new Integer(27), new Byte(48));
        defaultAWaitHashMap.put(new Integer(16), new Byte(32));
        defaultAWaitHashMap.put(new Integer(17), new Byte(32));
        defaultAWaitHashMap.put(new Integer(25), new Byte(32));
        defaultAWaitHashMap.put(new Integer(64), new Byte(32));
        defaultAWaitHashMap.put(new Integer(65), new Byte(32));
        defaultAWaitHashMap.put(new Integer(70), new Byte(32));
        defaultAWaitHashMap.put(new Integer(71), new Byte(32));
        defaultAWaitHashMap.put(new Integer(72), new Byte(32));
        defaultAWaitHashMap.put(new Integer(73), new Byte(32));
        defaultAWaitHashMap.put(new Integer(48), new Byte(-64));
        defaultAWaitHashMap.put(new Integer(50), new Byte(-112));
        defaultAWaitHashMap.put(new Integer(52), new Byte(-112));
        defaultAWaitHashMap.put(new Integer(53), new Byte(-112));
        defaultAWaitHashMap.put(new Integer(55), new Byte(-112));
        defaultAWaitHashMap.put(new Integer(56), new Byte(-112));
        defaultAWaitHashMap.put(new Integer(106), new Byte(48));
        defaultAWaitHashMap.put(new Integer(110), new Byte(48));
        defaultAWaitHashMap.put(new Integer(74), new Byte(48));
        defaultAWaitHashMap.put(new Integer(75), new Byte(48));
    }

    public static void loadDefaultBWait(HashMap defaultBWaitHashMap) {
        defaultBWaitHashMap.put(new Integer(84), new Byte(-112));
        defaultBWaitHashMap.put(new Integer(36), new Byte(72));
        defaultBWaitHashMap.put(new Integer(37), new Byte(72));
        defaultBWaitHashMap.put(new Integer(42), new Byte(0));
        defaultBWaitHashMap.put(new Integer(43), new Byte(0));
        defaultBWaitHashMap.put(new Integer(44), new Byte(0));
        defaultBWaitHashMap.put(new Integer(45), new Byte(0));
        defaultBWaitHashMap.put(new Integer(34), new Byte(16));
        defaultBWaitHashMap.put(new Integer(35), new Byte(16));
        defaultBWaitHashMap.put(new Integer(38), new Byte(0));
        defaultBWaitHashMap.put(new Integer(39), new Byte(0));
        defaultBWaitHashMap.put(new Integer(28), new Byte(16));
        defaultBWaitHashMap.put(new Integer(29), new Byte(16));
        defaultBWaitHashMap.put(new Integer(26), new Byte(0));
        defaultBWaitHashMap.put(new Integer(27), new Byte(0));
        defaultBWaitHashMap.put(new Integer(16), new Byte(16));
        defaultBWaitHashMap.put(new Integer(17), new Byte(16));
        defaultBWaitHashMap.put(new Integer(25), new Byte(16));
        defaultBWaitHashMap.put(new Integer(64), new Byte(16));
        defaultBWaitHashMap.put(new Integer(65), new Byte(16));
        defaultBWaitHashMap.put(new Integer(70), new Byte(16));
        defaultBWaitHashMap.put(new Integer(71), new Byte(16));
        defaultBWaitHashMap.put(new Integer(72), new Byte(16));
        defaultBWaitHashMap.put(new Integer(73), new Byte(16));
        defaultBWaitHashMap.put(new Integer(48), new Byte(0));
        defaultBWaitHashMap.put(new Integer(50), new Byte(72));
        defaultBWaitHashMap.put(new Integer(52), new Byte(72));
        defaultBWaitHashMap.put(new Integer(53), new Byte(72));
        defaultBWaitHashMap.put(new Integer(55), new Byte(72));
        defaultBWaitHashMap.put(new Integer(56), new Byte(72));
        defaultBWaitHashMap.put(new Integer(106), new Byte(0));
        defaultBWaitHashMap.put(new Integer(110), new Byte(0));
        defaultBWaitHashMap.put(new Integer(74), new Byte(0));
        defaultBWaitHashMap.put(new Integer(75), new Byte(0));
    }

    public static String formatData(byte[] bs) {
        return Util.toFormatedHexString((byte[])bs);
    }

    public static String formatData(SioIrp irp) {
        if (irp != null) {
            byte[] temp = new byte[irp.getLength()];
            System.arraycopy(irp.getData(), irp.getOffset(), temp, 0, irp.getLength());
            return Util.toFormatedHexString((byte[])temp);
        }
        return "";
    }

    public static boolean isTruncatedMsg(byte[] msg) {
        return msg[8] == 0 && msg[9] == 2;
    }
}

