/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.poskbd.bus;

import com.ibm.jutil.tasks.FifoScheduler;
import com.ibm.jutil.tasks.Task;
import com.ibm.jutil.tasks.TaskScheduler;
import com.ibm.poskbd.event.KeyboardEvent;
import com.ibm.poskbd.event.KeyboardListener;
import com.ibm.poskbd.event.ScancodeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KeyboardListenerHelper {
    private List listeners = new ArrayList();
    private TaskScheduler taskScheduler = new FifoScheduler();

    public void fireScancodeReceived(ScancodeEvent event) {
        this.taskScheduler.post((Task)new ScancodeEventTask(event));
    }

    public void fireKeyboardDisconnected(KeyboardEvent event) {
        this.taskScheduler.post((Task)new KeyboardDisconnectedTask(event));
    }

    public synchronized void addKeyboardListener(KeyboardListener listener) {
        if (null != listener && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeKeyboardListener(KeyboardListener listener) {
        if (null != listener) {
            this.listeners.remove(listener);
        }
    }

    public synchronized int getListenerCount() {
        return this.listeners.size();
    }

    private class KeyboardDisconnectedTask
    extends AbstractEventTask {
        KeyboardDisconnectedTask(KeyboardEvent event) {
            super(event);
        }

        protected void fireEvent(KeyboardEvent event, KeyboardListener listener) {
            listener.keyboardDisconnected(event);
        }
    }

    private class ScancodeEventTask
    extends AbstractEventTask {
        ScancodeEventTask(ScancodeEvent event) {
            super(event);
        }

        protected void fireEvent(KeyboardEvent event, KeyboardListener listener) {
            listener.scancodeReceived((ScancodeEvent)event);
        }
    }

    private abstract class AbstractEventTask
    implements Task {
        private KeyboardEvent event = null;

        AbstractEventTask(KeyboardEvent event) {
            this.event = event;
        }

        protected abstract void fireEvent(KeyboardEvent var1, KeyboardListener var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            ArrayList listenersCopy = null;
            List list = KeyboardListenerHelper.this.listeners;
            synchronized (list) {
                listenersCopy = new ArrayList(KeyboardListenerHelper.this.listeners);
            }
            Iterator iterator = listenersCopy.iterator();
            while (iterator.hasNext()) {
                KeyboardListener listener = (KeyboardListener)iterator.next();
                this.fireEvent(this.event, listener);
            }
        }

        public Exception getException() {
            return null;
        }

        public boolean isExecuted() {
            return false;
        }

        public boolean isInException() {
            return false;
        }

        public String getName() {
            return "";
        }
    }
}

