/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.POSPrinterControl15;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.OutputCompleteListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceLoader;
import jpos.services.EventCallbacks;
import jpos.services.POSPrinterService12;
import jpos.services.POSPrinterService13;
import jpos.services.POSPrinterService14;
import jpos.services.POSPrinterService15;

public class POSPrinter
implements POSPrinterControl15,
JposConst {
    protected static final String deviceControlDescription = "JavaPOS POSPrinter Device Control";
    protected static final int deviceControlVersion = 1005000;
    protected static final int deviceVersion12 = 1002000;
    protected static final int deviceVersion13 = 1003000;
    protected static final int deviceVersion14 = 1004000;
    protected static final int deviceVersion15 = 1005000;
    protected JposServiceConnection serviceConnection = null;
    protected int serviceVersion;
    protected POSPrinterService12 service12 = null;
    protected POSPrinterService13 service13 = null;
    protected POSPrinterService14 service14 = null;
    protected POSPrinterService15 service15 = null;
    protected Vector directIOListeners = new Vector();
    protected Vector errorListeners = new Vector();
    protected Vector outputCompleteListeners = new Vector();
    protected Vector statusUpdateListeners = new Vector();

    public int getCapCharacterSet() throws JposException {
        try {
            return this.service12.getCapCharacterSet();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapConcurrentJrnRec() throws JposException {
        try {
            return this.service12.getCapConcurrentJrnRec();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapConcurrentJrnSlp() throws JposException {
        try {
            return this.service12.getCapConcurrentJrnSlp();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapConcurrentRecSlp() throws JposException {
        try {
            return this.service12.getCapConcurrentRecSlp();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapCoverSensor() throws JposException {
        try {
            return this.service12.getCapCoverSensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapJrn2Color() throws JposException {
        try {
            return this.service12.getCapJrn2Color();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapJrnBold() throws JposException {
        try {
            return this.service12.getCapJrnBold();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapJrnDhigh() throws JposException {
        try {
            return this.service12.getCapJrnDhigh();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapJrnDwide() throws JposException {
        try {
            return this.service12.getCapJrnDwide();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapJrnDwideDhigh() throws JposException {
        try {
            return this.service12.getCapJrnDwideDhigh();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapJrnEmptySensor() throws JposException {
        try {
            return this.service12.getCapJrnEmptySensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapJrnItalic() throws JposException {
        try {
            return this.service12.getCapJrnItalic();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapJrnNearEndSensor() throws JposException {
        try {
            return this.service12.getCapJrnNearEndSensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapJrnPresent() throws JposException {
        try {
            return this.service12.getCapJrnPresent();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapJrnUnderline() throws JposException {
        try {
            return this.service12.getCapJrnUnderline();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRec2Color() throws JposException {
        try {
            return this.service12.getCapRec2Color();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecBarCode() throws JposException {
        try {
            return this.service12.getCapRecBarCode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecBitmap() throws JposException {
        try {
            return this.service12.getCapRecBitmap();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecBold() throws JposException {
        try {
            return this.service12.getCapRecBold();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecDhigh() throws JposException {
        try {
            return this.service12.getCapRecDhigh();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecDwide() throws JposException {
        try {
            return this.service12.getCapRecDwide();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecDwideDhigh() throws JposException {
        try {
            return this.service12.getCapRecDwideDhigh();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecEmptySensor() throws JposException {
        try {
            return this.service12.getCapRecEmptySensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecItalic() throws JposException {
        try {
            return this.service12.getCapRecItalic();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecLeft90() throws JposException {
        try {
            return this.service12.getCapRecLeft90();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecNearEndSensor() throws JposException {
        try {
            return this.service12.getCapRecNearEndSensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecPapercut() throws JposException {
        try {
            return this.service12.getCapRecPapercut();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecPresent() throws JposException {
        try {
            return this.service12.getCapRecPresent();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecRight90() throws JposException {
        try {
            return this.service12.getCapRecRight90();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecRotate180() throws JposException {
        try {
            return this.service12.getCapRecRotate180();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecStamp() throws JposException {
        try {
            return this.service12.getCapRecStamp();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapRecUnderline() throws JposException {
        try {
            return this.service12.getCapRecUnderline();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlp2Color() throws JposException {
        try {
            return this.service12.getCapSlp2Color();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpBarCode() throws JposException {
        try {
            return this.service12.getCapSlpBarCode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpBitmap() throws JposException {
        try {
            return this.service12.getCapSlpBitmap();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpBold() throws JposException {
        try {
            return this.service12.getCapSlpBold();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpDhigh() throws JposException {
        try {
            return this.service12.getCapSlpDhigh();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpDwide() throws JposException {
        try {
            return this.service12.getCapSlpDwide();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpDwideDhigh() throws JposException {
        try {
            return this.service12.getCapSlpDwideDhigh();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpEmptySensor() throws JposException {
        try {
            return this.service12.getCapSlpEmptySensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpFullslip() throws JposException {
        try {
            return this.service12.getCapSlpFullslip();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpItalic() throws JposException {
        try {
            return this.service12.getCapSlpItalic();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpLeft90() throws JposException {
        try {
            return this.service12.getCapSlpLeft90();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpNearEndSensor() throws JposException {
        try {
            return this.service12.getCapSlpNearEndSensor();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpPresent() throws JposException {
        try {
            return this.service12.getCapSlpPresent();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpRight90() throws JposException {
        try {
            return this.service12.getCapSlpRight90();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpRotate180() throws JposException {
        try {
            return this.service12.getCapSlpRotate180();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapSlpUnderline() throws JposException {
        try {
            return this.service12.getCapSlpUnderline();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCapTransaction() throws JposException {
        try {
            return this.service12.getCapTransaction();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCapPowerReporting() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getCapPowerReporting();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl13 interface");
    }

    public int getCapJrnCartridgeSensor() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getCapJrnCartridgeSensor();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public int getCapJrnColor() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getCapJrnColor();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public int getCapRecCartridgeSensor() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getCapRecCartridgeSensor();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public int getCapRecColor() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getCapRecColor();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public int getCapRecMarkFeed() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getCapRecMarkFeed();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public boolean getCapSlpBothSidesPrint() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getCapSlpBothSidesPrint();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public int getCapSlpCartridgeSensor() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getCapSlpCartridgeSensor();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public int getCapSlpColor() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getCapSlpColor();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public String getCheckHealthText() throws JposException {
        try {
            return this.service12.getCheckHealthText();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getClaimed() throws JposException {
        try {
            return this.service12.getClaimed();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceControlDescription() {
        return deviceControlDescription;
    }

    public int getDeviceControlVersion() {
        return 1005000;
    }

    public boolean getDeviceEnabled() throws JposException {
        try {
            return this.service12.getDeviceEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        try {
            this.service12.setDeviceEnabled(deviceEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        try {
            return this.service12.getDeviceServiceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getDeviceServiceVersion() throws JposException {
        try {
            return this.service12.getDeviceServiceVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getFreezeEvents() throws JposException {
        try {
            return this.service12.getFreezeEvents();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        try {
            this.service12.setFreezeEvents(freezeEvents);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        try {
            return this.service12.getPhysicalDeviceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getPhysicalDeviceName() throws JposException {
        try {
            return this.service12.getPhysicalDeviceName();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getState() {
        try {
            return this.service12.getState();
        }
        catch (Exception e) {
            return 1;
        }
    }

    public boolean getAsyncMode() throws JposException {
        try {
            return this.service12.getAsyncMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setAsyncMode(boolean asyncMode) throws JposException {
        try {
            this.service12.setAsyncMode(asyncMode);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getCharacterSet() throws JposException {
        try {
            return this.service12.getCharacterSet();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setCharacterSet(int characterSet) throws JposException {
        try {
            this.service12.setCharacterSet(characterSet);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getCharacterSetList() throws JposException {
        try {
            return this.service12.getCharacterSetList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getCoverOpen() throws JposException {
        try {
            return this.service12.getCoverOpen();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getErrorLevel() throws JposException {
        try {
            return this.service12.getErrorLevel();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getErrorStation() throws JposException {
        try {
            return this.service12.getErrorStation();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getErrorString() throws JposException {
        try {
            return this.service12.getErrorString();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getFlagWhenIdle() throws JposException {
        try {
            return this.service12.getFlagWhenIdle();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setFlagWhenIdle(boolean flagWhenIdle) throws JposException {
        try {
            this.service12.setFlagWhenIdle(flagWhenIdle);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getFontTypefaceList() throws JposException {
        try {
            return this.service12.getFontTypefaceList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getJrnEmpty() throws JposException {
        try {
            return this.service12.getJrnEmpty();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getJrnLetterQuality() throws JposException {
        try {
            return this.service12.getJrnLetterQuality();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setJrnLetterQuality(boolean jrnLetterQuality) throws JposException {
        try {
            this.service12.setJrnLetterQuality(jrnLetterQuality);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getJrnLineChars() throws JposException {
        try {
            return this.service12.getJrnLineChars();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setJrnLineChars(int jrnLineChars) throws JposException {
        try {
            this.service12.setJrnLineChars(jrnLineChars);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getJrnLineCharsList() throws JposException {
        try {
            return this.service12.getJrnLineCharsList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getJrnLineHeight() throws JposException {
        try {
            return this.service12.getJrnLineHeight();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setJrnLineHeight(int jrnLineHeight) throws JposException {
        try {
            this.service12.setJrnLineHeight(jrnLineHeight);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getJrnLineSpacing() throws JposException {
        try {
            return this.service12.getJrnLineSpacing();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setJrnLineSpacing(int jrnLineSpacing) throws JposException {
        try {
            this.service12.setJrnLineSpacing(jrnLineSpacing);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getJrnLineWidth() throws JposException {
        try {
            return this.service12.getJrnLineWidth();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getJrnNearEnd() throws JposException {
        try {
            return this.service12.getJrnNearEnd();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getMapMode() throws JposException {
        try {
            return this.service12.getMapMode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setMapMode(int mapMode) throws JposException {
        try {
            this.service12.setMapMode(mapMode);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getOutputID() throws JposException {
        try {
            return this.service12.getOutputID();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getRecBarCodeRotationList() throws JposException {
        try {
            return this.service12.getRecBarCodeRotationList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getRecEmpty() throws JposException {
        try {
            return this.service12.getRecEmpty();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getRecLetterQuality() throws JposException {
        try {
            return this.service12.getRecLetterQuality();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setRecLetterQuality(boolean recLetterQuality) throws JposException {
        try {
            this.service12.setRecLetterQuality(recLetterQuality);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getRecLineChars() throws JposException {
        try {
            return this.service12.getRecLineChars();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setRecLineChars(int recLineChars) throws JposException {
        try {
            this.service12.setRecLineChars(recLineChars);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getRecLineCharsList() throws JposException {
        try {
            return this.service12.getRecLineCharsList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getRecLineHeight() throws JposException {
        try {
            return this.service12.getRecLineHeight();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setRecLineHeight(int recLineHeight) throws JposException {
        try {
            this.service12.setRecLineHeight(recLineHeight);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getRecLineSpacing() throws JposException {
        try {
            return this.service12.getRecLineSpacing();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setRecLineSpacing(int recLineSpacing) throws JposException {
        try {
            this.service12.setRecLineSpacing(recLineSpacing);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getRecLinesToPaperCut() throws JposException {
        try {
            return this.service12.getRecLinesToPaperCut();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getRecLineWidth() throws JposException {
        try {
            return this.service12.getRecLineWidth();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getRecNearEnd() throws JposException {
        try {
            return this.service12.getRecNearEnd();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getRecSidewaysMaxChars() throws JposException {
        try {
            return this.service12.getRecSidewaysMaxChars();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getRecSidewaysMaxLines() throws JposException {
        try {
            return this.service12.getRecSidewaysMaxLines();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getRotateSpecial() throws JposException {
        try {
            return this.service12.getRotateSpecial();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setRotateSpecial(int rotateSpecial) throws JposException {
        try {
            this.service12.setRotateSpecial(rotateSpecial);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getSlpBarCodeRotationList() throws JposException {
        try {
            return this.service12.getSlpBarCodeRotationList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getSlpEmpty() throws JposException {
        try {
            return this.service12.getSlpEmpty();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getSlpLetterQuality() throws JposException {
        try {
            return this.service12.getSlpLetterQuality();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setSlpLetterQuality(boolean recLetterQuality) throws JposException {
        try {
            this.service12.setSlpLetterQuality(recLetterQuality);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getSlpLineChars() throws JposException {
        try {
            return this.service12.getSlpLineChars();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setSlpLineChars(int recLineChars) throws JposException {
        try {
            this.service12.setSlpLineChars(recLineChars);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public String getSlpLineCharsList() throws JposException {
        try {
            return this.service12.getSlpLineCharsList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getSlpLineHeight() throws JposException {
        try {
            return this.service12.getSlpLineHeight();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setSlpLineHeight(int recLineHeight) throws JposException {
        try {
            this.service12.setSlpLineHeight(recLineHeight);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getSlpLinesNearEndToEnd() throws JposException {
        try {
            return this.service12.getSlpLinesNearEndToEnd();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getSlpLineSpacing() throws JposException {
        try {
            return this.service12.getSlpLineSpacing();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setSlpLineSpacing(int recLineSpacing) throws JposException {
        try {
            this.service12.setSlpLineSpacing(recLineSpacing);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getSlpLineWidth() throws JposException {
        try {
            return this.service12.getSlpLineWidth();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getSlpMaxLines() throws JposException {
        try {
            return this.service12.getSlpMaxLines();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public boolean getSlpNearEnd() throws JposException {
        try {
            return this.service12.getSlpNearEnd();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getSlpSidewaysMaxChars() throws JposException {
        try {
            return this.service12.getSlpSidewaysMaxChars();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getSlpSidewaysMaxLines() throws JposException {
        try {
            return this.service12.getSlpSidewaysMaxLines();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public int getPowerNotify() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getPowerNotify();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl13 interface");
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                this.service13.setPowerNotify(powerNotify);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the POSPrinterControl13 interface");
        }
    }

    public int getPowerState() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1003000) {
            try {
                return this.service13.getPowerState();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl13 interface");
    }

    public int getCartridgeNotify() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getCartridgeNotify();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public void setCartridgeNotify(int notify) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.setCartridgeNotify(notify);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
        }
    }

    public int getJrnCartridgeState() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getJrnCartridgeState();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public int getJrnCurrentCartridge() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getJrnCurrentCartridge();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public void setJrnCurrentCartridge(int cartridge) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.setJrnCurrentCartridge(cartridge);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
        }
    }

    public int getRecCartridgeState() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getRecCartridgeState();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public int getRecCurrentCartridge() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getRecCurrentCartridge();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public void setRecCurrentCartridge(int cartridge) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.setRecCurrentCartridge(cartridge);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
        }
    }

    public int getSlpCartridgeState() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getSlpCartridgeState();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public int getSlpCurrentCartridge() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getSlpCurrentCartridge();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public void setSlpCurrentCartridge(int cartridge) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.setSlpCurrentCartridge(cartridge);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
        }
    }

    public int getSlpPrintSide() throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                return this.service15.getSlpPrintSide();
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        }
        throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
    }

    public void claim(int timeout) throws JposException {
        try {
            this.service12.claim(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void close() throws JposException {
        try {
            this.service12.close();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Service not open", e);
        }
        try {
            try {
                this.serviceConnection.disconnect();
            }
            catch (Exception e) {
                throw new JposException(104, "Unable to free service connection", e);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.service12 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            throw throwable;
        }
        Object var2_6 = null;
        this.service12 = null;
        this.service13 = null;
        this.service14 = null;
        this.service15 = null;
    }

    public void checkHealth(int level) throws JposException {
        try {
            this.service12.checkHealth(level);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void directIO(int command, int[] data, Object object) throws JposException {
        try {
            this.service12.directIO(command, data, object);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public synchronized void open(String logicalDeviceName) throws JposException {
        if (this.service12 != null) {
            throw new JposException(106, "Device control already open");
        }
        try {
            this.serviceConnection = JposServiceLoader.findService(logicalDeviceName);
            this.serviceConnection.connect();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(104, "Could not connect to service", e);
        }
        try {
            this.service12 = (POSPrinterService12)((Object)this.serviceConnection.getService());
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service instance", e);
        }
        try {
            this.serviceVersion = this.service12.getDeviceServiceVersion();
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service version information", e);
        }
        if (this.serviceVersion >= 1003000) {
            try {
                this.service13 = (POSPrinterService13)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement POSPrinterDevice13 interface", e);
            }
        }
        if (this.serviceVersion >= 1004000) {
            try {
                this.service14 = (POSPrinterService14)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement POSPrinterDevice14 interface", e);
            }
        }
        if (this.serviceVersion >= 1005000) {
            try {
                this.service15 = (POSPrinterService15)this.service12;
            }
            catch (Exception e) {
                throw new JposException(104, "Service does not fully implement POSPrinterDevice15 interface", e);
            }
        }
        POSPrinterCallbacks callbacks = new POSPrinterCallbacks();
        this.service12.open(logicalDeviceName, callbacks);
    }

    public void release() throws JposException {
        try {
            this.service12.release();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void beginInsertion(int timeout) throws JposException {
        try {
            this.service12.beginInsertion(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void beginRemoval(int timeout) throws JposException {
        try {
            this.service12.beginRemoval(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void clearOutput() throws JposException {
        try {
            this.service12.clearOutput();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void cutPaper(int percentage) throws JposException {
        try {
            this.service12.cutPaper(percentage);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void endInsertion() throws JposException {
        try {
            this.service12.endInsertion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void endRemoval() throws JposException {
        try {
            this.service12.endRemoval();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printBarCode(int station, String data, int symbology, int height, int width, int alignment, int textPosition) throws JposException {
        try {
            this.service12.printBarCode(station, data, symbology, height, width, alignment, textPosition);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printBitmap(int station, String fileName, int width, int alignment) throws JposException {
        try {
            this.service12.printBitmap(station, fileName, width, alignment);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printImmediate(int station, String data) throws JposException {
        try {
            this.service12.printImmediate(station, data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printNormal(int station, String data) throws JposException {
        try {
            this.service12.printNormal(station, data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void printTwoNormal(int stations, String data1, String data2) throws JposException {
        try {
            this.service12.printTwoNormal(stations, data1, data2);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void rotatePrint(int station, int rotation) throws JposException {
        try {
            this.service12.rotatePrint(station, rotation);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setBitmap(int bitmapNumber, int station, String fileName, int width, int alignment) throws JposException {
        try {
            this.service12.setBitmap(bitmapNumber, station, fileName, width, alignment);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void setLogo(int location, String data) throws JposException {
        try {
            this.service12.setLogo(location, data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void transactionPrint(int station, int control) throws JposException {
        try {
            this.service12.transactionPrint(station, control);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void validateData(int station, String data) throws JposException {
        try {
            this.service12.validateData(station, data);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(101, "Control not opened", e);
        }
    }

    public void changePrintSide(int side) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.changePrintSide(side);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
        }
    }

    public void markFeed(int type) throws JposException {
        if (this.service12 == null || this.serviceVersion >= 1005000) {
            try {
                this.service15.markFeed(type);
            }
            catch (JposException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JposException(101, "Control not opened", e);
            }
        } else {
            throw new JposException(104, "Service does not support the POSPrinterControl15 interface");
        }
    }

    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    public void addErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(l);
        }
    }

    public void removeErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(l);
        }
    }

    public void addOutputCompleteListener(OutputCompleteListener l) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.addElement(l);
        }
    }

    public void removeOutputCompleteListener(OutputCompleteListener l) {
        Vector vector = this.outputCompleteListeners;
        synchronized (vector) {
            this.outputCompleteListeners.removeElement(l);
        }
    }

    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    protected class POSPrinterCallbacks
    implements EventCallbacks {
        protected POSPrinterCallbacks() {
        }

        public BaseControl getEventSource() {
            return POSPrinter.this;
        }

        public void fireDataEvent(DataEvent e) {
        }

        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = POSPrinter.this.directIOListeners;
            synchronized (vector) {
                int x = 0;
                while (x < POSPrinter.this.directIOListeners.size()) {
                    ((DirectIOListener)POSPrinter.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                    ++x;
                }
            }
        }

        public void fireErrorEvent(ErrorEvent e) {
            Vector vector = POSPrinter.this.errorListeners;
            synchronized (vector) {
                int x = 0;
                while (x < POSPrinter.this.errorListeners.size()) {
                    ((ErrorListener)POSPrinter.this.errorListeners.elementAt(x)).errorOccurred(e);
                    ++x;
                }
            }
        }

        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
            Vector vector = POSPrinter.this.outputCompleteListeners;
            synchronized (vector) {
                int x = 0;
                while (x < POSPrinter.this.outputCompleteListeners.size()) {
                    ((OutputCompleteListener)POSPrinter.this.outputCompleteListeners.elementAt(x)).outputCompleteOccurred(e);
                    ++x;
                }
            }
        }

        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = POSPrinter.this.statusUpdateListeners;
            synchronized (vector) {
                int x = 0;
                while (x < POSPrinter.this.statusUpdateListeners.size()) {
                    ((StatusUpdateListener)POSPrinter.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                    ++x;
                }
            }
        }
    }
}

