/*
 * Decompiled with CFR 0.152.
 */
package jpos.loader.simple;

import jpos.JposException;
import jpos.config.DefaultCompositeRegPopulator;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.config.JposRegPopulator;
import jpos.config.simple.SimpleEntryRegistry;
import jpos.config.simple.SimpleRegPopulator;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceManager;
import jpos.loader.simple.SimpleServiceConnection;
import jpos.profile.DefaultProfileRegistry;
import jpos.profile.Profile;
import jpos.profile.ProfileException;
import jpos.profile.ProfileFactory;
import jpos.profile.ProfileRegistry;
import jpos.profile.XercesProfileFactory;
import jpos.util.DefaultProperties;
import jpos.util.JposProperties;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class SimpleServiceManager
implements JposServiceManager {
    private JposRegPopulator regPopulator = null;
    private SimpleEntryRegistry entryRegistry = null;
    private ProfileRegistry profileRegistry = null;
    private ProfileFactory profileFactory = null;
    private JposProperties jposProperties = new DefaultProperties();
    private Tracer tracer = TracerFactory.getInstance().createTracer("SimpleServiceManager");

    public SimpleServiceManager() {
        this.getProperties().loadJposProperties();
        this.init();
    }

    public SimpleServiceManager(JposProperties jposProperties) {
        this.jposProperties = jposProperties;
        this.init();
    }

    private void init() {
        this.initEntryRegistry();
    }

    private void initEntryRegistry() {
        this.initRegPopulator();
        this.entryRegistry = new SimpleEntryRegistry(this.regPopulator);
    }

    private void initRegPopulator() {
        JposProperties jposProperties = this.getProperties();
        if (jposProperties.isPropertyDefined("jpos.config.regPopulatorClass")) {
            String string = jposProperties.getPropertyString("jpos.config.regPopulatorClass");
            try {
                Class<?> clazz = Class.forName(string);
                this.regPopulator = (JposRegPopulator)clazz.newInstance();
            }
            catch (Exception exception) {
                this.tracer.println("Could not create populator by name: " + string + " Exception.message= " + exception.getMessage());
                this.regPopulator = new SimpleRegPopulator();
            }
        } else {
            this.regPopulator = jposProperties.hasMultiProperty("jpos.config.populator.class") ? new DefaultCompositeRegPopulator() : new SimpleRegPopulator();
        }
    }

    private ProfileFactory getProfileFactory() {
        if (this.profileFactory == null) {
            this.profileFactory = new XercesProfileFactory();
        }
        return this.profileFactory;
    }

    public JposEntryRegistry getEntryRegistry() {
        return this.entryRegistry;
    }

    public JposProperties getProperties() {
        return this.jposProperties;
    }

    public JposRegPopulator getRegPopulator() {
        return this.regPopulator;
    }

    public JposServiceConnection createConnection(String string) throws JposException {
        SimpleServiceConnection simpleServiceConnection = null;
        try {
            JposEntry jposEntry = this.entryRegistry.getJposEntry(string);
            if (jposEntry == null) {
                throw new JposException(104, "Could not find service");
            }
            String string2 = (String)jposEntry.getPropertyValue("serviceInstanceFactoryClass");
            simpleServiceConnection = new SimpleServiceConnection(string, jposEntry, string2);
        }
        catch (JposException jposException) {
            this.tracer.println("createConnection: JposException.msg=" + jposException.getMessage());
            throw jposException;
        }
        catch (Exception exception) {
            this.tracer.println("createConnection: Exception.msg=" + exception.getMessage());
            throw new JposException(104, "Could not find service");
        }
        return simpleServiceConnection;
    }

    public ProfileRegistry getProfileRegistry() {
        if (this.profileRegistry == null) {
            this.profileRegistry = new DefaultProfileRegistry();
        }
        return this.profileRegistry;
    }

    public Profile loadProfile(String string) throws ProfileException {
        Profile profile = this.getProfileFactory().createProfile(string);
        if (profile != null) {
            this.profileRegistry.addProfile(profile);
        }
        return profile;
    }

    public void reloadEntryRegistry() {
        this.getProperties().loadJposProperties();
        this.initEntryRegistry();
        this.getEntryRegistry().load();
        this.tracer.println("Sucessfully reloaded registry");
    }
}

