/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jpos.JposTestCase;
import jpos.test.JUnitUtility;
import jpos.util.DefaultProperties;
import jpos.util.JposProperties;
import junit.framework.Assert;

public class MultiPropertyTestCase
extends JposTestCase {
    private DefaultProperties properties = null;
    private JposProperties.MultiProperty multiProp = null;
    private List propNames = null;
    private List propValues = null;
    public static final String MULTIPROP_BASE_NAME = "multiPropName";
    public static final int MAX_NUMBER = 5;

    public MultiPropertyTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        DefaultProperties defaultProperties = this.properties = new DefaultProperties();
        defaultProperties.getClass();
        this.multiProp = defaultProperties.new DefaultProperties.MultiProp(MULTIPROP_BASE_NAME);
        this.propNames = new ArrayList();
        this.propValues = new ArrayList();
        int n = 0;
        while (n < 5) {
            String string = "multiPropName." + n;
            String string2 = string + ".value";
            this.propNames.add(string);
            this.propValues.add(string2);
            ((DefaultProperties.MultiProp)this.multiProp).add(string, string2);
            ++n;
        }
        try {
            ((DefaultProperties.MultiProp)this.multiProp).add("multiPropName.", "multiPropName.5.value");
            Assert.fail((String)"Expected an IllegalArgumentException here!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((DefaultProperties.MultiProp)this.multiProp).add("multiProp.6", "multiPropName.5.value");
            Assert.fail((String)"Expected an IllegalArgumentException here!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void tearDown() {
        this.properties = null;
        this.multiProp = null;
        this.propNames = null;
        this.propValues = null;
    }

    public void testGetBasePropertyName() {
        String string = this.multiProp.getBasePropertyName();
        Assert.assertTrue((String)"getBasePropertyName() should not return null", (string != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"getBasePropertyName() should return \"multiPropName\"", (boolean)MULTIPROP_BASE_NAME.equals(string));
    }

    public void testGetPropertyNames() {
        Iterator iterator = this.multiProp.getPropertyNames();
        Assert.assertTrue((String)"getPropertyNames() returned an Iterator with values with different values then what was added", (boolean)JUnitUtility.isEquals((Iterator)iterator, this.propNames.iterator()));
    }

    public void testGetSortedPropertyNames() {
        Iterator iterator = this.multiProp.getSortedPropertyNames();
        Collections.sort(this.propNames);
        Assert.assertTrue((String)"getSortedPropertyNames() returned an Iterator with values with different values then what was added", (boolean)JUnitUtility.isIdentical((Iterator)iterator, this.propNames.iterator()));
    }

    public void testGetPropertyValues() {
        Iterator iterator = this.multiProp.getPropertyValues();
        Assert.assertTrue((String)"getPropertyValues() returned an Iterator with values with different values then what was added", (boolean)JUnitUtility.isEquals((Iterator)iterator, this.propValues.iterator()));
    }

    public void testGetPropertyStringByName() {
        String string;
        int n = 0;
        while (n < 5) {
            string = "multiPropName." + n;
            Assert.assertTrue((String)("value of propName = " + string + " should be != null"), (boolean)this.multiProp.getPropertyString(string).equals(this.propValues.get(n)));
            ++n;
        }
        string = "multiPropName.6";
        Assert.assertTrue((String)("value of propName = " + string + " should BE null"), (this.multiProp.getPropertyString(string) == null ? 1 : 0) != 0);
    }

    public void testGetPropertyStringByNumber() {
        String string;
        int n = 0;
        while (n < 5) {
            string = "multiPropName." + n;
            Assert.assertTrue((String)("value of propName = " + string + " should be != null"), (boolean)this.multiProp.getPropertyString(n).equals(this.propValues.get(n)));
            ++n;
        }
        string = "multiPropName.6";
        Assert.assertTrue((String)("value of propName = " + string + " should BE null"), (this.multiProp.getPropertyString(10) == null ? 1 : 0) != 0);
    }
}

