/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import java.io.File;
import java.io.IOException;
import jpos.JposTestCase;
import jpos.util.XmlHelper;
import junit.framework.Assert;

public class XmlHelperTestCase
extends JposTestCase {
    private XmlHelper xmlHelper = null;

    public XmlHelperTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.xmlHelper = new XmlHelper();
    }

    protected void tearDown() {
        this.xmlHelper = null;
    }

    public void testXmlHelperRemoveDirs() {
        String string = "." + File.separator + "mike" + File.separator + "max" + File.separator + "profile";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            this.xmlHelper.removeDirs(string);
        }
        catch (IOException iOException) {
            Assert.fail((String)("XmlHelper.removeDirs( String ) failed with message = " + iOException.getMessage()));
        }
    }

    public void testXmlHelperJclDtd() {
        this.xmlHelper.setDtdFileName("jcl.dtd");
        this.xmlHelper.setDtdFilePath("jpos" + File.separator + "res");
        boolean bl = new File("." + File.separator + this.xmlHelper.getDtdFilePath() + this.xmlHelper.getDtdFileName()).exists();
        this.xmlHelper.checkAndCreateTempDtd();
        File file = new File("." + File.separator + this.xmlHelper.getDtdFilePath() + this.xmlHelper.getDtdFileName());
        Assert.assertTrue((String)"JCL DTD file was not extracted or does not exist...", (boolean)file.exists());
        this.xmlHelper.removeTempDtd();
        if (bl) {
            file = new File("." + File.separator + this.xmlHelper.getDtdFilePath() + this.xmlHelper.getDtdFileName());
            Assert.assertTrue((String)"JCL DTD file should still exists...", (boolean)file.exists());
        } else {
            file = new File("." + File.separator + this.xmlHelper.getDtdFilePath() + this.xmlHelper.getDtdFileName());
            Assert.assertTrue((String)"JCL DTD file should have been deleted...", (!file.exists() ? 1 : 0) != 0);
        }
    }

    public void testXmlHelperJclProfileDtd() {
        this.xmlHelper.setDtdFileName("jcl_profile.dtd");
        this.xmlHelper.setDtdFilePath("jpos" + File.separator + "res");
        boolean bl = new File("." + File.separator + this.xmlHelper.getDtdFilePath() + this.xmlHelper.getDtdFileName()).exists();
        this.xmlHelper.checkAndCreateTempDtd();
        File file = new File("." + File.separator + this.xmlHelper.getDtdFilePath() + this.xmlHelper.getDtdFileName());
        Assert.assertTrue((String)"JCL profile DTD file was not extracted or does not exist...", (boolean)file.exists());
        this.xmlHelper.removeTempDtd();
        if (bl) {
            file = new File("." + File.separator + this.xmlHelper.getDtdFilePath() + this.xmlHelper.getDtdFileName());
            Assert.assertTrue((String)"JCL DTD file should still exists...", (boolean)file.exists());
        } else {
            file = new File("." + File.separator + this.xmlHelper.getDtdFilePath() + this.xmlHelper.getDtdFileName());
            Assert.assertTrue((String)"JCL DTD file should have been deleted...", (!file.exists() ? 1 : 0) != 0);
        }
    }
}

