/*
 * Decompiled with CFR 0.152.
 */
package jpos.util.tracing;

import java.io.PrintStream;
import jpos.util.DefaultProperties;
import jpos.util.tracing.TracerOutput;

public class Tracer {
    private boolean tracerOn = false;
    private String tracerName = "";
    private boolean appendName = true;
    private TracerOutput customTracerOutput = null;
    private TracerOutput onTracerOutput = new DefaultTracerOutput();
    private TracerOutput offTracerOutput = new TracerOutput(){

        public void close() {
        }

        public String getPrefix() {
            return "";
        }

        public void print(Exception exception) {
        }

        public void println(String string) {
        }

        public void print(String string) {
        }

        public void flush() {
        }
    };
    private static Tracer instance = null;

    protected Tracer() {
        this.appendName = false;
    }

    Tracer(String string) {
        if (string == null || string.equals("")) {
            this.appendName = false;
            this.tracerName = "";
            this.onTracerOutput = new DefaultTracerOutput();
        } else {
            this.appendName = true;
            this.onTracerOutput = new DefaultTracerOutput("[" + string + "]");
            this.tracerName = string;
        }
    }

    public static Tracer getInstance() {
        if (instance == null) {
            instance = new Tracer();
            instance.init();
        }
        return instance;
    }

    public void println(String string) {
        this.getTracerOutput().println(string);
    }

    public void println(Object object) {
        this.getTracerOutput().println(object.toString());
    }

    public void print(String string) {
        this.getTracerOutput().print(string);
    }

    public void print(Object object) {
        this.getTracerOutput().print(object.toString());
    }

    public void print(Exception exception) {
        this.getTracerOutput().print(exception);
    }

    public void flush() {
        this.getTracerOutput().flush();
    }

    public void setOn(boolean bl) {
        this.tracerOn = bl;
    }

    public boolean isOn() {
        return this.tracerOn;
    }

    public String getName() {
        return this.tracerName;
    }

    public void setAppendName(boolean bl) {
        this.appendName = bl;
    }

    public boolean isAppendName() {
        return this.appendName;
    }

    private void init() {
        DefaultProperties defaultProperties = new DefaultProperties();
        defaultProperties.loadJposProperties();
        if (!defaultProperties.isPropertyDefined("jpos.util.tracing")) {
            this.setOn(false);
        } else {
            String string = defaultProperties.getPropertyString("jpos.util.tracing");
            if (string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("TRUE")) {
                this.setOn(true);
            }
        }
    }

    private TracerOutput getTracerOutput() {
        if (this.customTracerOutput != null) {
            return this.customTracerOutput;
        }
        return this.isOn() ? this.onTracerOutput : this.offTracerOutput;
    }

    void setTracerOutput(TracerOutput tracerOutput) {
        this.tracerOn = true;
        this.customTracerOutput = tracerOutput;
    }

    class DefaultTracerOutput
    implements TracerOutput {
        protected String prefix = "";
        protected PrintStream printStream = System.err;

        public DefaultTracerOutput() {
            this.prefix = "";
            Tracer.this.appendName = false;
        }

        public DefaultTracerOutput(String string) {
            if (string == null) {
                this.prefix = "";
            } else if (string.equals("")) {
                this.prefix = "";
            } else {
                this.prefix = string;
                Tracer.this.appendName = true;
            }
        }

        public DefaultTracerOutput(String string, PrintStream printStream) {
            this(string);
            this.printStream = printStream;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void close() {
            this.getPrintStream().close();
        }

        public void println(String string) {
            this.getPrintStream().println((Tracer.this.appendName ? this.prefix : "") + string);
        }

        public void print(String string) {
            this.getPrintStream().print((Tracer.this.appendName ? this.prefix : "") + string);
        }

        public void print(Exception exception) {
            if (Tracer.this.appendName) {
                System.err.println("<" + this.prefix + ">");
            }
            exception.printStackTrace(this.getPrintStream());
            if (Tracer.this.appendName) {
                System.err.println("</" + this.prefix + ">");
            }
        }

        public void flush() {
            this.getPrintStream().flush();
        }

        protected PrintStream getPrintStream() {
            return this.printStream;
        }

        protected void setPrintStream(PrintStream printStream) {
            this.printStream = printStream;
        }
    }
}

