/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.renderer;

import com.linx.touchkeyboard.TouchKeyboard;
import com.linx.touchkeyboard.configuration.Key;
import com.linx.touchkeyboard.configuration.KeyType;
import com.linx.touchkeyboard.configuration.KeyboardConfiguration;
import com.linx.touchkeyboard.configuration.Layout;
import com.linx.touchkeyboard.renderer.TouchKeyboardKey;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.OverrunStyle;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TouchKeyboardRenderer
implements Runnable {
    private final JFrame parent;
    private JPanel keyboardPanel;
    private KeyboardConfiguration configuration;
    private JFXPanel fxPanel = new JFXPanel();
    public static final String TOUCH_KEYBOARD_PANEL_NAME = "touch_keyboard_panel";
    private String currentLayoutId;
    private Logger logger = LoggerFactory.getLogger(TouchKeyboard.class);
    private final TouchKeyboard keyboard;

    public TouchKeyboardRenderer(KeyboardConfiguration keyboardConfiguration, JFrame jFrame, TouchKeyboard touchKeyboard) {
        this.configuration = keyboardConfiguration;
        this.parent = jFrame;
        this.keyboard = touchKeyboard;
    }

    public JFrame getParent() {
        return this.parent;
    }

    public JPanel getKeyboardPanel() {
        return this.keyboardPanel;
    }

    public void setKeyboardPanel(JPanel jPanel) {
        this.keyboardPanel = jPanel;
    }

    public KeyboardConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KeyboardConfiguration keyboardConfiguration) {
        this.configuration = keyboardConfiguration;
    }

    public void setLayout(String string) {
        if (string != null) {
            this.currentLayoutId = string;
            Platform.runLater((Runnable)new LayoutRenderer(this.configuration.getLayout(this.currentLayoutId), this.fxPanel));
        }
    }

    @Override
    public void run() {
        this.keyboardPanel = new JPanel();
        this.keyboardPanel.setName(TOUCH_KEYBOARD_PANEL_NAME);
        this.keyboardPanel.setLayout(null);
        this.keyboardPanel.add((Component)this.fxPanel);
        this.fxPanel.setVisible(true);
        this.keyboardPanel.setVisible(false);
        this.parent.add(this.keyboardPanel);
        Platform.setImplicitExit((boolean)false);
    }

    private class LayoutRenderer
    implements Runnable {
        private Layout layout;
        private JFXPanel panel;
        private GridPane[] layoutPages;
        private int currentPageIndex = 0;

        protected LayoutRenderer(Layout layout, JFXPanel jFXPanel) {
            this.layout = layout;
            this.panel = jFXPanel;
        }

        @Override
        public void run() {
            TouchKeyboardRenderer.this.fxPanel.getParent().setSize(this.layout.getWidth(), this.layout.getHeight());
            TouchKeyboardRenderer.this.fxPanel.getParent().setLocation(this.layout.getPosX(), this.layout.getPosY());
            TouchKeyboardRenderer.this.fxPanel.setSize(this.layout.getWidth(), this.layout.getHeight());
            TouchKeyboardRenderer.this.fxPanel.setLocation(0, 0);
            Group group = new Group();
            TouchKeyboardKey[][] touchKeyboardKeyArray = new TouchKeyboardKey[this.layout.getRows()][this.layout.getColumns()];
            RowConstraints rowConstraints = new RowConstraints();
            rowConstraints.setVgrow(Priority.SOMETIMES);
            ColumnConstraints columnConstraints = new ColumnConstraints();
            columnConstraints.setHgrow(Priority.SOMETIMES);
            int n = new BigDecimal(this.layout.getColumns() / this.layout.getVisibleColumns(), new MathContext(2, RoundingMode.UP)).intValue();
            this.layoutPages = new GridPane[n];
            for (int i = 0; i < this.layout.getColumns(); ++i) {
                Key key = null;
                int n2 = new BigDecimal(i / this.layout.getVisibleColumns(), new MathContext(2, RoundingMode.UP)).intValue();
                if (n2 < group.getChildren().size()) {
                    key = (GridPane)group.getChildren().get(n2);
                } else {
                    key = new GridPane();
                    key.setGridLinesVisible(false);
                    key.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
                    key.setPrefSize(this.layout.getWidth(), this.layout.getHeight());
                    key.getRowConstraints().add((Object)rowConstraints);
                    key.getColumnConstraints().add((Object)columnConstraints);
                    group.getChildren().add((Object)key);
                    this.layoutPages[n2] = key;
                }
                for (int j = 0; j < this.layout.getRows(); ++j) {
                    TouchKeyboardKey touchKeyboardKey = new TouchKeyboardKey();
                    GridPane.setMargin((Node)touchKeyboardKey, (Insets)new Insets(3.0, 3.0, 3.0, 3.0));
                    touchKeyboardKey.setPrefSize(this.layout.getWidth() / this.layout.getVisibleColumns(), this.layout.getHeight() / this.layout.getVisibleRows());
                    touchKeyboardKey.setTextAlignment(TextAlignment.CENTER);
                    touchKeyboardKey.setWrapText(true);
                    touchKeyboardKey.setTextOverrun(OverrunStyle.CLIP);
                    touchKeyboardKey.setFocusTraversable(false);
                    key.add((Node)touchKeyboardKey, i, j);
                    touchKeyboardKeyArray[j][i] = touchKeyboardKey;
                }
            }
            block8: for (Key key : this.layout.getKeys()) {
                final TouchKeyboardKey touchKeyboardKey = touchKeyboardKeyArray[key.getRow()][key.getColumn()];
                touchKeyboardKey.setKey(key);
                touchKeyboardKey.setText(key.getLabel());
                touchKeyboardKey.setId(key.getStyleId());
                switch (key.getType()) {
                    case FORWARD: {
                        touchKeyboardKey.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent actionEvent) {
                                LayoutRenderer.this.navigateToPage(touchKeyboardKey.getKey().getType());
                            }
                        });
                        continue block8;
                    }
                    case BACKWARD: {
                        touchKeyboardKey.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent actionEvent) {
                                LayoutRenderer.this.navigateToPage(touchKeyboardKey.getKey().getType());
                            }
                        });
                        continue block8;
                    }
                }
                touchKeyboardKey.addEventHandler(ActionEvent.ACTION, TouchKeyboardRenderer.this.keyboard);
            }
            this.layoutPages[this.currentPageIndex].toFront();
            Scene scene = new Scene((Parent)group, (double)this.layout.getWidth(), (double)this.layout.getHeight(), (Paint)Color.LIGHTGRAY);
            boolean bl = false;
            try {
                if (TouchKeyboardRenderer.this.configuration.getStyleFilePath() != null && !TouchKeyboardRenderer.this.configuration.getStyleFilePath().trim().equalsIgnoreCase("")) {
                    TouchKeyboardRenderer.this.logger.debug("Utilizando CSS parametrizado...");
                    scene.getStylesheets().add((Object)ClassLoader.getSystemResource(TouchKeyboardRenderer.this.configuration.getStyleFilePath()).toExternalForm());
                    bl = true;
                }
            }
            catch (Exception exception) {
                TouchKeyboardRenderer.this.logger.error("Erro carregando arquivo de estilo!");
            }
            if (!bl) {
                TouchKeyboardRenderer.this.logger.debug("Nenhum estilo foi definido, utilizando CSS padr\u00e3o.");
                scene.getStylesheets().add((Object)this.getClass().getClassLoader().getResource("resource/stylesheet.css").toString());
            }
            this.panel.setScene(scene);
        }

        private void navigateToPage(KeyType keyType) {
            switch (keyType) {
                case FORWARD: {
                    if (this.currentPageIndex >= this.layoutPages.length - 1) break;
                    this.layoutPages[++this.currentPageIndex].toFront();
                    break;
                }
                case BACKWARD: {
                    if (this.currentPageIndex <= 0) break;
                    this.layoutPages[--this.currentPageIndex].toFront();
                    break;
                }
            }
        }
    }
}

