/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util;

import com.linx.touchkeyboard.TouchKeyboard;
import com.linx.touchkeyboard.configuration.Key;
import com.linx.touchkeyboard.configuration.KeyboardConfiguration;
import com.linx.touchkeyboard.configuration.Layout;
import com.linx.touchkeyboard.exception.KeyboardConfigException;
import com.linx.touchkeyboard.exception.TouchKeyboardExceptionMessages;
import com.linx.touchkeyboard.util.TouchKeyboardXstreamConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TouchKeyboardXstreamUtil
implements TouchKeyboardExceptionMessages {
    private static Logger logger = LoggerFactory.getLogger(TouchKeyboard.class);

    public static void initizalizeConfiguration(XStream xStream) {
        xStream.alias("keyboardconfiguration", KeyboardConfiguration.class);
        xStream.omitField(KeyboardConfiguration.class, "styleId");
        xStream.alias("layout", Layout.class);
        xStream.alias("key", Key.class);
        xStream.registerConverter((Converter)new TouchKeyboardXstreamConverter());
    }

    public static KeyboardConfiguration loadKeyboardConfiguration(File file) throws KeyboardConfigException {
        try {
            XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            TouchKeyboardXstreamUtil.initizalizeConfiguration(xStream);
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
            return (KeyboardConfiguration)xStream.fromXML((Reader)inputStreamReader);
        }
        catch (IOException iOException) {
            logger.error("Arquivo com layouts do Teclado Touch n\u00e3o encontrado!", (Throwable)iOException);
            throw new KeyboardConfigException("Arquivo com layouts do Teclado Touch n\u00e3o encontrado!", iOException);
        }
        catch (Exception exception) {
            logger.error("Erro durante parse do arquivo de layout do Teclado Touch!", (Throwable)exception);
            throw new KeyboardConfigException("Erro durante parse do arquivo de layout do Teclado Touch!", exception);
        }
    }

    public static void saveKeyboardConfiguration(KeyboardConfiguration keyboardConfiguration, File file) throws KeyboardConfigException {
        try {
            XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            TouchKeyboardXstreamUtil.initizalizeConfiguration(xStream);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
            xStream.toXML((Object)keyboardConfiguration, (Writer)outputStreamWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error("Arquivo n\u00e3o encontrado para grava\u00e7\u00e3o das configura\u00e7\u00f5es!", (Throwable)fileNotFoundException);
            throw new KeyboardConfigException("Arquivo n\u00e3o encontrado para grava\u00e7\u00e3o das configura\u00e7\u00f5es!", fileNotFoundException);
        }
    }
}

