/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util.configuration;

import com.linx.touchkeyboard.configuration.Key;
import com.linx.touchkeyboard.configuration.KeyboardConfiguration;
import com.linx.touchkeyboard.configuration.Layout;
import com.linx.touchkeyboard.exception.KeyboardConfigException;
import com.linx.touchkeyboard.renderer.TouchKeyboardKey;
import com.linx.touchkeyboard.util.TouchKeyboardXstreamUtil;
import com.linx.touchkeyboard.util.configuration.AlertDialog;
import com.linx.touchkeyboard.util.configuration.TouchKeyboardKeyEventHandler;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationToolController
implements Initializable {
    Logger logger = LoggerFactory.getLogger(ConfigurationToolController.class);
    private KeyboardConfiguration configuration;
    private ObservableList<String> layouts = FXCollections.observableArrayList();
    private File savedFile;
    @FXML
    private BorderPane mainBorderPane;
    @FXML
    private TextField tfLayoutId;
    @FXML
    private TextField tfWidth;
    @FXML
    private TextField tfHeight;
    @FXML
    private TextField tfPosX;
    @FXML
    private TextField tfPosY;
    @FXML
    private TextField tfRows;
    @FXML
    private TextField tfColumns;
    @FXML
    private TextField tfVisibleRows;
    @FXML
    private TextField tfVisibleColumns;
    @FXML
    private ListView<String> lvLayouts;
    @FXML
    private MenuItem miAddLayout;
    @FXML
    private MenuItem miRemoveLayout;
    @FXML
    private MenuItem miCopyLayout;
    @FXML
    private HBox hbInputs;

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.lvLayouts.setItems(this.layouts);
    }

    @FXML
    public void handleMiQuitAction(ActionEvent actionEvent) {
        Platform.exit();
    }

    @FXML
    public void handleCmLayoutListShowing(WindowEvent windowEvent) {
        this.miAddLayout.setDisable(this.configuration == null);
        this.miRemoveLayout.setDisable(this.lvLayouts.getSelectionModel().getSelectedIndex() <= -1);
        this.miCopyLayout.setDisable(this.lvLayouts.getSelectionModel().getSelectedIndex() <= -1);
    }

    @FXML
    public void handleMiAddLayoutAction(ActionEvent actionEvent) {
        this.logger.debug("Iniciando tratador de evento para adicionar layout de configura\u00e7\u00e3o.");
        String string = "LAYOUT_" + (this.configuration.getLayouts().size() + 1);
        Layout layout = new Layout();
        layout.setId(string);
        this.configuration.getLayouts().put(string, layout);
        this.layouts.add((Object)string);
        this.hbInputs.setDisable(false);
        this.drawLayout(layout);
        this.logger.debug("Finalizando tratador de evento para adicionar layout de configura\u00e7\u00e3o.");
    }

    @FXML
    public void handleMiRemoveLayoutAction(ActionEvent actionEvent) {
        this.logger.debug("Iniciando tratador de evento para remover layout de configura\u00e7\u00e3o.");
        String string = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        this.lvLayouts.getItems().remove(this.lvLayouts.getSelectionModel().getSelectedIndex());
        this.configuration.getLayouts().remove(string);
        this.clear();
        if (this.layouts.size() == 0) {
            this.hbInputs.setDisable(true);
        }
        this.logger.debug("Finalizando tratador de evento para remover layout de configura\u00e7\u00e3o.");
    }

    @FXML
    public void handleMiCopyLayoutAction(ActionEvent actionEvent) {
        this.logger.debug("Iniciando tratador de evento para copiar layout de configura\u00e7\u00e3o.");
        String string = "COPIA_DE_" + (String)this.lvLayouts.getSelectionModel().getSelectedItem() + "_" + this.configuration.getLayouts().size();
        Layout layout = this.configuration.getLayouts().get(this.lvLayouts.getSelectionModel().getSelectedItem());
        Layout layout2 = new Layout();
        layout2.setId(string);
        layout2.setWidth(layout.getWidth());
        layout2.setHeight(layout.getHeight());
        layout2.setPosX(layout.getPosX());
        layout2.setPosY(layout.getPosY());
        layout2.setColumns(layout.getColumns());
        layout2.setRows(layout.getRows());
        layout2.setVisibleColumns(layout.getVisibleColumns());
        layout2.setVisibleRows(layout.getVisibleRows());
        ArrayList<Key> arrayList = new ArrayList<Key>();
        for (Key key : layout.getKeys()) {
            arrayList.add(key.clone());
        }
        layout2.setKeys(arrayList);
        this.configuration.getLayouts().put(string, layout2);
        this.layouts.add((Object)string);
        this.drawLayout(layout2);
        this.logger.debug("Finalizando tratador de evento para copiar layout de configura\u00e7\u00e3o.");
    }

    @FXML
    public void handleTfLayoutIdKeyReleased(KeyEvent keyEvent) {
        if (this.lvLayouts.getSelectionModel().getSelectedIndex() > -1) {
            String string = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
            int n = this.layouts.indexOf((Object)string);
            this.layouts.set(n, (Object)this.tfLayoutId.getText());
            this.lvLayouts.getSelectionModel().select(n);
            Layout layout = this.configuration.getLayouts().remove(string);
            layout.setId(this.tfLayoutId.getText());
            this.configuration.getLayouts().put(this.tfLayoutId.getText(), layout);
        }
    }

    @FXML
    public void handleTfWidthKeyReleased(KeyEvent keyEvent) {
        String string = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(string);
        if (!this.tfWidth.getText().equals("")) {
            layout.setWidth(Integer.parseInt(this.tfWidth.getText()));
            this.drawLayout(layout);
        }
    }

    @FXML
    public void handleTfHeightKeyReleased(KeyEvent keyEvent) {
        String string = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(string);
        if (!this.tfHeight.getText().equals("")) {
            layout.setHeight(Integer.parseInt(this.tfHeight.getText()));
            this.drawLayout(layout);
        }
    }

    @FXML
    public void handleTfPosXKeyReleased(KeyEvent keyEvent) {
        String string = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(string);
        if (!this.tfPosX.getText().equals("")) {
            layout.setPosX(Integer.parseInt(this.tfPosX.getText()));
        }
    }

    @FXML
    public void handleTfPosYKeyReleased(KeyEvent keyEvent) {
        String string = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(string);
        if (!this.tfPosY.getText().equals("")) {
            layout.setPosY(Integer.parseInt(this.tfPosY.getText()));
        }
    }

    @FXML
    public void handleTfRowsKeyReleased(KeyEvent keyEvent) {
        String string = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(string);
        if (!this.tfRows.getText().equals("")) {
            layout.setRows(Integer.parseInt(this.tfRows.getText()));
            ArrayList<Key> arrayList = new ArrayList<Key>();
            for (Key key : layout.getKeys()) {
                if (key.getRow() <= layout.getRows() - 1) continue;
                arrayList.add(key);
            }
            layout.getKeys().removeAll(arrayList);
            this.drawLayout(layout);
        }
    }

    @FXML
    public void handleTfColumnsKeyReleased(KeyEvent keyEvent) {
        String string = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(string);
        if (!this.tfColumns.getText().equals("")) {
            layout.setColumns(Integer.parseInt(this.tfColumns.getText()));
            ArrayList<Key> arrayList = new ArrayList<Key>();
            for (Key key : layout.getKeys()) {
                if (key.getColumn() <= layout.getColumns() - 1) continue;
                arrayList.add(key);
            }
            layout.getKeys().removeAll(arrayList);
            this.drawLayout(layout);
        }
    }

    @FXML
    public void handleTfVisibleRowsKeyReleased(KeyEvent keyEvent) {
        String string = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(string);
        if (!this.tfVisibleRows.getText().equals("")) {
            layout.setVisibleRows(Integer.parseInt(this.tfVisibleRows.getText()));
        }
    }

    @FXML
    public void handleTfVisibleColumnsKeyReleased(KeyEvent keyEvent) {
        String string = (String)this.lvLayouts.getSelectionModel().getSelectedItem();
        Layout layout = this.configuration.getLayouts().get(string);
        if (!this.tfVisibleColumns.getText().equals("")) {
            layout.setVisibleColumns(Integer.parseInt(this.tfVisibleColumns.getText()));
        }
    }

    private void drawLayout(Layout layout) {
        GridPane gridPane = new GridPane();
        gridPane.setPrefSize((double)layout.getWidth(), (double)layout.getHeight());
        gridPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        gridPane.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (int i = 0; i < layout.getColumns(); ++i) {
            for (int j = 0; j < layout.getRows(); ++j) {
                TouchKeyboardKey touchKeyboardKey = new TouchKeyboardKey();
                Key key = new Key(j, i);
                if (layout.getKeys().contains(key)) {
                    int n = layout.getKeys().indexOf(key);
                    touchKeyboardKey.setKey(layout.getKeys().get(n));
                    touchKeyboardKey.setText(layout.getKeys().get(n).getLabel());
                } else {
                    touchKeyboardKey.setKey(new Key(j, i));
                }
                this.configureKeyboardKey(touchKeyboardKey, layout);
                touchKeyboardKey.addEventHandler(ActionEvent.ACTION, new TouchKeyboardKeyEventHandler(layout, touchKeyboardKey));
                gridPane.add((Node)touchKeyboardKey, i, j);
            }
        }
        this.mainBorderPane.setCenter((Node)gridPane);
    }

    private void configureKeyboardKey(TouchKeyboardKey touchKeyboardKey, Layout layout) {
        GridPane.setMargin((Node)touchKeyboardKey, (Insets)new Insets(3.0, 3.0, 3.0, 3.0));
        touchKeyboardKey.setTextAlignment(TextAlignment.CENTER);
        touchKeyboardKey.setWrapText(true);
        touchKeyboardKey.setTextOverrun(OverrunStyle.CLIP);
        touchKeyboardKey.setFocusTraversable(false);
        touchKeyboardKey.setPrefSize(layout.getWidth() / layout.getColumns(), layout.getHeight() / layout.getRows());
    }

    @FXML
    public void handleLvLayoutsMouseClick(MouseEvent mouseEvent) {
        String string;
        if (this.configuration != null && (string = (String)this.lvLayouts.getSelectionModel().getSelectedItem()) != null && this.configuration.getLayouts().get(string) != null) {
            Layout layout = this.configuration.getLayout(string);
            this.drawLayout(layout);
            this.tfLayoutId.setText(layout.getId());
            this.tfWidth.setText(Integer.toString(layout.getWidth()));
            this.tfHeight.setText(Integer.toString(layout.getHeight()));
            this.tfPosX.setText(Integer.toString(layout.getPosX()));
            this.tfPosY.setText(Integer.toString(layout.getPosY()));
            this.tfRows.setText(Integer.toString(layout.getRows()));
            this.tfColumns.setText(Integer.toString(layout.getColumns()));
            this.tfVisibleRows.setText(Integer.toString(layout.getVisibleRows()));
            this.tfVisibleColumns.setText(Integer.toString(layout.getVisibleColumns()));
        }
    }

    @FXML
    public void handleMiLoadFileAction(ActionEvent actionEvent) {
        FileChooser fileChooser = new FileChooser();
        File file = fileChooser.showOpenDialog(this.mainBorderPane.getScene().getWindow());
        if (file != null && file.exists()) {
            try {
                this.configuration = TouchKeyboardXstreamUtil.loadKeyboardConfiguration(file);
                this.savedFile = file;
            }
            catch (KeyboardConfigException keyboardConfigException) {
                new AlertDialog(this.getPrimaryStage(), keyboardConfigException.getMessage());
                this.logger.error(keyboardConfigException.getMessage(), (Throwable)keyboardConfigException);
            }
        }
        Set<String> set = this.configuration.getLayouts().keySet();
        this.layouts.clear();
        this.layouts.addAll(set);
        this.hbInputs.setDisable(false);
        this.lvLayouts.setDisable(false);
    }

    @FXML
    public void handleMiSaveFileAction(ActionEvent actionEvent) {
        if (this.savedFile != null) {
            try {
                TouchKeyboardXstreamUtil.saveKeyboardConfiguration(this.configuration, this.savedFile);
            }
            catch (KeyboardConfigException keyboardConfigException) {
                new AlertDialog(this.getPrimaryStage(), keyboardConfigException.getMessage());
                this.logger.error(keyboardConfigException.getMessage(), (Throwable)keyboardConfigException);
            }
        } else {
            this.handleMiSaveAsFileAction(actionEvent);
        }
    }

    @FXML
    public void handleMiSaveAsFileAction(ActionEvent actionEvent) {
        FileChooser fileChooser = new FileChooser();
        this.savedFile = fileChooser.showSaveDialog(this.mainBorderPane.getScene().getWindow());
        if (this.savedFile != null) {
            try {
                TouchKeyboardXstreamUtil.saveKeyboardConfiguration(this.configuration, this.savedFile);
            }
            catch (KeyboardConfigException keyboardConfigException) {
                new AlertDialog(this.getPrimaryStage(), keyboardConfigException.getMessage());
                this.logger.error(keyboardConfigException.getMessage(), (Throwable)keyboardConfigException);
            }
        }
    }

    @FXML
    public void handleMiNewFileAction(ActionEvent actionEvent) {
        this.configuration = new KeyboardConfiguration();
        this.layouts = FXCollections.observableArrayList();
        this.lvLayouts.setItems(this.layouts);
        this.clear();
        this.tfLayoutId.requestFocus();
        this.lvLayouts.setDisable(false);
    }

    private void clear() {
        this.tfLayoutId.setText("");
        this.tfWidth.setText("");
        this.tfHeight.setText("");
        this.tfPosX.setText("");
        this.tfPosY.setText("");
        this.tfRows.setText("");
        this.tfColumns.setText("");
        this.tfVisibleRows.setText("");
        this.tfVisibleColumns.setText("");
        this.mainBorderPane.setCenter(null);
    }

    private Stage getPrimaryStage() {
        return (Stage)this.mainBorderPane.getScene().getWindow();
    }

    @FXML
    public void help() {
        String string = "";
        string = string + "Menu 'Arquivo'\n\n";
        string = string + "Nova Configura\u00e7\u00e3o: Habilita ferramenta para cria\u00e7\u00e3o de novos Layouts de Teclado.\n";
        string = string + "Abrir: Carrega uma configura\u00e7\u00e3o existente, exibindo os respectivos layouts na \u00e1rea de listagem.\n";
        string = string + "Salvar: Salva as modifica\u00e7\u00f5es realizadas na configura\u00e7\u00e3o de layouts carregada pela ferramenta. \n";
        string = string + "Salvar Como: Cria nova configura\u00e7\u00e3o a partir das modifica\u00e7\u00f5es realizadas na configura\u00e7\u00e3o de layouts carregada pela ferramenta.\n\n";
        string = string + "Passos para Criar Layout\n\n";
        string = string + "Passo 1. Ap\u00f3s iniciar 'Nova Configura\u00e7\u00e3o', clicar com bot\u00e3o direito do mouse na \u00e1rea de listagem da tela e selecionar op\u00e7\u00e3o 'Novo Layout'\n";
        string = string + "Passo 2. Infomar as configura\u00e7\u00f5es do teclado na parte superior da tela (Largura, altura, posicionamento, etc).\n\n";
        string = string + "Passos para Editar Layout\n\n";
        string = string + "Passo 1. Ap\u00f3s 'Abrir' configura\u00e7\u00e3o, selecionar layout na listagem exibida na parte lateral esquerda da tela.\n";
        string = string + "Passo 2. Alterar configura\u00e7\u00f5es do teclado na parte superior da tela (Largura, altura, posicionamento, etc).\n\n";
        string = string + "Observa\u00e7\u00e3o. Para criar um layout baseado em outro como modelo,  basta selecion\u00e1-lo na \u00e1rea de listagem, clicar com o bot\u00e3o direito \n";
        string = string + "do mouse e selecionar a op\u00e7\u00e3o 'Copiar Layout'.\n\n";
        string = string + "Passos para Editar Teclas\n\n";
        string = string + "Passo 1. Ap\u00f3s a cria\u00e7\u00e3o ou escolha do layout desejado, um teclado ser\u00e1 exibido pela ferramenta.\n";
        string = string + "Passo 2. Clicar na tecla desejada e alterar propriedades na tela popup exibida.\n\n";
        string = string + "Detalhamento dos campos da 'Tela de Edi\u00e7\u00e3o de Teclas':\n";
        string = string + "\t- R\u00f3tulo: Define o Label da tela a ser exibido no Teclado Touch. Ex.: VENDA, CANCELAMENTO.\n";
        string = string + "\t- C\u00f3digo ASC: Define o c\u00f3digo ASC que o Teclado Touch deve enviar \u00e0s aplica\u00e7\u00f5es. Ex.: Tecla VENDA vai repassa valor 10.\n";
        string = string + "\t- Caracter: Define a tecla que o Teclado Touch deve enviar \u00e0s aplica\u00e7\u00f5es. Ex.: Teclado Num\u00e9rico deve enviar os n\u00fameros.\n";
        string = string + "\t- ID Estilo (CSS): Identificador do estilo definido em arquivo CSS para alterar apresenta\u00e7\u00e3o da tecla.\n";
        string = string + "\t- Tipo: Define comportamento da tecla no Teclado Touch, conforme detalhamento abaixo:\n";
        string = string + "\t        CHAR - Repassam o caracter configurado para aplica\u00e7\u00e3o. Ex.: Teclas Num\u00e9ricas.\n";
        string = string + "\t        FUNCTION - Repassam um valor l\u00f3gico para a aplica\u00e7\u00e3o executar uma a\u00e7\u00e3o. Ex.: Executar um fluxo de opera\u00e7\u00f5es.\n";
        string = string + "\t        BACKWARD - Tecla de navega\u00e7\u00e3o da ferramenta utilizada para retroceder a pagina\u00e7\u00e3o do teclado touch.\n";
        string = string + "\t        FORWARD - Tecla de navega\u00e7\u00e3o da ferramenta utilizada para avan\u00e7ar a pagina\u00e7\u00e3o do teclado touch.\n";
        new AlertDialog(this.getPrimaryStage(), string).showAndWait();
    }
}

