/*
 * Decompiled with CFR 0.152.
 */
package com.csi.util.config;

import com.csi.util.config.ConfigConstants;
import com.csi.util.config.MultipleNamesFoundException;
import com.csi.util.config.NoSuchParameterException;
import com.csi.util.config.Parameter;
import com.csi.util.config.ParameterFilter;
import com.csi.util.config.ParameterSetFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.filter.Filter;

public class ParameterSet
implements ConfigConstants {
    protected Element jdomElement;

    public ParameterSet(String name) {
        this.jdomElement = new Element("ParameterSet");
        this.jdomElement.setAttribute("name", name);
    }

    protected ParameterSet(Element jdomElement) {
        this.jdomElement = jdomElement;
    }

    public synchronized Parameter getParameter(String name) throws MultipleNamesFoundException, NoSuchParameterException {
        List childParams = this.jdomElement.getContent((Filter)new ParameterFilter(name));
        if (childParams.size() > 1) {
            throw new MultipleNamesFoundException(name, this.getIdentity());
        }
        if (childParams.size() == 0) {
            throw new NoSuchParameterException(name, this.getIdentity());
        }
        return new Parameter((Element)childParams.get(0));
    }

    public synchronized List getParameters(String name) throws NoSuchParameterException {
        List childParams = this.jdomElement.getContent((Filter)new ParameterFilter(name));
        if (childParams.size() == 0 && name != null) {
            throw new NoSuchParameterException(name, this.getIdentity());
        }
        LinkedList<Parameter> returnList = new LinkedList<Parameter>();
        Iterator iterator = childParams.iterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            returnList.add(new Parameter(e));
        }
        return returnList;
    }

    public synchronized ParameterSet getParameterSet(String name) throws MultipleNamesFoundException, NoSuchParameterException {
        List childParamSets = this.jdomElement.getContent((Filter)new ParameterSetFilter(name));
        if (childParamSets.size() > 1) {
            throw new MultipleNamesFoundException(name, this.getIdentity());
        }
        if (childParamSets.size() == 0) {
            throw new NoSuchParameterException(name, this.getIdentity());
        }
        return new ParameterSet((Element)childParamSets.get(0));
    }

    public synchronized List getParameterSets(String name) throws NoSuchParameterException {
        List childParamSets = this.jdomElement.getContent((Filter)new ParameterSetFilter(name));
        if (childParamSets.size() == 0 && name != null) {
            throw new NoSuchParameterException(name, this.getIdentity());
        }
        LinkedList<ParameterSet> returnList = new LinkedList<ParameterSet>();
        Iterator iterator = childParamSets.iterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            returnList.add(new ParameterSet(e));
        }
        return returnList;
    }

    public List getAllParameters() {
        LinkedList returnList;
        try {
            returnList = this.getParameters(null);
        }
        catch (NoSuchParameterException e) {
            returnList = new LinkedList();
        }
        return returnList;
    }

    public List getAllParameterSets() {
        LinkedList returnList;
        try {
            returnList = this.getParameterSets(null);
        }
        catch (NoSuchParameterException e) {
            returnList = new LinkedList();
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachParameter(Parameter newParameter) {
        Element element = this.jdomElement;
        synchronized (element) {
            newParameter.attach(this.jdomElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachParameterSet(ParameterSet newParameterSet) {
        Element element = this.jdomElement;
        synchronized (element) {
            newParameterSet.attach(this.jdomElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterSet detach() {
        Element element = this.jdomElement;
        synchronized (element) {
            this.jdomElement.detach();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attach(Element newParent) {
        Element element = this.jdomElement;
        synchronized (element) {
            try {
                newParent.addContent((Content)this.jdomElement);
            }
            catch (IllegalAddException e1) {
                try {
                    this.jdomElement.detach();
                    newParent.addContent((Content)this.jdomElement);
                }
                catch (IllegalAddException e2) {
                    throw new UnsupportedOperationException("Could not detach() jdom element: " + e2.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        String returnString;
        Element element = this.jdomElement;
        synchronized (element) {
            returnString = this.jdomElement.getAttributeValue("name");
        }
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String newName) {
        Element element = this.jdomElement;
        synchronized (element) {
            this.jdomElement.setAttribute("name", newName);
        }
    }

    public Object clone() {
        Element newElement = (Element)this.jdomElement.clone();
        ParameterSet newParameterSet = new ParameterSet(newElement);
        return newParameterSet;
    }

    protected String getIdentity() {
        return this.jdomElement.getAttributeValue("name");
    }
}

