/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.config;

import com.ibm.jpos.config.ConfigParser;
import com.ibm.jpos.config.NullOutputStream;
import com.ibm.jpos.config.ParseException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ConfigC {
    public static void main(String[] stringArray) {
        ConfigParser configParser = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        OutputStream outputStream = new NullOutputStream();
        try {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-?") || stringArray[n].toLowerCase().equals("-help")) {
                    ConfigC.printUsage();
                } else if (stringArray[n].toLowerCase().equals("-v")) {
                    outputStream = System.err;
                } else if (fileInputStream == null) {
                    fileInputStream = new FileInputStream(stringArray[n]);
                } else if (fileOutputStream == null) {
                    fileOutputStream = new FileOutputStream(stringArray[n]);
                }
                ++n;
            }
            if (fileInputStream == null) {
                ConfigC.printUsage();
            }
            if (fileOutputStream == null) {
                fileOutputStream = new FileOutputStream("jpos.cfg");
            }
            configParser = new ConfigParser(fileInputStream, fileOutputStream, outputStream);
            configParser.start();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("\n**** File Not Found: " + fileNotFoundException.getMessage() + "\n");
            ConfigC.printUsage();
        }
        catch (IOException iOException) {
            System.err.println("\n**** I/O Error: " + iOException.getMessage() + "\n");
            System.exit(0);
        }
        catch (ParseException parseException) {
            System.err.println("\n**** Parse Error: " + parseException.getMessage() + "\n");
        }
    }

    private static void printUsage() {
        System.err.print("\nusage:\n  java com.ibm.jpos.config.ConfigC ");
        System.err.println("[-?] [-help] [-v] inputFile [outputFile]");
        System.err.println("\nwhere:");
        System.err.println("  -?          displays this help");
        System.err.println("  -help       displays this help");
        System.err.println("  -v          sets verbose mode");
        System.err.println("  inputFile   specifies the source JEML configuration file");
        System.err.println("  outputFile  specifies the compiled output file (default: \"jpos.cfg\")\n");
        System.exit(0);
    }
}

