/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.DeviceServiceImp;
import com.ibm.jpos.services.DeviceServiceImpMsg;
import com.ibm.jpos.services.DeviceServiceMsg;
import com.ibm.jpos.util.JposEntryInfo;
import com.ibm.jpos.util.Tracer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.loader.JposServiceInstance;
import jpos.loader.JposServiceInstanceFactory;

public final class IBMJposServiceInstanceFactory
implements JposServiceInstanceFactory {
    public JposServiceInstance createInstance(String string, JposEntry jposEntry) throws JposException {
        JposEntryInfo jposEntryInfo = new JposEntryInfo(string, jposEntry);
        JposServiceInstance jposServiceInstance = null;
        try {
            String string2 = jposEntryInfo.getImpClassName();
            if (string2 == null) {
                throw new JposException(104, DeviceServiceMsg.BC_IMPCLASS_ENTRY_NOT_FOUND_MSG);
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_FOUND_MSG, (Exception)classNotFoundException);
            }
            Method method = null;
            try {
                method = this.lookForStaticMethod("createImp", clazz);
            }
            catch (Exception exception) {
                throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_FOUND_MSG, exception);
            }
            if (method == null) {
                throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_COMPLIANT_MSG);
            }
            try {
                if (!this.isValidCreateImpMethod(method)) {
                    throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_COMPLIANT_MSG);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_COMPLIANT_MSG, (Exception)classNotFoundException);
            }
            String string3 = jposEntryInfo.getAbstractionClassName();
            if (string3 == null) {
                throw new JposException(104, DeviceServiceMsg.BC_ABSTRACTIONCLASS_ENTRY_NOT_FOUND_MSG);
            }
            Class<?> clazz2 = null;
            try {
                clazz2 = Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JposException(104, DeviceServiceMsg.ABSTRACTIONCLASS_NOT_FOUND_MSG, (Exception)classNotFoundException);
            }
            DeviceService deviceService = null;
            try {
                deviceService = (DeviceService)clazz2.newInstance();
            }
            catch (Exception exception) {
                throw new JposException(104, DeviceServiceMsg.ABSTRACTIONCLASS_INSTANTIATION_ERROR_MSG, exception);
            }
            deviceService.getDeviceServiceState().setJposEntryInfo(jposEntryInfo);
            DeviceServiceImp deviceServiceImp = null;
            Object[] objectArray = new Object[]{deviceService};
            try {
                deviceServiceImp = (DeviceServiceImp)method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                throw new JposException(104, DeviceServiceMsg.IMPCLASS_CREATEIMP_METHOD_ERROR_MSG, exception);
            }
            deviceService.setDeviceServiceImp(deviceServiceImp);
            jposServiceInstance = (JposServiceInstance)deviceService;
        }
        catch (ClassCastException classCastException) {
            throw new JposException(104, classCastException.getMessage(), (Exception)classCastException);
        }
        this.initTraceInfo(string, jposEntry);
        return jposServiceInstance;
    }

    private void initTraceInfo(String string, JposEntry jposEntry) {
        if (jposEntry != null) {
            String string2 = "";
            Enumeration enumeration = null;
            enumeration = jposEntry.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                Object object;
                string2 = (String)enumeration.nextElement();
                if (string2.equalsIgnoreCase("TraceLevel")) {
                    object = jposEntry.getPropertyValue(string2).toString();
                    int n = Integer.decode((String)object);
                    Tracer.setTracerLevel((int)n);
                }
                if (string2.equalsIgnoreCase("TraceFileName")) {
                    object = jposEntry.getPropertyValue(string2).toString();
                    Tracer.setTracerFilename((String)object);
                }
                if (!string2.equalsIgnoreCase("TraceClassName")) continue;
                object = new StringTokenizer(jposEntry.getPropertyValue(string2).toString(), " ,\n\r");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    Tracer.addTracerClassname((String)((StringTokenizer)object).nextToken());
                }
            }
        }
    }

    private boolean isValidCreateImpMethod(Method method) throws ClassNotFoundException {
        Class<?> clazz = Class.forName("com.ibm.jpos.services.ServiceInstanceImp");
        Class<?> clazz2 = Class.forName("com.ibm.jpos.services.DeviceServiceAbstraction");
        if (!Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (!clazz.equals(method.getReturnType())) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            return false;
        }
        return clazz2.equals(classArray[0]);
    }

    private Method lookForMethod(String string, Class clazz) throws SecurityException {
        Method method = null;
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals(string)) {
                method = methodArray[n];
                break;
            }
            ++n;
        }
        return method;
    }

    private Method lookForStaticMethod(String string, Class clazz) throws SecurityException {
        Method method = null;
        Method[] methodArray = clazz.getMethods();
        Vector<Method> vector = new Vector<Method>();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals(string) && Modifier.isStatic(methodArray[n].getModifiers())) {
                if (methodArray[n].getDeclaringClass().equals(clazz)) {
                    method = methodArray[n];
                    break;
                }
                vector.addElement(methodArray[n]);
            }
            ++n;
        }
        if (method == null) {
            Vector vector2 = new Vector();
            Class clazz2 = clazz.getSuperclass();
            while (clazz2 != null) {
                vector2.addElement(clazz2);
                clazz2 = clazz2.getSuperclass();
            }
            int n2 = 0;
            while (n2 < vector2.size() && method == null) {
                int n3 = 0;
                while (n3 < vector.size()) {
                    if (((Method)vector.elementAt(n3)).getDeclaringClass().equals((Class)vector2.elementAt(n2))) {
                        method = (Method)vector.elementAt(n3);
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return method;
    }
}

