/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.ibmprinter;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.EventQueueManager;
import com.ibm.jpos.services.ibmprinter.MicrPrinterState;
import com.ibm.jpos.services.ibmprinter.PrintData;
import com.ibm.jpos.services.ibmprinter.PrintDataVector;
import com.ibm.jpos.services.ibmprinter.PrinterOutput;
import com.ibm.jpos.util.Semaphore;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosDef;
import com.ibm.poss.Printer;
import jpos.JposConst;
import jpos.JposException;
import jpos.POSPrinterConst;

public class PrinterCommunicationsManager
implements PosDef,
Printer,
POSPrinterConst,
JposConst {
    MicrPrinterState serviceState = null;
    DeviceServiceAbstraction serviceAbstraction = null;
    EventQueueManager serviceEventQueueManager = null;
    PrintDataVector printerCRData;
    PrintDataVector printerSJData;
    PrintDataVector printerDIData;
    private String className = "PrinterCommunicationsManager";

    public PrinterCommunicationsManager(DeviceServiceAbstraction deviceServiceAbstraction, PrinterOutput printerOutput) throws JposException {
        Tracer.trace((int)4, (String)this.className, (String)"Constructor()", (String)"Entry");
        this.serviceAbstraction = deviceServiceAbstraction;
        this.serviceState = (MicrPrinterState)((Object)deviceServiceAbstraction.getDeviceServiceState());
        this.printerCRData = new PrintDataVector(2, this.serviceAbstraction, printerOutput);
        this.printerSJData = new PrintDataVector(1, this.serviceAbstraction, printerOutput);
        this.printerDIData = new PrintDataVector(4, this.serviceAbstraction, printerOutput);
        if (this.serviceState.getCapRecPresent()) {
            this.printerCRData.start();
        }
        if (this.serviceState.getCapJrnPresent()) {
            this.printerSJData.start();
        }
        if (this.serviceState.getCapSlpPresent()) {
            this.printerDIData.start();
        }
        Tracer.trace((int)4, (String)this.className, (String)"Constructor()", (String)"Exit");
    }

    public PrintDataVector getPrinterVector(int n) {
        switch (n) {
            case 2: {
                return this.printerCRData;
            }
            case 4: {
                return this.printerDIData;
            }
            case 1: {
                return this.printerSJData;
            }
        }
        return this.printerCRData;
    }

    public void clearOutput() {
        Tracer.trace((int)4, (String)this.className, (String)"clearOutput()", (String)"Entry");
        this.printerCRData.removeAllElements();
        this.printerSJData.removeAllElements();
        this.printerDIData.removeAllElements();
        if (this.printerCRData.getTransactionMode()) {
            this.printerCRData.setTransactionMode(false);
        }
        if (this.printerDIData.getTransactionMode()) {
            this.printerDIData.setTransactionMode(false);
        }
        if (this.printerSJData.getTransactionMode()) {
            this.printerSJData.setTransactionMode(false);
        }
        if (this.printerCRData.getRotateSidewaysMode()) {
            this.printerCRData.setRotateSidewaysMode(false);
        }
        if (this.printerDIData.getRotateSidewaysMode()) {
            this.printerDIData.setRotateSidewaysMode(false);
        }
        if (this.printerSJData.getRotateSidewaysMode()) {
            this.printerSJData.setRotateSidewaysMode(false);
        }
        Tracer.trace((int)4, (String)this.className, (String)"clearOutput()", (String)"Exit");
    }

    public void setTransactionMode(int n, boolean bl) throws JposException {
        Tracer.trace((int)4, (String)this.className, (String)("setTransactionMode(" + n + ", " + bl + ")"), (String)"Entry");
        switch (n) {
            case 2: {
                this.printerCRData.setTransactionMode(bl);
                if (bl) break;
                this.waitForSuccessfulPrint(n, this.printerCRData.transactionComplete, 60000);
                break;
            }
            case 4: {
                this.printerDIData.setTransactionMode(bl);
                if (bl) break;
                this.waitForSuccessfulPrint(n, this.printerDIData.transactionComplete, 60000);
                break;
            }
            case 1: {
                this.printerSJData.setTransactionMode(bl);
                if (bl) break;
                this.waitForSuccessfulPrint(n, this.printerSJData.transactionComplete, 60000);
            }
        }
        Tracer.trace((int)4, (String)this.className, (String)"setTransactionMode()", (String)"Exit");
    }

    public boolean getTransactionMode(int n) {
        switch (n) {
            case 2: {
                return this.printerCRData.getTransactionMode();
            }
            case 4: {
                return this.printerDIData.getTransactionMode();
            }
            case 1: {
                return this.printerSJData.getTransactionMode();
            }
        }
        return false;
    }

    public void setRotateSidewaysMode(int n, boolean bl) throws JposException {
        switch (n) {
            case 2: {
                this.printerCRData.setRotateSidewaysMode(bl);
                if (bl) break;
                this.waitForSuccessfulPrint(n, this.printerCRData.rotateSidewaysComplete, 60000);
                break;
            }
            case 4: {
                this.printerDIData.setRotateSidewaysMode(bl);
                if (bl) break;
                this.waitForSuccessfulPrint(n, this.printerDIData.rotateSidewaysComplete, 60000);
                break;
            }
            case 1: {
                this.printerSJData.setRotateSidewaysMode(bl);
                if (bl) break;
                this.waitForSuccessfulPrint(n, this.printerSJData.rotateSidewaysComplete, 60000);
            }
        }
    }

    public void waitForSuccessfulPrint(int n, Semaphore semaphore, int n2) throws JposException {
        int n3 = Math.min(2000, n2 / 10);
        int n4 = 0;
        while (!this.serviceState.getAsyncMode() && n4 < n2 && semaphore.isOff()) {
            semaphore.waitForSet(n3);
            if (semaphore.isOff() && this.serviceState.getCoverOpen() && !this.serviceState.getAsyncMode()) {
                throw new JposException(114, 201);
            }
            n4 += n3;
        }
    }

    public boolean getRotateSidewaysMode(int n) {
        switch (n) {
            case 2: {
                return this.printerCRData.getRotateSidewaysMode();
            }
            case 4: {
                return this.printerDIData.getRotateSidewaysMode();
            }
            case 1: {
                return this.printerSJData.getRotateSidewaysMode();
            }
        }
        return false;
    }

    void addData(int n, PrintData printData) throws JposException {
        Tracer.trace((int)4, (String)this.className, (String)("addData(" + n + ")"), (String)"Entry");
        switch (n) {
            case 2: {
                this.printerCRData.add(printData);
                break;
            }
            case 4: {
                this.printerDIData.add(printData);
                break;
            }
            case 1: {
                this.printerSJData.add(printData);
            }
        }
        Tracer.trace((int)4, (String)this.className, (String)"addData()", (String)"Exit");
    }

    public void addData(PrintData printData) throws JposException {
        Tracer.trace((int)4, (String)this.className, (String)"addData()", (String)"Entry");
        PrintData printData2 = new PrintData(printData.station, printData.outputID, printData.printAlignment, printData.printAlignment2, printData.printMode, printData.diWidth, printData.rotate, printData.crLineFeed, printData.diLineFeed, printData.sjLineFeed, 2, printData.data1, printData.data2, printData.bitmap, true, printData.asyncMode, printData.lineChars1, printData.lineChars2, printData.chaseWait);
        switch (printData.station) {
            case 1: {
                this.printerSJData.add(printData);
                break;
            }
            case 2: {
                this.printerCRData.add(printData);
                break;
            }
            case 4: {
                this.printerDIData.add(printData);
                break;
            }
            case 3: {
                this.printerSJData.add(printData);
                this.printerCRData.add(printData2);
                break;
            }
            case 5: {
                this.printerSJData.add(printData);
                this.printerDIData.add(printData2);
                break;
            }
            case 6: {
                this.printerCRData.add(printData);
                this.printerDIData.add(printData2);
            }
        }
        Tracer.trace((int)4, (String)this.className, (String)"addData()", (String)"Exit");
    }

    public boolean outputPending(int n) {
        switch (n) {
            case 2: {
                if (this.printerCRData.isEmpty()) break;
                return true;
            }
            case 1: {
                if (this.printerSJData.isEmpty()) break;
                return true;
            }
            case 4: {
                if (this.printerDIData.isEmpty()) break;
                return true;
            }
        }
        return false;
    }
}

