/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.util.Tracer;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class POSKeyboardMap {
    private static final boolean debug = false;
    private static final String className = "POSKeyboardMap";
    private String inString;
    private int lineNumber = 0;
    private int[][] kbdMap = new int[0][0];
    private int kbdMapLength = 0;
    private int[][] vMap = new int[0][0];
    private int vMapLength = 0;
    private int[] s1Array = new int[0];
    private int[] s2Array = new int[0];
    private static Vector scancodeSeqVector = new Vector();
    private static Vector virScancodeVector = new Vector();
    private static final int FOUND = 1;
    private static final int IN_PROGRESS = 2;
    private static final int NOT_FOUND = 3;
    public static final int LESS = -1;
    public static final int EQUAL = 0;
    public static final int GREATER = 1;
    static final String START_VIRTUAL_SC_TOKEN = "[";
    static final String END_VIRTUAL_SC_TOKEN = "]";
    static final int END_SENTINAL = -1;
    private static int pHead = 0;
    private static int pTail = 0;
    private static int index = 0;
    private static int kbdMapMaxWidth = 0;
    private static int[][] inputBuf = new int[0][0];
    private static int[] virtualKey = new int[0];
    private static int flag = 3;

    protected POSKeyboardMap(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((this.inString = bufferedReader.readLine()) != null) {
                ++this.lineNumber;
                if (this.inString.trim() == null || this.inString.startsWith("#")) continue;
                this.processInputLine(this.inString);
            }
            fileReader.close();
            this.showVector(virScancodeVector, "content of virScancodeVector:");
            this.showVector(scancodeSeqVector, "content of scancodeSeqVector:");
            makeArrayFromVector makeArrayFromVector2 = new makeArrayFromVector(virScancodeVector);
            this.vMap = makeArrayFromVector2.getArray();
            this.vMapLength = makeArrayFromVector2.getArrayLenght();
            makeArrayFromVector makeArrayFromVector3 = new makeArrayFromVector(scancodeSeqVector);
            this.kbdMap = makeArrayFromVector3.getArray();
            this.kbdMapLength = makeArrayFromVector3.getArrayLenght();
            pHead = 0;
            pTail = this.kbdMapLength;
            index = 0;
            kbdMapMaxWidth = makeArrayFromVector3.getArrayMaxWidth();
            inputBuf = new int[kbdMapMaxWidth][2];
            this.showArray(this.kbdMap, this.kbdMapLength, "scancodeSequenceArray");
            this.showArray(this.vMap, this.vMapLength, "virtualScancodeArray");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.kbdMapLength = 0;
            Tracer.trace((int)4, (String)className, (String)"file not found!", (String)" ");
        }
        catch (IOException iOException) {
            this.kbdMapLength = 0;
        }
    }

    public void processInputLine(String string) {
        int n;
        if (string.length() < 3) {
            return;
        }
        String string2 = "";
        String string3 = "";
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '\t') {
                cArray[n2] = 32;
            }
            ++n2;
        }
        string = new String(cArray);
        if (string.startsWith(START_VIRTUAL_SC_TOKEN) && (n = string.indexOf(END_VIRTUAL_SC_TOKEN)) != -1) {
            string2 = string.substring(1, n).trim();
            string3 = string.substring(n + 1).trim();
        } else {
            n = string.indexOf(" ");
            if (n != -1) {
                string2 = string.substring(0, n).trim();
                string3 = string.substring(n + 1).trim();
            }
        }
        int[] nArray = this.processString(string2);
        int[] nArray2 = this.processString(string3);
        if (nArray.length != 0 && nArray2.length != 0 && this.validateArrayValue(nArray, Integer.MAX_VALUE)) {
            this.insertElement(nArray, nArray2);
        }
    }

    private int[] processString(String string) {
        int[] nArray = new int[]{};
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) break;
            int n = this.decodeString(string2);
            if (-1 != n) {
                int[] nArray2 = new int[nArray.length + 1];
                int n2 = 0;
                while (n2 < nArray.length) {
                    nArray2[n2] = nArray[n2];
                    ++n2;
                }
                nArray2[nArray.length] = n;
                nArray = nArray2;
                continue;
            }
            return new int[0];
        }
        return nArray;
    }

    private boolean validateArrayValue(int[] nArray, int n) {
        int n2 = 1;
        while (n2 < nArray.length) {
            if (nArray[n2] > n) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private int decodeString(String string) {
        int n = 0;
        try {
            switch (string.length()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return this.convertToScancode(string.charAt(0));
                }
                case 2: {
                    if (string.charAt(0) != '^') break;
                    char c = string.charAt(1);
                    if (Character.isLetter(c)) {
                        c = Character.toUpperCase(c);
                    }
                    if ((n = c - 64) >= 0 && n <= 31) break;
                    return -1;
                }
            }
            if (string.charAt(0) == '+') {
                string = string.substring(1, string.length());
            }
            n = Short.decode(string).shortValue();
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    protected abstract int convertToScancode(char var1);

    private void insertElement(int[] nArray, int[] nArray2) {
        Vector vector = scancodeSeqVector;
        synchronized (vector) {
            boolean bl = false;
            int n = 0;
            n = 0;
            while (n < scancodeSeqVector.size()) {
                int n2 = this.doCompaire((int[])scancodeSeqVector.elementAt(n), nArray2);
                if (n2 > 0) {
                    scancodeSeqVector.insertElementAt(nArray2, n);
                    virScancodeVector.insertElementAt(nArray, n);
                    bl = true;
                    break;
                }
                if (n2 >= 0) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                scancodeSeqVector.addElement(nArray2);
                virScancodeVector.addElement(nArray);
            }
        }
    }

    private int doCompaire(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = nArray.length;
        if (nArray2.length < nArray.length) {
            n2 = nArray2.length;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] > nArray2[n3]) {
                return 1;
            }
            if (nArray[n3] < nArray2[n3]) {
                return -1;
            }
            ++n3;
        }
        if (nArray.length > nArray2.length) {
            return 1;
        }
        if (nArray.length < nArray2.length) {
            return -1;
        }
        return n;
    }

    public int getKeyboardMapLen() {
        return this.kbdMapLength;
    }

    public synchronized int[][] lookupScancodes(int n, int n2) {
        int n3;
        flag = 3;
        if (index >= kbdMapMaxWidth) {
            int[][] nArray = new int[kbdMapMaxWidth][2];
            System.arraycopy(inputBuf, 0, nArray, 0, kbdMapMaxWidth);
            pHead = 0;
            pTail = this.kbdMapLength;
            index = 0;
            return nArray;
        }
        POSKeyboardMap.inputBuf[POSKeyboardMap.index][0] = n;
        POSKeyboardMap.inputBuf[POSKeyboardMap.index][1] = n2;
        int n4 = pHead;
        while (n4 < pTail) {
            if (n == this.kbdMap[n4][index]) {
                pHead = n4;
                if (index == this.kbdMap[n4].length - 1) {
                    flag = 1;
                    break;
                }
                n3 = pHead + 1;
                while (n3 < pTail) {
                    if (n != this.kbdMap[n3][index]) {
                        pTail = n3;
                        break;
                    }
                    ++n3;
                }
                flag = 2;
                break;
            }
            ++n4;
        }
        if (flag == 1) {
            n3 = this.vMap[pHead].length;
            int[][] nArray = new int[n3][2];
            int n5 = 0;
            while (n5 < n3) {
                nArray[n5][0] = this.vMap[pHead][n5];
                nArray[n5][1] = 1;
                ++n5;
            }
            pHead = 0;
            pTail = this.kbdMapLength;
            index = 0;
            return nArray;
        }
        if (flag == 3) {
            int[][] nArray = new int[index + 1][2];
            System.arraycopy(inputBuf, 0, nArray, 0, index + 1);
            pHead = 0;
            pTail = this.kbdMapLength;
            index = 0;
            return nArray;
        }
        ++index;
        return new int[0][0];
    }

    public void showVector(Vector vector, String string) {
        Tracer.trace((int)4, (String)className, (String)string, (String)(" vector size: " + new Integer(vector.size())));
        Vector vector2 = vector;
        synchronized (vector2) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.showArray((int[])enumeration.nextElement());
            }
        }
    }

    public void showArray(int[] nArray) {
        String string = "";
        int n = 0;
        while (n < nArray.length) {
            string = string + "0x" + Integer.toHexString(nArray[n]) + " ";
            ++n;
        }
        Tracer.trace((int)4, (String)className, (String)string, (String)" ");
    }

    public void showArray(int[][] nArray, int n, String string) {
        Tracer.trace((int)4, (String)className, (String)string, (String)(" length=" + n + " contains:"));
        int n2 = 0;
        while (n2 < n) {
            this.showArray(nArray[n2]);
            ++n2;
        }
    }

    private class makeArrayFromVector {
        private int length;
        private int maxWidth = 0;
        private int[][] array2 = new int[0][0];

        makeArrayFromVector(Vector vector) {
            Vector vector2 = vector;
            synchronized (vector2) {
                this.length = vector.size();
                this.array2 = new int[this.length][];
                int n = 0;
                while (n < this.length) {
                    this.array2[n] = (int[])vector.elementAt(n);
                    if (this.array2[n].length > this.maxWidth) {
                        this.maxWidth = this.array2[n].length;
                    }
                    ++n;
                }
            }
        }

        public int getArrayMaxWidth() {
            return this.maxWidth;
        }

        public int getArrayLenght() {
            return this.length;
        }

        public int[][] getArray() {
            return this.array2;
        }
    }
}

