/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.POSPrinterServiceImp;
import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.CacheVector;
import com.ibm.jpos.services.ibmprinter.DirectIOBitmapInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOFontInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOPrintRawModeInfo;
import com.ibm.jpos.services.ibmprinter.DirectIOPrinterRead;
import com.ibm.jpos.services.ibmprinter.PrintBarCodeData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapImageInfo;
import com.ibm.jpos.services.ibmprinter.PrintDataCompiler;
import com.ibm.jpos.services.ibmprinter.PrintNormalData;
import com.ibm.jpos.services.ibmprinter.PrintNormalDataVector;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.ibmprinter.RotatePrintData;
import com.ibm.jpos.services.ibmprinter.SetBitmapData;
import com.ibm.jpos.services.poss.POSPrinter4689POSSPrintDataCompiler;
import com.ibm.jpos.services.poss.POSSPOSPrinterServiceImp;
import com.ibm.jpos.services.poss.POSSPrintNormalData;
import com.ibm.jpos.services.poss.Printer4689Parser;
import com.ibm.jpos.util.ByteBuffer;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosException;
import java.io.UnsupportedEncodingException;
import jpos.JposException;
import jpos.POSPrinterConst;
import jpos.services.EventCallbacks;

public class POSPrinter4689Imp
extends POSSPOSPrinterServiceImp
implements PosDef,
POSPrinterServiceImp,
POSPrinterConst {
    private static final String className = "POSPrinter4689Imp";
    private POSPrinter4689POSSPrintDataCompiler printDataCompiler = null;
    public static final int PosMODE_DIRECT = 0;
    private PrintNormalDataVector pndv = null;

    protected POSPrinter4689Imp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Tracer.trace((int)4, (String)className, (String)("open(" + string + ")"), (String)"Entry");
        super.open(string, eventCallbacks);
        this.printDataCompiler = new POSPrinter4689POSSPrintDataCompiler((POSPrinterServiceState)this.getDeviceServiceState());
        Tracer.trace((int)4, (String)className, (String)"open()", (String)"Exit");
    }

    public void printBarCode(int n, String string, int n2, int n3, int n4, int n5, int n6) throws JposException {
        Tracer.trace((int)4, (String)className, (String)"PrintBarCode()", (String)"Entry");
        if (this.printQueueManager.getPostingRotation(n) != 1) {
            throw new JposException(106);
        }
        switch (n2) {
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 123: {
                break;
            }
            default: {
                throw new JposException(106, "Illegal symbology: " + n2);
            }
        }
        switch (n5) {
            case -3: 
            case -2: 
            case -1: {
                break;
            }
            default: {
                throw new JposException(106, "Illegal alignment: " + n5);
            }
        }
        switch (n6) {
            case -13: 
            case -12: 
            case -11: {
                break;
            }
            default: {
                throw new JposException(106, "Illegal textPosition: " + n6);
            }
        }
        this.printQueueManager.post(new PrintBarCodeData(n, string, n2, n3, n4, n5, n6, this.serviceState.getAsyncMode()));
        Tracer.trace((int)4, (String)className, (String)"PrintBarCode()", (String)"Exit");
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        super.setDeviceEnabled(bl);
        if (bl) {
            try {
                int n = this.posDevice.getCodePage();
                if (n == 437 || n == 0 || n == 858) {
                    n = 932;
                    this.posDevice.setCodePage(n);
                }
                this.serviceState.setCharacterSet(n);
                this.serviceState.setCharacterSetList(new String("998,858," + new Integer(n).toString()));
            }
            catch (PosException posException) {
                // empty catch block
            }
        }
    }

    public synchronized void setJrnLineHeight(int n) throws JposException {
    }

    public synchronized void setJrnLineSpacing(int n) throws JposException {
    }

    public synchronized void setRecLineHeight(int n) throws JposException {
    }

    public synchronized void setRecLineSpacing(int n) throws JposException {
    }

    protected PrintDataCompiler getPrintDataCompiler() {
        return this.printDataCompiler;
    }

    void doDirectIOFlipCheck() throws JposException {
    }

    void doDirectIOPrintDownloadedBitmap(int n, DirectIOBitmapInfo directIOBitmapInfo) throws JposException {
    }

    void doDirectIOPrintDownloadedMessage(int n) throws JposException {
        this.printDataCompiler.setLogo(1, "");
        this.printDataCompiler.setLogo(2, "");
    }

    public void processRotatePrint(RotatePrintData rotatePrintData) throws JposException {
        Tracer.trace((int)4, (String)className, (String)"processRotatePrint()", (String)"Entry");
        if (rotatePrintData.getRotation() == 1) {
            if (this.pndv != null && this.pndv.size() > 0) {
                POSSPrintNormalData pOSSPrintNormalData = (POSSPrintNormalData)this.pndv.elementAt(0);
                int n = pOSSPrintNormalData.getStation();
                POSSPOSPrinterServiceImp.PrintingMode printingMode = this.getPrintingMode(n);
                try {
                    Tracer.trace((int)4, (String)className, (String)"processRotatePrint()", (String)"Start buffered print-out");
                    String string = new String();
                    int n2 = 0;
                    while (n2 < this.pndv.size()) {
                        POSSPrintNormalData pOSSPrintNormalData2 = (POSSPrintNormalData)this.pndv.elementAt(n2);
                        string = string + pOSSPrintNormalData2.getData();
                        ++n2;
                    }
                    Printer4689Parser printer4689Parser = new Printer4689Parser(this.serviceState.getCharacterSet());
                    ByteBuffer byteBuffer = new ByteBuffer();
                    byteBuffer.append(printer4689Parser.parse(string));
                    Tracer.trace((int)4, (String)className, (String)"processRotatePrint()", (String)("Raw data bytes:" + byteBuffer.getByteCount()));
                    PosArg[] posArgArray = new PosArg[]{new PosArg("printStation", 0), new PosArg("printMode", 0), new PosArg("printAlignment", 0)};
                    PosArg[] posArgArray2 = new PosArg[]{new PosArg("printStation", 1), new PosArg("printMode", 0), new PosArg("printAlignment", 0)};
                    Tracer.trace((int)4, (String)className, (String)"processRotatePrint()", (String)("rotate data: \n   " + PrintDataCompiler.getByteDump(byteBuffer.getBytes())));
                    this.posDevice.ioctl(302, posArgArray);
                    this.chaseCompleted.set(false);
                    this.posDevice.write(new byte[]{27, 71});
                    this.posDevice.ioctl(305, posArgArray2);
                    this.posDevice.write(byteBuffer.getBytes());
                    this.chaseCompleted.waitForTrue(30000);
                    this.posDevice.ioctl(305, posArgArray);
                }
                catch (Exception exception) {
                    if (printingMode.isSideways()) {
                        printingMode.setRotation(1);
                    }
                    printingMode.clearTransaction();
                    printingMode.clearSideways();
                    this.checkPrinterErrorCause((PrintNormalData)this.pndv.elementAt(0));
                    throw this.createJposException(exception);
                }
                this.pndv.setSize(0);
                Tracer.trace((int)4, (String)className, (String)"processRotatePrint()", (String)"Exit buffered print-out");
            }
        } else {
            if (this.pndv == null) {
                this.pndv = new PrintNormalDataVector();
            }
            this.pndv.setSize(0);
        }
        super.processRotatePrint(rotatePrintData);
        block1 : switch (rotatePrintData.getStation()) {
            case 2: {
                switch (rotatePrintData.getRotation()) {
                    case 257: {
                        this.setRecLineSpacing(15);
                        break block1;
                    }
                    case 1: {
                        this.setRecLineSpacing(this.serviceState.getRecLineSpacing());
                    }
                }
            }
        }
        Tracer.trace((int)4, (String)className, (String)"processRotatePrint()", (String)"Exit");
    }

    public void checkMode(int n, int n2) throws JposException {
        if (n2 == 16) {
            return;
        }
        throw new JposException(106);
    }

    public void clearBitmaps() throws JposException {
        if (this.printBitmapUtil != null) {
            this.printBitmapUtil.bitmapIndex = 1;
        }
    }

    public void clearMessages() throws JposException {
        if (this.printBitmapUtil != null) {
            this.printBitmapUtil.messageIndex = 1;
        }
    }

    public void downloadData(int n, String string, int n2, int n3) throws JposException {
        Tracer.trace((int)4, (String)className, (String)("downloadData(" + n + ", " + string + ", " + n2 + ", " + n3 + ")"), (String)"Entry");
        int n4 = string.indexOf("\u001bF");
        if (n4 > 0) {
            try {
                string = new String(string.substring(0, n4));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byte[] byArray = new byte[string.length()];
        int n5 = 0;
        while (n5 < byArray.length) {
            byArray[n5] = (byte)string.charAt(n5);
            ++n5;
        }
        try {
            PosArg[] posArgArray = new PosArg[]{new PosArg("printStation", 0), new PosArg("printMode", 0), new PosArg("printAlignment", 0)};
            this.posDevice.ioctl(302, posArgArray);
            PosArg[] posArgArray2 = new PosArg[]{new PosArg("printStation", 1), new PosArg("printMode", 8), new PosArg("printAlignment", 1)};
            this.posDevice.ioctl(305, posArgArray2);
            this.posDevice.write(byArray);
            this.posDevice.ioctl(305, posArgArray);
            if (this.printBitmapUtil != null) {
                this.printBitmapUtil.cacheVector.setDownloaded(CacheVector.BITMAP, n, n3, true);
            }
        }
        catch (PosException posException) {
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        Tracer.trace((int)4, (String)className, (String)"downloadData()", (String)"Exit");
    }

    public void downloadData(int n, byte[] byArray, int n2, int n3) throws JposException {
        Tracer.trace((int)4, (String)className, (String)("downloadData(" + n + ", " + n2 + ", " + n3 + ")"), (String)"Entry");
        PosArg[] posArgArray = new PosArg[1];
        try {
            int n4 = 0;
            while (true) {
                byArray[n4] = byArray[n4 + 3];
                ++n4;
            }
        }
        catch (Exception exception) {
            try {
                posArgArray[0] = new PosArg("printMode", 16);
                this.posDevice.ioctl(305, posArgArray);
                this.posDevice.write(byArray, 7632);
                posArgArray[0] = new PosArg("printMode", 1);
                this.posDevice.ioctl(305, posArgArray);
            }
            catch (Exception exception2) {
                posArgArray[0] = new PosArg("printMode", 1);
                try {
                    this.posDevice.ioctl(305, posArgArray);
                }
                catch (PosException posException) {
                    // empty catch block
                }
                if (exception2 instanceof PosException) {
                    throw new JposException(111, exception2.getMessage(), exception2);
                }
                if (exception2 instanceof JposException) {
                    throw new JposException(((JposException)((Object)exception2)).getErrorCode());
                }
                throw new JposException(111);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception3) {
                // empty catch block
            }
            if (this.printBitmapUtil != null) {
                this.printBitmapUtil.cacheVector.setDownloaded(CacheVector.BITMAP, n, n3, true);
            }
            Tracer.trace((int)4, (String)className, (String)"downloadData()", (String)"Exit");
            return;
        }
    }

    public int getStationMaxBitmapHeight(int n) {
        return 144;
    }

    public short getNextByteForStation(int n, PrintBitmapImageInfo printBitmapImageInfo) {
        return this.getNextByteForThermal(printBitmapImageInfo);
    }

    /*
     * Unable to fully structure code
     */
    public void processPrintBarCode(PrintBarCodeData var1_1) throws JposException {
        var2_2 = var1_1.getStation();
        var3_3 = var1_1.getData();
        var4_4 = var1_1.getSymbology();
        var5_5 = var1_1.getHeight();
        var6_6 = var1_1.getWidth();
        var7_7 = var1_1.getAlignment();
        var8_8 = var1_1.getTextPosition();
        var9_9 = new PosArg[1];
        Tracer.trace((int)4, (String)"POSPrinter4689Imp", (String)("processPrintBarCode(" + var2_2 + ", " + var3_3 + ", " + var4_4 + ", " + var5_5 + ", " + var6_6 + ", " + var7_7 + ", " + var8_8 + ")"), (String)"Entry");
        try {
            block42: {
                if (this.getPrintingMode(var2_2).getRotation() != 1) {
                    throw new JposException(106);
                }
                this.checkStations(var2_2);
                this.selectStations(var2_2);
                var10_10 = 0;
                var11_12 = 0;
                var15_13 = false;
                switch (var4_4) {
                    case 101: {
                        var11_12 = 0;
                        break;
                    }
                    case 102: {
                        var11_12 = 1;
                        break;
                    }
                    case 103: {
                        var11_12 = 3;
                        break;
                    }
                    case 104: {
                        var11_12 = 2;
                        break;
                    }
                    case 106: {
                        var11_12 = 5;
                        break;
                    }
                    case 107: {
                        var11_12 = 6;
                        break;
                    }
                    case 108: {
                        var11_12 = 4;
                        break;
                    }
                    case 109: {
                        var11_12 = 8;
                        break;
                    }
                    case 110: {
                        var11_12 = 7;
                        break;
                    }
                    default: {
                        throw new JposException(106, "Internal Error: don't recognize validated symbology: " + var4_4);
                    }
                }
                switch (var8_8) {
                    case -11: {
                        var10_10 = 0;
                        break;
                    }
                    case -12: {
                        var10_10 = 1;
                        break;
                    }
                    case -13: {
                        var10_10 = 2;
                        break;
                    }
                    default: {
                        throw new JposException(111, "Internal Error: don't recognize validated textPosition: " + var8_8);
                    }
                }
                var12_14 = this.mapModeCalc.convertToPrinterDots(this.serviceState.getMapMode(), var6_6, this.getDotsPerInchWide(var2_2)) / (this.serviceState.getRecLineWidth() / 2);
                if (var12_14 < 0) {
                    var12_14 = 0;
                } else if (var12_14 > 1) {
                    throw new JposException(106);
                }
                var13_15 = this.mapModeCalc.convertToPrinterDots(this.serviceState.getMapMode(), var5_5, this.getDotsPerInchWide(var2_2));
                if (var13_15 > 330) {
                    throw new JposException(106);
                }
                if ((var13_15 /= 22) > 15) {
                    throw new JposException(106);
                }
                switch (var4_4) {
                    case 101: {
                        if (var3_3.length() <= 13) break;
                        throw new JposException(106);
                    }
                    case 102: {
                        if (var3_3.length() <= 8) break;
                        throw new JposException(106);
                    }
                    case 103: {
                        if (var3_3.length() <= 8) break;
                        throw new JposException(106);
                    }
                    case 104: {
                        if (var3_3.length() <= 13) break;
                        throw new JposException(106);
                    }
                    case 106: {
                        if (!(var12_14 == 0 ? var3_3.length() > 21 : var3_3.length() > 13)) break;
                        throw new JposException(106);
                    }
                    case 107: {
                        if (!(var12_14 == 0 ? var3_3.length() > 15 : var3_3.length() > 10)) break;
                        throw new JposException(106);
                    }
                    case 108: {
                        if (!(var12_14 == 0 ? var3_3.length() > 17 : var3_3.length() > 6)) break;
                        throw new JposException(106);
                    }
                    case 109: {
                        if (!(var12_14 == 0 ? var3_3.length() > 17 : var3_3.length() > 10)) break;
                        throw new JposException(106);
                    }
                    case 110: {
                        if (!(var12_14 == 0 ? var3_3.length() > 28 : var3_3.length() > 15)) break;
                        throw new JposException(106);
                    }
                }
                var16_16 = new ByteBuffer();
                var16_16.setByteCount(0);
                var16_16.append(29).append(119);
                var16_16.append(var12_14);
                this.chaseCompleted.set(false);
                this.posDevice.write(new byte[]{27, 71});
                var9_9[0] = new PosArg("printMode", 128);
                this.posDevice.ioctl(305, var9_9);
                this.posDevice.write(var16_16.getBytes());
                this.chaseCompleted.waitForTrue(10000);
                var9_9[0] = new PosArg("printMode", 1);
                this.posDevice.ioctl(305, var9_9);
                var16_16.setByteCount(0);
                var16_16.append(29).append(104);
                var16_16.append(var13_15);
                this.chaseCompleted.set(false);
                this.posDevice.write(new byte[]{27, 71});
                var9_9[0] = new PosArg("printMode", 128);
                this.posDevice.ioctl(305, var9_9);
                this.posDevice.write(var16_16.getBytes());
                this.chaseCompleted.waitForTrue(10000);
                var9_9[0] = new PosArg("printMode", 1);
                this.posDevice.ioctl(305, var9_9);
                var16_16.setByteCount(0);
                var16_16.append(29).append(72);
                var16_16.append(var10_10);
                this.chaseCompleted.set(false);
                this.posDevice.write(new byte[]{27, 71});
                var9_9[0] = new PosArg("printMode", 128);
                this.posDevice.ioctl(305, var9_9);
                this.posDevice.write(var16_16.getBytes());
                this.chaseCompleted.waitForTrue(10000);
                var9_9[0] = new PosArg("printMode", 1);
                this.posDevice.ioctl(305, var9_9);
                var16_16.setByteCount(0);
                var16_16.append(29).append(102);
                if (var12_14 == 0) {
                    var16_16.append(1);
                } else {
                    var16_16.append(0);
                }
                this.chaseCompleted.set(false);
                this.posDevice.write(new byte[]{27, 71});
                var9_9[0] = new PosArg("printMode", 128);
                this.posDevice.ioctl(305, var9_9);
                this.posDevice.write(var16_16.getBytes());
                this.chaseCompleted.waitForTrue(10000);
                var9_9[0] = new PosArg("printMode", 1);
                this.posDevice.ioctl(305, var9_9);
                var16_16.setByteCount(0);
                var16_16.append(29).append(107);
                var16_16.append(var11_12);
                try {
                    var16_16.append(var3_3.getBytes("ISO8859_1"));
                    break block42;
                }
                catch (UnsupportedEncodingException var17_17) {
                    var18_18 = 0;
                    ** while (var18_18 < var3_3.length())
                }
lbl-1000:
                // 1 sources

                {
                    var16_16.append((byte)var3_3.charAt(var18_18));
                    ++var18_18;
                    continue;
                }
            }
            var16_16.append(0);
            var9_9[0] = new PosArg("printMode", 128);
            this.posDevice.ioctl(305, var9_9);
            this.posDevice.write(var16_16.getBytes());
            this.chaseCompleted.waitForTrue(10000);
            var9_9[0] = new PosArg("printMode", 1);
            this.posDevice.ioctl(305, var9_9);
            this.chaseCompleted.set(false);
            this.posDevice.write(new byte[]{27, 71});
        }
        catch (Exception var10_11) {
            if (this.getPrintingMode(var2_2).isTransaction()) {
                this.getPrintingMode(var2_2).clearTransaction();
            }
            this.checkPrinterErrorCause(var1_1);
            if (var10_11 instanceof JposException) {
                throw (JposException)var10_11;
            }
            throw new JposException(111);
        }
        Tracer.trace((int)4, (String)"POSPrinter4689Imp", (String)"processPrintBarCode()", (String)"Exit");
    }

    void doDirectIOSetStamp(String string) throws JposException {
        this.serviceState.setCapRecBitmap(true);
        int n = this.serviceState.getRecLineWidth();
        if (this.serviceState.getMapMode() != 1) {
            n = this.convertToDots(n, 2);
        }
        SetBitmapData setBitmapData = new SetBitmapData(1, 2, string, -11, -1, null);
        this.printBitmapUtil.validateBitmap(setBitmapData, 16, n);
        this.processSetBitmap(setBitmapData);
        this.serviceState.setCapRecBitmap(false);
    }

    public int getForcedBitmapHeight() {
        return 144;
    }

    public int getForcedBitmapWidth() {
        return 424;
    }

    protected int getDefaultCodePage() throws JposException {
        return 932;
    }

    protected int getCodePage() throws JposException {
        return 932;
    }

    protected void setCodePage(int n) throws JposException {
    }

    protected PrinterFont[] getPrinterFonts() throws JposException {
        Tracer.trace((int)4, (String)className, (String)"getPrinterFonts()", (String)"Entry");
        PrinterFont[] printerFontArray = null;
        printerFontArray = new PrinterFont[]{new PrinterFont(2, 32, 576, 1, 0, 32), new PrinterFont(1, 32, 474, 1, 0, 32)};
        Tracer.trace((int)4, (String)className, (String)"getPrinterFonts()", (String)"Exit");
        return printerFontArray;
    }

    short getNextByteForThermal(PrintBitmapImageInfo printBitmapImageInfo) {
        int n = 0;
        if (printBitmapImageInfo.row >= printBitmapImageInfo.height) {
            n = 0;
            printBitmapImageInfo.col += 8L;
            if (printBitmapImageInfo.col >= printBitmapImageInfo.width) {
                if (printBitmapImageInfo.row % 8L == 7L) {
                    printBitmapImageInfo.done = true;
                } else {
                    printBitmapImageInfo.col = 0L;
                    ++printBitmapImageInfo.row;
                }
            }
        } else {
            int n2 = 0;
            while (n2 < 8) {
                int n3 = printBitmapImageInfo.pixels[(int)(printBitmapImageInfo.row * printBitmapImageInfo.width + printBitmapImageInfo.col)];
                n3 = n3 == -1 ? 1 : 0;
                n = n << 1 | n3;
                ++printBitmapImageInfo.col;
                if (printBitmapImageInfo.col == printBitmapImageInfo.width) {
                    n <<= 7 - n2;
                    n2 = 8;
                    if (printBitmapImageInfo.row == printBitmapImageInfo.height - 1L && printBitmapImageInfo.row % 8L == 7L) {
                        printBitmapImageInfo.done = true;
                    } else {
                        printBitmapImageInfo.col = 0L;
                        ++printBitmapImageInfo.row;
                    }
                }
                ++n2;
            }
        }
        return (short)n;
    }

    public byte[] getBitmapHeader(int n, int n2) {
        return null;
    }

    public int getMicronsPerStep(int n) {
        return 353;
    }

    public int getDotsPerInchHigh(int n) {
        return 205;
    }

    public int getDotsPerInchWide(int n) throws JposException {
        return 205;
    }

    public int getMaxBytesPerWrite(int n) throws JposException {
        return 2000;
    }

    public int getWriteBufferSize() {
        return 8192;
    }

    public int getMaxSetBitmapSize(int n) throws JposException {
        return 7732;
    }

    public int getMaxPrintBitmapSize() throws JposException {
        return 0;
    }

    public boolean requiresLinefeed(int n) {
        return n != 2;
    }

    void doDirectIODownloadPropFont(DirectIOFontInfo directIOFontInfo) throws JposException {
        throw new JposException(106);
    }

    void doDirectIODownloadNonPropFont(DirectIOFontInfo directIOFontInfo) throws JposException {
        throw new JposException(106);
    }

    void doDirectIOHeadMovement(int n) throws JposException {
        throw new JposException(106);
    }

    void doSelectResidentCharacterSet() throws JposException {
        throw new JposException(106);
    }

    void doSelectUserDefinedCharacterSet() throws JposException {
        throw new JposException(106);
    }

    void doSelectCodePage(int n) throws JposException {
        throw new JposException(106);
    }

    void doEraseUserDefinedCharacterSet(int n) throws JposException {
        throw new JposException(106);
    }

    void doPrintInRawMode(DirectIOPrintRawModeInfo directIOPrintRawModeInfo) throws JposException {
        throw new JposException(106);
    }

    void doPrinterRead(DirectIOPrinterRead directIOPrinterRead) throws JposException {
        throw new JposException(106);
    }

    public void processPrintNormal(PrintNormalData printNormalData) throws JposException {
        Tracer.trace((int)4, (String)className, (String)"processPrintNormal()", (String)"Entry");
        POSSPrintNormalData pOSSPrintNormalData = (POSSPrintNormalData)printNormalData;
        int n = pOSSPrintNormalData.getStation();
        POSSPOSPrinterServiceImp.PrintingMode printingMode = this.getPrintingMode(n);
        Tracer.trace((int)4, (String)className, (String)"processPrintNormal()", (String)("data: \n   " + printNormalData.getData() + "\n" + PrintDataCompiler.getByteDump(pOSSPrintNormalData.getCompiledData())));
        try {
            this.checkStations(n);
            if (n == 4 && this.documentInserted.isFalse()) {
                throw new JposException(114, 204);
            }
            Tracer.trace((int)4, (String)className, (String)"processPrintNormal()", (String)"selecting stations");
            if (!printingMode.isTransaction() && !printingMode.isSideways()) {
                this.selectStations(n);
            }
            Tracer.trace((int)4, (String)className, (String)"processPrintNormal()", (String)"writing data");
            if (!printingMode.isSideways()) {
                Tracer.trace((int)4, (String)className, (String)"processPrintNormal()", (String)"Not sideways mode");
                this.chaseCompleted.set(false);
                this.posDevice.write(pOSSPrintNormalData.getCompiledData());
            } else {
                Tracer.trace((int)4, (String)className, (String)"processPrintNormal()", (String)"Buffering printNormalData");
                if (this.pndv == null) {
                    this.pndv = new PrintNormalDataVector();
                    this.pndv.setSize(0);
                }
                this.pndv.add(printNormalData);
            }
            Tracer.trace((int)4, (String)className, (String)"processPrintNormal()", (String)"done writing");
            if (!printingMode.isTransaction() && !printingMode.isSideways()) {
                Tracer.trace((int)4, (String)className, (String)"processPrintNormal()", (String)"waiting on chase");
                this.chase(30000);
                Tracer.trace((int)4, (String)className, (String)"processPrintNormal()", (String)"chase complete");
            }
        }
        catch (Exception exception) {
            if (printingMode.isSideways()) {
                printingMode.setRotation(1);
            }
            printingMode.clearTransaction();
            printingMode.clearSideways();
            this.checkPrinterErrorCause(printNormalData);
            throw this.createJposException(exception);
        }
        Tracer.trace((int)4, (String)className, (String)"processPrintNormal()", (String)"Exit");
    }
}

