/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.DeviceServiceImp;
import com.ibm.jpos.services.DeviceServiceImpMsg;
import com.ibm.jpos.services.ImpFactory;
import com.ibm.jpos.services.ServiceInstanceImp;
import com.ibm.jpos.services.ServiceRegistry;
import com.ibm.jpos.services.poss.POSSServiceInfo;
import com.ibm.jpos.services.poss.POSSServiceKey;
import com.ibm.jpos.util.JposEntryInfo;
import java.lang.reflect.Constructor;
import jpos.JposException;

public class POSSImpFactory
extends ImpFactory {
    public static final String PORT_NUMBER_PROP_NAME = "posNportNumber";
    public static final String SLOT_NUMBER_PROP_NAME = "posNslotNumber";
    public static final String DEVICE_NUMBER_PROP_NAME = "posNdeviceNumber";

    public static ServiceInstanceImp createImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        JposEntryInfo jposEntryInfo = deviceServiceAbstraction.getDeviceServiceState().getJposEntryInfo();
        String string = jposEntryInfo.getImpClassName();
        Class<?> clazz = null;
        try {
            if (string != null) {
                clazz = Class.forName(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_FOUND_MSG, (Exception)classNotFoundException);
        }
        Constructor constructor = POSSImpFactory.lookForValidImpConstructor(clazz);
        if (constructor == null) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_COMPLIANT_MSG);
        }
        DeviceServiceImp deviceServiceImp = null;
        Object[] objectArray = new Object[]{deviceServiceAbstraction};
        try {
            deviceServiceImp = (DeviceServiceImp)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_INSTANTIATION_ERROR_MSG, exception);
        }
        try {
            POSSServiceKey pOSSServiceKey = POSSImpFactory.createServiceKey(jposEntryInfo, deviceServiceAbstraction.getDeviceCategory());
            deviceServiceAbstraction.getDeviceServiceState().setServiceKey(pOSSServiceKey);
            ServiceRegistry.getInstance().setServiceInfo(pOSSServiceKey, new POSSServiceInfo(pOSSServiceKey));
        }
        catch (Exception exception) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_INSTANTIATION_ERROR_MSG, exception);
        }
        return deviceServiceImp;
    }

    private static POSSServiceKey createServiceKey(JposEntryInfo jposEntryInfo, String string) {
        Object object = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        object = jposEntryInfo.getPropertyValue(PORT_NUMBER_PROP_NAME);
        if (object != null) {
            n = Integer.decode((String)object);
        }
        if ((object = jposEntryInfo.getPropertyValue(SLOT_NUMBER_PROP_NAME)) != null) {
            n2 = Integer.decode((String)object);
        }
        if ((object = jposEntryInfo.getPropertyValue(DEVICE_NUMBER_PROP_NAME)) != null) {
            n3 = Integer.decode((String)object);
        }
        POSSServiceKey pOSSServiceKey = new POSSServiceKey(n, n2, n3, string);
        return pOSSServiceKey;
    }

    private static Constructor lookForValidImpConstructor(Class clazz) {
        Constructor<?>[] constructorArray = null;
        try {
            constructorArray = clazz.getDeclaredConstructors();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (constructorArray == null || constructorArray.length == 0) {
            return null;
        }
        Constructor<?> constructor = null;
        int n = 0;
        while (n < constructorArray.length) {
            Class<?>[] classArray = constructorArray[n].getParameterTypes();
            if (classArray.length == 1 && classArray[0].getName().equals("com.ibm.jpos.services.DeviceServiceAbstraction")) {
                constructor = constructorArray[n];
                break;
            }
            ++n;
        }
        return constructor;
    }
}

