/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.MICRServiceImp;
import com.ibm.jpos.services.MICRServiceState;
import com.ibm.jpos.services.POSPrinterServiceMsg;
import com.ibm.jpos.services.ibmprinter.BeginInsertionData;
import com.ibm.jpos.services.ibmprinter.BeginRemovalData;
import com.ibm.jpos.services.ibmprinter.CutPaperData;
import com.ibm.jpos.services.ibmprinter.DirectIOData;
import com.ibm.jpos.services.ibmprinter.EndInsertionData;
import com.ibm.jpos.services.ibmprinter.EndRemovalData;
import com.ibm.jpos.services.ibmprinter.PrintBarCodeData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapData;
import com.ibm.jpos.services.ibmprinter.PrintImmediateData;
import com.ibm.jpos.services.ibmprinter.PrintNormalData;
import com.ibm.jpos.services.ibmprinter.PrintNormalDataVector;
import com.ibm.jpos.services.ibmprinter.PrintQueueManager;
import com.ibm.jpos.services.ibmprinter.PrintQueueManagerCallback;
import com.ibm.jpos.services.ibmprinter.PrintQueueManagerServiceState;
import com.ibm.jpos.services.ibmprinter.PrintTwoNormalData;
import com.ibm.jpos.services.ibmprinter.RotatePrintData;
import com.ibm.jpos.services.ibmprinter.SetBitmapData;
import com.ibm.jpos.services.ibmprinter.SetCharacterSetData;
import com.ibm.jpos.services.ibmprinter.SetLogoData;
import com.ibm.jpos.services.ibmprinter.TransactionPrintData;
import com.ibm.jpos.services.ibmprinter.ValidateDataData;
import com.ibm.jpos.services.poss.POSSDeviceServiceImp;
import com.ibm.jpos.util.BooleanMonitor;
import com.ibm.jpos.util.Debug;
import com.ibm.jpos.util.JposEntryInfo;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDevice;
import com.ibm.poss.PosException;
import com.ibm.poss.PosmPrnChaseCompleteListener;
import com.ibm.poss.PosmPrnDataAvailListener;
import com.ibm.poss.PosmPrnPrinterErrorListener;
import com.ibm.poss.PosmPrnStatusChangeListener;
import com.ibm.poss.Printer;
import jpos.JposException;
import jpos.MICRConst;
import jpos.POSPrinterConst;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.services.EventCallbacks;

public abstract class POSSMICRServiceImp
extends POSSDeviceServiceImp
implements MICRServiceImp,
Printer,
POSPrinterConst,
PrintQueueManagerCallback,
MICRConst {
    EventCallbacks eventCallback = null;
    boolean[] firingComplete = new boolean[1];
    JposException errorEventException = null;
    boolean[] chaseComplete = new boolean[5];
    MICRListener mickey = null;
    protected PosDevice posDevice = null;
    private boolean insertMode = false;
    private boolean removeMode = false;
    private boolean exceptionTFound = false;
    private String transit = "";
    private int type = 99;
    private int spaces = 0;
    private char field = '\u0000';
    private char skip = '\u0000';
    private int size = 0;
    private int acc_rl = 0;
    private int beginSerIndex;
    private int endSerIndex = -1;
    private int beginActIndex;
    private int endActIndex = -1;
    private boolean format2 = false;
    private String onusData = new String("");
    protected BooleanMonitor documentInserted = null;
    protected BooleanMonitor documentRegistered = null;
    protected PrintQueueManager printQueueManager = null;
    private Debug debug = new Debug(false);
    DeviceServiceAbstraction serviceAbstraction;
    private BooleanMonitor goodMicrData = new BooleanMonitor(false);
    MICRServiceState micrState;
    int biTime = 100;
    int eState = 2;
    private static final String className = "POSSMICRServiceImp";

    protected POSSMICRServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        this.serviceAbstraction = deviceServiceAbstraction;
        this.posDevice = this.getPosDevice();
        this.mickey = new MICRListener();
        this.posDevice.setPosmPrnStatusChangeListener(this.mickey);
        this.posDevice.setPosmPrnDataAvailListener(this.mickey);
        this.posDevice.setPosmPrnChaseCompleteListener(this.mickey);
        this.posDevice.setPosmPrnPrinterErrorListener(this.mickey);
    }

    public void deleteImp() throws JposException {
        super.deleteImp();
        this.posDevice.setPosmPrnDataAvailListener(null);
        this.posDevice.setPosmPrnChaseCompleteListener(null);
        this.posDevice.setPosmPrnPrinterErrorListener(null);
        this.posDevice.setPosmPrnStatusChangeListener(null);
    }

    protected String getPOSSDeviceClass() {
        return "PosPrinter";
    }

    public void setAutoDisable(boolean bl) throws JposException {
    }

    public void setDataEventEnabled(boolean bl) throws JposException {
    }

    protected boolean isCompositeDevice() {
        return true;
    }

    public void claim(int n) throws JposException {
        long l = 0L;
        Tracer.trace((int)4, (String)className, (String)"claim", (String)"Entry");
        super.claim(n);
        this.printQueueManager = new PrintQueueManager((PrintQueueManagerServiceState)this.micrState, this.getDeviceServiceAbstraction().getEventQueueManager(), this.eventCallback.getEventSource(), this);
        this.setPossStation(4, true);
        Tracer.trace((int)4, (String)className, (String)"claim", (String)"Exit");
    }

    public void release() throws JposException {
        this.printQueueManager.shutdown();
        super.release();
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        PosArg[] posArgArray;
        block4: {
            super.open(string, eventCallbacks);
            JposEntryInfo jposEntryInfo = this.getDeviceServiceState().getJposEntryInfo();
            if (jposEntryInfo.hasPropertyWithName("debugOn")) {
                this.debug.on();
            }
            this.micrState = (MICRServiceState)this.getDeviceServiceState();
            this.eventCallback = eventCallbacks;
            posArgArray = new PosArg[]{new PosArg(" ", 0)};
            posArgArray[0].setArg("printStatus", 0);
            try {
                this.getPosDevice().ioctl(302, posArgArray);
            }
            catch (Exception exception) {
                if (!this.debug.isOn()) break block4;
                exception.printStackTrace();
            }
        }
        int n = (Integer)posArgArray[0].getValue();
        Tracer.trace((int)4, (String)className, (String)"open", (String)("stats= " + String.valueOf(n)));
        if ((n & 0x2000) != 8192) {
            throw new JposException(108);
        }
        this.micrState.setState(2);
        this.documentInserted = new BooleanMonitor(false);
        this.documentRegistered = new BooleanMonitor(false);
        this.documentInserted.set(false);
        this.documentRegistered.set(false);
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        super.setDeviceEnabled(bl);
        this.setSemaphores();
    }

    public void beginInsertion(int n) throws JposException {
        this.biTime = n;
        this.setSemaphores();
        this.printQueueManager.post(new BeginInsertionData(n));
    }

    /*
     * Unable to fully structure code
     */
    public void processBeginInsertion(BeginInsertionData var1_1) throws JposException {
        block4: {
            Tracer.trace((int)4, (String)"POSSMICRServiceImp", (String)"processBeginInsertion", (String)"Entry");
            if (this.micrState.getCoverOpen()) {
                throw new JposException(111);
            }
            this.insertMode = true;
            this.removeMode = false;
            if (var1_1.getTimeout() < 0) ** GOTO lbl14
            this.documentInserted.waitForTrue(var1_1.getTimeout());
            break block4;
lbl-1000:
            // 1 sources

            {
                try {
                    this.documentInserted.waitForTrue(10000);
                    continue;
                }
                catch (Exception var2_2) {
                    // empty catch block
                }
lbl14:
                // 3 sources

                ** while (this.documentInserted.isFalse())
            }
        }
        Tracer.trace((int)4, (String)"POSSMICRServiceImp", (String)"processBeginInsertion", (String)"Exit");
    }

    public void beginRemoval(int n) throws JposException {
        this.setSemaphores();
        this.printQueueManager.post(new BeginRemovalData(n));
    }

    /*
     * Unable to fully structure code
     */
    public void processBeginRemoval(BeginRemovalData var1_1) throws JposException {
        block10: {
            try {
                if (this.getCurrentStation() != 4) {
                    this.setPossStation(4, true);
                }
            }
            catch (Exception var2_2) {
                throw new JposException(111);
            }
            Tracer.trace((int)4, (String)"POSSMICRServiceImp", (String)"processBeginRemoval", (String)"Entry");
            if (this.micrState.getCoverOpen()) {
                throw new JposException(111);
            }
            Tracer.trace((int)4, (String)"POSSMICRServiceImp", (String)"processBeginRemoval", (String)"After Cover Open Check");
            this.insertMode = false;
            this.removeMode = true;
            if (this.documentInserted.isFalse()) {
                return;
            }
            try {
                this.posDevice.write("\u001bM");
            }
            catch (Exception var2_3) {
                // empty catch block
            }
            if (var1_1.getTimeout() < 0) ** GOTO lbl29
            this.documentInserted.waitForFalse(var1_1.getTimeout());
            break block10;
lbl-1000:
            // 1 sources

            {
                try {
                    this.documentInserted.waitForFalse(10000);
                    continue;
                }
                catch (Exception var2_5) {
                    // empty catch block
                }
lbl29:
                // 3 sources

                ** while (this.documentInserted.isTrue())
            }
        }
        Tracer.trace((int)4, (String)"POSSMICRServiceImp", (String)"processBeginRemoval", (String)"Exit");
    }

    public void clearInput() throws JposException {
    }

    public void endInsertion() throws JposException {
        if (!this.insertMode) {
            throw new JposException(106);
        }
        this.setSemaphores();
        this.printQueueManager.post(new EndInsertionData());
        this.micrState.setState(this.eState);
    }

    public void processEndInsertion(EndInsertionData endInsertionData) throws JposException {
        this.insertMode = false;
        this.eState = 2;
        try {
            if (this.getCurrentStation() != 4) {
                this.setPossStation(4, true);
            }
        }
        catch (Exception exception) {
            throw new JposException(111);
        }
        if (this.micrState.getCoverOpen()) {
            throw new JposException(111);
        }
        Tracer.trace((int)4, (String)className, (String)"processEndInsertion", (String)("doc in" + this.documentInserted.isTrue() + " doc reg " + this.documentInserted.isTrue()));
        byte[] byArray = new byte[4];
        if (!this.documentInserted.isTrue()) {
            Tracer.trace((int)4, (String)className, (String)"processEndInsertion", (String)"doc inserted");
            throw new JposException(114, 201);
        }
        try {
            block21: {
                if (!this.documentRegistered.isTrue()) {
                    Tracer.trace((int)4, (String)className, (String)"processEndInsertion", (String)"No doc registered");
                }
                try {
                    byArray[2] = 0;
                    byArray[0] = 27;
                    byArray[1] = 76;
                    while (byArray[2] < 2) {
                        byArray[2] = (byte)(byArray[2] + 1);
                        this.posDevice.write(byArray, 2);
                        if (this.documentRegistered.isTrue()) break;
                        Thread.currentThread();
                        Thread.sleep(2580L);
                    }
                    byArray[0] = 27;
                    byArray[1] = 71;
                    this.posDevice.write(byArray, 2);
                    this.doChase("Chase for register");
                }
                catch (Exception exception) {
                    if (!this.debug.isOn()) break block21;
                    exception.printStackTrace();
                }
            }
            if (!this.documentRegistered.isTrue()) {
                throw new JposException(112, "no register -timeout/nocheck");
            }
        }
        catch (Exception exception) {
            throw new JposException(111);
        }
        POSSMICRErrorEvent pOSSMICRErrorEvent = null;
        byArray[0] = 27;
        byArray[1] = 82;
        byArray[2] = 27;
        byArray[3] = 71;
        try {
            Tracer.trace((int)4, (String)className, (String)"processEndInsertion", (String)"Send read micr command");
            this.posDevice.write(byArray, 4);
        }
        catch (Exception exception) {
            throw new JposException(111);
        }
        if (!this.doChase("Chase for micr read done")) {
            try {
                pOSSMICRErrorEvent = new POSSMICRErrorEvent(this.micrState, " ");
                this.getEventQueueManager().postEvent((JposEventContainer)pOSSMICRErrorEvent);
                this.eState = 4;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.goodMicrData.waitForTrue(4000);
        }
        catch (Exception exception) {
            Tracer.trace((int)4, (String)className, (String)"processEndInsertion", (String)"No good data");
            try {
                pOSSMICRErrorEvent = new POSSMICRErrorEvent(this.micrState, " ");
                this.getEventQueueManager().postEvent((JposEventContainer)pOSSMICRErrorEvent);
                this.eState = 4;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this.goodMicrData.set(false);
    }

    boolean doChase(String string) {
        boolean bl = true;
        boolean[] blArray = this.chaseComplete;
        synchronized (blArray) {
            block5: {
                try {
                    this.chaseComplete.wait(5000L);
                    Tracer.trace((int)4, (String)className, (String)"doChase", (String)string);
                }
                catch (Exception exception) {
                    Tracer.trace((int)4, (String)className, (String)"doChase", (String)(string + " exception"));
                    bl = false;
                    if (!this.debug.isOn()) break block5;
                    exception.printStackTrace();
                }
            }
        }
        return bl;
    }

    public void endRemoval() throws JposException {
        this.printQueueManager.post(new EndRemovalData());
    }

    public void processEndRemoval(EndRemovalData endRemovalData) throws JposException {
        Tracer.trace((int)4, (String)className, (String)"processEndRemoval", (String)"processer");
        if (!this.removeMode) {
            throw new JposException(106);
        }
        this.removeMode = false;
        if (this.documentInserted.isTrue()) {
            throw new JposException(114, 202);
        }
    }

    int getPrinterStatus(int n) {
        PosArg[] posArgArray = new PosArg[]{n == 1 ? new PosArg("printStatus", 0) : new PosArg("printStatus2", 0)};
        try {
            this.posDevice.ioctl(302, posArgArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Integer)posArgArray[0].getValue();
    }

    void setSemaphores() {
        int n = this.getPrinterStatus(1);
        if ((n & 1) != 0) {
            this.micrState.setCoverOpen(true);
        } else {
            this.micrState.setCoverOpen(false);
        }
        if ((n & 0x20) != 0) {
            this.documentInserted.set(true);
            this.documentRegistered.set(true);
        } else {
            this.documentRegistered.set(false);
        }
        if ((n & 0x10) != 0 || (n & 8) != 0) {
            this.documentInserted.set(true);
        } else {
            this.documentInserted.set(false);
            this.documentRegistered.set(false);
        }
    }

    public int getCurrentStation() throws PosException {
        int n = 4;
        PosArg[] posArgArray = new PosArg[]{new PosArg("printStation", 0)};
        this.posDevice.ioctl(302, posArgArray);
        n = (Integer)posArgArray[0].getValue();
        return n;
    }

    void setPossStation(int n, boolean bl) throws JposException {
        PosArg[] posArgArray = new PosArg[]{new PosArg("printStation", n)};
        try {
            this.posDevice.ioctl(305, posArgArray);
        }
        catch (PosException posException) {
            int n2 = -1;
            this.handlePossError(posException.getErrorCode());
        }
        if (n == 4) {
            this.setDiPrinting(true);
        }
    }

    void setDiPrinting(boolean bl) throws JposException {
        int n = 4901;
        if (bl) {
            n = 4902;
        }
        try {
            this.posDevice.ioctl(n);
        }
        catch (PosException posException) {
            this.handlePossError(posException.getErrorCode());
        }
    }

    private boolean possError() {
        int n = this.getPrinterStatus(1);
        if ((n & 2) > 0 || (n & 4) > 0 || (n & 0x100) > 0 || (n & 0x200) > 0 || (n & 0x400) > 0) {
            return true;
        }
        n = this.getPrinterStatus(2);
        return (n & 1) > 0 || (n & 2) > 0;
    }

    private void handlePossError(int n) throws JposException {
        int n2 = n;
        if (this.micrState.getAsyncMode()) {
            if (n2 == 0) {
                this.mickey.posmPrnPrinterError((short)-1, 0);
            } else {
                this.mickey.posmPrnPrinterError((short)n, 0);
            }
        } else {
            this.errorEventException = n2 == 0 ? new JposException(111) : new JposException(114, n2);
        }
    }

    int jposStation(int n) {
        int n2 = 2;
        switch (n) {
            case 2: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
            }
        }
        return n2;
    }

    public void clearPrinterError() {
    }

    public void processCutPaper(CutPaperData cutPaperData) throws JposException {
    }

    public void processDirectIO(DirectIOData directIOData) throws JposException {
    }

    public void processPrintImmediate(PrintImmediateData printImmediateData) throws JposException {
    }

    public void processPrintNormal(PrintNormalData printNormalData) throws JposException {
    }

    public void processPrintNormalDataVector(PrintNormalDataVector printNormalDataVector) throws JposException {
    }

    public void processPrintBarCode(PrintBarCodeData printBarCodeData) throws JposException {
    }

    public void processPrintBitmap(PrintBitmapData printBitmapData) throws JposException {
    }

    public void processSetBitmap(SetBitmapData setBitmapData) throws JposException {
    }

    public void processSetCharacterSet(SetCharacterSetData setCharacterSetData) throws JposException {
    }

    public void processSetLogo(SetLogoData setLogoData) throws JposException {
    }

    public void processPrintTwoNormal(PrintTwoNormalData printTwoNormalData) throws JposException {
    }

    public void processRotatePrint(RotatePrintData rotatePrintData) throws JposException {
    }

    public void processTransactionPrint(TransactionPrintData transactionPrintData) throws JposException {
    }

    public void processValidateData(ValidateDataData validateDataData) throws JposException {
    }

    class POSSMICRErrorEvent
    implements JposEventContainer {
        private MICRServiceState serviceState = null;
        private ErrorEvent errorEvent = null;
        private String rawData;

        public POSSMICRErrorEvent(MICRServiceState mICRServiceState, String string) {
            this.serviceState = mICRServiceState;
            this.rawData = string;
            int n = 2;
            int n2 = 12;
            this.errorEvent = new ErrorEvent((Object)POSSMICRServiceImp.this.eventCallback.getEventSource(), 111, 0, n, n2);
        }

        public void setErrorCode(int n, int n2) {
            int n3 = 2;
            int n4 = 12;
            this.errorEvent = new ErrorEvent((Object)POSSMICRServiceImp.this.eventCallback.getEventSource(), 111, 0, n3, n4);
        }

        public JposEvent getJposEvent() {
            return this.errorEvent;
        }

        public void doneFiring() {
            boolean[] blArray = POSSMICRServiceImp.this.firingComplete;
            synchronized (blArray) {
                POSSMICRServiceImp.this.firingComplete[0] = true;
                POSSMICRServiceImp.this.firingComplete.notifyAll();
            }
            switch (this.errorEvent.getErrorResponse()) {
                case 13: {
                    if (this.errorEvent.getErrorLocus() != 2) break;
                    POSSMICRServiceImp.this.eState = 2;
                    try {
                        POSSMICRServiceImp.this.clearInput();
                        this.serviceState.setState(2);
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    try {
                        POSSMICRServiceImp.this.eState = 2;
                        this.serviceState.setState(2);
                        POSSMICRServiceImp.this.clearInput();
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public void prepareToFire() {
            try {
                Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"prepareToFile", (String)"Prep ??");
                this.rawData = this.rawData.replace('T', 't').replace('A', 'o').replace('$', 'a');
                this.serviceState.setRawData(this.rawData);
                this.serviceState.setState(4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class POSSMICRDataEvent
    implements JposEventContainer,
    MICRConst {
        private DataEvent dataEvent = null;
        private MICRServiceState micrState = null;
        private String rawData = null;

        public POSSMICRDataEvent(MICRServiceState mICRServiceState, String string) {
            Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"POSSMICRDataEvent", (String)("MICR Dataevent ctor raw=" + string));
            this.micrState = mICRServiceState;
            this.rawData = string;
            this.dataEvent = new DataEvent((Object)POSSMICRServiceImp.this.eventCallback.getEventSource(), 0);
        }

        public JposEvent getJposEvent() {
            return this.dataEvent;
        }

        public void doneFiring() {
        }

        public void prepareToFire() {
            Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"prepareToFire", (String)"Entering prepareToFire");
            boolean bl = false;
            this.rawData = this.rawData.replace('T', 't').replace('A', 'o').replace('$', 'a');
            byte[] byArray = this.rawData.getBytes();
            int n = byArray.length;
            int n2 = 0;
            String string = new String("");
            int n3 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = true;
            POSSMICRServiceImp.this.onusData = "";
            Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"prepareToFire", (String)("Init properties " + this.rawData));
            try {
                this.micrState.setAccountNumber("");
                this.micrState.setAmount("");
                this.micrState.setBankNumber("");
                this.micrState.setEPC("");
                this.micrState.setRawData("");
                this.micrState.setSerialNumber("");
                this.micrState.setTransitNumber("");
                this.micrState.setBankNumber("");
                try {
                    this.micrState.setCheckType(POSSMICRServiceImp.this.type);
                    this.micrState.setCountryCode(99);
                }
                catch (JposException jposException) {
                    // empty catch block
                }
                this.micrState.setRawData(this.rawData);
                Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"prepareToFire", (String)"Setting properties");
                while (n3 < n) {
                    switch ((char)byArray[n3]) {
                        case 't': {
                            if (!bl6) {
                                bl6 = true;
                                bl3 = false;
                                this.micrState.setTransitNumber(string);
                                bl = true;
                                break;
                            }
                            bl6 = false;
                            bl3 = true;
                            break;
                        }
                        case 'o': {
                            if (!bl6) {
                                bl6 = true;
                                bl4 = false;
                                bl = false;
                                if (n2 > 0) {
                                    this.micrState.setSerialNumber(this.micrState.getAccountNumber());
                                    this.micrState.setAccountNumber(string);
                                } else {
                                    this.micrState.setAccountNumber(string);
                                }
                                ++n2;
                                break;
                            }
                            bl4 = true;
                            bl6 = false;
                            break;
                        }
                        case 'a': {
                            if (!bl6) {
                                bl6 = true;
                                bl2 = false;
                                this.micrState.setAmount(string);
                                break;
                            }
                            bl2 = true;
                            bl6 = false;
                            break;
                        }
                        default: {
                            string = string + (char)byArray[n3];
                            if (bl) {
                                POSSMICRServiceImp.this.onusData = POSSMICRServiceImp.this.onusData + String.valueOf((char)byArray[n3]);
                            }
                            if (!bl6) {
                                if (!bl5 || n2 != 0) break;
                                if (string.length() <= 5 && string.length() > 2 && (byArray[n3 + 1] == 32 || byArray[n3 + 1] == 45)) {
                                    this.micrState.setSerialNumber(string);
                                    bl5 = false;
                                    bl6 = true;
                                    break;
                                }
                                if (!bl5) break;
                                break;
                            }
                            if (byArray[n3 + 1] == 116 && byArray[n3] >= 48 && byArray[n3] <= 57) {
                                bl6 = true;
                                this.micrState.setEPC(string);
                                bl5 = false;
                                break;
                            }
                            if (byArray[n3] == 32 || byArray[n3] == 45) {
                                bl5 = false;
                                bl6 = true;
                                break;
                            }
                            bl5 = true;
                            bl6 = false;
                        }
                    }
                    if (bl6) {
                        string = "";
                    }
                    ++n3;
                }
                if (string.length() > 0) {
                    this.micrState.setSerialNumber(string);
                }
                this.readExceptionTable();
                Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"prepareToFire", (String)"Setting properties Successful");
            }
            catch (Exception exception) {
                Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"prepareToFire", (String)"Setting properties failed");
                POSSMICRErrorEvent pOSSMICRErrorEvent = new POSSMICRErrorEvent(this.micrState, this.rawData);
                try {
                    POSSMICRServiceImp.this.getEventQueueManager().postEvent((JposEventContainer)pOSSMICRErrorEvent);
                }
                catch (JposException jposException) {
                    Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"prepareToFire", (String)jposException.toString());
                }
            }
        }

        public void readExceptionTable() {
            String string = "";
            JposEntryInfo jposEntryInfo = POSSMICRServiceImp.this.getDeviceServiceState().getJposEntryInfo();
            int n = 0;
            while (true) {
                String string2 = "";
                String string3 = "exceptionTable" + n;
                String string4 = "";
                string2 = (String)jposEntryInfo.getPropertyValue(string3);
                if (string2 != null) {
                    string4 = string2.substring(1, 10);
                    if (string4.equals(this.micrState.getTransitNumber())) {
                        this.setExceptionTable(string2);
                        break;
                    }
                } else {
                    POSSMICRServiceImp.this.exceptionTFound = false;
                    break;
                }
                ++n;
            }
            try {
                if (POSSMICRServiceImp.this.exceptionTFound) {
                    String string5 = this.micrState.getAccountNumber();
                    if (POSSMICRServiceImp.this.format2) {
                        if (POSSMICRServiceImp.this.beginActIndex != -1 && POSSMICRServiceImp.this.endActIndex != -1 && POSSMICRServiceImp.this.endActIndex <= POSSMICRServiceImp.this.onusData.length()) {
                            this.micrState.setAccountNumber(POSSMICRServiceImp.this.onusData.substring(POSSMICRServiceImp.this.beginActIndex, POSSMICRServiceImp.this.endActIndex));
                        }
                        if (POSSMICRServiceImp.this.beginSerIndex != -1 && POSSMICRServiceImp.this.endSerIndex != -1 && POSSMICRServiceImp.this.endSerIndex <= POSSMICRServiceImp.this.onusData.length()) {
                            this.micrState.setSerialNumber(POSSMICRServiceImp.this.onusData.substring(POSSMICRServiceImp.this.beginSerIndex, POSSMICRServiceImp.this.endSerIndex));
                        }
                    } else {
                        if (POSSMICRServiceImp.this.spaces == 68) {
                            int n2 = 0;
                            while (n2 < string5.length()) {
                                if (string5.charAt(n2) != ' ') {
                                    string = string + string5.charAt(n2);
                                }
                                ++n2;
                            }
                        }
                        this.micrState.setCheckType(POSSMICRServiceImp.this.type);
                        this.micrState.setAccountNumber(string5.substring(Character.getNumericValue(POSSMICRServiceImp.this.skip)));
                        this.micrState.setBankNumber(POSSMICRServiceImp.this.transit.substring(4, 8));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setExceptionTable(String string) {
            string.toUpperCase();
            POSSMICRServiceImp.this.format2 = false;
            try {
                POSSMICRServiceImp.this.type = string.charAt(0);
                POSSMICRServiceImp.this.transit = string.substring(1, 10);
                POSSMICRServiceImp.this.spaces = string.charAt(10);
                if (string.charAt(11) >= '0' && string.charAt(11) <= '9') {
                    POSSMICRServiceImp.this.field = string.charAt(11);
                    POSSMICRServiceImp.this.skip = string.charAt(12);
                    POSSMICRServiceImp.this.size = string.charAt(13);
                    POSSMICRServiceImp.this.acc_rl = string.charAt(14);
                    if (POSSMICRServiceImp.this.acc_rl == 82 || POSSMICRServiceImp.this.acc_rl == 76) {
                        POSSMICRServiceImp.this.exceptionTFound = true;
                    }
                } else {
                    POSSMICRServiceImp.this.beginSerIndex = -1;
                    POSSMICRServiceImp.this.endSerIndex = -1;
                    POSSMICRServiceImp.this.beginActIndex = -1;
                    POSSMICRServiceImp.this.endActIndex = -1;
                    boolean bl = false;
                    boolean bl2 = false;
                    int n = 11;
                    while (n < string.length() && n <= 31) {
                        if (bl) {
                            if (string.charAt(n) != 'A') {
                                POSSMICRServiceImp.this.endActIndex = n - 11;
                                bl = false;
                            }
                        } else if (bl2 && string.charAt(n) != 'S') {
                            POSSMICRServiceImp.this.endSerIndex = n - 11;
                            bl2 = false;
                        }
                        if (string.charAt(n) == 'A' && POSSMICRServiceImp.this.endActIndex == -1 && !bl) {
                            POSSMICRServiceImp.this.beginActIndex = n - 11;
                            bl = true;
                        } else if (string.charAt(n) == 'S' && POSSMICRServiceImp.this.endSerIndex == -1 && !bl2) {
                            POSSMICRServiceImp.this.beginSerIndex = n - 11;
                            bl2 = true;
                        }
                        ++n;
                    }
                    if (bl) {
                        bl = false;
                        POSSMICRServiceImp.this.endActIndex = n - 11;
                    } else if (bl2) {
                        bl2 = false;
                        POSSMICRServiceImp.this.endSerIndex = n - 11;
                    }
                    if (POSSMICRServiceImp.this.beginActIndex != -1 && POSSMICRServiceImp.this.endActIndex != -1 || POSSMICRServiceImp.this.beginSerIndex != -1 && POSSMICRServiceImp.this.endSerIndex != -1) {
                        POSSMICRServiceImp.this.exceptionTFound = true;
                        POSSMICRServiceImp.this.format2 = true;
                    }
                }
                if (POSSMICRServiceImp.this.type == 66) {
                    POSSMICRServiceImp.this.type = 2;
                    POSSMICRServiceImp.this.exceptionTFound = true;
                } else if (POSSMICRServiceImp.this.type == 80) {
                    POSSMICRServiceImp.this.type = 1;
                    POSSMICRServiceImp.this.exceptionTFound = true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private class MICRListener
    implements PosmPrnDataAvailListener,
    PosmPrnStatusChangeListener,
    PosmPrnChaseCompleteListener,
    PosmPrnPrinterErrorListener {
        private MICRListener() {
        }

        public void posmPrnDataAvail(short s, short s2) {
            block12: {
                String string;
                Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"posmPrnDataAvail", (String)"Data Avail");
                byte[] byArray = new byte[400];
                int n = 0;
                try {
                    n = POSSMICRServiceImp.this.posDevice.read(byArray);
                    string = new String(byArray);
                    Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"posmPrnDataAvail", (String)("Data Avail read " + string));
                }
                catch (PosException posException) {
                    n = -1;
                    Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"posmPrnDataAvail", (String)"Data Avail didn't read");
                }
                string = new String(byArray, 0, n);
                POSSMICRServiceImp.this.goodMicrData.set(true);
                if (n < 3 || string.indexOf("?") != -1) {
                    Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"posmPrnDataAvail", (String)"Post Error");
                    POSSMICRErrorEvent pOSSMICRErrorEvent = null;
                    pOSSMICRErrorEvent = new POSSMICRErrorEvent(POSSMICRServiceImp.this.micrState, string);
                    try {
                        POSSMICRServiceImp.this.getEventQueueManager().postEvent((JposEventContainer)pOSSMICRErrorEvent);
                        POSSMICRServiceImp.this.eState = 4;
                    }
                    catch (Exception exception) {
                        if (POSSMICRServiceImp.this.debug.isOn()) {
                            exception.printStackTrace();
                        }
                        break block12;
                    }
                }
                POSSMICRServiceImp.this.eState = 2;
                Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"posmPrnDataAvail", (String)("Data Avail read=" + string));
                POSSMICRDataEvent pOSSMICRDataEvent = new POSSMICRDataEvent(POSSMICRServiceImp.this.micrState, string);
                try {
                    POSSMICRServiceImp.this.getEventQueueManager().postEvent((JposEventContainer)pOSSMICRDataEvent);
                }
                catch (JposException jposException) {
                    Tracer.trace((int)4, (String)POSSMICRServiceImp.className, (String)"posmPrnDataAvail", (String)jposException.toString());
                }
                MICRServiceState mICRServiceState = POSSMICRServiceImp.this.micrState;
                synchronized (mICRServiceState) {
                    if (POSSMICRServiceImp.this.micrState.getAutoDisable()) {
                        POSSMICRServiceImp.this.micrState.setDeviceEnabled(false);
                    }
                }
            }
        }

        public void posmPrnStatusChange(short s, int n) {
            POSSMICRServiceImp.this.setSemaphores();
        }

        public void posmPrnChaseComplete(short s, int n) {
            boolean[] blArray = POSSMICRServiceImp.this.chaseComplete;
            synchronized (blArray) {
                POSSMICRServiceImp.this.chaseComplete[POSSMICRServiceImp.this.jposStation((int)s)] = true;
                POSSMICRServiceImp.this.chaseComplete.notifyAll();
            }
        }

        public void posmPrnPrinterError(short s, int n) {
            block57: {
                int n2 = 0;
                int n3 = 0;
                String string = POSPrinterServiceMsg.UNKNOWN;
                int n4 = 0;
                if (s == -1) {
                    POSSMICRServiceImp.this.errorEventException = new JposException(111);
                    n2 = 2;
                    n3 = 2;
                    string = POSPrinterServiceMsg.DEVICE_WRITE_FAILURE;
                }
                if (s == 1) {
                    POSSMICRServiceImp.this.errorEventException = new JposException(114, 201);
                    n2 = 2;
                    n3 = 2;
                    string = POSPrinterServiceMsg.COVER_OPEN;
                } else if (s == 2) {
                    n2 = 2;
                    n3 = 2;
                    string = POSPrinterServiceMsg.TRANSPORT_ERROR;
                } else if (s == 3) {
                    n2 = 2;
                    n3 = 2;
                    string = POSPrinterServiceMsg.PRINT_HEAD_OPEN;
                } else if (s == 4) {
                    n2 = 2;
                    n3 = 1;
                    string = POSPrinterServiceMsg.JOURNAL_PAPER_ERROR;
                } else if (s == 5) {
                    n2 = 2;
                    n3 = 1;
                    string = POSPrinterServiceMsg.JOURNAL_PRINT_HEAD_OPEN;
                } else if (s == 8) {
                    n2 = 2;
                    n3 = 4;
                    string = POSPrinterServiceMsg.DOCUMENT_INSERTED;
                } else if (s == 16) {
                    POSSMICRServiceImp.this.errorEventException = new JposException(114, 204);
                    n2 = 2;
                    n3 = 4;
                    string = POSPrinterServiceMsg.DOCUMENT_NOT_INSERTED;
                } else if (s == 32) {
                    POSSMICRServiceImp.this.errorEventException = new JposException(114, 204);
                    n2 = 2;
                    n3 = 4;
                    string = POSPrinterServiceMsg.DOCUMENT_NOT_READY;
                } else if (s == 64) {
                    POSSMICRServiceImp.this.errorEventException = new JposException(114, 205);
                    n2 = 2;
                    n3 = 4;
                    string = POSPrinterServiceMsg.DOCUMENT_NOT_EJECTED;
                } else if (s == 128) {
                    n2 = 2;
                    n3 = 4;
                    string = POSPrinterServiceMsg.MICR_ERROR;
                } else if (s == 256) {
                    n2 = 2;
                    n3 = 2;
                    string = POSPrinterServiceMsg.PAPER_ERROR;
                } else if (s == 512) {
                    n2 = 2;
                    n3 = 2;
                    string = POSPrinterServiceMsg.EEPROM_LOAD_ERROR;
                } else if (s == 1024) {
                    n2 = 2;
                    n3 = 2;
                    string = POSPrinterServiceMsg.EEPROM_FULL;
                } else if (s == 4096) {
                    n2 = 2;
                    n3 = 2;
                    string = POSPrinterServiceMsg.INTERNAL_COMMUNICATION_ERROR;
                } else if (s == 8192) {
                    n2 = 2;
                    n3 = 4;
                    string = POSPrinterServiceMsg.SLIP_FEED_ERROR;
                } else if (s == 16384) {
                    n2 = 3;
                    n3 = 2;
                    string = POSPrinterServiceMsg.STARTUP_ERROR;
                } else if (s == 16385) {
                    n2 = 3;
                    n3 = 2;
                    string = POSPrinterServiceMsg.UNRECOVERABLE_ERROR;
                } else if (s == Short.MIN_VALUE) {
                    n2 = 2;
                    n3 = 2;
                    string = POSPrinterServiceMsg.COMMAND_REJECTED;
                }
                if (!POSSMICRServiceImp.this.micrState.getAsyncMode()) {
                    int n5 = 0;
                    try {
                        POSSMICRServiceImp.this.posDevice.ioctl(4903);
                    }
                    catch (Exception exception) {
                        n5 = -1;
                    }
                    if (n5 != 0) {
                        try {
                            POSSMICRServiceImp.this.posDevice.ioctl(4908);
                        }
                        catch (Exception exception) {
                            n5 = -1;
                        }
                    }
                    return;
                }
                POSSMICRErrorEvent pOSSMICRErrorEvent = null;
                try {
                    POSSMICRServiceImp.this.micrState.setState(4);
                    pOSSMICRErrorEvent = new POSSMICRErrorEvent(POSSMICRServiceImp.this.micrState, " ");
                    POSSMICRServiceImp.this.firingComplete[0] = false;
                    boolean[] blArray = POSSMICRServiceImp.this.firingComplete;
                    synchronized (blArray) {
                        POSSMICRServiceImp.this.getEventQueueManager().postEvent((JposEventContainer)pOSSMICRErrorEvent);
                        POSSMICRServiceImp.this.firingComplete.wait();
                    }
                    if (!POSSMICRServiceImp.this.firingComplete[0]) {
                        n4 = 12;
                    }
                    if (n4 == 0) {
                        n4 = ((ErrorEvent)pOSSMICRErrorEvent.getJposEvent()).getErrorResponse();
                    }
                    if (n4 == 12) {
                        int n6 = 0;
                        try {
                            POSSMICRServiceImp.this.posDevice.ioctl(4903);
                        }
                        catch (Exception exception) {
                            n6 = -1;
                        }
                        if (n6 != 0) {
                            try {
                                POSSMICRServiceImp.this.posDevice.ioctl(4908);
                            }
                            catch (PosException posException) {
                                n6 = -1;
                            }
                        }
                        break block57;
                    }
                    try {
                        POSSMICRServiceImp.this.posDevice.ioctl(4904);
                    }
                    catch (PosException posException) {
                        int n7 = -1;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

