/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import com.ibm.jpos.util.Timerable;

public final class Timer
implements Runnable {
    private Thread timerThread = new Thread(this);
    private Timerable timerable = null;
    private long time = 0L;
    private long timeLeft = 0L;
    private boolean started = false;
    private boolean timerReset = false;
    private Object waitObj = new Object();

    public Timer(Timerable timerable) {
        this.setTimerable(timerable);
        this.timerThread.setPriority(10);
        this.timerThread.start();
    }

    public Timer(Timerable timerable, int n) throws IllegalArgumentException {
        this(timerable);
        this.setTime(n);
    }

    public void run() {
        while (true) {
            long l = 0L;
            long l2 = 0L;
            boolean bl = false;
            this.timerReset = false;
            while (!this.started) {
                Object object = this.waitObj;
                synchronized (object) {
                    try {
                        this.waitObj.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            try {
                l = System.currentTimeMillis();
                Thread.sleep(this.timeLeft);
            }
            catch (InterruptedException interruptedException) {
                if (this.timerReset) {
                    this.timeLeft = this.time;
                } else {
                    l2 = System.currentTimeMillis();
                    this.timeLeft -= l2 - l;
                }
                bl = true;
            }
            if (bl) continue;
            this.timeLeft = 0L;
            this.started = false;
            this.timerable.timerExpired();
        }
    }

    public synchronized void start() {
        this.started = true;
        Object object = this.waitObj;
        synchronized (object) {
            this.waitObj.notifyAll();
        }
    }

    public synchronized void stop() {
        if (this.timerThread.isAlive()) {
            this.timerThread.interrupt();
        }
    }

    public synchronized void reset() {
        this.timerReset = true;
        this.stop();
    }

    public synchronized void setTime(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.timeLeft = this.time = (long)n;
    }

    public synchronized boolean getStarted() {
        return this.started;
    }

    public synchronized long getTimeLeft() {
        return this.timeLeft;
    }

    public synchronized long getTime() {
        return this.time;
    }

    private void setTimerable(Timerable timerable) {
        this.timerable = timerable;
    }
}

