/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.poss;

import com.ibm.poss.Device;
import com.ibm.poss.DeviceEventListener;
import com.ibm.poss.Errno;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosDevice;
import com.ibm.poss.PosException;
import com.ibm.poss.PosQMsg;
import com.ibm.poss.PosScaleData;
import com.ibm.poss.PosSubsystem;
import java.util.Enumeration;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class DeviceConnection
implements Device,
Errno,
PosDef {
    private static boolean trace = false;
    private static boolean debug = false;
    private static final boolean assert = true;
    private static Vector deviceConnectionVector;
    private Vector clientPosDeviceVector = new Vector();
    private DeviceEventListener deviceEventListener = new DeviceEventListenerImpl();
    private int defaultCodePage = -1;
    private int posNdeviceNumber = -1;
    private int posNslotNumber = -1;
    private int posNportNumber = -1;
    private boolean posNcompositeDevice = false;
    private boolean posNlockableDevice = false;
    private boolean posNshareableDevice = false;
    private boolean online = false;
    private int descriptor = -1;

    DeviceConnection(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws PosException {
        this.descriptor = n;
        this.posNdeviceNumber = n2;
        this.posNslotNumber = n3;
        this.posNportNumber = n4;
        this.posNcompositeDevice = n5 != 0;
        this.posNlockableDevice = n6 != 0;
        this.posNshareableDevice = n7 != 0;
        this.defaultCodePage = DeviceConnection.getCodePage(n);
        this.online = true;
    }

    synchronized int getDefaultCodePage() {
        if (trace) {
            System.err.println("--> Entry: DeviceConnection.getDefaultCodePage");
            System.err.println("<-- Exit : DeviceConnection.getDefaultCodePage");
        }
        return this.defaultCodePage;
    }

    synchronized int getCodePage() throws PosException {
        return DeviceConnection.getCodePage(this.descriptor);
    }

    private static synchronized int getCodePage(int n) throws PosException {
        int n2 = -1;
        PosArg[] posArgArray = new PosArg[]{new PosArg("displayCodePage", n2)};
        PosSubsystem.ioctl(n, 302, posArgArray, 1);
        n2 = (Integer)posArgArray[0].getValue();
        switch (n2) {
            case 0: {
                n2 = 437;
                break;
            }
            case 1: {
                n2 = 897;
                break;
            }
            case 2: {
                n2 = 858;
                break;
            }
            case 3: {
                n2 = 852;
                break;
            }
            case 4: {
                n2 = 855;
                break;
            }
            case 5: {
                n2 = 857;
                break;
            }
            case 6: {
                n2 = 862;
                break;
            }
            case 7: {
                n2 = 863;
                break;
            }
            case 8: {
                n2 = 864;
                break;
            }
            case 9: {
                n2 = 865;
                break;
            }
            case 10: {
                n2 = 866;
                break;
            }
            case 11: {
                n2 = 869;
                break;
            }
            case 128: {
                n2 = 932;
                break;
            }
            case 144: {
                n2 = 949;
                break;
            }
            case 160: {
                n2 = 950;
                break;
            }
            case 176: {
                n2 = 1381;
                break;
            }
            case -1: {
                posArgArray[0].setName("codePage");
                PosSubsystem.ioctl(n, 302, posArgArray, 1);
                n2 = (Integer)posArgArray[0].getValue();
            }
        }
        return n2;
    }

    synchronized void setCodePage(int n) throws PosException {
        PosArg[] posArgArray = new PosArg[]{new PosArg("codePage", n)};
        PosSubsystem.ioctl(this.descriptor, 305, posArgArray, 1);
        int n2 = -1;
        switch (n) {
            case 437: {
                n2 = 0;
                break;
            }
            case 897: {
                n2 = 1;
                break;
            }
            case 850: 
            case 858: {
                n2 = 2;
                break;
            }
            case 852: {
                n2 = 3;
                break;
            }
            case 855: {
                n2 = 4;
                break;
            }
            case 857: {
                n2 = 5;
                break;
            }
            case 862: {
                n2 = 6;
                break;
            }
            case 863: {
                n2 = 7;
                break;
            }
            case 864: {
                n2 = 8;
                break;
            }
            case 865: {
                n2 = 9;
                break;
            }
            case 866: {
                n2 = 10;
                break;
            }
            case 869: {
                n2 = 11;
                break;
            }
            case 301: 
            case 932: {
                n2 = 128;
                break;
            }
            case 949: 
            case 951: 
            case 1088: {
                n2 = 144;
                break;
            }
            case 950: {
                n2 = 160;
                break;
            }
            case 1381: {
                n2 = 176;
            }
        }
        if (n2 != -1) {
            posArgArray[0].setName("displayCodePage");
            posArgArray[0].setValue(n2);
            PosSubsystem.ioctl(this.descriptor, 305, posArgArray, 1);
        }
    }

    synchronized void close(PosDevice posDevice) throws PosException {
        if (trace) {
            System.err.println("--> Entry: DeviceConnection.close");
        }
        Vector vector = deviceConnectionVector;
        synchronized (vector) {
            try {
                this.releaseDevice(posDevice);
            }
            catch (PosException posException) {
                // empty catch block
            }
            posDevice.setAcquired(false);
            this.clientPosDeviceVector.removeElement(posDevice);
            if (this.clientPosDeviceVector.isEmpty()) {
                PosSubsystem.removeDeviceEventListener(this.deviceEventListener);
                deviceConnectionVector.removeElement(this);
                try {
                    PosSubsystem.close(this.descriptor);
                }
                catch (PosException posException) {
                    // empty catch block
                }
                this.descriptor = -1;
            }
        }
        if (trace) {
            System.err.println("<-- Exit : DeviceConnection.close");
        }
    }

    synchronized void ioctl(PosDevice posDevice, int n, PosArg[] posArgArray, int n2) throws PosException {
        if (trace) {
            System.err.println("--> Entry: DeviceConnection.ioctl");
        }
        if (trace) {
            System.err.print("\tDeviceConnection.ioctl: request == ");
        }
        switch (n) {
            case 301: {
                if (trace) {
                    System.err.println("POS_SYS_ACQUIRE_DEVICE");
                }
                if (!this.online) {
                    throw new PosException(317, "PosIOCtl == -1, errno == 317");
                }
                this.acquireDevice(posDevice);
                break;
            }
            case 304: {
                if (trace) {
                    System.err.println("POS_SYS_RELEASE_DEVICE");
                }
                this.releaseDevice(posDevice);
                break;
            }
            case 303: {
                if (trace) {
                    System.err.println("POS_SYS_LOCK_DEVICE");
                }
                this.lockDevice(posDevice);
                break;
            }
            case 306: {
                if (trace) {
                    System.err.println("POS_SYS_UNLOCK_DEVICE");
                }
                if (!this.online) {
                    throw new PosException(317, "PosIOCtl == -1, errno == 317");
                }
                this.unlockDevice(posDevice);
                break;
            }
            default: {
                if (trace) {
                    System.err.println(n);
                }
                if (!this.online) {
                    throw new PosException(317, "PosIOCtl == -1, errno == 317");
                }
                PosSubsystem.ioctl(this.descriptor, n, posArgArray, n2);
            }
        }
        if (trace) {
            System.err.println("<-- Exit : DeviceConnection.ioctl");
        }
    }

    static synchronized DeviceConnection open(PosDevice posDevice, String string, String string2, PosArg[] posArgArray) throws PosException {
        Vector vector;
        if (trace) {
            System.err.println("--> Entry: DeviceConnection.open");
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        PosArg posArg = null;
        String string3 = null;
        int n7 = 0;
        int n8 = posArgArray.length;
        while (n7 < n8) {
            posArg = posArgArray[n7];
            string3 = posArg.getName();
            if (string3.equals("deviceNumber")) {
                try {
                    n = (Integer)posArg.getValue();
                }
                catch (ClassCastException classCastException) {
                    throw new PosException(307, "PosOpen == -1, errno == 307");
                }
            }
            if (string3.equals("slotNumber")) {
                try {
                    n2 = (Integer)posArg.getValue();
                }
                catch (ClassCastException classCastException) {
                    throw new PosException(326, "PosOpen == -1, errno == 326");
                }
            }
            if (string3.equals("portNumber")) {
                try {
                    n3 = (Integer)posArg.getValue();
                }
                catch (ClassCastException classCastException) {
                    throw new PosException(328, "PosOpen == -1, errno == 328");
                }
            }
            if (string3.equals("shareableDevice")) {
                try {
                    n4 = (Integer)posArg.getValue();
                }
                catch (ClassCastException classCastException) {
                    throw new PosException(399, "PosOpen == -1, errno == 399");
                }
            }
            if (string3.equals("compositeDevice")) {
                try {
                    n5 = (Integer)posArg.getValue();
                }
                catch (ClassCastException classCastException) {
                    throw new PosException(398, "PosOpen == -1, errno == 398");
                }
            }
            if (string3.equals("lockableDevice")) {
                try {
                    n6 = (Integer)posArg.getValue();
                }
                catch (ClassCastException classCastException) {
                    throw new PosException(397, "PosOpen == -1, errno == 397");
                }
            }
            ++n7;
        }
        if (trace) {
            System.out.println("Checking online...");
        }
        int n9 = 16;
        while (n9 > 0) {
            if (PosSubsystem.isDeviceOnline(n, n2, n3)) {
                if (!trace) break;
                System.out.println("Device is online");
                break;
            }
            try {
                if (trace) {
                    System.out.println("Device is offline");
                }
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --n9;
        }
        if (!PosSubsystem.isDeviceOnline(n, n2, n3)) {
            throw new PosException(317, "PosOpen == -1, errno == 317");
        }
        DeviceConnection deviceConnection = null;
        if (n5 != 0) {
            vector = deviceConnectionVector;
            synchronized (vector) {
                Enumeration enumeration = deviceConnectionVector.elements();
                while (enumeration.hasMoreElements()) {
                    deviceConnection = (DeviceConnection)enumeration.nextElement();
                    if (deviceConnection.posNdeviceNumber == n && deviceConnection.posNslotNumber == n2 && deviceConnection.posNportNumber == n3 && deviceConnection.posNcompositeDevice) break;
                    deviceConnection = null;
                }
            }
        }
        if (n4 != 0) {
            vector = deviceConnectionVector;
            synchronized (vector) {
                Enumeration enumeration = deviceConnectionVector.elements();
                while (enumeration.hasMoreElements()) {
                    deviceConnection = (DeviceConnection)enumeration.nextElement();
                    if (deviceConnection.posNdeviceNumber == n && deviceConnection.posNslotNumber == n2 && deviceConnection.posNportNumber == n3 && deviceConnection.posNshareableDevice) break;
                    deviceConnection = null;
                }
            }
        }
        if (deviceConnection == null) {
            int n10 = PosSubsystem.open(string, string2, posArgArray);
            deviceConnection = new DeviceConnection(n10, n, n2, n3, n5, n6, n4);
            deviceConnectionVector.addElement(deviceConnection);
            PosSubsystem.addDeviceEventListener(deviceConnection.deviceEventListener);
        }
        deviceConnection.clientPosDeviceVector.addElement(posDevice);
        PosQMsg posQMsg = PosSubsystem.getOnlinePosQMsg(n, n2, n3);
        if (posQMsg != null) {
            posDevice.deviceEventOccurred(posQMsg);
        }
        if (trace) {
            System.err.println("<-- Exit : DeviceConnection.open");
        }
        return deviceConnection;
    }

    synchronized int read(PosDevice posDevice, byte[] byArray) throws PosException {
        if (trace) {
            System.err.println("--> Entry: DeviceConnection.read");
        }
        if (!this.online) {
            throw new PosException(317, "PosRead == -1, errno == 317");
        }
        int n = PosSubsystem.read(this.descriptor, byArray);
        if (trace) {
            System.err.println("<-- Exit : DeviceConnection.read");
        }
        return n;
    }

    synchronized int read(PosDevice posDevice, PosScaleData posScaleData) throws PosException {
        if (trace) {
            System.err.println("--> Entry: DeviceConnection.read");
        }
        if (!this.online) {
            throw new PosException(317, "PosRead == -1, errno == 317");
        }
        int n = PosSubsystem.read(this.descriptor, posScaleData);
        if (trace) {
            System.err.println("<-- Exit : DeviceConnection.read");
        }
        return n;
    }

    synchronized int write(PosDevice posDevice, byte[] byArray, int n) throws PosException {
        if (trace) {
            System.err.println("--> Entry: DeviceConnection.write");
        }
        if (!this.online) {
            throw new PosException(317, "PosWrite == -1, errno == 317");
        }
        int n2 = PosSubsystem.write(this.descriptor, byArray, n);
        if (trace) {
            System.err.println("<-- Exit : DeviceConnection.write");
        }
        return n2;
    }

    synchronized int write(PosDevice posDevice, String string) throws PosException {
        if (trace) {
            System.err.println("--> Entry: DeviceConnection.write");
        }
        if (!this.online) {
            throw new PosException(317, "PosWrite == -1, errno == 317");
        }
        int n = PosSubsystem.write(this.descriptor, string);
        if (trace) {
            System.err.println("<-- Exit : DeviceConnection.write");
        }
        return n;
    }

    private void acquireDevice(PosDevice posDevice) throws PosException {
        if (trace) {
            System.err.println("--> Entry: DeviceConnection.acquireDevice");
        }
        if (posDevice.isAcquired()) {
            throw new PosException(314, "PosIOCtl == -1, errno == 314");
        }
        if (!PosSubsystem.isDeviceOnline(this.posNdeviceNumber, this.posNslotNumber, this.posNportNumber)) {
            throw new PosException(317, "PosIOCtl == -1, errno == 317");
        }
        PosDevice posDevice2 = null;
        boolean bl = true;
        Vector vector = this.clientPosDeviceVector;
        synchronized (vector) {
            Enumeration enumeration = this.clientPosDeviceVector.elements();
            while (enumeration.hasMoreElements()) {
                posDevice2 = (PosDevice)enumeration.nextElement();
                if (!posDevice2.isAcquired()) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            if (trace) {
                System.err.println("\tDeviceConnection.acquireDevice: acquiring device");
            }
            PosSubsystem.ioctl(this.descriptor, 301, null, 0);
        } else if (trace) {
            System.err.println("\tDeviceConnection.acquireDevice: device already acquired");
        }
        posDevice.setAcquired(true);
        this.lockDevice(posDevice);
        if (trace) {
            System.err.println("--> Exit : DeviceConnection.acquireDevice");
        }
    }

    private void lockDevice(PosDevice posDevice) throws PosException {
        if (trace) {
            System.err.println("--> Entry: DeviceConnection.lockDevice");
        }
        if (!posDevice.isAcquired()) {
            throw new PosException(315, "PosIOCtl == -1, errno == 315");
        }
        if (this.posNlockableDevice) {
            boolean bl = true;
            PosDevice posDevice2 = null;
            Enumeration enumeration = this.clientPosDeviceVector.elements();
            while (enumeration.hasMoreElements()) {
                posDevice2 = (PosDevice)enumeration.nextElement();
                if (posDevice2 == posDevice || !posDevice2.isUnlocked()) continue;
                bl = false;
                break;
            }
            if (bl) {
                if (trace) {
                    System.err.println("\tDeviceConnection.lockDevice: locking device");
                }
                try {
                    PosSubsystem.ioctl(this.descriptor, 303, null, 0);
                }
                catch (PosException posException) {}
            } else if (trace) {
                System.err.println("\tDeviceConnection.lockDevice: device already locked");
            }
        } else if (trace) {
            System.err.println("\tDeviceConnection.lockDevice: virtual-only lock of non-lockable device");
        }
        posDevice.setUnlocked(false);
        if (trace) {
            System.err.println("<-- Exit : DeviceConnection.lockDevice");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void unlockDevice(PosDevice var1_1) throws PosException {
        if (DeviceConnection.trace) {
            System.err.println("--> Entry: DeviceConnection.unlockDevice");
        }
        if (!var1_1.isAcquired()) {
            throw new PosException(315, "PosIOCtl == -1, errno == 315");
        }
        if (this.posNlockableDevice) {
            try {
                if (DeviceConnection.trace) {
                    System.err.println("\tDeviceConnection.unlockDevice: unlocking device");
                }
                PosSubsystem.ioctl(this.descriptor, 306, null, 0);
            }
            catch (PosException var2_2) {
                if (var2_2.getErrorCode() == 316) ** GOTO lbl16
                throw var2_2;
            }
        } else if (DeviceConnection.trace) {
            System.err.println("\tDeviceConnection.unlockDevice: virtual-only unlock of non-lockable device");
        }
lbl16:
        // 5 sources

        var1_1.setUnlocked(true);
        if (DeviceConnection.trace) {
            System.err.println("<-- Exit : DeviceConnection.unlockDevice");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void releaseDevice(PosDevice var1_1) throws PosException {
        if (DeviceConnection.trace) {
            System.err.println("--> Entry: DeviceConnection.releaseDevice");
        }
        if (!var1_1.isAcquired()) {
            throw new PosException(315, "PosIOCtl == -1, errno == 315");
        }
        this.lockDevice(var1_1);
        var2_2 = true;
        var3_3 = null;
        var4_4 = this.clientPosDeviceVector.elements();
        while (var4_4.hasMoreElements()) {
            var3_3 = (PosDevice)var4_4.nextElement();
            if (var3_3 == var1_1 || !var3_3.isAcquired()) continue;
            var2_2 = false;
            break;
        }
        if (var2_2) {
            if (DeviceConnection.trace) {
                System.err.println("\tDeviceConnection.releaseDevice: releasing device");
            }
            try {
                PosSubsystem.ioctl(this.descriptor, 304, null, 0);
            }
            catch (PosException var5_5) {
                if (var5_5.getErrorCode() == 317) ** GOTO lbl25
                throw var5_5;
            }
        } else if (DeviceConnection.trace) {
            System.err.println("\tDeviceConnection.releaseDevice: device acquired by other(s), not releasing.");
        }
lbl25:
        // 5 sources

        var1_1.setAcquired(false);
        if (DeviceConnection.trace) {
            System.err.println("<-- Exit : DeviceConnection.releaseDevice");
        }
    }

    static {
        if (!System.getProperty("TracePosSubsystem", "false").equals("false")) {
            trace = true;
        }
        if (!System.getProperty("DebugPosSubsystem", "false").equals("false")) {
            debug = true;
            trace = true;
        }
        if (trace) {
            System.err.println("--> Entry: DeviceConnection.static");
        }
        if (trace) {
            System.err.println("<-- Exit : DeviceConnection.static");
        }
        deviceConnectionVector = new Vector();
    }

    private class DeviceEventListenerImpl
    implements DeviceEventListener {
        private DeviceEventListenerImpl() {
        }

        public void deviceEventOccurred(PosQMsg posQMsg) {
            Object object;
            Object object2;
            int n;
            if (trace) {
                System.err.println("--> Entry: DeviceConnection$DeviceEventListenerImpl.deviceEventOccurred");
            }
            if ((n = posQMsg.getMsg()) == 16909 || n == 16908) {
                DeviceConnection.this.online = n == 16909;
            }
            if (n == 16909) {
                boolean bl = true;
                object2 = DeviceConnection.this.clientPosDeviceVector.elements();
                while (object2.hasMoreElements()) {
                    if (!((PosDevice)object2.nextElement()).isAcquired()) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    try {
                        PosSubsystem.ioctl(DeviceConnection.this.descriptor, 304, null, 0);
                    }
                    catch (PosException posException) {
                        // empty catch block
                    }
                }
                if (DeviceConnection.this.posNlockableDevice) {
                    try {
                        object = this;
                        synchronized (object) {
                            boolean bl2 = true;
                            PosDevice posDevice = null;
                            Enumeration enumeration = DeviceConnection.this.clientPosDeviceVector.elements();
                            while (enumeration.hasMoreElements()) {
                                posDevice = (PosDevice)enumeration.nextElement();
                                if (!posDevice.isUnlocked()) continue;
                                PosSubsystem.ioctl(DeviceConnection.this.descriptor, 306, null, 0);
                                bl2 = false;
                                break;
                            }
                            if (bl2) {
                                PosSubsystem.ioctl(DeviceConnection.this.descriptor, 303, null, 0);
                            }
                        }
                    }
                    catch (PosException posException) {
                        // empty catch block
                    }
                }
            }
            PosDevice posDevice = null;
            object2 = DeviceConnection.this.clientPosDeviceVector;
            synchronized (object2) {
                object = DeviceConnection.this.clientPosDeviceVector.elements();
                while (object.hasMoreElements()) {
                    posDevice = (PosDevice)object.nextElement();
                    try {
                        posDevice.deviceEventOccurred(posQMsg);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (trace) {
                System.err.println("<-- Exit : DeviceConnection$DeviceEventListenerImpl.deviceEventOccurred");
            }
        }

        public int getPosNdeviceNumber() {
            if (trace) {
                System.err.println("--> Entry: DeviceConnection$DeviceEventListenerImpl.getPosNdeviceNumber");
                System.err.println("<-- Exit : DeviceConnection$DeviceEventListenerImpl.getPosNdeviceNumber");
            }
            return DeviceConnection.this.posNdeviceNumber;
        }

        public int getPosNslotNumber() {
            if (trace) {
                System.err.println("--> Entry: DeviceConnection$DeviceEventListenerImpl.getPosNslotNumber");
                System.err.println("<-- Exit : DeviceConnection$DeviceEventListenerImpl.getPosNslotNumber");
            }
            return DeviceConnection.this.posNslotNumber;
        }

        public int getPosNportNumber() {
            if (trace) {
                System.err.println("--> Entry: DeviceConnection$DeviceEventListenerImpl.getPosNportNumber");
                System.err.println("<-- Exit : DeviceConnection$DeviceEventListenerImpl.getPosNportNumber");
            }
            return DeviceConnection.this.posNportNumber;
        }

        public int getDescriptor() {
            if (trace) {
                System.err.println("--> Entry: DeviceConnection$DeviceEventListenerImpl.getDescriptor");
                System.err.println("<-- Exit : DeviceConnection$DeviceEventListenerImpl.getDescriptor");
            }
            return DeviceConnection.this.descriptor;
        }
    }
}

