/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.usb4java;

import de.ailis.usb4java.AbstractDevice;
import de.ailis.usb4java.Config;
import de.ailis.usb4java.Services;
import de.ailis.usb4java.libusb.DeviceHandle;
import de.ailis.usb4java.libusb.LibUsb;
import de.ailis.usb4java.libusb.LibUsbException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.usb.UsbControlIrp;
import javax.usb.UsbException;
import javax.usb.UsbIrp;
import javax.usb.UsbShortPacketException;

abstract class AbstractIrpQueue<T extends UsbIrp> {
    private final Queue<T> irps = new ConcurrentLinkedQueue<T>();
    private Thread processor;
    private final AbstractDevice device;

    AbstractIrpQueue(AbstractDevice device) {
        if (device == null) {
            throw new IllegalArgumentException("device must be set");
        }
        this.device = device;
    }

    public final void add(T irp) {
        this.irps.add(irp);
        if (this.processor == null) {
            this.processor = new Thread(new Runnable(){

                @Override
                public void run() {
                    AbstractIrpQueue.this.process();
                }
            });
            this.processor.setDaemon(true);
            this.processor.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void process() {
        UsbIrp irp = (UsbIrp)this.irps.poll();
        while (irp != null) {
            try {
                this.processIrp(irp);
            }
            catch (UsbException e) {
                irp.setUsbException(e);
            }
            UsbIrp nextIrp = (UsbIrp)this.irps.poll();
            if (nextIrp == null) {
                this.processor = null;
            }
            irp.complete();
            this.finishIrp(irp);
            irp = nextIrp;
        }
        this.processor = null;
        Queue<T> queue = this.irps;
        synchronized (queue) {
            this.irps.notifyAll();
        }
    }

    protected abstract void processIrp(T var1) throws UsbException;

    protected abstract void finishIrp(UsbIrp var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abort() {
        this.irps.clear();
        while (this.isBusy()) {
            try {
                Queue<T> queue = this.irps;
                synchronized (queue) {
                    if (this.isBusy()) {
                        this.irps.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public final boolean isBusy() {
        return !this.irps.isEmpty() || this.processor != null;
    }

    protected final Config getConfig() {
        return Services.getInstance().getConfig();
    }

    protected final AbstractDevice getDevice() {
        return this.device;
    }

    protected final void processControlIrp(UsbControlIrp irp) throws UsbException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(irp.getLength());
        buffer.put(irp.getData(), irp.getOffset(), irp.getLength());
        buffer.rewind();
        DeviceHandle handle = this.getDevice().open();
        int result = LibUsb.controlTransfer(handle, irp.bmRequestType(), irp.bRequest(), irp.wValue(), irp.wIndex(), buffer, this.getConfig().getTimeout());
        if (result < 0) {
            throw new LibUsbException("Unable to submit control message", result);
        }
        buffer.rewind();
        buffer.get(irp.getData(), irp.getOffset(), result);
        irp.setActualLength(result);
        if (irp.getActualLength() != irp.getLength() && !irp.getAcceptShortPacket()) {
            throw new UsbShortPacketException();
        }
    }
}

