/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.usb4java;

import de.ailis.usb4java.Interface;
import de.ailis.usb4java.Pipe;
import de.ailis.usb4java.descriptors.SimpleUsbEndpointDescriptor;
import de.ailis.usb4java.libusb.EndpointDescriptor;
import javax.usb.UsbEndpoint;
import javax.usb.UsbEndpointDescriptor;
import javax.usb.UsbPipe;

final class Endpoint
implements UsbEndpoint {
    private final Interface iface;
    private final UsbEndpointDescriptor descriptor;
    private final Pipe pipe;

    Endpoint(Interface iface, EndpointDescriptor descriptor) {
        this.iface = iface;
        this.descriptor = new SimpleUsbEndpointDescriptor(descriptor);
        this.pipe = new Pipe(this);
    }

    @Override
    public Interface getUsbInterface() {
        return this.iface;
    }

    @Override
    public UsbEndpointDescriptor getUsbEndpointDescriptor() {
        return this.descriptor;
    }

    @Override
    public byte getDirection() {
        byte address = this.descriptor.bEndpointAddress();
        return (byte)(address & 0xFFFFFF80);
    }

    @Override
    public byte getType() {
        byte attribs = this.descriptor.bmAttributes();
        return (byte)(attribs & 3);
    }

    @Override
    public UsbPipe getUsbPipe() {
        return this.pipe;
    }
}

