/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.usb4java;

import de.ailis.usb4java.AbstractIrpQueue;
import de.ailis.usb4java.Endpoint;
import de.ailis.usb4java.Pipe;
import de.ailis.usb4java.libusb.DeviceHandle;
import de.ailis.usb4java.libusb.LibUsb;
import de.ailis.usb4java.libusb.LibUsbException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.usb.UsbControlIrp;
import javax.usb.UsbEndpointDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbIrp;
import javax.usb.UsbShortPacketException;

final class IrpQueue
extends AbstractIrpQueue<UsbIrp> {
    private final Pipe pipe;

    IrpQueue(Pipe pipe) {
        super(pipe.getDevice());
        this.pipe = pipe;
    }

    @Override
    protected void finishIrp(UsbIrp irp) {
        this.pipe.sendEvent(irp);
    }

    @Override
    protected void processIrp(UsbIrp irp) throws UsbException {
        Endpoint endpoint = this.pipe.getUsbEndpoint();
        byte direction = endpoint.getDirection();
        byte type = endpoint.getType();
        if (type == 0) {
            this.processControlIrp((UsbControlIrp)irp);
            return;
        }
        switch (direction) {
            case 0: {
                irp.setActualLength(this.write(irp.getData(), irp.getOffset(), irp.getLength()));
                if (irp.getActualLength() >= irp.getLength() || irp.getAcceptShortPacket()) break;
                throw new UsbShortPacketException();
            }
            case -128: {
                irp.setActualLength(this.read(irp.getData(), irp.getOffset(), irp.getLength()));
                if (irp.getActualLength() >= irp.getLength() || irp.getAcceptShortPacket()) break;
                throw new UsbShortPacketException();
            }
            default: {
                throw new UsbException("Invalid direction: " + direction);
            }
        }
    }

    private UsbEndpointDescriptor getEndpointDescriptor() {
        return this.pipe.getUsbEndpoint().getUsbEndpointDescriptor();
    }

    private int read(byte[] data, int offset, int len) throws UsbException {
        int read;
        int result;
        UsbEndpointDescriptor descriptor = this.getEndpointDescriptor();
        byte type = this.pipe.getUsbEndpoint().getType();
        DeviceHandle handle = this.getDevice().open();
        for (read = 0; read < len; read += result) {
            int size = Math.min(len - read, descriptor.wMaxPacketSize() & 0xFFFF);
            ByteBuffer buffer = ByteBuffer.allocateDirect(size);
            result = this.transfer(handle, descriptor, type, buffer);
            buffer.rewind();
            buffer.get(data, offset + read, result);
            if (result >= size) continue;
            break;
        }
        return read;
    }

    private int write(byte[] data, int offset, int len) throws UsbException {
        int written;
        int result;
        UsbEndpointDescriptor descriptor = this.getEndpointDescriptor();
        byte type = this.pipe.getUsbEndpoint().getType();
        DeviceHandle handle = this.getDevice().open();
        for (written = 0; written < len; written += result) {
            int size = Math.min(len - written, descriptor.wMaxPacketSize() & 0xFFFF);
            ByteBuffer buffer = ByteBuffer.allocateDirect(size);
            buffer.put(data, offset + written, size);
            buffer.rewind();
            result = this.transfer(handle, descriptor, type, buffer);
            if (result >= size) continue;
            break;
        }
        return written;
    }

    private int transfer(DeviceHandle handle, UsbEndpointDescriptor descriptor, int type, ByteBuffer buffer) throws UsbException {
        IntBuffer transferred = IntBuffer.allocate(1);
        if (type == 2) {
            int result = LibUsb.bulkTransfer(handle, descriptor.bEndpointAddress(), buffer, transferred, this.getConfig().getTimeout());
            if (result < 0) {
                throw new LibUsbException("Transfer error on bulk endpoint", result);
            }
        } else if (type == 3) {
            int result = LibUsb.interruptTransfer(handle, descriptor.bEndpointAddress(), buffer, transferred, this.getConfig().getTimeout());
            if (result < 0) {
                throw new LibUsbException("Transfer error on interrupt endpoint", result);
            }
        } else {
            throw new UsbException("Unsupported endpoint type: " + type);
        }
        return transferred.get(0);
    }
}

